/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.EventListenerList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

final class SimpleProxyLookup
extends Lookup {
    private Lookup.Provider provider;
    private Lookup delegate;
    private WeakHashMap results;

    SimpleProxyLookup(Lookup.Provider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup checkLookup() {
        Lookup lookup = this.provider.getLookup();
        Iterator<Object> iterator = null;
        Object object = this;
        synchronized (object) {
            if (lookup != this.delegate) {
                this.delegate = lookup;
                if (this.results != null) {
                    iterator = Arrays.asList(this.results.values().toArray()).iterator();
                }
            }
        }
        if (iterator != null) {
            LookupListener lookupListener;
            Object object2;
            object = new ArrayList();
            Iterator<Object> iterator2 = iterator;
            while (iterator2.hasNext()) {
                object2 = (Reference)iterator2.next();
                lookupListener = (ProxyResult)((Reference)object2).get();
                if (lookupListener == null || !((ProxyResult)lookupListener).updateLookup(lookup)) continue;
                ((ProxyResult)lookupListener).collectFires((Collection)object);
            }
            iterator2 = ((ArrayList)object).iterator();
            while (iterator2.hasNext()) {
                object2 = (LookupEvent)iterator2.next();
                lookupListener = (LookupListener)iterator2.next();
                lookupListener.resultChanged((LookupEvent)object2);
            }
        }
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lookup.Result lookup(Lookup.Template template) {
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            Object object;
            if (this.results == null) {
                this.results = new WeakHashMap();
            } else {
                ProxyResult proxyResult;
                object = (Reference)this.results.get(template);
                if (object != null && (proxyResult = (ProxyResult)((Reference)object).get()) != null) {
                    return proxyResult;
                }
            }
            object = new ProxyResult(template);
            this.results.put(template, new WeakReference<Object>(object));
            return object;
        }
    }

    @Override
    public Object lookup(Class clazz) {
        return this.checkLookup().lookup(clazz);
    }

    @Override
    public Lookup.Item lookupItem(Lookup.Template template) {
        return this.checkLookup().lookupItem(template);
    }

    private final class WeakResult
    extends WaitableResult
    implements LookupListener {
        private Lookup.Result source;
        private Reference result;

        public WeakResult(ProxyResult proxyResult, Lookup.Result result) {
            this.result = new WeakReference<ProxyResult>(proxyResult);
            this.source = result;
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            ProxyResult proxyResult = (ProxyResult)this.result.get();
            if (proxyResult != null) {
                proxyResult.beforeLookup(template);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        protected void collectFires(Collection collection) {
            ProxyResult proxyResult = (ProxyResult)this.result.get();
            if (proxyResult != null) {
                proxyResult.collectFires(collection);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public void addLookupListener(LookupListener lookupListener) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener lookupListener) {
            assert (false);
        }

        @Override
        public Collection allInstances() {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent lookupEvent) {
            ProxyResult proxyResult = (ProxyResult)this.result.get();
            if (proxyResult != null) {
                proxyResult.resultChanged(lookupEvent);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public Collection allItems() {
            assert (false);
            return null;
        }

        @Override
        public Set allClasses() {
            assert (false);
            return null;
        }
    }

    private final class ProxyResult
    extends WaitableResult
    implements LookupListener {
        private Lookup.Template template;
        private Lookup.Result delegate;
        private EventListenerList listeners;
        private LookupListener lastListener;

        ProxyResult(Lookup.Template template) {
            this.template = template;
        }

        private Lookup.Result checkResult() {
            this.updateLookup(SimpleProxyLookup.this.checkLookup());
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateLookup(Lookup lookup) {
            LookupListener lookupListener;
            List list = this.delegate != null ? this.delegate.allItems() : null;
            Lookup.Result result = this;
            synchronized (result) {
                if (this.delegate != null && this.lastListener != null) {
                    lookupListener = this.lastListener;
                    this.delegate.removeLookupListener(this.lastListener);
                } else {
                    lookupListener = null;
                }
            }
            result = lookup.lookup(this.template);
            ArrayList arrayList = this;
            synchronized (arrayList) {
                if (lookupListener == this.lastListener) {
                    this.delegate = result;
                    this.lastListener = new WeakResult(this, this.delegate);
                    this.delegate.addLookupListener(this.lastListener);
                }
            }
            if (list == null) {
                return false;
            }
            arrayList = this.delegate.allItems();
            if (!(list instanceof List)) {
                list = list == Collections.EMPTY_SET ? Collections.EMPTY_LIST : new ArrayList(list);
            }
            if (!(arrayList instanceof List)) {
                arrayList = new ArrayList(arrayList);
            }
            return !((Object)list).equals(arrayList);
        }

        @Override
        public synchronized void addLookupListener(LookupListener lookupListener) {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
            this.listeners.add(LookupListener.class, lookupListener);
        }

        @Override
        public synchronized void removeLookupListener(LookupListener lookupListener) {
            if (this.listeners != null) {
                this.listeners.remove(LookupListener.class, lookupListener);
            }
        }

        @Override
        public Collection allInstances() {
            return this.checkResult().allInstances();
        }

        @Override
        public Set allClasses() {
            return this.checkResult().allClasses();
        }

        @Override
        public Collection allItems() {
            return this.checkResult().allItems();
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            Lookup.Result result = this.checkResult();
            if (result instanceof WaitableResult) {
                ((WaitableResult)result).beforeLookup(template);
            }
        }

        @Override
        public void resultChanged(LookupEvent lookupEvent) {
            this.collectFires(null);
        }

        @Override
        protected void collectFires(Collection collection) {
            EventListenerList eventListenerList = this.listeners;
            if (eventListenerList == null) {
                return;
            }
            Object[] objectArray = eventListenerList.getListenerList();
            if (objectArray.length == 0) {
                return;
            }
            LookupEvent lookupEvent = new LookupEvent(this);
            AbstractLookup.notifyListeners(objectArray, lookupEvent, collection);
        }
    }
}

