/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.BlueZServiceRecordXML;
import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.DeviceInquiryRunnable;
import com.intel.bluetooth.DeviceInquiryThread;
import com.intel.bluetooth.NotSupportedRuntimeException;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.SearchServicesRunnable;
import com.intel.bluetooth.SearchServicesThread;
import com.intel.bluetooth.ServiceRecordImpl;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.UtilsJavaSE;
import cx.ath.matthew.unix.UnixSocket;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;
import org.bluez.BlueZAPI;
import org.bluez.BlueZAPIFactory;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;

class BluetoothStackBlueZDBus
implements BluetoothStack,
DeviceInquiryRunnable,
SearchServicesRunnable {
    public static final String NATIVE_BLUECOVE_LIB_BLUEZ = "bluecovez";
    private static final String BLUEZ_DEVICEID_PREFIX = "hci";
    private static final int LISTEN_BACKLOG_RFCOMM = 4;
    private static final int LISTEN_BACKLOG_L2CAP = 4;
    private final int l2cap_receiveMTU_max = 65535;
    private static final Vector<String> devicesUsed = new Vector();
    private DBusConnection dbusConn = null;
    private String deviceID;
    private BlueZAPI blueZ;
    static final int BLUECOVE_DBUS_VERSION = 2010100;
    private long localDeviceBTAddress = -1L;
    private Map<String, String> propertiesMap;
    private DiscoveryListener discoveryListener;
    private boolean deviceInquiryCanceled = false;

    BluetoothStackBlueZDBus() {
    }

    public String getStackID() {
        return "bluez-dbus";
    }

    public String toString() {
        if (this.deviceID != null) {
            return this.getStackID() + ":" + this.deviceID;
        }
        return this.getStackID();
    }

    public native boolean isNativeCodeLoaded();

    public BluetoothStack.LibraryInformation[] requireNativeLibraries() {
        try {
            BluetoothStack.LibraryInformation unixSocketLib = new BluetoothStack.LibraryInformation("unix-java", false);
            unixSocketLib.stackClass = UnixSocket.class;
            return new BluetoothStack.LibraryInformation[]{new BluetoothStack.LibraryInformation(NATIVE_BLUECOVE_LIB_BLUEZ), unixSocketLib};
        }
        catch (NoClassDefFoundError e) {
            return new BluetoothStack.LibraryInformation[]{new BluetoothStack.LibraryInformation(NATIVE_BLUECOVE_LIB_BLUEZ)};
        }
    }

    private native int getLibraryVersionNative();

    public int getLibraryVersion() throws BluetoothStateException {
        int version = this.getLibraryVersionNative();
        if (version != 2010100) {
            DebugLog.fatal((String)("BlueCove native library version mismatch " + version + " expected " + 2010100));
            throw new BluetoothStateException("BlueCove native library version mismatch");
        }
        return version;
    }

    public int detectBluetoothStack() {
        return 32;
    }

    private String toHexString(long l) {
        StringBuffer buf = new StringBuffer();
        String lo = Integer.toHexString((int)l);
        if (l > 0xFFFFFFFFL) {
            String hi = Integer.toHexString((int)(l >> 32));
            buf.append(hi);
        }
        buf.append(lo);
        StringBuffer result = new StringBuffer();
        int prependZeros = 12 - buf.length();
        for (int i = 0; i < prependZeros; ++i) {
            result.append("0");
        }
        result.append(buf.toString());
        StringBuffer hex = new StringBuffer();
        for (int i = 0; i < 12; i += 2) {
            hex.append(result.substring(i, i + 2));
            if (i >= 10) continue;
            hex.append(":");
        }
        return hex.toString().toUpperCase(Locale.ENGLISH);
    }

    private long convertBTAddress(String anAddress) {
        long btAddress = Long.parseLong(anAddress.replaceAll(":", ""), 16);
        return btAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws BluetoothStateException {
        boolean intialized = false;
        try {
            Path adapterPath;
            try {
                this.dbusConn = DBusConnection.getConnection((int)0);
            }
            catch (DBusException e) {
                DebugLog.error((String)"Failed to get the dbus connection", (Throwable)e);
                throw new BluetoothStateException(e.getMessage());
            }
            try {
                this.blueZ = BlueZAPIFactory.getBlueZAPI(this.dbusConn);
            }
            catch (DBusException e) {
                DebugLog.error((String)"Failed to get bluez dbus manager", (Throwable)e);
                throw (BluetoothStateException)UtilsJavaSE.initCause((Throwable)new BluetoothStateException("Can't access BlueZ D-Bus"), (Throwable)e);
            }
            String findID = BlueCoveImpl.getConfigProperty((String)"bluecove.deviceID");
            String deviceAddressStr = BlueCoveImpl.getConfigProperty((String)"bluecove.deviceAddress");
            if (findID != null) {
                if (findID.startsWith(BLUEZ_DEVICEID_PREFIX)) {
                    adapterPath = this.blueZ.findAdapter(findID);
                    if (adapterPath == null) {
                        throw new BluetoothStateException("Can't find '" + findID + "' adapter");
                    }
                } else {
                    int findNumber = Integer.parseInt(findID);
                    adapterPath = this.blueZ.getAdapter(findNumber);
                    if (adapterPath == null) {
                        throw new BluetoothStateException("Can't find adapter #" + findID);
                    }
                }
            } else if (deviceAddressStr != null) {
                String pattern = this.toHexString(Long.parseLong(deviceAddressStr, 16));
                adapterPath = this.blueZ.findAdapter(pattern);
                if (adapterPath == null) {
                    throw new BluetoothStateException("Can't find adapter with address '" + deviceAddressStr + "'");
                }
            } else {
                adapterPath = this.blueZ.defaultAdapter();
                if (adapterPath == null) {
                    throw new BluetoothStateException("Can't find default adapter");
                }
            }
            try {
                this.blueZ.selectAdapter(adapterPath);
            }
            catch (DBusException e) {
                throw new BluetoothStateException(adapterPath + " " + e.getMessage());
            }
            this.localDeviceBTAddress = this.convertBTAddress(this.blueZ.getAdapterAddress());
            this.deviceID = this.blueZ.getAdapterID();
            if (devicesUsed.contains(this.deviceID)) {
                throw new BluetoothStateException("LocalDevice " + this.deviceID + " alredy in use");
            }
            this.propertiesMap = new TreeMap<String, String>();
            this.propertiesMap.put("bluetooth.connected.devices.max", "7");
            this.propertiesMap.put("bluetooth.sd.trans.max", "7");
            this.propertiesMap.put("bluecove.deviceID", this.deviceID);
            String TRUE = "true";
            String FALSE = "false";
            this.propertiesMap.put("bluetooth.connected.inquiry.scan", "true");
            this.propertiesMap.put("bluetooth.connected.page.scan", "true");
            this.propertiesMap.put("bluetooth.connected.inquiry", "true");
            this.propertiesMap.put("bluetooth.connected.page", "true");
            this.propertiesMap.put("bluetooth.sd.attr.retrievable.max", String.valueOf(256));
            this.propertiesMap.put("bluetooth.master.switch", "false");
            this.propertiesMap.put("bluetooth.l2cap.receiveMTU.max", String.valueOf(65535));
            intialized = true;
        }
        finally {
            if (!intialized) {
                if (this.dbusConn != null) {
                    this.dbusConn.disconnect();
                }
                this.dbusConn = null;
            }
        }
    }

    public void destroy() {
        DebugLog.debug((String)"destroy()");
        if (this.deviceID != null) {
            devicesUsed.removeElement(this.deviceID);
            this.deviceID = null;
        }
        if (this.dbusConn != null) {
            this.dbusConn.disconnect();
            this.dbusConn = null;
        }
    }

    public native void enableNativeDebug(Class var1, boolean var2);

    public boolean isCurrentThreadInterruptedCallback() {
        return Thread.interrupted();
    }

    public int getFeatureSet() {
        return 3;
    }

    public String getLocalDeviceBluetoothAddress() throws BluetoothStateException {
        return RemoteDeviceHelper.getBluetoothAddress((long)this.localDeviceBTAddress);
    }

    public DeviceClass getLocalDeviceClass() {
        try {
            int record = this.blueZ.getAdapterDeviceClass();
            if (10390272 == this.getLocalDeviceDiscoverable()) {
                record |= 0x2000;
            }
            return new DeviceClass(record);
        }
        catch (DBusExecutionException e) {
            DebugLog.error((String)"getLocalDeviceClass", (Throwable)e);
            return null;
        }
    }

    public String getLocalDeviceName() {
        return this.blueZ.getAdapterName();
    }

    public boolean isLocalDevicePowerOn() {
        return this.blueZ.isAdapterPowerOn();
    }

    public String getLocalDeviceProperty(String property) {
        if ("bluecove.local_devices_ids".equals(property)) {
            StringBuffer b = new StringBuffer();
            for (String adapterId : this.blueZ.listAdapters()) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(adapterId);
            }
            return b.toString();
        }
        if ("bluecove.radio.version".equals(property)) {
            return this.blueZ.getAdapterVersion() + "; HCI " + this.blueZ.getAdapterRevision();
        }
        if ("bluecove.radio.manufacturer".equals(property)) {
            return this.blueZ.getAdapterManufacturer();
        }
        return this.propertiesMap.get(property);
    }

    public int getLocalDeviceDiscoverable() {
        if (this.blueZ.isAdapterDiscoverable()) {
            int timeout = this.blueZ.getAdapterDiscoverableTimeout();
            if (timeout == 0) {
                return 10390323;
            }
            return 10390272;
        }
        return 0;
    }

    public boolean setLocalDeviceDiscoverable(int mode) throws BluetoothStateException {
        if (this.getLocalDeviceDiscoverable() == mode) {
            return true;
        }
        try {
            return this.blueZ.setAdapterDiscoverable(mode);
        }
        catch (DBusException e) {
            throw (BluetoothStateException)UtilsJavaSE.initCause((Throwable)new BluetoothStateException(e.getMessage()), (Throwable)e);
        }
        catch (DBusExecutionException e) {
            throw (BluetoothStateException)UtilsJavaSE.initCause((Throwable)new BluetoothStateException(e.getMessage()), (Throwable)e);
        }
    }

    public void setLocalDeviceServiceClasses(int classOfDevice) {
        DebugLog.debug((String)"setLocalDeviceServiceClasses()");
        throw new NotSupportedRuntimeException(this.getStackID());
    }

    public boolean authenticateRemoteDevice(long address) throws IOException {
        try {
            this.blueZ.authenticateRemoteDevice(this.toHexString(address));
            return true;
        }
        catch (Throwable e) {
            DebugLog.error((String)"Error creating bonding", (Throwable)e);
            return false;
        }
    }

    public boolean authenticateRemoteDevice(long address, String passkey) throws IOException {
        try {
            return this.blueZ.authenticateRemoteDevice(this.toHexString(address), passkey);
        }
        catch (Throwable e) {
            throw (IOException)UtilsJavaSE.initCause((Throwable)new IOException(e.getMessage()), (Throwable)e);
        }
    }

    public void removeAuthenticationWithRemoteDevice(long address) throws IOException {
        try {
            this.blueZ.removeAuthenticationWithRemoteDevice(this.toHexString(address));
        }
        catch (Throwable e) {
            throw (IOException)UtilsJavaSE.initCause((Throwable)new IOException(e.getMessage()), (Throwable)e);
        }
    }

    public boolean startInquiry(int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        DebugLog.debug((String)"startInquiry()");
        if (this.discoveryListener != null) {
            throw new BluetoothStateException("Another inquiry already running");
        }
        this.discoveryListener = listener;
        this.deviceInquiryCanceled = false;
        return DeviceInquiryThread.startInquiry((BluetoothStack)this, (DeviceInquiryRunnable)this, (int)accessCode, (DiscoveryListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int runDeviceInquiry(final DeviceInquiryThread startedNotify, int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        DebugLog.debug((String)"runDeviceInquiry()");
        try {
            final HashMap address2DiscoveryData = new HashMap();
            BlueZAPI.DeviceInquiryListener bluezDiscoveryListener = new BlueZAPI.DeviceInquiryListener(){

                public void deviceInquiryStarted() {
                    startedNotify.deviceInquiryStartedCallback();
                }

                public void deviceDiscovered(String deviceAddr, String deviceName, int deviceClass, boolean paired) {
                    long longAddress = BluetoothStackBlueZDBus.this.convertBTAddress(deviceAddr);
                    DiscoveryData discoveryData = (DiscoveryData)address2DiscoveryData.get(longAddress);
                    if (discoveryData == null) {
                        discoveryData = new DiscoveryData();
                        address2DiscoveryData.put(longAddress, discoveryData);
                    }
                    if (deviceName != null) {
                        discoveryData.name = deviceName;
                    }
                    if (deviceClass >= 0) {
                        discoveryData.deviceClass = deviceClass;
                    }
                }
            };
            try {
                this.blueZ.deviceInquiry(bluezDiscoveryListener);
            }
            catch (Throwable e) {
                if (this.deviceInquiryCanceled) {
                    int n = 5;
                    this.discoveryListener = null;
                    return n;
                }
                DebugLog.error((String)"deviceInquiry error", (Throwable)e);
                throw (BluetoothStateException)UtilsJavaSE.initCause((Throwable)new BluetoothStateException(e.getMessage()), (Throwable)e);
            }
            for (Long address : address2DiscoveryData.keySet()) {
                DiscoveryData discoveryData = (DiscoveryData)address2DiscoveryData.get(address);
                if (discoveryData.name == null) {
                    try {
                        discoveryData.name = this.blueZ.getRemoteDeviceFriendlyName(this.toHexString(address));
                    }
                    catch (Throwable e) {
                        DebugLog.error((String)"can't get device name", (Throwable)e);
                    }
                    if (discoveryData.name == null) {
                        discoveryData.name = "";
                    }
                }
                RemoteDevice remoteDevice = RemoteDeviceHelper.createRemoteDevice((BluetoothStack)this, (long)address, (String)discoveryData.name, (boolean)discoveryData.paired);
                listener.deviceDiscovered(remoteDevice, new DeviceClass(discoveryData.deviceClass));
                if (!this.deviceInquiryCanceled) continue;
            }
            if (this.deviceInquiryCanceled) {
                int n = 5;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.discoveryListener = null;
        }
    }

    public void deviceDiscoveredCallback(DiscoveryListener listener, long deviceAddr, int deviceClass, String deviceName, boolean paired) {
    }

    public boolean cancelInquiry(DiscoveryListener listener) {
        DebugLog.debug((String)"cancelInquiry()");
        if (this.discoveryListener != null && this.discoveryListener == listener) {
            this.deviceInquiryCanceled = true;
            try {
                this.blueZ.deviceInquiryCancel();
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public String getRemoteDeviceFriendlyName(long deviceAddress) throws IOException {
        if (this.discoveryListener != null) {
            throw new IOException("DeviceInquiry alredy running");
        }
        try {
            return this.blueZ.getRemoteDeviceFriendlyName(this.toHexString(deviceAddress));
        }
        catch (DBusExecutionException e) {
            throw (BluetoothStateException)UtilsJavaSE.initCause((Throwable)new BluetoothStateException(e.getMessage()), (Throwable)e);
        }
        catch (DBusException e) {
            throw (BluetoothStateException)UtilsJavaSE.initCause((Throwable)new BluetoothStateException(e.getMessage()), (Throwable)e);
        }
    }

    public RemoteDevice[] retrieveDevices(int option) {
        List<String> preKnownDevices = this.blueZ.retrieveDevices(1 == option);
        if (preKnownDevices == null) {
            return null;
        }
        Vector<RemoteDevice> devices = new Vector<RemoteDevice>();
        for (String addres : preKnownDevices) {
            devices.add(RemoteDeviceHelper.createRemoteDevice((BluetoothStack)this, (long)this.convertBTAddress(addres), null, (boolean)true));
        }
        return RemoteDeviceHelper.remoteDeviceListToArray(devices);
    }

    public Boolean isRemoteDeviceTrusted(long address) {
        try {
            return this.blueZ.isRemoteDeviceTrusted(this.toHexString(address));
        }
        catch (DBusExecutionException e) {
            DebugLog.error((String)"isRemoteDeviceTrusted", (Throwable)e);
            return Boolean.FALSE;
        }
        catch (DBusException e) {
            DebugLog.error((String)"isRemoteDeviceTrusted", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    public Boolean isRemoteDeviceAuthenticated(long address) {
        try {
            return this.blueZ.isRemoteDeviceConnected(this.toHexString(address)) && this.blueZ.isRemoteDeviceTrusted(this.toHexString(address)) != false;
        }
        catch (DBusExecutionException e) {
            DebugLog.error((String)"isRemoteDeviceAuthenticated", (Throwable)e);
            return Boolean.FALSE;
        }
        catch (DBusException e) {
            DebugLog.error((String)"isRemoteDeviceAuthenticated", (Throwable)e);
            return false;
        }
    }

    public int searchServices(int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        try {
            DebugLog.debug((String)"searchServices() device", (String)device.getBluetoothAddress());
            return SearchServicesThread.startSearchServices((BluetoothStack)this, (SearchServicesRunnable)this, (int[])attrSet, (UUID[])uuidSet, (RemoteDevice)device, (DiscoveryListener)listener);
        }
        catch (Exception ex) {
            DebugLog.debug((String)"searchServices() failed", (Throwable)ex);
            throw new BluetoothStateException("searchServices() failed: " + ex.getMessage());
        }
    }

    private int getRemoteServices(SearchServicesThread sst, UUID[] uuidSet, RemoteDevice remoteDevice) {
        Map<Integer, String> xmlRecords;
        try {
            xmlRecords = this.blueZ.getRemoteDeviceServices(this.toHexString(RemoteDeviceHelper.getAddress((RemoteDevice)remoteDevice)));
        }
        catch (DBusException e) {
            DebugLog.error((String)"get Service records failed", (Throwable)e);
            return 3;
        }
        catch (DBusExecutionException e) {
            DebugLog.error((String)"get Service records failed", (Throwable)e);
            return 3;
        }
        if (xmlRecords == null) {
            return 6;
        }
        block5: for (Map.Entry<Integer, String> record : xmlRecords.entrySet()) {
            Map<Integer, DataElement> elements;
            DebugLog.debug((String)"pars service record", (String)record.getValue());
            ServiceRecordImpl sr = new ServiceRecordImpl((BluetoothStack)this, remoteDevice, (long)record.getKey().intValue());
            try {
                elements = BlueZServiceRecordXML.parsXMLRecord(record.getValue());
            }
            catch (IOException e) {
                DebugLog.error((String)"Error parsing service record", (Throwable)e);
                continue;
            }
            for (Map.Entry<Integer, DataElement> element : elements.entrySet()) {
                sr.populateAttributeValue(element.getKey().intValue(), element.getValue());
            }
            for (int u = 0; u < uuidSet.length; ++u) {
                if (sr.hasServiceClassUUID(uuidSet[u]) || sr.hasProtocolClassUUID(uuidSet[u])) continue;
                DebugLog.debug((String)"ignoring service", (Object)sr);
                continue block5;
            }
            DebugLog.debug((String)"found service");
            sst.addServicesRecords((ServiceRecord)sr);
        }
        return 1;
    }

    public int runSearchServices(SearchServicesThread sst, int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        DebugLog.debug((String)"runSearchServices()");
        sst.searchServicesStartedCallback();
        int respCode = this.getRemoteServices(sst, uuidSet, device);
        DebugLog.debug((String)"SearchServices finished", (long)sst.getTransID());
        Vector records = sst.getServicesRecords();
        if (records.size() != 0) {
            ServiceRecord[] servRecordArray = (ServiceRecord[])Utils.vector2toArray((Vector)records, (Object[])new ServiceRecord[records.size()]);
            listener.servicesDiscovered(sst.getTransID(), servRecordArray);
        }
        if (respCode != 3 && sst.isTerminated()) {
            return 2;
        }
        if (respCode == 1) {
            if (records.size() != 0) {
                return 1;
            }
            return 4;
        }
        return respCode;
    }

    public boolean cancelServiceSearch(int transID) {
        DebugLog.debug((String)"cancelServiceSearch()");
        SearchServicesThread sst = SearchServicesThread.getServiceSearchThread((int)transID);
        if (sst != null) {
            return sst.setTerminated();
        }
        return false;
    }

    public boolean populateServicesRecordAttributeValues(ServiceRecordImpl serviceRecord, int[] attrIDs) throws IOException {
        DebugLog.debug((String)"populateServicesRecordAttributeValues()");
        long remoteDeviceAddress = RemoteDeviceHelper.getAddress((RemoteDevice)serviceRecord.getHostDevice());
        throw new UnsupportedOperationException("populateServicesRecordAttributeValues Not supported yet.");
    }

    private synchronized void registerSDPRecord(ServiceRecordImpl serviceRecord) throws ServiceRegistrationException {
        long handle;
        try {
            handle = this.blueZ.registerSDPRecord(BlueZServiceRecordXML.exportXMLRecord((ServiceRecord)serviceRecord));
        }
        catch (Throwable e) {
            throw (ServiceRegistrationException)UtilsJavaSE.initCause((Throwable)new ServiceRegistrationException(e.getMessage()), (Throwable)e);
        }
        serviceRecord.setHandle(handle);
        serviceRecord.populateAttributeValue(0, new DataElement(10, handle));
    }

    private synchronized void updateSDPRecord(ServiceRecordImpl serviceRecord) throws ServiceRegistrationException {
        try {
            this.blueZ.updateSDPRecord(serviceRecord.getHandle(), BlueZServiceRecordXML.exportXMLRecord((ServiceRecord)serviceRecord));
        }
        catch (Throwable e) {
            throw (ServiceRegistrationException)UtilsJavaSE.initCause((Throwable)new ServiceRegistrationException(e.getMessage()), (Throwable)e);
        }
    }

    private synchronized void unregisterSDPRecord(ServiceRecordImpl serviceRecord) throws ServiceRegistrationException {
        try {
            this.blueZ.unregisterSDPRecord(serviceRecord.getHandle());
        }
        catch (Throwable e) {
            throw (ServiceRegistrationException)UtilsJavaSE.initCause((Throwable)new ServiceRegistrationException(e.getMessage()), (Throwable)e);
        }
    }

    private native long connectionRfOpenClientConnectionImpl(long var1, long var3, int var5, boolean var6, boolean var7, int var8) throws IOException;

    public long connectionRfOpenClientConnection(BluetoothConnectionParams params) throws IOException {
        return this.connectionRfOpenClientConnectionImpl(this.localDeviceBTAddress, params.address, params.channel, params.authenticate, params.encrypt, params.timeout);
    }

    public native void connectionRfCloseClientConnection(long var1) throws IOException;

    public native int rfGetSecurityOptImpl(long var1) throws IOException;

    public int rfGetSecurityOpt(long handle, int expected) throws IOException {
        return this.rfGetSecurityOptImpl(handle);
    }

    public boolean rfEncrypt(long address, long handle, boolean on) throws IOException {
        return false;
    }

    private native long rfServerOpenImpl(long var1, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, int var8) throws IOException;

    private native int rfServerGetChannelIDImpl(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rfServerOpen(BluetoothConnectionNotifierParams params, ServiceRecordImpl serviceRecord) throws IOException {
        long socket = this.rfServerOpenImpl(this.localDeviceBTAddress, params.authorize, params.authenticate, params.encrypt, params.master, params.timeouts, 4);
        boolean success = false;
        try {
            int channel = this.rfServerGetChannelIDImpl(socket);
            serviceRecord.populateRFCOMMAttributes(0L, channel, params.uuid, params.name, params.obex);
            this.registerSDPRecord(serviceRecord);
            success = true;
            long l = socket;
            return l;
        }
        finally {
            if (!success) {
                this.rfServerCloseImpl(socket, true);
            }
        }
    }

    private native void rfServerCloseImpl(long var1, boolean var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rfServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        try {
            this.unregisterSDPRecord(serviceRecord);
        }
        finally {
            this.rfServerCloseImpl(handle, false);
        }
    }

    public void rfServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        this.updateSDPRecord(serviceRecord);
    }

    public native long rfServerAcceptAndOpenRfServerConnection(long var1) throws IOException;

    public void connectionRfCloseServerConnection(long clientHandle) throws IOException {
        this.connectionRfCloseClientConnection(clientHandle);
    }

    public int connectionRfRead(long handle) throws IOException {
        byte[] data = new byte[1];
        int size = this.connectionRfRead(handle, data, 0, 1);
        if (size == -1) {
            return -1;
        }
        return 0xFF & data[0];
    }

    public native int connectionRfRead(long var1, byte[] var3, int var4, int var5) throws IOException;

    public native int connectionRfReadAvailable(long var1) throws IOException;

    public native void connectionRfWrite(long var1, int var3) throws IOException;

    public native void connectionRfWrite(long var1, byte[] var3, int var4, int var5) throws IOException;

    public native void connectionRfFlush(long var1) throws IOException;

    public native long getConnectionRfRemoteAddress(long var1) throws IOException;

    private void validateMTU(int receiveMTU, int transmitMTU) {
        if (receiveMTU > 65535) {
            throw new IllegalArgumentException("invalid ReceiveMTU value " + receiveMTU);
        }
    }

    private native long l2OpenClientConnectionImpl(long var1, long var3, int var5, boolean var6, boolean var7, int var8, int var9, int var10) throws IOException;

    public long l2OpenClientConnection(BluetoothConnectionParams params, int receiveMTU, int transmitMTU) throws IOException {
        this.validateMTU(receiveMTU, transmitMTU);
        return this.l2OpenClientConnectionImpl(this.localDeviceBTAddress, params.address, params.channel, params.authenticate, params.encrypt, receiveMTU, transmitMTU, params.timeout);
    }

    public native void l2CloseClientConnection(long var1) throws IOException;

    private native long l2ServerOpenImpl(long var1, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, int var8, int var9, int var10, int var11) throws IOException;

    public native int l2ServerGetPSMImpl(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long l2ServerOpen(BluetoothConnectionNotifierParams params, int receiveMTU, int transmitMTU, ServiceRecordImpl serviceRecord) throws IOException {
        this.validateMTU(receiveMTU, transmitMTU);
        long socket = this.l2ServerOpenImpl(this.localDeviceBTAddress, params.authorize, params.authenticate, params.encrypt, params.master, params.timeouts, 4, receiveMTU, transmitMTU, params.bluecove_ext_psm);
        boolean success = false;
        try {
            int channel = this.l2ServerGetPSMImpl(socket);
            serviceRecord.populateL2CAPAttributes(0, channel, params.uuid, params.name);
            this.registerSDPRecord(serviceRecord);
            success = true;
            long l = socket;
            return l;
        }
        finally {
            if (!success) {
                this.l2ServerCloseImpl(socket, true);
            }
        }
    }

    public void l2ServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        this.updateSDPRecord(serviceRecord);
    }

    public native long l2ServerAcceptAndOpenServerConnection(long var1) throws IOException;

    public void l2CloseServerConnection(long handle) throws IOException {
        this.l2CloseClientConnection(handle);
    }

    private native void l2ServerCloseImpl(long var1, boolean var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void l2ServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        try {
            this.unregisterSDPRecord(serviceRecord);
        }
        finally {
            this.l2ServerCloseImpl(handle, false);
        }
    }

    public native boolean l2Ready(long var1) throws IOException;

    public native int l2Receive(long var1, byte[] var3) throws IOException;

    public native void l2Send(long var1, byte[] var3, int var4) throws IOException;

    public native int l2GetReceiveMTU(long var1) throws IOException;

    public native int l2GetTransmitMTU(long var1) throws IOException;

    public native long l2RemoteAddress(long var1) throws IOException;

    public native int l2GetSecurityOpt(long var1, int var3) throws IOException;

    public boolean l2Encrypt(long address, long handle, boolean on) throws IOException {
        return false;
    }

    private class DiscoveryData {
        public int deviceClass;
        public String name;
        boolean paired;

        private DiscoveryData() {
        }
    }
}

