/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;

public final class ByteString {
    private final byte[] bytes;
    public static final ByteString EMPTY = new ByteString(new byte[0]);
    private volatile int hash = 0;

    private ByteString(byte[] byArray) {
        this.bytes = byArray;
    }

    public byte byteAt(int n) {
        return this.bytes[n];
    }

    public int size() {
        return this.bytes.length;
    }

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public static ByteString copyFrom(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return new ByteString(byArray2);
    }

    public static ByteString copyFrom(byte[] byArray) {
        return ByteString.copyFrom(byArray, 0, byArray.length);
    }

    public static ByteString copyFrom(ByteBuffer byteBuffer, int n) {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return new ByteString(byArray);
    }

    public static ByteString copyFrom(ByteBuffer byteBuffer) {
        return ByteString.copyFrom(byteBuffer, byteBuffer.remaining());
    }

    public static ByteString copyFrom(String string, String string2) throws UnsupportedEncodingException {
        return new ByteString(string.getBytes(string2));
    }

    public static ByteString copyFromUtf8(String string) {
        try {
            return new ByteString(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported?", unsupportedEncodingException);
        }
    }

    public static ByteString copyFrom(List<ByteString> list) {
        if (list.size() == 0) {
            return EMPTY;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        int n = 0;
        for (ByteString byteString : list) {
            n += byteString.size();
        }
        Object object = new byte[n];
        int n2 = 0;
        for (ByteString byteString : list) {
            System.arraycopy(byteString.bytes, 0, object, n2, byteString.size());
            n2 += byteString.size();
        }
        return new ByteString((byte[])object);
    }

    public void copyTo(byte[] byArray, int n) {
        System.arraycopy(this.bytes, 0, byArray, n, this.bytes.length);
    }

    public void copyTo(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(this.bytes, n, byArray, n2, n3);
    }

    public byte[] toByteArray() {
        int n = this.bytes.length;
        byte[] byArray = new byte[n];
        System.arraycopy(this.bytes, 0, byArray, 0, n);
        return byArray;
    }

    public ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes);
        return byteBuffer.asReadOnlyBuffer();
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.bytes, string);
    }

    public String toStringUtf8() {
        try {
            return new String(this.bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported?", unsupportedEncodingException);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        ByteString byteString = (ByteString)object;
        int n = this.bytes.length;
        if (n != byteString.bytes.length) {
            return false;
        }
        byte[] byArray = this.bytes;
        byte[] byArray2 = byteString.bytes;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            int n2;
            byte[] byArray = this.bytes;
            n = n2 = this.bytes.length;
            for (int i = 0; i < n2; ++i) {
                n = n * 31 + byArray[i];
            }
            if (n == 0) {
                n = 1;
            }
            this.hash = n;
        }
        return n;
    }

    public InputStream newInput() {
        return new ByteArrayInputStream(this.bytes);
    }

    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.bytes);
    }

    public static Output newOutput(int n) {
        return new Output(new ByteArrayOutputStream(n));
    }

    public static Output newOutput() {
        return ByteString.newOutput(32);
    }

    static CodedBuilder newCodedBuilder(int n) {
        return new CodedBuilder(n);
    }

    static final class CodedBuilder {
        private final CodedOutputStream output;
        private final byte[] buffer;

        private CodedBuilder(int n) {
            this.buffer = new byte[n];
            this.output = CodedOutputStream.newInstance(this.buffer);
        }

        public ByteString build() {
            this.output.checkNoSpaceLeft();
            return new ByteString(this.buffer);
        }

        public CodedOutputStream getCodedOutput() {
            return this.output;
        }
    }

    public static final class Output
    extends FilterOutputStream {
        private final ByteArrayOutputStream bout;

        private Output(ByteArrayOutputStream byteArrayOutputStream) {
            super(byteArrayOutputStream);
            this.bout = byteArrayOutputStream;
        }

        public ByteString toByteString() {
            byte[] byArray = this.bout.toByteArray();
            return new ByteString(byArray);
        }
    }
}

