/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide;

import com.mathworks.mlservices.MLInspectorServices;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.ResourceManager;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.palette.MObjectProxy;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class LayoutStatusBar
extends MJStatusBar {
    private Point fFigureOrigin = new Point(0, 0);
    private LayoutArea fLayoutArea;
    private int fUpdatesPending = 0;
    private Point fCurrentPoint = new Point(0, 0);
    private Point fPositionPoint = new Point(0, 0);
    private int fPositionWidth = 0;
    private int fPositionHeight = 0;
    private boolean fHideX = false;
    private boolean fHideY = false;
    private boolean fHideW = false;
    private boolean fHideH = false;
    private MJStatusBar.Field fCurrentPointField;
    private MJStatusBar.Field fSelectionField;
    private static final String MULTI = MLInspectorServices.getMixedValueDisplay();
    private static final String CURRENT_TAG = ResourceManager.getString("statusbar.Tag");
    private static final String CURRENT_MULTITAG = ResourceManager.getString("statusbar.MultipleTags");
    private static final String CURRENT_POINT = ResourceManager.getString("statusbar.CurrentPoint");
    private static final String POSITION = ResourceManager.getString("statusbar.Position");
    private static final String TOOLTIP_TAG = ResourceManager.getString("statusbar.TooltipTag");
    private static final String TOOLTIP_CURRENTPOINT = ("<html>" + ResourceManager.getString("statusbar.TooltipCurrentPoint") + "</html>").replaceAll("\n", "&nbsp;<br>");
    private static final String TOOLTIP_POSITION = ("<html>" + ResourceManager.getString("statusbar.TooltipPosition") + "</html>").replaceAll("\n", "&nbsp;<br>");

    public LayoutStatusBar(LayoutArea layoutArea) {
        this.fLayoutArea = layoutArea;
        MJStatusBar.Field field = new MJStatusBar.Field("WWW", 100, true);
        FontMetrics fontMetrics = field.getFontMetrics(field.getFont());
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(CURRENT_POINT + ": [9999, 9999]", field.getGraphics());
        Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(POSITION + ": [" + MULTI + ", " + MULTI + ", " + MULTI + ", " + MULTI + ']', field.getGraphics());
        Border border = BorderFactory.createEmptyBorder(0, 2, 0, 2);
        Border border2 = BorderFactory.createLineBorder(UIManager.getColor("controlLtHighlight"));
        this.fMainField.setToolTipText(TOOLTIP_TAG);
        this.fMainField.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2), BorderFactory.createCompoundBorder(border2, border)));
        this.fCurrentPointField = new MJStatusBar.Field((int)rectangle2D.getWidth() + 12, true);
        this.fCurrentPointField.setToolTipText(TOOLTIP_CURRENTPOINT);
        this.fCurrentPointField.setText(CURRENT_POINT + ": [0, 0]");
        this.fCurrentPointField.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0), BorderFactory.createCompoundBorder(border2, border)));
        this.fSelectionField = new MJStatusBar.Field((int)rectangle2D2.getWidth() + 12, true);
        this.fSelectionField.setToolTipText(TOOLTIP_POSITION);
        this.fSelectionField.setText(POSITION + ": [0, 0, 0, 0]");
        this.fSelectionField.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2), BorderFactory.createCompoundBorder(border2, border)));
        this.add((Component)this.fCurrentPointField);
        this.add((Component)this.fSelectionField);
    }

    public void setCurrentPoint(Point point) {
        this.fCurrentPoint.x = point.x;
        this.fCurrentPoint.y = point.y;
        LayoutStatusBar.adjustOrigin(this.getFigureOrigin(), this.fCurrentPoint);
        this.displayCurrentPoint();
    }

    public void setPosition(LOControlWrapper lOControlWrapper, LOControlWrapper lOControlWrapper2, boolean bl) {
        Point point = new Point(lOControlWrapper2.getLeft(), lOControlWrapper2.getBottom());
        Point point2 = new Point(lOControlWrapper2.getRight(), lOControlWrapper2.getTop());
        this.setPosition(lOControlWrapper, point, point2, bl);
    }

    public void setPosition(LOControlWrapper lOControlWrapper, Point point, Point point2, boolean bl) {
        this.noticeMultiSelection(bl);
        Point point3 = this.getFigureOrigin();
        if (lOControlWrapper != null) {
            point3 = new Point(lOControlWrapper.getLeft(), lOControlWrapper.getBottom());
        }
        this.fPositionWidth = point2.x - point.x;
        this.fPositionHeight = point.y - point2.y;
        this.fPositionPoint.x = point.x;
        this.fPositionPoint.y = point.y;
        LayoutStatusBar.adjustOrigin(point3, this.fPositionPoint);
        this.displayPosition();
    }

    public void setPosition(Rectangle rectangle) {
        if (rectangle != null) {
            this.noticeMultiSelection(false);
            this.fPositionPoint.x = rectangle.x;
            this.fPositionPoint.y = rectangle.y;
            this.fPositionWidth = rectangle.width;
            this.fPositionHeight = rectangle.height;
            this.displayPosition();
        }
    }

    public void updateSelectionCoord() {
        ++this.fUpdatesPending;
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateSelectionCoordHelper();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LayoutStatusBar.this.updateSelectionCoordHelper();
                }
            });
        }
    }

    private void updateSelectionCoordHelper() {
        Vector<LOControlWrapper> vector = this.fLayoutArea.getSelectedControls();
        if (vector.isEmpty()) {
            this.setText(MessageFormat.format(CURRENT_TAG, this.fLayoutArea.getFigureTag()));
            this.setPosition(this.fLayoutArea.getRuntimeArea().getRuntimeBounds());
        } else if (vector.size() >= 1) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.get(0);
            if (vector.size() == 1) {
                ArrayList<String> arrayList = ((MObjectProxy)lOControlWrapper.getControl()).getDisplayStrings();
                this.setText(MessageFormat.format(CURRENT_TAG, arrayList.get(0)));
            } else {
                this.setText(MessageFormat.format(CURRENT_MULTITAG, vector.size()));
            }
            this.setPosition(lOControlWrapper.getParent(), lOControlWrapper, true);
        }
        --this.fUpdatesPending;
        if (this.fUpdatesPending < 0) {
            this.fUpdatesPending = 0;
        }
    }

    private void noticeMultiSelection(boolean bl) {
        Vector<LOControlWrapper> vector;
        this.unhideAllPosition();
        if (bl && (vector = this.fLayoutArea.getSelectedControls()).size() > 1) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.get(0);
            for (Object e : vector) {
                LOControlWrapper lOControlWrapper2 = (LOControlWrapper)e;
                this.fHideX = this.fHideX || lOControlWrapper2.getLeft() != lOControlWrapper.getLeft();
                this.fHideY = this.fHideY || lOControlWrapper2.getBottom() != lOControlWrapper.getBottom();
                this.fHideW = this.fHideW || lOControlWrapper2.getRight() - lOControlWrapper2.getLeft() != lOControlWrapper.getRight() - lOControlWrapper.getLeft();
                this.fHideH = this.fHideH || lOControlWrapper2.getBottom() - lOControlWrapper2.getTop() != lOControlWrapper.getBottom() - lOControlWrapper.getTop();
            }
        }
    }

    private static void adjustOrigin(Point point, Point point2) {
        point2.x -= point.x;
        point2.y = point.y - point2.y;
    }

    private Point getFigureOrigin() {
        this.fFigureOrigin.y = this.fLayoutArea.getHeight();
        return this.fFigureOrigin;
    }

    private void displayPosition() {
        String[] stringArray = new String[]{String.valueOf(this.fPositionPoint.x), String.valueOf(this.fPositionPoint.y), String.valueOf(this.fPositionWidth), String.valueOf(this.fPositionHeight)};
        if (this.fHideX) {
            stringArray[0] = MULTI;
        }
        if (this.fHideY) {
            stringArray[1] = MULTI;
        }
        if (this.fHideW) {
            stringArray[2] = MULTI;
        }
        if (this.fHideH) {
            stringArray[3] = MULTI;
        }
        this.fSelectionField.setText(POSITION + ": [" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3] + ']');
    }

    private void displayCurrentPoint() {
        this.fCurrentPointField.setText(CURRENT_POINT + ":  [" + this.fCurrentPoint.x + ", " + this.fCurrentPoint.y + ']');
    }

    private void unhideAllPosition() {
        this.fHideX = false;
        this.fHideY = false;
        this.fHideW = false;
        this.fHideH = false;
    }

    public Point getCurrentPoint() {
        return this.fCurrentPoint;
    }

    public Rectangle getPosition() {
        return new Rectangle(this.fPositionPoint.x, this.fPositionPoint.y, this.fPositionWidth, this.fPositionHeight);
    }

    public String getCurrentTag() {
        return this.getText();
    }

    public boolean isHidingX() {
        return this.fHideX;
    }

    public boolean isHidingY() {
        return this.fHideY;
    }

    public boolean isHidingW() {
        return this.fHideW;
    }

    public boolean isHidingH() {
        return this.fHideH;
    }

    public int getUpdatesPending() {
        return this.fUpdatesPending;
    }
}

