/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.dragdrop;

import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.dragdrop.MarqueeDrag;
import com.mathworks.toolbox.matlab.guide.dragdrop.MoveTracker;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOWrapperOwner;
import com.mathworks.toolbox.matlab.guide.palette.ToolRegistry;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;

public final class AddDrag
extends MarqueeDrag
implements MoveTracker {
    private static final String ACTIVEX_NAME = "ActiveX Control";
    private int fToolID;
    private LOWrapperOwner fCurrentContainer;
    private boolean fDrawnFirstParent;

    public AddDrag(LayoutArea layoutArea, int n) {
        super(layoutArea);
        this.fToolID = n;
        this.fDrawnFirstParent = false;
    }

    public int getToolID() {
        return this.fToolID;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        Graphics graphics = this.getXORGraphics();
        this.drawContainer(graphics);
        this.fLayoutArea.getGrid().snapToGrid(this.fStartPt, 0, 0);
        if (this.fLayoutArea.selectAll(false)) {
            this.fLayoutArea.drawNow();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        Object object = ToolRegistry.buildObject(this.fToolID);
        if (object != null) {
            this.fLayoutArea.addObject(ToolRegistry.getType(this.fToolID), object, this.getBounds(), this.fCurrentContainer);
        }
    }

    @Override
    protected void constrainMarquee(boolean bl) {
        if (bl) {
            Point point = new Point(this.fCurrentPt.x - this.fStartPt.x, this.fCurrentPt.y - this.fStartPt.y);
            if (point.x > point.y) {
                this.fCurrentPt.y = this.fStartPt.y + point.x;
            } else {
                this.fCurrentPt.x = this.fStartPt.x + point.y;
            }
        }
        this.fLayoutArea.getGrid().snapToGrid(this.fCurrentPt, 0, 0);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.fCurrentPt = mouseEvent.getPoint();
        LOWrapperOwner lOWrapperOwner = this.fCurrentContainer;
        LOWrapperOwner lOWrapperOwner2 = this.fLayoutArea;
        LOControlWrapper lOControlWrapper = this.fLayoutArea.findContainer(this.fCurrentPt);
        if (lOControlWrapper != null && !ToolRegistry.getName(this.fToolID).equals(ACTIVEX_NAME)) {
            lOWrapperOwner2 = lOControlWrapper;
        }
        if (!lOWrapperOwner2.equals(lOWrapperOwner)) {
            Graphics graphics = this.getXORGraphics();
            this.drawContainer(graphics);
            this.fCurrentContainer = lOWrapperOwner2;
            this.fDrawnFirstParent = true;
            this.drawContainer(graphics);
        }
    }

    void resetTracker() {
        Graphics graphics = this.getXORGraphics();
        this.drawContainer(graphics);
        this.fToolID = this.fLayoutArea.getPalette().getSelectedButtonIndex();
        this.fCurrentContainer = null;
        this.fDrawnFirstParent = false;
    }

    private void drawContainer(Graphics graphics) {
        if (this.fDrawnFirstParent && this.fCurrentContainer != null) {
            if (this.fCurrentContainer.equals(this.fLayoutArea)) {
                this.drawDropOutline(graphics);
            } else {
                Point point = ((LOControlWrapper)this.fCurrentContainer).getBaseLocation();
                Dimension dimension = ((LOControlWrapper)this.fCurrentContainer).getControl().getSize();
                graphics.drawRect(point.x - 1, point.y - 1, dimension.width + 1, dimension.height + 1);
                graphics.drawRect(point.x - 2, point.y - 2, dimension.width + 3, dimension.height + 3);
            }
        }
    }
}

