/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.gridrulerguide;

import com.mathworks.services.Prefs;
import com.mathworks.toolbox.matlab.guide.gridrulerguide.LayoutGridTarget;
import com.mathworks.toolbox.matlab.guide.gridrulerguide.RulerGuide;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.util.Enumeration;
import java.util.Vector;

public final class LayoutGrid {
    static final int DEFAULT_GRID_WIDTH = 50;
    private static final int SNAP_TOL = 9;
    private static final int HIT_TOL = 2;
    static final String SNAPTOGRID = "LayoutSnapToGrid";
    static final String SHOWGRID = "LayoutShowGrid";
    static final String SHOWGUIDES = "LayoutShowGuides";
    static final String GRIDWIDTH = "LayoutGridWidth";
    private boolean fSnapToGrid = Prefs.getBooleanPref((String)"LayoutSnapToGrid", (boolean)true);
    private boolean fShowGrid = Prefs.getBooleanPref((String)"LayoutShowGrid", (boolean)true);
    private boolean fShowGuides = Prefs.getBooleanPref((String)"LayoutShowGuides", (boolean)true);
    private int fGridSize = Prefs.getIntegerPref((String)"LayoutGridWidth", (int)50);
    private Vector<RulerGuide> fHGuideList = new Vector();
    private Vector<RulerGuide> fVGuideList = new Vector();
    private Vector<LayoutGridTarget> fTargets = new Vector(3);

    public static int getDefaulGridSize() {
        return 50;
    }

    public void setSnapToGrid(boolean bl) {
        if (bl != this.fSnapToGrid) {
            this.fSnapToGrid = bl;
            Prefs.setBooleanPref((String)SNAPTOGRID, (boolean)this.fSnapToGrid);
            this.notifyTargets();
        }
    }

    public boolean getSnapToGrid() {
        return this.fSnapToGrid;
    }

    public void setShowGrid(boolean bl) {
        if (this.fShowGrid != bl) {
            this.fShowGrid = bl;
            Prefs.setBooleanPref((String)SHOWGRID, (boolean)this.fShowGrid);
        }
    }

    public boolean getShowGrid() {
        return this.fShowGrid;
    }

    void setShowGuides(boolean bl) {
        if (this.fShowGuides != bl) {
            this.fShowGuides = bl;
            Prefs.setBooleanPref((String)SHOWGUIDES, (boolean)this.fShowGuides);
        }
    }

    boolean getShowGuides() {
        return this.fShowGuides;
    }

    public void setGridWidth(int n) {
        if (this.fGridSize != n) {
            this.fGridSize = n;
            Prefs.setIntegerPref((String)GRIDWIDTH, (int)this.fGridSize);
        }
    }

    public int getGridWidth() {
        return this.fGridSize;
    }

    public void snapToGrid(Point point, int n, int n2) {
        int n3;
        if (this.fSnapToGrid) {
            int n4 = point.x / this.fGridSize;
            int n5 = point.y / this.fGridSize;
            n3 = point.x - n4 * this.fGridSize;
            int n6 = point.y - n5 * this.fGridSize;
            if (n3 < 9) {
                point.x = n4 * this.fGridSize + n;
            } else if (this.fGridSize - n3 < 9) {
                point.x = (n4 + 1) * this.fGridSize + n;
            }
            if (n6 < 9) {
                point.y = n5 * this.fGridSize + n2;
            } else if (this.fGridSize - n6 < 9) {
                point.y = (n5 + 1) * this.fGridSize + n2;
            }
        }
        Enumeration<RulerGuide> enumeration = this.fHGuideList.elements();
        while (enumeration.hasMoreElements()) {
            RulerGuide rulerGuide = enumeration.nextElement();
            n3 = Math.abs(rulerGuide.getLocation() - point.y);
            if (n3 >= 9) continue;
            point.y = rulerGuide.getLocation() + n2;
        }
        enumeration = this.fVGuideList.elements();
        while (enumeration.hasMoreElements()) {
            RulerGuide rulerGuide = enumeration.nextElement();
            n3 = Math.abs(rulerGuide.getLocation() - point.x);
            if (n3 >= 9) continue;
            point.x = rulerGuide.getLocation() + n;
        }
    }

    public Point getGridSnapRect(Rectangle rectangle, int n, int n2) {
        Point point = new Point(this.getSnapX(rectangle), this.getSnapY(rectangle));
        if (point.x + rectangle.x + rectangle.width > n) {
            point.x = 0;
        }
        if (point.y + rectangle.y + rectangle.height > n2) {
            point.y = 0;
        }
        return point;
    }

    private int getSnapDelta(int n) {
        int n2 = this.fGridSize / 2;
        if ((n %= this.fGridSize) < n2) {
            return n * -1;
        }
        return this.fGridSize - n;
    }

    private int getSnapX(Rectangle rectangle) {
        int n;
        int n2 = 0;
        int n3 = this.getSnapDelta(rectangle.x);
        int n4 = this.getSnapDelta(rectangle.x + rectangle.width);
        int n5 = Math.abs(n3);
        if (n5 <= (n = Math.abs(n4))) {
            if (n5 < 9) {
                n2 = n3;
            }
        } else if (n < 9) {
            n2 = n4;
        }
        return n2;
    }

    private int getSnapY(Rectangle rectangle) {
        int n;
        int n2 = 0;
        int n3 = this.getSnapDelta(rectangle.y);
        int n4 = this.getSnapDelta(rectangle.y + rectangle.height);
        int n5 = Math.abs(n3);
        if (n5 <= (n = Math.abs(n4))) {
            if (n5 < 9) {
                n2 = n3;
            }
        } else if (n < 9) {
            n2 = n4;
        }
        return n2;
    }

    public Point getGuideSnapRect(Rectangle rectangle, int n, int n2) {
        int n3;
        int n4;
        RulerGuide rulerGuide;
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Point point = new Point(0, 0);
        rectangle2.x = rectangle.x;
        rectangle2.y = rectangle.y;
        rectangle2.width = rectangle.width;
        rectangle2.height = rectangle.height;
        Enumeration<RulerGuide> enumeration = this.fHGuideList.elements();
        while (enumeration.hasMoreElements()) {
            rulerGuide = enumeration.nextElement();
            n4 = rulerGuide.getLocation();
            n3 = rectangle.y - n4;
            if (n3 > 0) {
                if (n3 <= 9) {
                    point.y = n3 * -1;
                }
            } else {
                n3 = n4 - rectangle.y;
                if (n3 <= 9 && n3 + rectangle.y + rectangle.height <= n2) {
                    point.y = n3;
                }
            }
            if (point.y != 0) continue;
            n3 = rectangle.y + rectangle.height - n4;
            if (n3 > 0) {
                if (n3 > 9 || rectangle.y - n3 <= 0) continue;
                point.y = n3 * -1 + 1;
                continue;
            }
            n3 = n4 - (rectangle.y + rectangle.height);
            if (n3 > 9) continue;
            point.y = n3 + 1;
        }
        enumeration = this.fVGuideList.elements();
        while (enumeration.hasMoreElements()) {
            rulerGuide = enumeration.nextElement();
            n4 = rulerGuide.getLocation();
            n3 = rectangle.x - n4;
            if (n3 > 0) {
                if (n3 <= 9) {
                    point.x = n3 * -1;
                }
            } else {
                n3 = n4 - rectangle.x;
                if (n3 <= 9 && n3 + rectangle.x + rectangle.width <= n) {
                    point.x = n3;
                }
            }
            if (point.x != 0) continue;
            n3 = rectangle.x + rectangle.width - n4;
            if (n3 > 0) {
                if (n3 > 9 || rectangle.x - n3 <= 0) continue;
                point.x = n3 * -1 + 1;
                continue;
            }
            n3 = n4 - (rectangle.x + rectangle.width);
            if (n3 > 9) continue;
            point.x = n3 + 1;
        }
        rectangle2.translate(point.x, point.y);
        return point;
    }

    public void paintGrid(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Color color = graphics.getColor();
        Color color2 = Color.blue;
        if (this.fShowGrid) {
            int n;
            graphics.setColor(SystemColor.controlShadow);
            for (n = rectangle.y / this.fGridSize * this.fGridSize; n < rectangle.y + rectangle.height; n += this.fGridSize) {
                graphics.drawLine(rectangle.x, n, rectangle.x + rectangle.width, n);
            }
            for (n = rectangle.x / this.fGridSize * this.fGridSize; n < rectangle.x + rectangle.width; n += this.fGridSize) {
                graphics.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
            }
        }
        if (this.fShowGuides) {
            int n;
            RulerGuide rulerGuide;
            graphics.setColor(color2);
            Enumeration<RulerGuide> enumeration = this.fHGuideList.elements();
            while (enumeration.hasMoreElements()) {
                rulerGuide = enumeration.nextElement();
                n = rulerGuide.getLocation();
                graphics.drawLine(rectangle.x, n, rectangle.x + rectangle.width, n);
            }
            enumeration = this.fVGuideList.elements();
            while (enumeration.hasMoreElements()) {
                rulerGuide = enumeration.nextElement();
                n = rulerGuide.getLocation();
                graphics.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
            }
        }
        graphics.setColor(color);
    }

    public void addGuide(RulerGuide rulerGuide) {
        if (rulerGuide.getOrientation() == 1) {
            this.fHGuideList.addElement(rulerGuide);
        } else {
            this.fVGuideList.addElement(rulerGuide);
        }
    }

    public void removeGuide(RulerGuide rulerGuide) {
        if (rulerGuide.getOrientation() == 1) {
            this.fHGuideList.removeElement(rulerGuide);
        } else {
            this.fVGuideList.removeElement(rulerGuide);
        }
    }

    public RulerGuide findGuide(Point point) {
        if (this.fShowGuides) {
            RulerGuide rulerGuide;
            Enumeration<RulerGuide> enumeration = this.fHGuideList.elements();
            while (enumeration.hasMoreElements()) {
                rulerGuide = enumeration.nextElement();
                if (rulerGuide.getLocation() < point.y - 2 || rulerGuide.getLocation() > point.y + 2) continue;
                return rulerGuide;
            }
            enumeration = this.fVGuideList.elements();
            while (enumeration.hasMoreElements()) {
                rulerGuide = enumeration.nextElement();
                if (rulerGuide.getLocation() < point.x - 2 || rulerGuide.getLocation() > point.x + 2) continue;
                return rulerGuide;
            }
        }
        return null;
    }

    public void addLayoutGridTarget(LayoutGridTarget layoutGridTarget) {
        if (layoutGridTarget != null) {
            this.fTargets.addElement(layoutGridTarget);
            layoutGridTarget.snapToGridChanged(this.fSnapToGrid);
        }
    }

    void removeLayoutGridTarget(LayoutGridTarget layoutGridTarget) {
        this.fTargets.removeElement(layoutGridTarget);
    }

    void notifyTargets() {
        if (!this.fTargets.isEmpty()) {
            Enumeration<LayoutGridTarget> enumeration = this.fTargets.elements();
            while (enumeration.hasMoreElements()) {
                LayoutGridTarget layoutGridTarget = enumeration.nextElement();
                layoutGridTarget.snapToGridChanged(this.fSnapToGrid);
            }
        }
    }
}

