/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.layouttool;

import com.mathworks.services.ObjectOwner;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.ObjectRegistryEvent;
import com.mathworks.services.ObjectRegistryListener;
import com.mathworks.toolbox.matlab.guide.LayoutEditor;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.layouttool.LayoutToolInfo;
import com.mathworks.toolbox.matlab.guide.layouttool.LayoutToolRegistry;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class LayoutToolHandler
implements ObjectRegistryListener,
ItemListener {
    private LayoutEditor fLayout;
    public static final String START_TOOL = "start";
    public static final String STOP_TOOL = "stop";
    public static final String SELECTION_CHANGE = "select";
    public static final String OBJECT_CHANGE = "update";
    public static final String RECOGNIZABLE = "isRecognizable";
    public static final String GUIDE_TOOL_INTERFACE = "GUIDE2ToolInterface";
    public static final String TOOL_GUIDE_INTERFACE = "Tool2GUIDEInterface";

    public LayoutToolHandler(LayoutEditor layoutEditor) {
        this.fLayout = layoutEditor;
        ObjectRegistry.getLayoutRegistry().addObjectRegistryListener((ObjectRegistryListener)this);
        ObjectRegistry.getLayoutRegistry().addItemListener((ItemListener)this);
    }

    public void cleanUp() {
        ObjectRegistry.getLayoutRegistry().removeObjectRegistryListener((ObjectRegistryListener)this);
        ObjectRegistry.getLayoutRegistry().removeItemListener((ItemListener)this);
        this.fLayout = null;
    }

    public void addObject(Object[] objectArray, Object object, boolean bl) {
        ObjectRegistry.getLayoutRegistry().register(objectArray, object, -1, (ObjectOwner)this.fLayout, bl);
    }

    public void removeObject(Object[] objectArray) {
        ObjectRegistry.getLayoutRegistry().unregister(objectArray);
    }

    public void selectObject(Object[] objectArray, boolean bl) {
        ObjectRegistry.getLayoutRegistry().setSelected(objectArray, bl);
    }

    public void moveObject(Object[] objectArray, Object object, int n) {
        ObjectRegistry.getLayoutRegistry().move(objectArray, object, n);
    }

    public void inspectObject(Object[] objectArray) {
        this.selectObject(objectArray, true);
        LayoutEditor.showInspector();
    }

    public void changeObject(Object[] objectArray) {
        ObjectRegistry.getLayoutRegistry().change(objectArray);
    }

    public static String[] getExpectedToolActions() {
        return new String[]{START_TOOL, "Called by GUIDE to show the tool on screen", STOP_TOOL, "Called by GUIDE when GUIDE closes", SELECTION_CHANGE, "Called by GUIDE when its selected GUI object changed", OBJECT_CHANGE, "Called by GUIDE when the property of certain GUI object changed", RECOGNIZABLE, "Called by GUIDE to determine whether a tool can manipulate a given object"};
    }

    public void doToolAction(String string) {
        this.doToolAction(string, null);
    }

    public void doToolAction(int n, String string) {
        this.doToolAction(n, string, null);
    }

    private void doToolAction(String string, Object[] objectArray) {
        if (this.fLayout.getHandle() != null) {
            LayoutToolInfo[] layoutToolInfoArray = LayoutToolRegistry.getTools();
            for (int i = 0; i < layoutToolInfoArray.length; ++i) {
                this.doToolAction(i, string, objectArray);
            }
        }
    }

    private void doToolAction(int n, String string, Object[] objectArray) {
        if (this.fLayout.getHandle() != null) {
            LayoutToolInfo[] layoutToolInfoArray = LayoutToolRegistry.getTools();
            if (START_TOOL.equals(string) || layoutToolInfoArray[n].isRunning()) {
                if (objectArray == null) {
                    objectArray = ObjectRegistry.getLayoutRegistry().getSelectedObjects();
                }
                LayoutLooper.doToolAction(string, this.fLayout, this.fLayout.getHandle(), layoutToolInfoArray[n], objectArray);
            }
        }
    }

    public void objectRegistered(ObjectRegistryEvent objectRegistryEvent) {
        this.askLayoutToUpdate(objectRegistryEvent);
    }

    public void objectUnregistered(ObjectRegistryEvent objectRegistryEvent) {
        this.askLayoutToUpdate(objectRegistryEvent);
    }

    public void objectChanged(ObjectRegistryEvent objectRegistryEvent) {
        this.askLayoutToUpdate(objectRegistryEvent);
        this.doToolAction(OBJECT_CHANGE, objectRegistryEvent.getObjects());
    }

    public void objectMoved(ObjectRegistryEvent objectRegistryEvent) {
        this.askLayoutToUpdate(objectRegistryEvent);
    }

    public void transactionStarted(ObjectRegistryEvent objectRegistryEvent) {
    }

    public void transactionEnded(ObjectRegistryEvent objectRegistryEvent) {
    }

    private void askLayoutToUpdate(ObjectRegistryEvent objectRegistryEvent) {
        this.fLayout.contentChanged(objectRegistryEvent.getChangeSource());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.doToolAction(SELECTION_CHANGE);
        }
    }
}

