/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.palette;

import com.mathworks.hg.types.HGRectangle;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.toolbox.matlab.guide.HGControl;
import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.palette.DefaultProxy;
import com.mathworks.toolbox.matlab.guide.palette.MObjectWrapper;
import com.mathworks.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public abstract class MObjectProxy
extends Container {
    protected int fType;
    protected int fStyle;
    protected MObjectWrapper fWrapper;
    private String fTag;
    protected int fParentHeight;
    public static final int ML_UDD_OBJECT = 0;
    public static final int ML_HG_UICONTROL = 1;
    public static final int ML_HG_AXES = 2;
    public static final int ML_HG_UIPANEL = 3;
    public static final int ML_JAVA_AWT = 4;
    public static final int ML_JAVA_SWING = 5;
    public static final int ML_ACTIVEX = 6;
    static final String[] MLOBJECT_TYPE_NAMES = new String[]{"udd", "uicontrol", "axes", "uipanel", "awt", "swing", "activex"};
    private static final Font DEFAULT_FONT = new Font("SansSerif", 0, 10);
    protected Component fComponent;
    protected Image fComponentImage;
    protected Component fComponentView;
    protected static final int RENDER_DIRECT = 0;
    protected static final int RENDER_IMAGE = 1;
    protected static final int RENDER_COMPONENT = 2;
    protected static int sRenderingMethod = 2;
    protected static boolean sShowTable = true;

    public static void setRenderingMethod(int n) {
        sRenderingMethod = n;
    }

    public static void setShowTable(boolean bl) {
        sShowTable = bl;
    }

    protected abstract Component buildComponent();

    Component getComponent() {
        return this.fComponent;
    }

    protected void updateProxyImage(UDDObject uDDObject) {
    }

    Image getComponentImage() {
        return this.fComponentImage;
    }

    void setComponentImage(Image image) {
        this.fComponentImage = image;
    }

    protected void updateProxyComponent(UDDObject uDDObject) {
    }

    Component getComponentView() {
        return this.fComponentView;
    }

    void setComponentView(Component component) {
        this.fComponentView = component;
    }

    public boolean isProxyCreated() {
        return this.fComponent != null;
    }

    public int getType() {
        return this.fType;
    }

    public String getTypeString() {
        return MLOBJECT_TYPE_NAMES[this.fType];
    }

    public int getStyle() {
        return this.fStyle;
    }

    public String getStyleString() {
        return null;
    }

    public Object[] getProxyData() {
        return null;
    }

    public void setProxyData(Object[] objectArray) {
    }

    MObjectWrapper getWrapper() {
        return this.fWrapper;
    }

    void setWrapper(MObjectWrapper mObjectWrapper) {
        this.fWrapper = mObjectWrapper;
    }

    public ArrayList<String> getDisplayStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isProxyCreated()) {
            if (this.fTag != null) {
                arrayList.add(this.fTag);
            } else if (this.getStyleString() != null) {
                arrayList.add(this.getStyleString());
            } else {
                arrayList.add(this.getTypeString());
            }
        }
        return arrayList;
    }

    final void init(int n, int n2) {
        this.init(n, n2, null, null);
    }

    final void init(int n, int n2, Object object, final Component component) {
        this.fType = n;
        this.fStyle = n2;
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (MObjectProxy.this.fComponent != null) {
                        MObjectProxy.this.remove(MObjectProxy.this.fComponent);
                        MObjectProxy.this.fComponent = null;
                    }
                    MObjectProxy.this.fComponentImage = null;
                    MObjectProxy.this.fComponentView = component;
                    MObjectProxy.this.fComponent = MObjectProxy.this.buildComponent();
                    if (MObjectProxy.this.fComponent != null) {
                        MObjectProxy.this.fComponent.setFont(DEFAULT_FONT);
                        MObjectProxy.this.setLayout(new BorderLayout());
                        MObjectProxy.this.add(MObjectProxy.this.fComponent, "Center");
                    }
                }
            });
        }
        catch (Throwable throwable) {
            Log.logThrowable((Throwable)throwable);
        }
        if (object != null) {
            this.updateProxy(object);
        }
        if (this.fWrapper != null) {
            this.fWrapper.syncWithMObject();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (sRenderingMethod == 2) {
            if (this.getComponentView() != null) {
                Container container = this.getComponentView().getParent();
                boolean bl = this.getComponentView().isVisible();
                LayoutManager layoutManager = this.getLayout();
                this.removeAll();
                this.setLayout(null);
                this.add(this.getComponentView(), 0);
                if (container != null) {
                    this.getComponentView().setBounds(0, 0, container.getWidth(), container.getHeight());
                } else {
                    this.getComponentView().setBounds(0, 0, this.getWidth(), this.getHeight());
                }
                this.getComponentView().setVisible(true);
                this.validate();
                this.getComponentView().paint(graphics);
                this.getComponentView().setVisible(bl);
                this.remove(this.getComponentView());
                if (container != null) {
                    container.add(this.getComponentView());
                }
                this.setLayout(layoutManager);
                this.add(this.fComponent);
            } else if (this.canUseDefaultProxy()) {
                this.paintWithDefaultProxy(graphics);
            } else {
                super.paint(graphics);
            }
        } else if (sRenderingMethod == 1) {
            if (this.getComponentImage() != null) {
                graphics.drawImage(this.getComponentImage(), 0, 0, this);
            } else if (this.canUseDefaultProxy()) {
                this.paintWithDefaultProxy(graphics);
            } else {
                super.paint(graphics);
            }
        } else {
            super.paint(graphics);
        }
    }

    protected boolean canUseDefaultProxy() {
        return false;
    }

    private void paintWithDefaultProxy(Graphics graphics) {
        DefaultProxy.getInstance().setBackground(this.fComponent.getBackground());
        this.add((Component)((Object)DefaultProxy.getInstance()), "Center");
        this.validate();
        DefaultProxy.getInstance().paint(graphics);
        this.remove((Component)((Object)DefaultProxy.getInstance()));
    }

    public void updateProxy(Object object) {
        if (object instanceof UDDObject) {
            this.updatePosition((UDDObject)object);
            this.updateTag((UDDObject)object);
            this.updateProxyImage((UDDObject)object);
            this.updateProxyComponent((UDDObject)object);
        }
    }

    protected void updateTag(UDDObject uDDObject) {
        String[] stringArray = new String[]{this.fTag};
        Object object = HGControl.getPropertyValueForCompatibility(uDDObject, "Tag");
        if (object instanceof String) {
            stringArray = new String[]{(String)object};
        } else if (object instanceof String[]) {
            stringArray = (String[])object;
        }
        this.fTag = stringArray[0];
        this.repaint(5L);
    }

    public void updatePosition(UDDObject uDDObject) {
        if (uDDObject != null) {
            int n = 4;
            Object object = HGControl.getPropertyValueForCompatibility(uDDObject, "Units");
            if (object != null && object instanceof Integer) {
                n = (Integer)object;
            }
            if (n != 4) {
                HGControl.setPropertyValueForCompatibility(uDDObject, "Units", new Integer(4));
            }
            String string = "Position";
            object = HGControl.getPropertyValueForCompatibility(uDDObject, string);
            if (n != 4) {
                HGControl.setPropertyValueForCompatibility(uDDObject, "Units", new Integer(n));
            }
            if (object != null && object instanceof HGRectangle) {
                this.updateComponentPosition((HGRectangle)object);
            }
        }
    }

    private void updateComponentPosition(final HGRectangle hGRectangle) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateComponentPositionAWT(hGRectangle);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MObjectProxy.this.updateComponentPositionAWT(hGRectangle);
                }
            });
        }
    }

    protected void updateComponentPositionAWT(HGRectangle hGRectangle) {
        Rectangle rectangle = this.getBounds();
        if (hGRectangle != null && hGRectangle instanceof HGRectangle) {
            Container container = this.getParent();
            if (container != null) {
                this.fParentHeight = container.getSize().height;
            }
            rectangle.x = (int)Math.round(hGRectangle.getX());
            rectangle.y = this.fParentHeight - (int)(Math.round(hGRectangle.getY()) + Math.round(hGRectangle.getHeight()));
            rectangle.width = (int)Math.round(hGRectangle.getWidth());
            rectangle.height = (int)Math.round(hGRectangle.getHeight());
        }
        this.setBounds(rectangle);
        LayoutArea.forceLayout(this);
    }

    boolean isEnclosure() {
        return this.fType == 3;
    }

    public boolean isEnclosable() {
        return this.fType != 6;
    }

    boolean canEnclose(int n) {
        return this.isEnclosure() && n != 6;
    }
}

