/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.undoredo;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.toolbox.matlab.guide.LayoutEditor;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import java.util.ResourceBundle;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class LayoutUndoManager
extends UndoManager {
    private static ResourceBundle RES_BUNDLE = ResourceBundle.getBundle("com.mathworks.toolbox.matlab.guide.undoredo.resources.RES_UndoRedo");
    private static final String UNDO_TEXT = RES_BUNDLE.getString("undo.undo");
    private static final String REDO_TEXT = RES_BUNDLE.getString("undo.redo");
    private boolean fBusy;
    private LayoutEditor fLayoutEditor;
    private UndoableEditSupport support;
    private Object layoutSource;

    public LayoutUndoManager(LayoutEditor layoutEditor) {
        this.fLayoutEditor = layoutEditor;
        this.fBusy = false;
        this.support = new ExtendedUndoableEditSupport();
        this.layoutSource = this;
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit undoableEdit) {
        boolean bl = super.addEdit(undoableEdit);
        if (bl) {
            this.support.postEdit(undoableEdit);
        }
        return bl;
    }

    @Override
    public synchronized void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        UndoableEdit undoableEdit = undoableEditEvent.getEdit();
        this.layoutSource = undoableEditEvent.getSource();
        this.addEdit(undoableEdit);
    }

    public synchronized void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.support.addUndoableEditListener(undoableEditListener);
    }

    public synchronized void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.support.removeUndoableEditListener(undoableEditListener);
    }

    public synchronized boolean hasRedo() {
        return super.editToBeRedone() != null;
    }

    public synchronized String getRedoName() {
        if (this.hasRedo()) {
            return super.editToBeRedone().getRedoPresentationName();
        }
        return REDO_TEXT;
    }

    public synchronized boolean hasUndo() {
        return super.editToBeUndone() != null;
    }

    public synchronized String getUndoName() {
        if (this.hasUndo()) {
            return super.editToBeUndone().getUndoPresentationName();
        }
        return UNDO_TEXT;
    }

    private void begin() {
        this.fBusy = false;
        if (this.fLayoutEditor.getHandle() != null) {
            this.fBusy = true;
            LayoutLooper.executeInM("trackUndoRedo", (Object)new UndoRedoCompleted());
        }
        this.fLayoutEditor.updateUndoRedoDisplay();
    }

    private void finish() {
        this.fBusy = false;
        this.fLayoutEditor.updateUndoRedoDisplay();
    }

    private boolean isBusy() {
        return this.fBusy;
    }

    @Override
    public synchronized boolean canUndo() {
        return super.canUndo() && !this.isBusy();
    }

    @Override
    public synchronized boolean canRedo() {
        return super.canRedo() && !this.isBusy();
    }

    @Override
    public synchronized void undo() {
        super.undo();
        this.begin();
    }

    @Override
    public synchronized void redo() {
        super.redo();
        this.begin();
    }

    class UndoRedoCompleted
    implements CompletionObserver {
        UndoRedoCompleted() {
        }

        public void completed(int n, Object object) {
            LayoutUndoManager.this.finish();
        }
    }

    class ExtendedUndoableEditSupport
    extends UndoableEditSupport {
        ExtendedUndoableEditSupport() {
        }

        @Override
        public synchronized void postEdit(UndoableEdit undoableEdit) {
            if (LayoutUndoManager.this.layoutSource == null) {
                LayoutUndoManager.this.layoutSource = LayoutUndoManager.this.fLayoutEditor;
            }
            this.realSource = LayoutUndoManager.this.layoutSource;
            super.postEdit(undoableEdit);
        }
    }
}

