/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.undoredo;

import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.palette.GObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.undoredo.LayoutUndoableEdit;
import java.util.Vector;

public class UndoProperty
extends LayoutUndoableEdit {
    private LayoutArea fLayout;
    private LOControlWrapper[] fWrappers;
    private int fWrapperCount;
    private Object[] fOldValues;
    private Object[] fNewValues;

    public UndoProperty(LayoutArea layoutArea, Vector vector, Vector vector2) {
        int n;
        this.fLayout = layoutArea;
        this.fWrapperCount = vector.size();
        this.fOldValues = new Object[this.fWrapperCount];
        this.fNewValues = new Object[this.fWrapperCount];
        this.fWrappers = new LOControlWrapper[this.fWrapperCount];
        for (n = 0; n < vector2.size(); ++n) {
            this.fNewValues[n] = vector2.elementAt(n);
        }
        for (n = 0; n < this.fWrapperCount; ++n) {
            this.fWrappers[n] = (LOControlWrapper)vector.elementAt(n);
            if (!this.fWrappers[n].isGObject()) continue;
            this.fOldValues[n] = ((GObjectWrapper)this.fWrappers[n]).getProperties();
        }
    }

    @Override
    public void undo() {
        this.fLayout.selectAll(false);
        Vector<LOControlWrapper> vector = new Vector<LOControlWrapper>();
        for (int i = 0; i < this.fWrapperCount; ++i) {
            if (!this.fWrappers[i].isGObject()) continue;
            vector.addElement(this.fWrappers[i]);
            this.fLayout.selectObject(this.fWrappers[i], true);
            Object[] objectArray = (Object[])this.fOldValues[i];
            ((GObjectWrapper)this.fWrappers[i]).setProperties(objectArray);
        }
        LayoutLooper.setProperty(vector, this.fOldValues, this.fLayout);
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        this.fLayout.repaint(5L);
    }

    @Override
    public void redo() {
        this.fLayout.selectAll(false);
        Vector<LOControlWrapper> vector = new Vector<LOControlWrapper>();
        for (int i = 0; i < this.fWrapperCount; ++i) {
            if (!this.fWrappers[i].isGObject()) continue;
            vector.addElement(this.fWrappers[i]);
            this.fLayout.selectObject(this.fWrappers[i], true);
            Object[] objectArray = (Object[])this.fNewValues[i];
            ((GObjectWrapper)this.fWrappers[i]).setProperties(objectArray);
        }
        LayoutLooper.setProperty(vector, this.fNewValues, this.fLayout);
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        this.fLayout.repaint(5L);
    }

    @Override
    String getUndoTypeKey() {
        return "undo.property";
    }
}

