/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search;

import com.mathworks.search.SearchField;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultAdapter;
import com.mathworks.search.SimpleResultAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CachingResultAdapter<T>
implements SearchResultAdapter<T> {
    private final Collection<SearchField> fFields;
    private final SearchResultAdapter<T> fRealAdapter;

    private CachingResultAdapter(SearchResultAdapter<T> realAdapter, Collection<SearchField> fieldsToCache) {
        this.fRealAdapter = realAdapter;
        this.fFields = new ArrayList<SearchField>(fieldsToCache);
    }

    public static CachingResultAdapter<SearchResult> createAdapter(Collection<SearchField> fieldsToCache) {
        return new CachingResultAdapter<SearchResult>(new SimpleResultAdapter(), fieldsToCache);
    }

    public static <T> CachingResultAdapter<T> createAdapter(SearchResultAdapter<T> realAdapter, Collection<SearchField> fieldsToCache) {
        return new CachingResultAdapter<T>(realAdapter, fieldsToCache);
    }

    @Override
    public T adaptResult(SearchResult result) {
        CachedSearchResult cached = new CachedSearchResult(result);
        return this.fRealAdapter.adaptResult(cached);
    }

    private class CachedSearchResult
    implements SearchResult {
        private final Map<String, String> iFieldValues = new HashMap<String, String>();
        private final float iScore;

        private CachedSearchResult(SearchResult result) {
            this.iScore = result.getScore();
            for (SearchField field : CachingResultAdapter.this.fFields) {
                this.iFieldValues.put(field.getFieldName(), result.getFieldValue(field.getFieldName()));
            }
        }

        @Override
        public String getFieldValue(String fieldName) {
            return this.iFieldValues.get(fieldName);
        }

        @Override
        public float getScore() {
            return this.iScore;
        }
    }
}

