/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search;

import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.CompoundSearchExpression;
import com.mathworks.search.ExactPhraseSearchExpression;
import com.mathworks.search.PartialWordSearchExpression;
import com.mathworks.search.SearchCriteria;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchStringParseException;
import com.mathworks.search.SimpleSearchExpression;
import com.mathworks.search.UnarySearchExpression;
import com.mathworks.search.WildcardSearchExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchStringParser {
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String NOT = "NOT";
    private static final char JAPANESE_FULL_WIDTH_CHAR = '\u3000';
    private static final Pattern SEARCH_TERM_PATTERN = Pattern.compile("(\\([^\\(\\)]+\\)|\"[^\"]+\"|\\S+)");
    private static final Pattern SPECIAL_CHARS_PATTERN = Pattern.compile("[^\\p{L}\\p{N}\\*_]+");
    private static final Set<String> sCommonWords;
    private static final String[] COMMON_WORDS;

    private SearchStringParser() {
    }

    public static SearchCriteria buildSearchCriteria(String searchString) throws SearchStringParseException {
        SearchExpression expr = SearchStringParser.buildExpression(searchString);
        return new SearchCriteria(expr);
    }

    public static SearchExpression buildExpression(String searchString, BooleanSearchOperator operator, SearchField ... fields) throws SearchStringParseException {
        SearchExpression expr = SearchStringParser.buildExpression(searchString);
        expr.setBooleanOperator(operator);
        if (fields != null) {
            for (SearchField field : fields) {
                expr.addSearchField(field);
            }
        }
        return expr;
    }

    public static SearchExpression buildExpression(String searchString) throws SearchStringParseException {
        return new SearchExpressionBuilder(searchString).buildExpression();
    }

    static {
        COMMON_WORDS = new String[]{"a", "an", "of", "the"};
        sCommonWords = new HashSet<String>();
        Collections.addAll(sCommonWords, COMMON_WORDS);
    }

    private static class SearchExpressionBuilder {
        private final Matcher fWordMatcher;
        private final List<SearchExpression> iSearchExprs = new ArrayList<SearchExpression>();
        private UnarySearchExpression[] iPendingExprs = null;
        private CompoundSearchExpression iOrExpr = null;
        private boolean iNegated = false;
        private boolean iAfterOr = false;
        private boolean iFoundNonsearchableWord = false;

        private SearchExpressionBuilder(String searchString) throws SearchStringParseException {
            if (searchString == null || searchString.trim().length() == 0) {
                throw new SearchStringParseException(SearchStringParseException.Type.EMPTY_SEARCH_STRING);
            }
            String adjustedSearchString = SearchExpressionBuilder.adjustSearchString(searchString);
            this.fWordMatcher = SEARCH_TERM_PATTERN.matcher(adjustedSearchString);
        }

        private static String adjustSearchString(String searchString) {
            String adjustedString = searchString;
            if (searchString.indexOf(12288) > -1) {
                adjustedString = adjustedString.replace('\u3000', ' ');
            }
            return adjustedString;
        }

        private SearchExpression buildExpression() throws SearchStringParseException {
            while (this.fWordMatcher.find()) {
                String word = this.fWordMatcher.group();
                if (word.equals(SearchStringParser.NOT)) {
                    this.iFoundNonsearchableWord = true;
                    this.iNegated = true;
                    continue;
                }
                if (word.equals(SearchStringParser.OR)) {
                    this.handleOrKeyword();
                    this.iFoundNonsearchableWord = true;
                    this.iAfterOr = true;
                    continue;
                }
                boolean foundWord = this.handleSearchWord(word);
                if (!foundWord) continue;
                this.iNegated = false;
                this.iAfterOr = false;
            }
            this.addPendingExpressions();
            if (this.iSearchExprs.isEmpty()) {
                SearchStringParseException.Type reason = this.iFoundNonsearchableWord ? SearchStringParseException.Type.NO_SEARCHABLE_WORDS : SearchStringParseException.Type.TOO_FEW_CHARS;
                throw new SearchStringParseException(reason);
            }
            if (this.iSearchExprs.size() == 1) {
                return this.iSearchExprs.get(0);
            }
            return new CompoundSearchExpression(this.iSearchExprs);
        }

        private void handleOrKeyword() {
            if (this.iOrExpr == null) {
                this.iOrExpr = new CompoundSearchExpression();
            }
            if (this.iPendingExprs != null) {
                for (UnarySearchExpression pendingExpr : this.iPendingExprs) {
                    pendingExpr.setBooleanOperator(BooleanSearchOperator.SHOULD_OCCUR);
                    this.iOrExpr.addExpression(pendingExpr);
                }
                this.iPendingExprs = null;
            }
        }

        private boolean handleSearchWord(String word) throws SearchStringParseException {
            if (word.equals(SearchStringParser.AND) || sCommonWords.contains(word.toLowerCase(Locale.ENGLISH))) {
                this.iFoundNonsearchableWord = true;
                return false;
            }
            if (!this.iAfterOr) {
                this.addPendingExpressions();
                this.iPendingExprs = this.buildUnaryExpressions(word);
                return this.iPendingExprs != null;
            }
            return this.handleSearchWordAfterOr(word);
        }

        private boolean handleSearchWordAfterOr(String word) throws SearchStringParseException {
            if (this.iOrExpr != null) {
                UnarySearchExpression[] exprs = this.buildUnaryExpressions(word);
                if (exprs == null) {
                    return false;
                }
                for (UnarySearchExpression expr : exprs) {
                    BooleanSearchOperator operator = this.iNegated ? BooleanSearchOperator.MUST_NOT_OCCUR : BooleanSearchOperator.SHOULD_OCCUR;
                    expr.setBooleanOperator(operator);
                    this.iOrExpr.addExpression(expr);
                }
                this.iPendingExprs = null;
                return true;
            }
            return false;
        }

        private void addPendingExpressions() {
            if (this.iOrExpr != null && !this.iOrExpr.getExpressions().isEmpty()) {
                this.iOrExpr.setBooleanOperator(BooleanSearchOperator.MUST_OCCUR);
                this.iSearchExprs.add(this.iOrExpr);
                this.iOrExpr = null;
            }
            if (this.iPendingExprs != null) {
                this.iSearchExprs.addAll(Arrays.asList(this.iPendingExprs));
            }
        }

        private UnarySearchExpression[] buildUnaryExpressions(String expr) throws SearchStringParseException {
            BooleanSearchOperator operator = this.iNegated ? BooleanSearchOperator.MUST_NOT_OCCUR : BooleanSearchOperator.MUST_OCCUR;
            String correctedExpr = expr;
            if (correctedExpr.length() > 1 && correctedExpr.startsWith("\"") && correctedExpr.endsWith("\"")) {
                if (correctedExpr.indexOf(42) > -1) {
                    throw new SearchStringParseException(SearchStringParseException.Type.WILDCARD_IN_EXACT_PHRASE);
                }
                correctedExpr = correctedExpr.substring(1, correctedExpr.length() - 1);
            }
            if (correctedExpr.indexOf(34) > -1) {
                throw new SearchStringParseException(SearchStringParseException.Type.MISMATCHED_QUOTES);
            }
            Matcher specialCharMatcher = SPECIAL_CHARS_PATTERN.matcher(correctedExpr);
            if (specialCharMatcher.find()) {
                if (specialCharMatcher.matches()) {
                    return null;
                }
                return SearchExpressionBuilder.toExprArray(new ExactPhraseSearchExpression(correctedExpr, operator));
            }
            if (correctedExpr.indexOf(42) > -1) {
                UnarySearchExpression wildcardExpr = SearchExpressionBuilder.handleWildcardExpression(correctedExpr, operator);
                return SearchExpressionBuilder.toExprArray(wildcardExpr);
            }
            return SearchExpressionBuilder.toExprArray(new SimpleSearchExpression(correctedExpr, operator));
        }

        private static UnarySearchExpression[] toExprArray(UnarySearchExpression ... exprs) {
            return exprs;
        }

        private static UnarySearchExpression handleWildcardExpression(String expr, BooleanSearchOperator operator) throws SearchStringParseException {
            char wildcardChar = '*';
            if (expr.charAt(0) == wildcardChar) {
                throw new SearchStringParseException(SearchStringParseException.Type.STARTS_WITH_WILDCARD);
            }
            if (!expr.matches("([^" + wildcardChar + "]\\" + wildcardChar + "*){2,}")) {
                throw new SearchStringParseException(SearchStringParseException.Type.TOO_FEW_NONWILDCARD_CHARS);
            }
            if (expr.indexOf(42) == expr.length() - 1) {
                String partialWord = expr.substring(0, expr.length() - 1);
                return new PartialWordSearchExpression(partialWord, operator);
            }
            return new WildcardSearchExpression(expr, operator);
        }
    }
}

