/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.SearchLanguage;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharTokenizer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;

public class MWAnalyzer {
    private final Analyzer fAnalyzer;

    public MWAnalyzer(SearchLanguage language) {
        switch (language) {
            case JAPANESE: 
            case SIMPLIFIED_CHINESE: {
                this.fAnalyzer = new CJKAnalyzer();
                break;
            }
            default: {
                this.fAnalyzer = new HelpAnalyzer();
            }
        }
    }

    public Analyzer getIndexAnalyzer() {
        return this.fAnalyzer;
    }

    public Analyzer getSearchAnalyzer() {
        return this.fAnalyzer;
    }

    private static class LetterDigitTokenizer
    extends CharTokenizer {
        private LetterDigitTokenizer(Reader reader) {
            super(reader);
        }

        protected boolean isTokenChar(char c) {
            return Character.isLetter(c) || Character.isDigit(c) || c == '_';
        }
    }

    private static class HelpAnalyzer
    extends Analyzer {
        private HelpAnalyzer() {
        }

        public TokenStream tokenStream(String fieldName, Reader reader) {
            LetterDigitTokenizer st = new LetterDigitTokenizer(reader);
            return new LowerCaseFilter((TokenStream)st);
        }
    }
}

