/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.fiddler;

import com.sun.jini.fiddler.Fiddler;
import com.sun.jini.fiddler.FiddlerLease;
import com.sun.jini.fiddler.FiddlerRenewResults;
import com.sun.jini.fiddler.ProxyUtil;
import com.sun.jini.lease.AbstractLeaseMap;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lease.LeaseMapException;
import net.jini.id.Uuid;

class FiddlerLeaseMap
extends AbstractLeaseMap {
    final Fiddler server;
    final Uuid serverID;
    static /* synthetic */ Class class$net$jini$core$lease$Lease;
    static /* synthetic */ Class class$com$sun$jini$fiddler$Fiddler;
    static /* synthetic */ Class array$Lnet$jini$id$Uuid;
    static /* synthetic */ Class array$J;

    static FiddlerLeaseMap createLeaseMap(FiddlerLease fiddlerLease, long l) {
        if (fiddlerLease instanceof FiddlerLease.ConstrainableFiddlerLease) {
            MethodConstraints methodConstraints = ((FiddlerLease.ConstrainableFiddlerLease)fiddlerLease).getConstraints();
            return new ConstrainableFiddlerLeaseMap(fiddlerLease.getServer(), fiddlerLease, l, methodConstraints);
        }
        return new FiddlerLeaseMap(fiddlerLease.getServer(), fiddlerLease, l);
    }

    private FiddlerLeaseMap(Fiddler fiddler, FiddlerLease fiddlerLease, long l) {
        super(fiddlerLease, l);
        this.server = fiddler;
        this.serverID = fiddlerLease.getServerID();
    }

    public boolean canContainKey(Object object) {
        return object instanceof FiddlerLease && this.serverID.equals((Object)((FiddlerLease)object).getServerID());
    }

    public void renewAll() throws LeaseMapException, RemoteException {
        int n = this.map.size();
        if (n == 0) {
            return;
        }
        Uuid[] uuidArray = new Uuid[n];
        Uuid[] uuidArray2 = new Uuid[n];
        long[] lArray = new long[n];
        int n2 = 0;
        Object object = this.map.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = object.next();
            FiddlerLease fiddlerLease = (FiddlerLease)entry.getKey();
            uuidArray[n2] = fiddlerLease.getRegistrationID();
            uuidArray2[n2] = fiddlerLease.getLeaseID();
            lArray[n2] = (Long)entry.getValue();
            ++n2;
        }
        object = this.server.renewLeases(uuidArray, uuidArray2, lArray);
        long l = System.currentTimeMillis();
        HashMap hashMap = ((FiddlerRenewResults)object).exceptions != null ? new HashMap(2 * ((FiddlerRenewResults)object).exceptions.length + 1) : null;
        n2 = 0;
        int n3 = 0;
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            long l2 = ((FiddlerRenewResults)object).durations[n2];
            if (l2 >= 0L) {
                ((FiddlerLease)entry.getKey()).setExpiration(l2 + l);
            } else {
                hashMap.put(entry.getKey(), ((FiddlerRenewResults)object).exceptions[n3++]);
                iterator.remove();
            }
            ++n2;
        }
        if (hashMap != null) {
            throw new LeaseMapException("lease renewal failures", hashMap);
        }
    }

    public void cancelAll() throws LeaseMapException, RemoteException {
        Serializable serializable;
        int n = this.map.size();
        if (n == 0) {
            return;
        }
        Uuid[] uuidArray = new Uuid[n];
        Uuid[] uuidArray2 = new Uuid[n];
        int n2 = 0;
        Exception[] exceptionArray = this.map.keySet().iterator();
        while (exceptionArray.hasNext()) {
            serializable = (FiddlerLease)exceptionArray.next();
            uuidArray[n2] = ((FiddlerLease)serializable).getRegistrationID();
            uuidArray2[n2] = ((FiddlerLease)serializable).getLeaseID();
            ++n2;
        }
        exceptionArray = this.server.cancelLeases(uuidArray, uuidArray2);
        if (exceptionArray == null) {
            return;
        }
        n2 = 0;
        serializable = new HashMap(13);
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            FiddlerLease fiddlerLease = (FiddlerLease)iterator.next();
            Exception exception = exceptionArray[n2];
            if (exception != null) {
                ((HashMap)serializable).put(fiddlerLease, exception);
                iterator.remove();
            }
            ++n2;
        }
        throw new LeaseMapException("lease cancellation failures", (Map)((Object)serializable));
    }

    static final class ConstrainableFiddlerLeaseMap
    extends FiddlerLeaseMap {
        private static final Method renewMethod = ProxyUtil.getMethod(class$net$jini$core$lease$Lease == null ? (class$net$jini$core$lease$Lease = FiddlerLeaseMap.class$("net.jini.core.lease.Lease")) : class$net$jini$core$lease$Lease, "renew", new Class[]{Long.TYPE});
        private static final Method cancelMethod = ProxyUtil.getMethod(class$net$jini$core$lease$Lease == null ? (class$net$jini$core$lease$Lease = FiddlerLeaseMap.class$("net.jini.core.lease.Lease")) : class$net$jini$core$lease$Lease, "cancel", new Class[0]);
        private static final Method[] methodMapArray = new Method[]{renewMethod, ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerLeaseMap.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "renewLeases", new Class[]{array$Lnet$jini$id$Uuid == null ? (array$Lnet$jini$id$Uuid = FiddlerLeaseMap.class$("[Lnet.jini.id.Uuid;")) : array$Lnet$jini$id$Uuid, array$Lnet$jini$id$Uuid == null ? (array$Lnet$jini$id$Uuid = FiddlerLeaseMap.class$("[Lnet.jini.id.Uuid;")) : array$Lnet$jini$id$Uuid, array$J == null ? (array$J = FiddlerLeaseMap.class$("[J")) : array$J}), cancelMethod, ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerLeaseMap.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "cancelLeases", new Class[]{array$Lnet$jini$id$Uuid == null ? (array$Lnet$jini$id$Uuid = FiddlerLeaseMap.class$("[Lnet.jini.id.Uuid;")) : array$Lnet$jini$id$Uuid, array$Lnet$jini$id$Uuid == null ? (array$Lnet$jini$id$Uuid = FiddlerLeaseMap.class$("[Lnet.jini.id.Uuid;")) : array$Lnet$jini$id$Uuid})};
        private static final Method[] canContainKeyMethodMapArray = new Method[]{renewMethod, renewMethod, cancelMethod, cancelMethod};
        private MethodConstraints methodConstraints;

        private ConstrainableFiddlerLeaseMap(Fiddler fiddler, FiddlerLease fiddlerLease, long l, MethodConstraints methodConstraints) {
            super(ConstrainableFiddlerLeaseMap.constrainServer(fiddler, methodConstraints), fiddlerLease, l);
            this.methodConstraints = methodConstraints;
        }

        public boolean canContainKey(Object object) {
            if (!super.canContainKey(object)) {
                return false;
            }
            if (!(object instanceof FiddlerLease.ConstrainableFiddlerLease)) {
                return false;
            }
            MethodConstraints methodConstraints = ((FiddlerLease.ConstrainableFiddlerLease)object).getConstraints();
            return ConstrainableProxyUtil.equivalentConstraints(this.methodConstraints, methodConstraints, canContainKeyMethodMapArray);
        }

        private static Fiddler constrainServer(Fiddler fiddler, MethodConstraints methodConstraints) {
            MethodConstraints methodConstraints2 = ConstrainableProxyUtil.translateConstraints(methodConstraints, methodMapArray);
            RemoteMethodControl remoteMethodControl = ((RemoteMethodControl)fiddler).setConstraints(methodConstraints2);
            return (Fiddler)remoteMethodControl;
        }
    }
}

