/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.web.util;

import com.mathworks.toolbox.javabuilder.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public abstract class ContentEncoding {
    private String fName;
    public static final ContentEncoding NONE = new ContentEncoding(null){

        @Override
        public byte[] apply(byte[] byArray) throws IOException {
            return byArray;
        }
    };
    public static final ContentEncoding GZIP = new ContentEncoding("gzip"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] apply(byte[] byArray) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 2 / 3);
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                try {
                    Streams.copyAllAvailable(byteArrayInputStream, gZIPOutputStream);
                }
                finally {
                    gZIPOutputStream.close();
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                return byArray2;
            }
            finally {
                byteArrayInputStream.close();
            }
        }
    };
    public static final ContentEncoding X_GZIP = new ContentEncoding("x-gzip"){

        @Override
        public byte[] apply(byte[] byArray) throws IOException {
            return GZIP.apply(byArray);
        }
    };
    public static final ContentEncoding DEFLATE = new ContentEncoding("deflate"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] apply(byte[] byArray) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 2 / 3);
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
                try {
                    Streams.copyAllAvailable(byteArrayInputStream, deflaterOutputStream);
                }
                finally {
                    deflaterOutputStream.close();
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                return byArray2;
            }
            finally {
                byteArrayInputStream.close();
            }
        }
    };
    private static final ContentEncoding[] sOrderOfPreference = new ContentEncoding[]{X_GZIP, GZIP, DEFLATE};

    private ContentEncoding(String string) {
        this.fName = string;
    }

    public abstract byte[] apply(byte[] var1) throws IOException;

    public String getName() {
        return this.fName;
    }

    public static ContentEncoding fromAcceptEncoding(String string) {
        boolean bl;
        if (null == string) {
            return NONE;
        }
        String string2 = System.getProperty("mathworks.www.disableHttpCompression");
        boolean bl2 = bl = string2 != null && Boolean.valueOf(string2) != false;
        if (!bl) {
            for (ContentEncoding contentEncoding : sOrderOfPreference) {
                if (!string.contains(contentEncoding.getName())) continue;
                return contentEncoding;
            }
        }
        return NONE;
    }
}

