/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.widgets;

import com.mathworks.ide.widgets.Highlighter;
import com.mathworks.ide.widgets.HighlighterState;
import com.mathworks.ide.widgets.HighlighterSupport;
import com.mathworks.ide.widgets.HighlighterToken;
import com.mathworks.ide.widgets.MHighlighterState;
import com.mathworks.ide.widgets.MScanner;
import com.mathworks.mwt.text.MWStyle;
import com.mathworks.mwt.text.MWTextModel;
import com.mathworks.util.Assert;

class MHighlighter
implements Highlighter {
    private static int[] sCategories = new int[]{0, 1, 2, 3, 4, 5, 6};
    private static MWStyle[] sDefaultStyles = new MWStyle[]{PALETTE[0], PALETTE[6], PALETTE[4], PALETTE[8], PALETTE[7], PALETTE[9], PALETTE[1]};
    private static MWStyle[] sStyles = sDefaultStyles;
    private MWStyle fTextStyle = null;
    private boolean fCRMode;

    MHighlighter() {
    }

    @Override
    public String[] getCategories() {
        String[] stringArray = new String[sCategories.length];
        for (int i = 0; i < sCategories.length; ++i) {
            stringArray[i] = CATEGORIES[sCategories[i]];
        }
        return stringArray;
    }

    @Override
    public MWStyle[] getStyles() {
        MWStyle[] mWStyleArray = new MWStyle[sCategories.length];
        for (int i = 0; i < sCategories.length; ++i) {
            mWStyleArray[i] = (MWStyle)sStyles[i].clone();
        }
        return mWStyleArray;
    }

    @Override
    public MWStyle[] getDefaultStyles() {
        MWStyle[] mWStyleArray = new MWStyle[sCategories.length];
        for (int i = 0; i < sCategories.length; ++i) {
            mWStyleArray[i] = (MWStyle)sDefaultStyles[i].clone();
        }
        return mWStyleArray;
    }

    @Override
    public MWStyle getStyle(int n) {
        if (n < 0 || n >= 7) {
            throw new IllegalArgumentException();
        }
        return sStyles[n];
    }

    @Override
    public MWStyle getStyle(String string) {
        int n = HighlighterSupport.indexFromCategory(string);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return sStyles[n];
    }

    @Override
    public void setStyle(String string, MWStyle mWStyle) {
        if (mWStyle == null) {
            throw new IllegalArgumentException();
        }
        int n = HighlighterSupport.indexFromCategory(string);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        MHighlighter.sStyles[n] = (MWStyle)mWStyle.clone();
    }

    @Override
    public void setStyles(MWStyle[] mWStyleArray) {
        if (mWStyleArray.length != sCategories.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < sCategories.length; ++i) {
            if (mWStyleArray[i] != null) continue;
            throw new IllegalArgumentException();
        }
        MWStyle[] mWStyleArray2 = new MWStyle[sCategories.length];
        for (int i = 0; i < sCategories.length; ++i) {
            mWStyleArray2[i] = (MWStyle)mWStyleArray[i].clone();
        }
        sStyles = mWStyleArray2;
    }

    @Override
    public MWStyle[] swapHighlightStyles(MWStyle[] mWStyleArray) {
        MWStyle[] mWStyleArray2;
        if (mWStyleArray == null) {
            mWStyleArray2 = sStyles;
        } else if (mWStyleArray.length == sStyles.length) {
            mWStyleArray2 = sStyles;
            sStyles = mWStyleArray;
        } else {
            mWStyleArray2 = null;
        }
        return mWStyleArray2;
    }

    @Override
    public MWStyle swapTextStyle(MWStyle mWStyle) {
        MWStyle mWStyle2 = this.fTextStyle;
        this.fTextStyle = mWStyle;
        return mWStyle2;
    }

    public void setCRIsWhiteSpace(boolean bl) {
        this.fCRMode = bl;
    }

    @Override
    public HighlighterState createState() {
        return new MHighlighterState(this.fCRMode);
    }

    @Override
    public HighlighterState createState(char[] cArray, int n, int n2) {
        return new MHighlighterState(cArray, n, n2, this.fCRMode);
    }

    @Override
    public void getNextToken(HighlighterState highlighterState, HighlighterToken highlighterToken, HighlighterState highlighterState2) {
        if (highlighterToken == null) {
            throw new IllegalArgumentException();
        }
        if (!(highlighterState instanceof MHighlighterState) || !(highlighterState instanceof MHighlighterState)) {
            throw new IllegalArgumentException();
        }
        MHighlighterState mHighlighterState = (MHighlighterState)highlighterState;
        MHighlighterState mHighlighterState2 = (MHighlighterState)highlighterState2;
        mHighlighterState2.copyFrom(mHighlighterState);
        MScanner.getNextToken(mHighlighterState2.getMScannerState());
        int n = this.categoryFromType(mHighlighterState2.getTokenType());
        if (n == 0 && this.fTextStyle != null) {
            highlighterToken.setStyle(this.fTextStyle);
        } else {
            highlighterToken.setStyle(sStyles[n]);
        }
        highlighterToken.setStart(mHighlighterState2.getTokenStart());
        highlighterToken.setEnd(mHighlighterState2.getTokenEnd());
    }

    @Override
    public void setTextStyle(MWStyle mWStyle) {
        this.fTextStyle = mWStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void highlight(MWTextModel mWTextModel, int n, int n2) {
        MWTextModel mWTextModel2 = mWTextModel;
        synchronized (mWTextModel2) {
            HighlighterSupport.highlight(this, mWTextModel, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void highlightRange(MWTextModel mWTextModel, int n, int n2) {
        MWTextModel mWTextModel2 = mWTextModel;
        synchronized (mWTextModel2) {
            HighlighterSupport.highlightRange(this, mWTextModel, n, n2);
        }
    }

    private int categoryFromType(int n) {
        switch (n) {
            case 36: {
                return 3;
            }
            case 55: 
            case 63: {
                return 2;
            }
            case 33: {
                return 5;
            }
            case 60: {
                return 4;
            }
            case 58: 
            case 59: 
            case 61: {
                return 6;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 64: 
            case 65: {
                return 1;
            }
            case 34: {
                return 0;
            }
        }
        return 0;
    }

    static {
        Assert._assert((sCategories.length == sStyles.length ? 1 : 0) != 0);
    }
}

