/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.net.transport;

import com.mathworks.net.transport.MWTransportClientProperties;
import com.mathworks.net.transport.ProxyTestThread;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

abstract class AbstractTransportClientProperties
implements MWTransportClientProperties {
    protected static final String proxyHostKey = "proxyHost";
    protected static final String proxyUserKey = "proxyUser";
    protected static final String proxyPasswordKey = "proxyPassword";
    protected static final String proxyPortKey = "proxyPort";
    protected static final String nonProxyHostsKey = "nonProxyHosts";

    AbstractTransportClientProperties() {
    }

    public abstract Properties getProtocolProperties();

    @Override
    public Proxy getProxy() {
        try {
            String string = this.getProxyHost();
            if (string != null) {
                int n = this.getPortNumber();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
                return new Proxy(Proxy.Type.HTTP, inetSocketAddress);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int getPortNumber() {
        int n;
        try {
            n = Integer.parseInt(this.getProxyPort());
        }
        catch (NumberFormatException numberFormatException) {
            n = 80;
        }
        return n;
    }

    @Override
    public String getNonProxyHosts() {
        return this.getProperty(nonProxyHostsKey);
    }

    @Override
    public String getProxyHost() {
        return this.getProperty(proxyHostKey);
    }

    @Override
    public String getProxyPassword() {
        return this.getProperty(proxyPasswordKey);
    }

    @Override
    public String getProxyPort() {
        return this.getProperty(proxyPortKey, true);
    }

    @Override
    public String getProxyUser() {
        return this.getProperty(proxyUserKey);
    }

    public Map<String, String> getNonProxyHostsMap() {
        return this.getProperties(nonProxyHostsKey);
    }

    public Map<String, String> getProxyHostMap() {
        return this.getProperties(proxyHostKey);
    }

    public Map<String, String> getProxyPasswordMap() {
        return this.getProperties(proxyPasswordKey);
    }

    public Map<String, String> getProxyPortMap() {
        return this.getProperties(proxyPortKey);
    }

    public Map<String, String> getProxyUserMap() {
        return this.getProperties(proxyUserKey);
    }

    @Override
    public void setNonProxyHosts(String string) {
        this.multiSetProperty(nonProxyHostsKey, string);
    }

    @Override
    public void setProxyHost(String string) {
        this.multiSetProperty(proxyHostKey, string);
    }

    @Override
    public void setProxyPassword(String string) {
        this.multiSetProperty(proxyPasswordKey, string);
    }

    @Override
    public void setProxyPort(String string) {
        this.multiSetProperty(proxyPortKey, string);
    }

    @Override
    public void setProxyUser(String string) {
        this.multiSetProperty(proxyUserKey, string);
    }

    protected void multiSetProperty(String string, String string2) {
        String[] stringArray;
        String string3 = (String)this.getProtocolProperties().get(string);
        for (String string4 : stringArray = string3.split(",")) {
            if (string2 == null || "".equalsIgnoreCase(string2)) {
                System.clearProperty(string4);
                continue;
            }
            System.setProperty(string4, string2);
        }
    }

    protected String getProperty(String string, boolean bl) {
        String string2 = (String)this.getProtocolProperties().get(string);
        String string3 = string2.contains(",") ? string2.substring(0, string2.indexOf(44)) : string2;
        String string4 = System.getProperty(string3);
        String string5 = bl ? string4 : AbstractTransportClientProperties.nonNullValue(string4);
        return string5;
    }

    protected String getProperty(String string) {
        return this.getProperty(string, true);
    }

    protected HashMap<String, String> getProperties(String string) {
        String string2 = (String)this.getProtocolProperties().get(string);
        String[] stringArray = string2.split(",");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string3 : stringArray) {
            hashMap.put(string3, System.getProperty(string3));
        }
        return hashMap;
    }

    private static String nonNullValue(String string) {
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void testProxySettings(Logger logger) {
        ProxyTestThread proxyTestThread = new ProxyTestThread(logger);
        AbstractTransportClientProperties.executeProxyTest(proxyTestThread);
    }

    public void testProxySettings(String string, Logger logger) {
        ProxyTestThread proxyTestThread = new ProxyTestThread(logger);
        AbstractTransportClientProperties.executeProxyTest(proxyTestThread);
    }

    private static void executeProxyTest(Runnable runnable) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(runnable);
        executorService.shutdown();
    }
}

