/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.mde.cmdwin.CmdWin;
import com.mathworks.mde.cmdwin.CmdWinDocument;
import com.mathworks.mde.cmdwin.CmdWinMLIF;
import com.mathworks.mde.cmdwin.Prompt;
import com.mathworks.mde.cmdwin.XCaret;
import com.mathworks.mde.cmdwin.XCmdWndView;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.datatransfer.MJDataFlavor;
import com.mathworks.mwswing.datatransfer.MJDragCursorUtilities;
import com.mathworks.mwswing.text.VerticalLinePainter;
import com.mathworks.util.Log;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;

public class CWDragDropImpl
implements DropTargetListener,
DragGestureListener,
DragSourceListener {
    private int fAction = 0;
    private static XCmdWndView sCWView;
    private static CmdWinDocument sDoc;
    private static CWDragDropImpl sImpl;
    private boolean fIsDragSource = false;
    private static boolean sDragEntered;
    private static Highlighter.HighlightPainter sVerticalPainter;
    protected Object fTokenHighlightKey;

    private CWDragDropImpl(XCmdWndView xCmdWndView) {
        sCWView = xCmdWndView;
        sDoc = CmdWinDocument.getInstance();
        sImpl = this;
    }

    static CWDragDropImpl getInstance(XCmdWndView xCmdWndView) {
        if (sImpl == null) {
            new CWDragDropImpl(xCmdWndView);
        }
        return sImpl;
    }

    static boolean getDragEntered() {
        return sDragEntered;
    }

    private void insertDropString(int n, String string) {
        try {
            if (sDoc.isInOrBeforeThePrompt(n)) {
                sDoc.insertString(sDoc.getPromptLineEndOffset(true), string, null);
                sCWView.getCaret().setDot(sDoc.getPromptLineEndOffset(true));
            } else {
                sDoc.insertString(n, string, null);
                sCWView.getCaret().setDot(n + string.length());
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Cursor cursor;
        int n = dragGestureEvent.getDragAction();
        if (n != 1 && n != 2) {
            return;
        }
        switch (dragGestureEvent.getDragAction()) {
            case 1: {
                cursor = MJDragCursorUtilities.getCursor((int)1);
                break;
            }
            case 2: {
                cursor = MJDragCursorUtilities.getCursor((int)2);
                break;
            }
            default: {
                return;
            }
        }
        StringSelection stringSelection = new StringSelection(sCWView.getSelectedText());
        try {
            sCWView.getDragSource().startDrag(dragGestureEvent, cursor, stringSelection, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        this.fIsDragSource = true;
        this.fAction = dragSourceDragEvent.getUserAction();
        Cursor cursor = null;
        Cursor cursor2 = dragSourceDragEvent.getDragSourceContext().getCursor();
        switch (dragSourceDragEvent.getUserAction()) {
            case 1: {
                if (cursor2.equals(MJDragCursorUtilities.getCursor((int)1))) break;
                cursor = MJDragCursorUtilities.getCursor((int)1);
                break;
            }
            case 2: {
                if (cursor2.equals(MJDragCursorUtilities.getCursor((int)2))) break;
                cursor = MJDragCursorUtilities.getCursor((int)2);
                break;
            }
            default: {
                cursor = MJDragCursorUtilities.getCursor((int)1);
            }
        }
        if (cursor != null) {
            dragSourceDragEvent.getDragSourceContext().setCursor(cursor);
        }
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.getDragSourceContext().setCursor(MJDragCursorUtilities.getCursor((int)7563));
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        this.fAction = dragSourceDragEvent.getUserAction();
        Cursor cursor = null;
        Cursor cursor2 = dragSourceDragEvent.getDragSourceContext().getCursor();
        switch (dragSourceDragEvent.getUserAction()) {
            case 1: {
                if (cursor2.equals(MJDragCursorUtilities.getCursor((int)1))) break;
                cursor = MJDragCursorUtilities.getCursor((int)1);
                break;
            }
            case 2: {
                if (cursor2.equals(MJDragCursorUtilities.getCursor((int)2))) break;
                cursor = MJDragCursorUtilities.getCursor((int)2);
                break;
            }
            default: {
                cursor = MJDragCursorUtilities.getCursor((int)1);
            }
        }
        if (cursor != null) {
            dragSourceDragEvent.getDragSourceContext().setCursor(cursor);
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (dragSourceDropEvent.getDropSuccess() && dragSourceDropEvent.getDropAction() == 3 && this.fIsDragSource) {
            XCmdWndView.getInstance().replaceSelection("");
        }
        this.fIsDragSource = false;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!sDragEntered) {
            sDragEntered = true;
            if (MJDataFlavor.isDecodableFileFlavor((DropTargetDragEvent)dropTargetDragEvent) || dropTargetDragEvent.isDataFlavorSupported(MLDataFlavor.matReferenceListFlavor)) {
                dropTargetDragEvent.acceptDrag(1);
            } else if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor) || dropTargetDragEvent.isDataFlavorSupported(DataFlavor.plainTextFlavor)) {
                dropTargetDragEvent.acceptDrag(3);
            } else {
                DataFlavor dataFlavor;
                DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
                int n = dataFlavorArray.length;
                boolean bl = false;
                for (int i = 0; i < n && !(bl = (dataFlavor = dataFlavorArray[i]).equals(DataFlavor.getTextPlainUnicodeFlavor())); ++i) {
                }
                if (bl) {
                    dropTargetDragEvent.acceptDrag(3);
                } else {
                    dropTargetDragEvent.rejectDrag();
                }
            }
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        sDragEntered = false;
        this.clearHighlights();
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        int n;
        block5: {
            n = 0;
            try {
                n = sCWView.viewToModel(dropTargetDragEvent.getLocation());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                StackTraceElement stackTraceElement = arrayIndexOutOfBoundsException.getStackTrace()[0];
                if ("sun.font.FontDesignMetrics".equals(stackTraceElement.getClassName()) && "charsWidth".equals(stackTraceElement.getMethodName())) break block5;
                throw arrayIndexOutOfBoundsException;
            }
        }
        if (!sDoc.isAfterThePrompt(n)) {
            n = sDoc.getPromptLineEndOffset(true);
        }
        try {
            this.clearHighlights();
            this.fTokenHighlightKey = sCWView.getHighlighter().addHighlight(n, n, sVerticalPainter);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    private void clearHighlights() {
        if (this.fTokenHighlightKey != null) {
            sCWView.getHighlighter().removeHighlight(this.fTokenHighlightKey);
            this.fTokenHighlightKey = null;
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.clearHighlights();
        sDragEntered = false;
        sDoc.setUserInitialized();
        int n = dropTargetDropEvent.getDropAction();
        if (MJDataFlavor.isDecodableFileFlavor((DropTargetDropEvent)dropTargetDropEvent)) {
            dropTargetDropEvent.acceptDrop(1);
            Transferable transferable = dropTargetDropEvent.getTransferable();
            File[] fileArray = null;
            try {
                fileArray = MJDataFlavor.decodeJavaFileListFlavor((Transferable)transferable);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Log.logException((Exception)unsupportedFlavorException);
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
            }
            if (fileArray != null) {
                for (File file : fileArray) {
                    String string = file.getAbsolutePath();
                    String string2 = null;
                    if (MLFileUtils.isMFile((String)string)) {
                        string2 = "run('" + StringUtils.quoteSingleQuotes((String)string) + "')";
                    } else if (MLFileUtils.isMatFile((String)string)) {
                        WorkspaceCommands.importDataMat((File)file);
                    } else {
                        string2 = file.isDirectory() ? "cd('" + StringUtils.quoteSingleQuotes((String)string) + "')" : "uiopen('" + StringUtils.quoteSingleQuotes((String)string) + "',1)";
                    }
                    if (string2 == null) continue;
                    CmdWinMLIF.doExecuteCommand(string2);
                }
            }
            dropTargetDropEvent.dropComplete(true);
            this.giveCommandWindowFocus();
            return;
        }
        if (WorkspaceCommands.importVariablesFromDropEvent((Component)MJFrame.getFrame((Component)sCWView), (DropTargetDropEvent)dropTargetDropEvent)) {
            this.giveCommandWindowFocus();
            return;
        }
        if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            String string;
            if (dropTargetDropEvent.getDropAction() == 2) {
                dropTargetDropEvent.acceptDrop(2);
            } else if (dropTargetDropEvent.getDropAction() == 1) {
                dropTargetDropEvent.acceptDrop(1);
            } else if (dropTargetDropEvent.getDropAction() == 3) {
                dropTargetDropEvent.acceptDrop(3);
            } else {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Log.logException((Exception)unsupportedFlavorException);
                dropTargetDropEvent.rejectDrop();
                return;
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
                dropTargetDropEvent.rejectDrop();
                return;
            }
            string = Prompt.stripPrompts(string);
            string = string.trim();
            Point point = dropTargetDropEvent.getLocation();
            int n2 = sCWView.viewToModel(point);
            int n3 = sCWView.getSelectionStart();
            int n4 = sCWView.getSelectionEnd();
            if (this.fIsDragSource && (n3 == n4 || n2 >= n4 || n2 < n3)) {
                if (!sDoc.isAfterThePrompt(n3) || !sDoc.isAfterThePrompt(n4)) {
                    n = 1;
                }
                if (n == 2) {
                    int n5 = sCWView.getSelectedText().length();
                    if (n2 >= n4) {
                        n2 = Math.min(n2, sCWView.getDocument().getLength());
                        n2 -= n5;
                    }
                    try {
                        sDoc.remove(n3, n5);
                    }
                    catch (BadLocationException badLocationException) {
                        Log.logException((Exception)badLocationException);
                    }
                }
                this.insertDropString(n2, string);
            } else if (!this.fIsDragSource) {
                ((XCaret)sCWView.getCaret()).removeSelection();
                this.insertDropString(n2, string);
            } else {
                ((XCaret)sCWView.getCaret()).removeSelection();
            }
            dropTargetDropEvent.dropComplete(true);
            this.giveCommandWindowFocus();
            return;
        }
        dropTargetDropEvent.rejectDrop();
    }

    private void giveCommandWindowFocus() {
        Window window = SwingUtilities.getWindowAncestor((Component)((Object)CmdWin.getInstance()));
        if (window != null) {
            window.toFront();
        }
        CmdWin.getInstance().requestFocus();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    static {
        sDragEntered = false;
        sVerticalPainter = new VerticalLinePainter();
    }
}

