/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.cmdwin.CmdWinPrefs;
import com.mathworks.mlservices.MLCommandWindowServices;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFormattedTextField;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.MaskFormatter;

public class CmdWinPrefsGeneralPanel
extends MJPanel {
    private static CmdWinPrefsGeneralPanel sPrefsPanel = null;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.cmdwin.resources.RES_CmdWin");
    private static ResourceBundle sPrefsRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private static final int EIGHTY_COLS = 0;
    private MJCheckBox fEightyColsCheckbox;
    private MJComboBox fFormatChoice;
    private MJComboBox fDisplayChoice;
    private SpinnerNumberModel fSpinnerModel;
    private MJCheckBox fWrapLinesCheckbox;
    private MJCheckBox fStartupMsgCheckbox;
    private MJCheckBox fFunctionBrowserCheckbox;
    private MJCheckBox fTypoSuggestionsCheckbox;
    private FormatCallback fFormatAnswer;
    private Matlab fMatlab;
    private MJFormattedTextField fSpacesPerTabField;
    private static final String[] FORMAT_CHOICES = new String[]{"short", "long", "short e", "long e", "short g", "long g", "short eng", "long eng", "hex", "bank", "+", "rational"};
    private static final String[] DISPLAY_CHOICES = new String[]{"compact", "loose"};

    public CmdWinPrefsGeneralPanel(Dimension dimension) {
        Cloneable cloneable;
        Object[] objectArray;
        MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(0, 2, 6, 5, 196608, (Object)Float.valueOf(0.0f), null));
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(sRes.getString("cwpp.textdisplay.groupbox")));
        mJPanel.setName("TextDisplayPanel");
        mJPanel.getAccessibleContext().setAccessibleName(sRes.getString("cwpp.textdisplay.groupbox"));
        MJLabel mJLabel = new MJLabel(sRes.getString("cwpp.numericformat.label"));
        this.fFormatChoice = new MJComboBox((Object[])FORMAT_CHOICES);
        this.fFormatChoice.setSelectedIndex(0);
        this.fFormatChoice.setName("NumericFormatCombo");
        this.fFormatChoice.getAccessibleContext().setAccessibleName(sRes.getString("acc.prefs.numericformat"));
        mJLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        mJPanel.add((Component)mJLabel);
        mJPanel.add((Component)this.fFormatChoice);
        MJLabel mJLabel2 = new MJLabel(sRes.getString("cwpp.numericdisplay.label"));
        mJLabel2.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.fDisplayChoice = new MJComboBox((Object[])DISPLAY_CHOICES);
        this.fDisplayChoice.setSelectedIndex(0);
        this.fDisplayChoice.setName("NumericDisplayCombo");
        this.fDisplayChoice.getAccessibleContext().setAccessibleName(sRes.getString("acc.prefs.numericdisplay"));
        mJPanel.add((Component)mJLabel2);
        mJPanel.add((Component)this.fDisplayChoice);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new MGridLayout(0, 1, 4, 0, 196608, (Object)Float.valueOf(0.0f), null));
        mJPanel2.setBorder((Border)BorderFactory.createTitledBorder(sRes.getString("cwpp.display.groupbox")));
        mJPanel2.setName("EchoPanel");
        mJPanel2.getAccessibleContext().setAccessibleName(sRes.getString("cwpp.display.groupbox"));
        this.fWrapLinesCheckbox = new MJCheckBox(sRes.getString("cwpp.wraplines.check"));
        this.fWrapLinesCheckbox.setSelected(CmdWinPrefs.isWrapLines());
        this.fWrapLinesCheckbox.setName("WrapCheckbox");
        this.fWrapLinesCheckbox.getAccessibleContext().setAccessibleName(sRes.getString("cwpp.wraplines.check"));
        this.fWrapLinesCheckbox.setBorder(BorderFactory.createEmptyBorder(5, 6, 5, 6));
        mJPanel2.add((Component)this.fWrapLinesCheckbox);
        this.fEightyColsCheckbox = new MJCheckBox(sRes.getString("cwpp.eightycols.check"));
        this.fEightyColsCheckbox.setSelected(CmdWinPrefs.isEightyColumnLimit());
        this.fEightyColsCheckbox.setName("EightyColumnsCheckbox");
        this.fEightyColsCheckbox.getAccessibleContext().setAccessibleName(sRes.getString("cwpp.eightycols.check"));
        this.fEightyColsCheckbox.setBorder(BorderFactory.createEmptyBorder(5, 6, 5, 6));
        mJPanel2.add((Component)this.fEightyColsCheckbox);
        this.fStartupMsgCheckbox = new MJCheckBox(sRes.getString("cwpp.showinfobar"));
        this.fStartupMsgCheckbox.setSelected(CmdWinPrefs.shouldShowStartingMessage());
        this.fStartupMsgCheckbox.setName("ShowInfoBarCheckbox");
        this.fStartupMsgCheckbox.getAccessibleContext().setAccessibleName(sRes.getString("cwpp.showinfobar"));
        this.fStartupMsgCheckbox.setBorder(BorderFactory.createEmptyBorder(5, 6, 5, 6));
        mJPanel2.add((Component)this.fStartupMsgCheckbox);
        this.fFunctionBrowserCheckbox = new MJCheckBox(sRes.getString("cwpp.fb.check"));
        this.fFunctionBrowserCheckbox.setSelected(CmdWinPrefs.isShowFunctionBrowser());
        this.fFunctionBrowserCheckbox.setName("FunctionBrowserCheckbox");
        this.fFunctionBrowserCheckbox.getAccessibleContext().setAccessibleName(sRes.getString("cwpp.fb.check"));
        this.fFunctionBrowserCheckbox.setBorder(BorderFactory.createEmptyBorder(5, 6, 5, 6));
        mJPanel2.add((Component)this.fFunctionBrowserCheckbox);
        this.fTypoSuggestionsCheckbox = new MJCheckBox(sRes.getString("cwpp.cwts.check"));
        this.fTypoSuggestionsCheckbox.setSelected(CmdWinPrefs.isShowTypoSuggestions());
        this.fTypoSuggestionsCheckbox.setName("TypoSuggestionsCheckbox");
        this.fTypoSuggestionsCheckbox.getAccessibleContext().setAccessibleName(sRes.getString("cwpp.cwts.check"));
        this.fTypoSuggestionsCheckbox.setBorder(BorderFactory.createEmptyBorder(5, 6, 5, 6));
        mJPanel2.add((Component)this.fTypoSuggestionsCheckbox);
        MJPanel mJPanel3 = new MJPanel();
        MJLabel mJLabel3 = new MJLabel(sRes.getString("cwpp.scrollbuffer.label"));
        Integer n = CmdWinPrefs.getSessionSize();
        Integer n2 = 1000;
        Integer n3 = 25000;
        Integer n4 = 1000;
        this.fSpinnerModel = new SpinnerNumberModel(n, n2, n3, n4);
        MJSpinner mJSpinner = new MJSpinner((SpinnerModel)this.fSpinnerModel);
        mJSpinner.setName("SessionSizeSpinner");
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor((JSpinner)mJSpinner);
        JFormattedTextField jFormattedTextField = numberEditor.getTextField();
        jFormattedTextField.setBackground(SystemColor.window);
        jFormattedTextField.setForeground(SystemColor.windowText);
        jFormattedTextField.setBorder(null);
        jFormattedTextField.getAccessibleContext().setAccessibleName(sRes.getString("acc.prefs.scrollbuffer"));
        mJSpinner.setEditor((JComponent)numberEditor);
        numberEditor.getTextField().setEditable(false);
        numberEditor.getAccessibleContext().setAccessibleName(sRes.getString("cwpp.scrollbuffer.label"));
        mJPanel3.add((Component)mJLabel3);
        mJPanel3.add((Component)mJSpinner);
        mJPanel2.add((Component)mJPanel3);
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(MessageFormat.format(sRes.getString("cwkp.colorlink.message"), sRes.getString("cwkp.colorlink.message0")), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                MLPrefsDialogServices.showPrefsDialog((String)sPrefsRes.getString("area.colors"));
            }
        }, false, "ColorLink", "Color Preferences Link.");
        hyperlinkTextLabel.getComponent().setBorder(BorderFactory.createEmptyBorder(5, 6, 5, 6));
        mJPanel2.add((Component)hyperlinkTextLabel.getComponent());
        if (Matlab.isMatlabAvailable()) {
            this.fMatlab = new Matlab();
            this.fFormatAnswer = new FormatCallback();
            sPrefsPanel = this;
            this.fMatlab.eval("disp(get(0, 'Format'))", (CompletionObserver)this.fFormatAnswer);
            this.fMatlab.eval("disp(get(0, 'FormatSpacing'))", (CompletionObserver)this.fFormatAnswer);
            objectArray = new Object[]{"EightyColumns"};
            this.fMatlab.feval("feature", objectArray, (CompletionObserver)new DoubleCallback(0));
        }
        objectArray = new MJPanel((LayoutManager)new MGridLayout(0, 1, 6, 5, 196608, (Object)Float.valueOf(0.0f), null));
        objectArray.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(sRes.getString("cwpp.acc.groupbox")), new EmptyBorder(0, 6, 0, 0)));
        objectArray.setName("AccDisplayPanel");
        objectArray.getAccessibleContext().setAccessibleName(sRes.getString("cwpp.acc.groupbox"));
        HyperlinkTextLabel hyperlinkTextLabel2 = new HyperlinkTextLabel(sRes.getString("cwpp.arrows"), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                MLPrefsDialogServices.showPrefsDialog((String)(sPrefsRes.getString("area.keyboard") + "." + sPrefsRes.getString("area.keyboard.shortcuts")));
            }
        }, false, "KeyboardNavigation", "Keyboard Shortcut Preferences Link.");
        hyperlinkTextLabel2.constrainSize(dimension.width - 24, dimension.height);
        objectArray.add((Component)hyperlinkTextLabel2.getComponent());
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel4.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(sRes.getString("cwkp.tabkey.groupbox")), new EmptyBorder(0, 6, 5, 0)));
        mJPanel4.setName("TabSizePanel");
        MJLabel mJLabel4 = new MJLabel(sRes.getString("cwkp.tabsize.label"));
        try {
            cloneable = new MaskFormatter("###");
            cloneable.setValidCharacters("0123456789");
            this.fSpacesPerTabField = new MJFormattedTextField((JFormattedTextField.AbstractFormatter)((Object)cloneable));
        }
        catch (ParseException parseException) {
            this.fSpacesPerTabField = new MJFormattedTextField();
        }
        this.fSpacesPerTabField.setFocusLostBehavior(0);
        this.fSpacesPerTabField.setColumns(3);
        this.fSpacesPerTabField.setText(String.valueOf(CmdWinPrefs.getTabSize()));
        this.fSpacesPerTabField.setName("TabSizeField");
        this.fSpacesPerTabField.getAccessibleContext().setAccessibleName(sRes.getString("acc.prefs.TabSize"));
        cloneable = new GridBagConstraints();
        ((GridBagConstraints)cloneable).weightx = 0.0;
        ((GridBagConstraints)cloneable).insets = new Insets(0, 0, 0, 6);
        mJPanel4.add((Component)mJLabel4, (Object)cloneable);
        ((GridBagConstraints)cloneable).gridx = 1;
        mJPanel4.add((Component)this.fSpacesPerTabField, (Object)cloneable);
        HyperlinkTextLabel hyperlinkTextLabel3 = new HyperlinkTextLabel(MessageFormat.format(sRes.getString("cwkp.tabcompletion.message"), sRes.getString("cwkp.tabcompletion.message0")), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                MLPrefsDialogServices.showPrefsDialog((String)sPrefsRes.getString("area.keyboard"));
            }
        }, false, "TabCompletionLink", "Tab Completion Preferences Link.");
        ((GridBagConstraints)cloneable).gridx = 2;
        ((GridBagConstraints)cloneable).anchor = 13;
        ((GridBagConstraints)cloneable).weightx = 1.0;
        mJPanel4.add((Component)hyperlinkTextLabel3.getComponent(), (Object)cloneable);
        this.setLayout((LayoutManager)new MGridLayout(0, 1, 6, 5, 131072));
        this.add((Component)mJPanel);
        this.add((Component)mJPanel2);
        this.add((Component)objectArray);
        this.add((Component)mJPanel4);
        this.fWrapLinesCheckbox.setEnabled(MLCommandWindowServices.isJavaCWInitialized());
        mJSpinner.setEnabled(MLCommandWindowServices.isJavaCWInitialized());
        mJLabel3.setEnabled(MLCommandWindowServices.isJavaCWInitialized());
        this.fSpacesPerTabField.setEnabled(MLCommandWindowServices.isJavaCWInitialized());
    }

    public static MJPanel createPrefsPanel(Dimension dimension) {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new CmdWinPrefsGeneralPanel(dimension);
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    private void saveOptions() {
        int n;
        int n2 = this.fSpinnerModel.getNumber().intValue();
        if (CmdWinPrefs.getSessionSize() != n2) {
            CmdWinPrefs.setSessionSize(n2);
        }
        if (CmdWinPrefs.isWrapLines() != this.fWrapLinesCheckbox.isSelected()) {
            CmdWinPrefs.setWrapLines(this.fWrapLinesCheckbox.isSelected());
        }
        if (CmdWinPrefs.shouldShowStartingMessage() != this.fStartupMsgCheckbox.isSelected()) {
            CmdWinPrefs.setShouldShowStartingMessage(this.fStartupMsgCheckbox.isSelected());
        }
        if (CmdWinPrefs.isShowFunctionBrowser() != this.fFunctionBrowserCheckbox.isSelected()) {
            CmdWinPrefs.setShowFunctionBrowser(this.fFunctionBrowserCheckbox.isSelected());
        }
        if (CmdWinPrefs.isShowTypoSuggestions() != this.fTypoSuggestionsCheckbox.isSelected()) {
            CmdWinPrefs.setShowTypoSuggestions(this.fTypoSuggestionsCheckbox.isSelected());
        }
        String string = (String)this.fFormatChoice.getSelectedItem();
        CmdWinPrefs.setNumericFormat(string);
        if (this.fMatlab != null) {
            this.fMatlab.evalNoOutput("set(0, 'Format', '" + string + "')");
        }
        String string2 = (String)this.fDisplayChoice.getSelectedItem();
        CmdWinPrefs.setNumericDisplay(string2);
        if (this.fMatlab != null) {
            this.fMatlab.evalNoOutput("set(0, 'FormatSpacing', '" + string2 + "')");
        }
        CmdWinPrefs.setEightyColumnLimit(this.fEightyColsCheckbox.isSelected());
        if (this.fMatlab != null) {
            String string3 = this.fEightyColsCheckbox.isSelected() ? "1" : "0";
            this.fMatlab.evalNoOutput("feature('EightyColumns', " + string3 + ");");
        }
        if (this.fSpacesPerTabField.getText().trim().length() > 0 && (n = new Integer(this.fSpacesPerTabField.getText().trim()).intValue()) != CmdWinPrefs.getTabSize()) {
            CmdWinPrefs.setTabSize(n);
        }
    }

    private static void setComboBoxIndex(final MJComboBox mJComboBox, final int n) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                mJComboBox.setSelectedIndex(n);
            }
        });
    }

    private static void setCheckboxStateOnEventThread(final MJCheckBox mJCheckBox, final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                mJCheckBox.setSelected(bl);
            }
        });
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_commandwindow_prefs"};
    }

    private FormatCallback getFormatCallbackForUnittest() {
        if (this.fFormatAnswer == null) {
            this.fFormatAnswer = new FormatCallback();
            sPrefsPanel = this;
        }
        return this.fFormatAnswer;
    }

    private class DoubleCallback
    implements CompletionObserver {
        private final int fCmd;

        DoubleCallback(int n) {
            this.fCmd = n;
        }

        public void completed(int n, Object object) {
            double[] dArray = (double[])object;
            if (dArray == null || sPrefsPanel == null) {
                return;
            }
            if (dArray[0] == 0.0) {
                if (this.fCmd == 0) {
                    CmdWinPrefsGeneralPanel.setCheckboxStateOnEventThread(CmdWinPrefsGeneralPanel.this.fEightyColsCheckbox, false);
                }
            } else if (this.fCmd == 0) {
                CmdWinPrefsGeneralPanel.setCheckboxStateOnEventThread(CmdWinPrefsGeneralPanel.this.fEightyColsCheckbox, true);
            }
        }
    }

    private class FormatCallback
    implements CompletionObserver {
        private FormatCallback() {
        }

        public void completed(int n, Object object) {
            String string = (String)object;
            if (string == null || string.length() == 0 || sPrefsPanel == null) {
                return;
            }
            if (string.contains("compact")) {
                CmdWinPrefsGeneralPanel.setComboBoxIndex(CmdWinPrefsGeneralPanel.this.fDisplayChoice, 0);
            } else if (string.contains("loose")) {
                CmdWinPrefsGeneralPanel.setComboBoxIndex(CmdWinPrefsGeneralPanel.this.fDisplayChoice, 1);
            } else if (string.contains("shortEng")) {
                CmdWinPrefsGeneralPanel.setComboBoxIndex(CmdWinPrefsGeneralPanel.this.fFormatChoice, 6);
            } else if (string.contains("longEng")) {
                CmdWinPrefsGeneralPanel.setComboBoxIndex(CmdWinPrefsGeneralPanel.this.fFormatChoice, 7);
            } else if (string.contains("shortE")) {
                CmdWinPrefsGeneralPanel.setComboBoxIndex(CmdWinPrefsGeneralPanel.this.fFormatChoice, 2);
            } else if (string.contains("shortG")) {
                CmdWinPrefsGeneralPanel.setComboBoxIndex(CmdWinPrefsGeneralPanel.this.fFormatChoice, 4);
            } else if (string.contains("short")) {
                CmdWinPrefsGeneralPanel.setComboBoxIndex(CmdWinPrefsGeneralPanel.this.fFormatChoice, 0);
            } else if (string.contains("longE")) {
                CmdWinPrefsGeneralPanel.setComboBoxIndex(CmdWinPrefsGeneralPanel.this.fFormatChoice, 3);
            } else if (string.contains("longG")) {
                CmdWinPrefsGeneralPanel.setComboBoxIndex(CmdWinPrefsGeneralPanel.this.fFormatChoice, 5);
            } else if (string.contains("long")) {
                CmdWinPrefsGeneralPanel.setComboBoxIndex(CmdWinPrefsGeneralPanel.this.fFormatChoice, 1);
            } else if (string.contains("hex")) {
                CmdWinPrefsGeneralPanel.setComboBoxIndex(CmdWinPrefsGeneralPanel.this.fFormatChoice, 8);
            } else if (string.contains("bank")) {
                CmdWinPrefsGeneralPanel.setComboBoxIndex(CmdWinPrefsGeneralPanel.this.fFormatChoice, 9);
            } else if (string.contains("+")) {
                CmdWinPrefsGeneralPanel.setComboBoxIndex(CmdWinPrefsGeneralPanel.this.fFormatChoice, 10);
            } else if (string.contains("rational")) {
                CmdWinPrefsGeneralPanel.setComboBoxIndex(CmdWinPrefsGeneralPanel.this.fFormatChoice, 11);
            }
        }
    }
}

