/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.mwswing.text.TextUtils;
import java.text.BreakIterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;

public class CmdWinTextUtilities {
    public static int getWordEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        int[] nArray = TextUtils.getLineStartAndEnd((JTextComponent)jTextComponent, (int)n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        String string = jTextComponent.getDocument().getText(n2, n3 - n2);
        if (string != null && string.length() > 0) {
            string = CmdWinTextUtilities.fixDelimiters(string);
            BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
            breakIterator.setText(string);
            int n4 = n - n2;
            if (n4 >= breakIterator.last()) {
                n4 = breakIterator.last() - 1;
            }
            n = n2 + breakIterator.following(n4);
        }
        return n;
    }

    public static int getWordStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        int[] nArray = TextUtils.getLineStartAndEnd((JTextComponent)jTextComponent, (int)n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        String string = jTextComponent.getDocument().getText(n2, n3 - n2);
        if (string != null && string.length() > 0) {
            string = CmdWinTextUtilities.fixDelimiters(string);
            BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
            breakIterator.setText(string);
            int n4 = n - n2;
            if (n4 >= breakIterator.last()) {
                n4 = breakIterator.last() - 1;
            }
            breakIterator.following(n4);
            n = n2 + breakIterator.previous();
        }
        return n;
    }

    private static String fixDelimiters(String string) {
        string = string.replaceAll("\\.", "?");
        string = string.replaceAll("[0-9]", "x");
        string = string.replaceAll("_", "x");
        return string;
    }

    static int getPrevWordInParagraph(JTextComponent jTextComponent, Element element, int n) throws BadLocationException {
        int n2;
        if (element == null) {
            throw new BadLocationException("No more words", n);
        }
        Document document = element.getDocument();
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset();
        if (n > n4 || n < n3) {
            throw new BadLocationException("No more words", n);
        }
        String string = document.getText(n3, n4 - n3);
        string = CmdWinTextUtilities.fixDelimiters(string);
        BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
        breakIterator.setText(string);
        if (breakIterator.following(n - n3) == -1) {
            breakIterator.last();
        }
        if ((n2 = breakIterator.previous()) == n - n3) {
            n2 = breakIterator.previous();
        }
        if (n2 == -1) {
            return -1;
        }
        char c = string.charAt(n2);
        if (!Character.isWhitespace(c)) {
            return n3 + n2;
        }
        n2 = breakIterator.previous();
        if (n2 != -1) {
            return n3 + n2;
        }
        return -1;
    }

    public static final int getPreviousWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        Element element = CmdWinTextUtilities.getParagraphElement(jTextComponent, n);
        int n2 = CmdWinTextUtilities.getPrevWordInParagraph(jTextComponent, element, n);
        while (n2 == -1) {
            n = element.getStartOffset() - 1;
            element = CmdWinTextUtilities.getParagraphElement(jTextComponent, n);
            n2 = CmdWinTextUtilities.getPrevWordInParagraph(jTextComponent, element, n);
        }
        return n2;
    }

    public static final Element getParagraphElement(JTextComponent jTextComponent, int n) {
        int n2;
        Document document = jTextComponent.getDocument();
        if (document instanceof StyledDocument) {
            return ((StyledDocument)document).getParagraphElement(n);
        }
        Element element = document.getDefaultRootElement();
        Element element2 = element.getElement(n2 = element.getElementIndex(n));
        if (n >= element2.getStartOffset() && n < element2.getEndOffset()) {
            return element2;
        }
        return null;
    }

    public static final int getNextWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        Element element = CmdWinTextUtilities.getParagraphElement(jTextComponent, n);
        int n2 = CmdWinTextUtilities.getNextWordInParagraph(jTextComponent, element, n, false);
        while (n2 == -1) {
            n = element.getEndOffset();
            element = CmdWinTextUtilities.getParagraphElement(jTextComponent, n);
            n2 = CmdWinTextUtilities.getNextWordInParagraph(jTextComponent, element, n, true);
        }
        return n2;
    }

    static int getNextWordInParagraph(JTextComponent jTextComponent, Element element, int n, boolean bl) throws BadLocationException {
        if (element == null) {
            throw new BadLocationException("No more words", n);
        }
        Document document = element.getDocument();
        int n2 = element.getStartOffset();
        int n3 = Math.min(element.getEndOffset(), document.getLength());
        if (n >= n3 || n < n2) {
            throw new BadLocationException("No more words", n);
        }
        String string = document.getText(n2, n3 - n2);
        string = CmdWinTextUtilities.fixDelimiters(string);
        BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
        breakIterator.setText(string);
        if (bl && breakIterator.first() == n - n2 && !Character.isWhitespace(string.charAt(breakIterator.first()))) {
            return n;
        }
        int n4 = breakIterator.following(n - n2);
        if (n4 == -1 || n4 >= string.length()) {
            return -1;
        }
        char c = string.charAt(n4);
        if (!Character.isWhitespace(c)) {
            return n2 + n4;
        }
        n4 = breakIterator.next();
        if (n4 != -1 && (n = n2 + n4) != n3) {
            return n;
        }
        return -1;
    }
}

