/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.dataimport;

import com.mathworks.mde.dataimport.DataPreviewSelector;
import com.mathworks.mde.dataimport.DataPreviewWidgetBuilder;
import com.mathworks.mde.dataimport.ImportProxy;
import com.mathworks.mde.dataimport.ImportUtils;
import com.mathworks.mde.dataimport.ImportWizardContents;
import com.mathworks.mde.dataimport.VariableContentsViewer;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;

public class DataPreviewPanel
extends MJPanel {
    private MJTabbedPane fFilePreviewTabbedPane;
    private MJTextArea fNotRecognizedText;
    private MJScrollPane fNotRecognizedSSP;
    private MJTextArea fCreatingPreviewText;
    private MJScrollPane fCreatingPreviewSSP;
    private DataPreviewSelector fDataPreviewSelector;
    public static final Font MSG_FONT = new Font("Dialog", 0, 13);

    DataPreviewPanel(ImportProxy importProxy, boolean bl, ImportWizardContents importWizardContents) {
        this.setLayout(new BorderLayout());
        this.buildDataPreviewWidget(importWizardContents, importProxy);
        this.buildFilePreviewTabbedPane();
        this.buildNotRecognizedPane();
        this.buildCreatingPreviewPane();
        this.buildTabbedPane(bl);
        this.buildSplitPane();
    }

    private void buildDataPreviewWidget(ImportWizardContents importWizardContents, ImportProxy importProxy) {
        this.fDataPreviewSelector = DataPreviewWidgetBuilder.makeWidget(importWizardContents, importProxy);
        this.fDataPreviewSelector.setName("FilePreviewScrollPane");
    }

    private void buildFilePreviewTabbedPane() {
        this.fFilePreviewTabbedPane = new MJTabbedPane();
        this.fFilePreviewTabbedPane.setName("FilePreviewTabbedPane");
    }

    private void buildNotRecognizedPane() {
        this.fNotRecognizedText = new MJTextArea(ImportUtils.getResource("dssp.noRecognized"));
        this.fNotRecognizedText.setName("NoRecognizedDataTextPane");
        this.fNotRecognizedText.setEditable(false);
        this.fNotRecognizedSSP = new MJScrollPane((Component)this.fNotRecognizedText);
        this.fNotRecognizedSSP.setName("NoRecognizedDataScrollPane");
        this.fNotRecognizedText.setFont(MSG_FONT);
    }

    private void buildCreatingPreviewPane() {
        this.fCreatingPreviewText = new MJTextArea(ImportUtils.getResource("dssp.creatingPreview"));
        this.fCreatingPreviewText.setName("CreatingPreviewDataTextPane");
        this.fCreatingPreviewText.setEditable(false);
        this.fCreatingPreviewSSP = new MJScrollPane((Component)this.fCreatingPreviewText);
        this.fCreatingPreviewSSP.setName("CreatingPreviewDataScrollPane");
        this.fCreatingPreviewText.setFont(MSG_FONT);
    }

    private void buildTabbedPane(boolean bl) {
        this.fFilePreviewTabbedPane.addTab(ImportUtils.getResource("all.noDataTabHeader"), (Component)(bl ? this.fCreatingPreviewSSP : this.fNotRecognizedSSP));
    }

    private void buildSplitPane() {
        MJSplitPane mJSplitPane = new MJSplitPane(1, (Component)((Object)this.fDataPreviewSelector), (Component)this.fFilePreviewTabbedPane);
        mJSplitPane.setName("FilePreviewSplitPane");
        this.add((Component)mJSplitPane, "Center");
        mJSplitPane.setDividerLocation(this.fDataPreviewSelector.getPreviewPaneRatio());
        mJSplitPane.setResizeWeight(0.5);
    }

    void setTitle(String string) {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), string));
    }

    void cleanupTabbedPane() {
        for (int i = 0; i < this.fFilePreviewTabbedPane.getTabCount(); ++i) {
            Component component = this.fFilePreviewTabbedPane.getComponentAt(i);
            if (component instanceof VariableContentsViewer) {
                ((VariableContentsViewer)((Object)component)).cleanup();
            }
            this.fFilePreviewTabbedPane.removeAll();
        }
    }

    void addTab(String string, Component component) {
        this.fFilePreviewTabbedPane.addTab(string, component);
    }

    void addNoDataTab() {
        this.fFilePreviewTabbedPane.addTab(ImportUtils.getResource("all.noDataTabHeader"), (Component)this.fNotRecognizedSSP);
    }

    void setPreviewTextContents(String string, String[] stringArray) {
        this.fDataPreviewSelector.setPreviewTextContents(string, stringArray);
    }

    void setPreviewForeground(Color color) {
        this.fDataPreviewSelector.setChildForeground(color);
        this.fNotRecognizedSSP.setForeground(color);
        this.fCreatingPreviewSSP.setForeground(color);
        this.fNotRecognizedText.setForeground(color);
        this.fCreatingPreviewText.setForeground(color);
        for (int i = 0; i < this.fFilePreviewTabbedPane.getTabCount(); ++i) {
            Component component = this.fFilePreviewTabbedPane.getComponentAt(i);
            if (component instanceof VariableContentsViewer) {
                ((VariableContentsViewer)((Object)component)).resetColors();
                continue;
            }
            component.setForeground(color);
            component.setBackground(color);
        }
    }

    void setPreviewBackground(Color color) {
        this.fDataPreviewSelector.setChildBackground(color);
        this.fNotRecognizedSSP.setBackground(color);
        this.fCreatingPreviewSSP.setBackground(color);
        this.fNotRecognizedText.setBackground(color);
        this.fCreatingPreviewText.setBackground(color);
    }

    void cleanup() {
        this.cleanupTabbedPane();
        this.fFilePreviewTabbedPane = null;
    }

    String getCurrentWorksheetName() {
        return this.fDataPreviewSelector.getZOrder();
    }
}

