/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.dataimport;

import com.mathworks.mde.dataimport.DataPreviewPanel;
import com.mathworks.mde.dataimport.DataPreviewSelector;
import com.mathworks.mde.dataimport.ImportProxy;
import com.mathworks.mde.dataimport.ImportUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJTextArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SpreadsheetSelector
extends DataPreviewSelector {
    static final String BUSY_MESSAGE = ImportUtils.getResource("dssp.creatingPreview");
    static final String WIDGET_BUSY_NAME = "SpreadSheetBusyPane";
    private String fDescription;
    private ImportProxy fImportProxy;
    private List<String> fLabels;
    private Color fBackgroundColor;

    public SpreadsheetSelector(ImportProxy importProxy) {
        super((JComponent)new MJPanel());
        this.getChildComponent().setLayout(new BoxLayout(this.getChildComponent(), 1));
        this.getChildComponent().setBorder(BorderFactory.createTitledBorder(ImportUtils.getResource("dpp.ssw.Worksheets")));
        this.fImportProxy = importProxy;
    }

    @Override
    public void setText(String string) {
        this.fDescription = string;
    }

    @Override
    public void setChildBackground(Color color) {
        super.setChildBackground(color);
        this.fBackgroundColor = color;
    }

    public String[] getLabels() {
        return this.fLabels != null ? (String[])this.fLabels.toArray() : null;
    }

    public void setLabels(String[] stringArray) {
        if (stringArray != null) {
            this.fLabels = Collections.unmodifiableList(Arrays.asList(stringArray));
            this.fZOrder = this.fLabels.get(0);
        } else {
            this.fLabels = null;
        }
    }

    @Override
    public void setPreviewTextContents(String string, String[] stringArray) {
        super.setPreviewTextContents(string, stringArray);
        if (!BUSY_MESSAGE.equals(this.fDescription)) {
            this.buildAndDisplaySelectorPanel(stringArray);
        } else {
            this.buildAndDisplayBusyPanel(BUSY_MESSAGE);
        }
    }

    @Override
    public double getPreviewPaneRatio() {
        return 0.2;
    }

    private void buildAndDisplaySelectorPanel(String[] stringArray) {
        this.setLabels(stringArray);
        int n = this.getChildComponent().getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getChildComponent().getComponent(i);
            if (!WIDGET_BUSY_NAME.equals(component.getName())) continue;
            this.getChildComponent().remove(i);
        }
        WorksheetSelectorGroup worksheetSelectorGroup = new WorksheetSelectorGroup();
        worksheetSelectorGroup.makeSelectors();
        this.getChildComponent().repaint();
    }

    private void buildAndDisplayBusyPanel(String string) {
        MJTextArea mJTextArea = new MJTextArea(string);
        mJTextArea.setName(WIDGET_BUSY_NAME);
        mJTextArea.setEditable(false);
        mJTextArea.setFont(DataPreviewPanel.MSG_FONT);
        this.getChildComponent().add((Component)mJTextArea);
    }

    private class WorksheetSelectorGroup {
        private ButtonGroup fButtonGroup;
        private Matcher fMatcher;
        private Map<String, MJRadioButton> fButtonList;
        private String[] fLabelsArray;

        WorksheetSelectorGroup() {
            this.fLabelsArray = SpreadsheetSelector.this.getLabels();
            this.makeGroup();
            this.makeMatcher();
        }

        private void makeGroup() {
            this.fButtonGroup = new ButtonGroup();
        }

        private void makeMatcher() {
            String string = "^(.*)$";
            Pattern pattern = Pattern.compile(string, 8);
            this.fMatcher = pattern.matcher(SpreadsheetSelector.this.fDescription);
        }

        private void makeSelectors() {
            String string;
            this.fButtonList = new HashMap<String, MJRadioButton>();
            int n = 0;
            while ((string = this.findMatch(this.fMatcher)) != null) {
                MJRadioButton mJRadioButton;
                boolean bl;
                boolean bl2 = bl = n == 0;
                if ((mJRadioButton = this.makeButton(string, this.fLabelsArray[n++])) == null) continue;
                if (SwingUtilities.isEventDispatchThread()) {
                    this.addSelector(mJRadioButton, string, bl);
                    continue;
                }
                SelectorPanelUpdater selectorPanelUpdater = new SelectorPanelUpdater(mJRadioButton, string, bl);
                SwingUtilities.invokeLater(selectorPanelUpdater);
            }
        }

        private void addSelector(MJRadioButton mJRadioButton, String string, boolean bl) {
            SpreadsheetSelector.this.getChildComponent().add((Component)mJRadioButton);
            this.fButtonList.put(string, mJRadioButton);
            mJRadioButton.setSelected(bl);
            mJRadioButton.setBackground(SpreadsheetSelector.this.fBackgroundColor != null ? SpreadsheetSelector.this.fBackgroundColor : Color.WHITE);
        }

        private MJRadioButton makeButton(String string, String string2) {
            if (string != null) {
                MJRadioButton mJRadioButton = new MJRadioButton(string2);
                mJRadioButton.setName(string);
                mJRadioButton.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (((AbstractButton)itemEvent.getSource()).isSelected()) {
                            SpreadsheetSelector.this.fZOrder = ((Component)itemEvent.getSource()).getName();
                            SpreadsheetSelector.this.fImportProxy.requestVariableList(SpreadsheetSelector.this.fZOrder);
                        }
                    }
                });
                this.fButtonGroup.add((AbstractButton)mJRadioButton);
                return mJRadioButton;
            }
            return null;
        }

        private String findMatch(Matcher matcher) {
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }

        public void setSelectorLabel(String string, String string2) {
            MJRadioButton mJRadioButton;
            if (this.fButtonList != null && (mJRadioButton = this.fButtonList.get(string)) != null) {
                mJRadioButton.setText(string2);
            }
        }

        private class SelectorPanelUpdater
        implements Runnable {
            private final MJRadioButton fTheButton;
            private final String fName;
            private final boolean fSelected;

            SelectorPanelUpdater(MJRadioButton mJRadioButton, String string, boolean bl) {
                this.fTheButton = mJRadioButton;
                this.fName = string;
                this.fSelected = bl;
            }

            @Override
            public void run() {
                WorksheetSelectorGroup.this.addSelector(this.fTheButton, this.fName, this.fSelected);
            }
        }
    }
}

