/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.mde.editor.ActionID;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.services.binding.MatlabKeyBindings;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Observer;

public final class EditorAction {
    private final boolean fStatic;
    private ObservableAction fStaticAction;
    private static int sNumericId;
    public static final EditorAction NEW;
    public static final EditorAction OPEN;
    public static final EditorAction OPEN_AS_TEXT;
    public static final EditorAction SAVE;
    public static final EditorAction SAVE_AS;
    public static final EditorAction SAVE_BACKUP;
    public static final EditorAction SAVE_ALL;
    public static final EditorAction FIND;
    public static final EditorAction FIND_AGAIN;
    public static final EditorAction FIND_AGAIN_BACK;
    public static final EditorAction FIND_SELECTION;
    public static final EditorAction FIND_SELECTION_BACK;
    public static final EditorAction FIND_FILES;
    public static final EditorAction GOTO;
    public static final EditorAction EVALUATE_SELECTION;
    public static final EditorAction OPEN_SELECTION;
    public static final EditorAction HELP_ON_SELECTION;
    public static final EditorAction PRINT_SELECTION;
    public static final EditorAction FUNCTION_MENU;
    public static final EditorAction TOGGLE_BOOKMARK;
    public static final EditorAction NEXT_BOOKMARK;
    public static final EditorAction PREVIOUS_BOOKMARK;
    public static final EditorAction PRINT;
    public static final EditorAction PAGE_SETUP;
    public static final EditorAction FUNCTION_BROWSER;
    public static final EditorAction FUNCTION_HINTS;
    public static final EditorAction COPY_FULL_PATH;
    private final int fNumericId;
    private final String fActionId;
    private final String fName;

    public int getId() {
        return this.fNumericId;
    }

    public String getActionId() {
        return this.fActionId;
    }

    boolean isStatic() {
        return this.fStatic;
    }

    public List<KeyStrokeList> getKeyBindings() {
        KeyBindingManager keyBindingManager = MatlabKeyBindings.getManager();
        return keyBindingManager.getCurrentKeyBindingSet().getKeyBindings(keyBindingManager.getContext("MATLABEditor"), keyBindingManager.getActionData(this.getActionId()));
    }

    public MJAbstractAction createDummyAction() {
        ObservableAction observableAction = this.getAction();
        observableAction.setEnabled(false);
        return observableAction;
    }

    public ObservableAction getAction() {
        ObservableAction observableAction;
        if (this.fStatic && this.fStaticAction != null) {
            observableAction = this.fStaticAction;
        } else {
            observableAction = new ObservableAction(this.fNumericId);
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABEditor", this.getActionId(), (ExtendedAction)observableAction);
            if (this.fName != null) {
                observableAction.setName(this.fName);
            }
            if (this.fStatic) {
                this.fStaticAction = observableAction;
            }
        }
        return observableAction;
    }

    public EditorAction(String string) {
        this(string, null, false);
    }

    private EditorAction(String string, String string2, boolean bl) {
        assert (string != null);
        this.fNumericId = ++sNumericId;
        this.fActionId = string;
        this.fName = string2;
        this.fStatic = bl;
    }

    private EditorAction(ActionID actionID, boolean bl) {
        this(actionID.getId(), null, bl);
    }

    private EditorAction(ActionID actionID, String string, boolean bl) {
        this(actionID.getId(), string, bl);
    }

    private EditorAction(ActionID actionID) {
        this(actionID.getId(), null, false);
    }

    static {
        NEW = new EditorAction(ActionID.NEW, true);
        OPEN = new EditorAction(ActionID.OPEN, true);
        OPEN_AS_TEXT = new EditorAction(ActionID.OPEN_AS_TEXT, true);
        SAVE = new EditorAction(ActionID.SAVE);
        SAVE_AS = new EditorAction(ActionID.SAVE_AS);
        SAVE_BACKUP = new EditorAction(ActionID.SAVE_BACKUP);
        SAVE_ALL = new EditorAction(ActionID.SAVE_ALL, true);
        FIND = new EditorAction(ActionID.FIND, EditorUtils.lookup("find.action.name"), true);
        FIND_AGAIN = new EditorAction(ActionID.FIND_NEXT, true);
        FIND_AGAIN_BACK = new EditorAction(ActionID.FIND_PREVIOUS, true);
        FIND_SELECTION = new EditorAction(ActionID.FIND_SELECTION);
        FIND_SELECTION_BACK = new EditorAction(ActionID.FIND_PREVIOUS_SELECTION);
        FIND_FILES = new EditorAction(ActionID.FIND_FILES, true);
        GOTO = new EditorAction(ActionID.GOTO);
        EVALUATE_SELECTION = new EditorAction(ActionID.EVALUATE_SELECTION);
        OPEN_SELECTION = new EditorAction(ActionID.OPEN_SELECTION);
        HELP_ON_SELECTION = new EditorAction(ActionID.HELP_ON_SELECTION);
        PRINT_SELECTION = new EditorAction(ActionID.PRINT_SELECTION);
        FUNCTION_MENU = new EditorAction(ActionID.SHOW_FUNCTIONS);
        TOGGLE_BOOKMARK = new EditorAction(ActionID.TOGGLE_BOOKMARK);
        NEXT_BOOKMARK = new EditorAction(ActionID.NEXT_BOOKMARK);
        PREVIOUS_BOOKMARK = new EditorAction(ActionID.PREVIOUS_BOOKMARK);
        PRINT = new EditorAction(ActionID.PRINT);
        PAGE_SETUP = new EditorAction(ActionID.PAGE_SETUP);
        FUNCTION_BROWSER = new EditorAction(ActionID.FUNCTION_BROWSER);
        FUNCTION_HINTS = new EditorAction(ActionID.FUNCTION_HINTS);
        COPY_FULL_PATH = new EditorAction(ActionID.COPY_FULL_PATH);
    }

    public static class ObservableAction
    extends MJAbstractAction {
        private Observer fObserver;
        private final Integer fId;

        private ObservableAction(int n) {
            this.fId = n;
        }

        public void setObserver(Observer observer) {
            this.fObserver = observer;
        }

        public Observer getObserver() {
            return this.fObserver;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.fObserver != null) {
                this.fObserver.update(null, new ActionEvent(actionEvent.getSource(), this.fId, actionEvent.getActionCommand(), actionEvent.getModifiers()));
            }
        }
    }
}

