/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mlwidgets.prefs.ConfirmationDialogPrefsPanel;
import com.mathworks.services.KeyboardPrefs;
import com.mathworks.services.Prefs;
import com.mathworks.services.PrefsAWT;
import com.mathworks.widgets.text.EditorPreferences;
import com.mathworks.widgets.text.EditorPrefsAccessor;
import com.mathworks.widgets.text.matlab.MatlabFunctionIndentingScheme;
import java.awt.Color;
import java.awt.Font;

public class EditorOptions {
    static final String TAB_TO_SPACE = "TabToSpaces";
    static final String EMACS_STYLE_TAB = "EmacsTab";
    static final String SPACES_PER_INDENT = "SpacesPerIndent";
    public static final String MOSTRECENTLYUSED = "MRU";
    static final String UNREGISTERED_EDITOR = "Unregistered";
    static final String MRU_SIZE = "MRUSize";
    static final String NAMED_BUFFER_OPTION = "NamedBufferOption";
    static final String SHOW_NEW_FILE_PROMPT = "ShowNewFilePrompt";
    static final String PROMPT_BEFORE_EXITING_DEBUG = "PromptBeforeExitingDebugMode";
    static final String REG_TEXTFIELD_ENTRY = "OtherEditorTextFieldEntry";
    private static final String AUTO_RELOAD_FILES = "AutoReloadFiles";
    private static final String AUTO_TERMINATE_LAST_LINE = "AutoTerminateLastLine";
    static final int PRINTSTYLE_BW = 1;
    static final int PRINTSTYLE_COLOR = 2;
    static final int PRINTSTYLE_STYLED = 3;
    public static final int NAMEDBUFFER_CREATE = 1;
    public static final int NAMEDBUFFER_DONTCREATE = 2;
    static final int DEFAULT_MRU_SIZE = 8;
    static final int MRU_SIZE_LIMIT = 12;

    private EditorOptions() {
    }

    public static int getNamedBufferOption() {
        return Prefs.getIntegerPref((String)"EditorNamedBufferOption", (int)1);
    }

    static void setNamedBufferOption(int n) {
        Prefs.setIntegerPref((String)"EditorNamedBufferOption", (int)n);
    }

    static String getShowNewFilePromptKey() {
        return "EditorShowNewFilePrompt";
    }

    static boolean getDefaultShowNewFilePromptValue() {
        return true;
    }

    public static boolean getShowNewFilePrompt() {
        return Prefs.getBooleanPref((String)EditorOptions.getShowNewFilePromptKey(), (boolean)EditorOptions.getDefaultShowNewFilePromptValue());
    }

    private static void setShowNewFilePrompt(boolean bl) {
        Prefs.setBooleanPref((String)EditorOptions.getShowNewFilePromptKey(), (boolean)bl);
    }

    static String getPromptWhenSavingInDebugKey() {
        return "EditorPromptBeforeExitingDebugMode";
    }

    static boolean getDefaultPromptWhenSavingInDebug() {
        return true;
    }

    static int getPrintOptions() {
        return EditorPrefsAccessor.getPrintOptions();
    }

    static void setPrintOptions(int n) {
        Prefs.setIntegerPref((String)"EditorPrintOptions", (int)n);
    }

    public static int getMRUSize() {
        return Prefs.getIntegerPref((String)"EditorMRUSize", (int)8);
    }

    static void setMRUSize(int n) {
        if (n >= 0 && n <= 12) {
            Prefs.setIntegerPref((String)"EditorMRUSize", (int)n);
        }
    }

    static boolean getShowLineNumbers() {
        return EditorPrefsAccessor.getShowLineNumbers();
    }

    static void setShowLineNumbers(boolean bl) {
        Prefs.setBooleanPref((String)"EditorShowLineNumbers", (boolean)bl);
    }

    public static String getOtherEditor() {
        return Prefs.getStringPref((String)"EditorOtherEditor", (String)"");
    }

    static void setOtherEditor(String string) {
        Prefs.setStringPref((String)"EditorOtherEditor", (String)string);
    }

    public static String getOtherEditorTextFieldEntry() {
        return Prefs.getStringPref((String)"EditorOtherEditorTextFieldEntry", (String)"");
    }

    static void setOtherEditorTextFieldEntry(String string) {
        Prefs.setStringPref((String)"EditorOtherEditorTextFieldEntry", (String)string);
    }

    public static void setGraphicalDebugging(boolean bl) {
        Prefs.setBooleanPref((String)"EditorGraphicalDebugging", (boolean)bl);
    }

    static boolean getDataTips() {
        return Prefs.getBooleanPref((String)"EditorEnableDataTips", (boolean)false);
    }

    static void setDataTips(boolean bl) {
        Prefs.setBooleanPref((String)"EditorEnableDataTips", (boolean)bl);
    }

    static boolean isReopenFilesUponStart() {
        return Prefs.getBooleanPref((String)"EditorReloadFiles", (boolean)true);
    }

    static void setReopenFilesUponStart(boolean bl) {
        Prefs.setBooleanPref((String)"EditorReloadFiles", (boolean)bl);
    }

    public static boolean getBuiltinEditor() {
        return Prefs.getBooleanPref((String)"EditorBuiltinEditor", (boolean)true);
    }

    static void setBuiltinEditor(boolean bl) {
        Prefs.setBooleanPref((String)"EditorBuiltinEditor", (boolean)bl);
    }

    static boolean isTabCompletionEnabled() {
        return KeyboardPrefs.isEditorTabCompletionEnabled();
    }

    public static int getSpacesPerTab() {
        return EditorPrefsAccessor.getSpacesPerTab();
    }

    public static void setSpacesPerTab(int n) {
        EditorPreferences.setSpacesPerTab((int)n);
    }

    static int getSpacesPerIndent() {
        return EditorPrefsAccessor.getSpacesPerIndent();
    }

    static void setSpacesPerIndent(int n) {
        Prefs.setIntegerPref((String)"EditorSpacesPerIndent", (int)n);
    }

    public static MatlabFunctionIndentingScheme getMatlabIndentingScheme() {
        return EditorPrefsAccessor.getMatlabIndentingScheme();
    }

    public static void setMatlabIndentingScheme(MatlabFunctionIndentingScheme matlabFunctionIndentingScheme) {
        Prefs.setStringPref((String)"EditorMFunctionIndentType", (String)matlabFunctionIndentingScheme.getInternalName());
    }

    public static boolean isTabChangedToSpaces() {
        return EditorPrefsAccessor.isTabChangedToSpaces();
    }

    public static void setTabChangedToSpaces(boolean bl) {
        EditorPreferences.setTabChangedToSpaces((boolean)bl);
    }

    static boolean isEmacsStyleTab() {
        return EditorPrefsAccessor.isEmacsStyleTab();
    }

    static void setEmacsStyleTab(boolean bl) {
        Prefs.setBooleanPref((String)"EditorEmacsTab", (boolean)bl);
    }

    static boolean isCaretRowHighlightingOn() {
        return EditorPrefsAccessor.isHighlightCaretRow();
    }

    static Color getHighlightCaretRowColor() {
        return EditorPrefsAccessor.getHighlightCaretRowColor();
    }

    static void setCaretRowHighlightingOptions(boolean bl, Color color) {
        Prefs.setBooleanPref((String)"Editorhighlight-caret-row-boolean", (boolean)bl);
        PrefsAWT.setColorPref((String)"Editorhighlight-caret-row-boolean-color", (Color)color);
    }

    static boolean isTextLimitOn() {
        return EditorPrefsAccessor.isTextLimitOn();
    }

    static void setTextLimitOn(boolean bl) {
        Prefs.setBooleanPref((String)"EditorRightTextLineVisible", (boolean)bl);
    }

    static int getTextLimit() {
        return EditorPrefsAccessor.getTextLimit();
    }

    static void setTextLimit(int n) {
        Prefs.setIntegerPref((String)"EditorRightTextLineLimit", (int)n);
    }

    static void setTextLimitLineWidth(Integer n) {
        Prefs.setIntegerPref((String)"EditorRightTextLimitLineWidth", (int)n);
    }

    static int getTextLimitLineWidth() {
        return EditorPrefsAccessor.getTextLimitLineWidth();
    }

    static Color getTextLimitLineColor() {
        return EditorPrefsAccessor.getTextLimitLineColor();
    }

    static void setTextLimitLineColor(Color color) {
        Prefs.setColorPref((String)"EditorRightTextLimitLineColor", (Color)color);
    }

    public static boolean isAutoReloadFilesFromDisc() {
        return Prefs.getBooleanPref((String)"EditorAutoReloadFiles", (boolean)true);
    }

    public static void setAutoReloadFilesFromDisc(boolean bl) {
        Prefs.setBooleanPref((String)"EditorAutoReloadFiles", (boolean)bl);
    }

    static boolean isAutoTerminateLastLine() {
        return Prefs.getBooleanPref((String)"EditorAutoTerminateLastLine", (boolean)false);
    }

    static void setAutoTerminateLastLine(boolean bl) {
        Prefs.setBooleanPref((String)"EditorAutoTerminateLastLine", (boolean)bl);
    }

    static void setPrintingBodyCustomFont(Font font) {
        Prefs.setFontPref((String)"EditorTextFont", (Font)font);
    }

    static void setPrintingHeaderCustomFont(Font font) {
        Prefs.setFontPref((String)"EditorHeaderFont", (Font)font);
    }

    public static ConfirmationDialogPrefsPanel.DialogItem[] getDialogItems() {
        return new ConfirmationDialogPrefsPanel.DialogItem[]{new ConfirmationDialogPrefsPanel.DialogItem(EditorUtils.lookup("msg.NewFilePrompt"), EditorOptions.getShowNewFilePromptKey(), EditorUtils.lookup("pref.general.Editor"), EditorOptions.getDefaultShowNewFilePromptValue()), new ConfirmationDialogPrefsPanel.DialogItem(EditorUtils.lookup("msg.PromptBeforeExitingDebug"), EditorOptions.getPromptWhenSavingInDebugKey(), EditorUtils.lookup("pref.general.Editor"), EditorOptions.getDefaultPromptWhenSavingInDebug())};
    }
}

