/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mde.editor.EditorOptions;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.color.ColorPicker;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;

public class EditorPrefsDisplayPanel
extends MJPanel {
    private static EditorPrefsDisplayPanel sPrefsPanel = null;
    private MJCheckBox fDataTips;
    private MJCheckBox fShowLineNumbers;
    private MJCheckBox fCaretRowHighlighting;
    private ColorPicker fCaretRowHighlightingColorPicker;
    private MJCheckBox fRightHandLine;
    private MJSpinner fRightHandLimit;
    private MJLabel fRightHandLimitUnitsLabel;
    private MJSpinner fRightHandLineWidth;
    private MJLabel fRightHandLimitWidthLabel;
    private ColorPicker fRightHandLimitColor;
    private MJLabel fRightHandLimitColorLabel;
    private MJLabel fRightHandLimitLabel;
    private MJLabel fRightHandLineWidthUnitsLabel;

    public EditorPrefsDisplayPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(EditorUtils.lookup("pref.disp.Display")));
        mJPanel.setName("Display");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        int n = 5;
        int n2 = 6;
        gridBagConstraints.insets = new Insets(0, 0, n, n2);
        this.fCaretRowHighlighting = new MJCheckBox(EditorUtils.lookup("pref.disp.CaretRowHighlighting"));
        this.fCaretRowHighlighting.setName("ShowCaretRowHighlightingCheckbox");
        this.fCaretRowHighlighting.setSelected(EditorOptions.isCaretRowHighlightingOn());
        mJPanel.add((Component)this.fCaretRowHighlighting, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        this.fCaretRowHighlightingColorPicker = new ColorPicker(ColorPicker.PickerIcon.NONE);
        this.fCaretRowHighlightingColorPicker.setValue((Object)EditorOptions.getHighlightCaretRowColor());
        this.fCaretRowHighlightingColorPicker.getAccessibleContext().setAccessibleName(EditorUtils.lookup("prefs.language.acc.ColorPicker"));
        this.fCaretRowHighlightingColorPicker.setEnabled(EditorOptions.isCaretRowHighlightingOn());
        mJPanel.add((Component)this.fCaretRowHighlightingColorPicker, (Object)gridBagConstraints);
        this.fCaretRowHighlighting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditorPrefsDisplayPanel.this.fCaretRowHighlightingColorPicker.setEnabled(EditorPrefsDisplayPanel.this.fCaretRowHighlighting.isSelected());
            }
        });
        this.fShowLineNumbers = new MJCheckBox(EditorUtils.lookup("pref.disp.ShowLineNumbers"), EditorOptions.getShowLineNumbers());
        this.fShowLineNumbers.setName("ShowLineNumbers");
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        mJPanel.add((Component)this.fShowLineNumbers, (Object)gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.fDataTips = new MJCheckBox(EditorUtils.lookup("pref.disp.DataTips"), EditorOptions.getDataTips());
        this.fDataTips.setName("DataTips");
        mJPanel.add((Component)this.fDataTips, (Object)gridBagConstraints);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new FormLayout(MJUtilities.getCheckBoxIndent() + "px, p, 2dlu, l:p, 2dlu, p", "p, 2dlu, p, 4dlu, p, 4dlu, p"));
        mJPanel2.setBorder((Border)BorderFactory.createTitledBorder(EditorUtils.lookup("pref.disp.RightHand")));
        mJPanel2.setName("RightHand");
        CellConstraints cellConstraints = new CellConstraints();
        boolean bl = EditorOptions.isTextLimitOn();
        this.fRightHandLine = new MJCheckBox(EditorUtils.lookup("pref.disp.ShowLine"), bl);
        this.fRightHandLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = EditorPrefsDisplayPanel.this.fRightHandLine.isSelected();
                EditorPrefsDisplayPanel.this.fRightHandLimit.setEnabled(bl);
                EditorPrefsDisplayPanel.this.fRightHandLimitUnitsLabel.setEnabled(bl);
                EditorPrefsDisplayPanel.this.fRightHandLimitLabel.setEnabled(bl);
                EditorPrefsDisplayPanel.this.fRightHandLineWidth.setEnabled(bl);
                EditorPrefsDisplayPanel.this.fRightHandLimitWidthLabel.setEnabled(bl);
                EditorPrefsDisplayPanel.this.fRightHandLineWidthUnitsLabel.setEnabled(bl);
                EditorPrefsDisplayPanel.this.fRightHandLimitColor.setEnabled(bl);
                EditorPrefsDisplayPanel.this.fRightHandLimitColorLabel.setEnabled(bl);
            }
        });
        mJPanel2.add((Component)this.fRightHandLine, (Object)cellConstraints.xyw(1, 1, 5));
        this.fRightHandLimitLabel = new MJLabel(EditorUtils.lookup("pref.disp.LineLabel"));
        this.fRightHandLimitLabel.setEnabled(bl);
        mJPanel2.add((Component)this.fRightHandLimitLabel, (Object)cellConstraints.xy(2, 3));
        this.fRightHandLimit = new MJSpinner((SpinnerModel)new SpinnerNumberModel(EditorOptions.getTextLimit(), 1, 160, 5));
        this.fRightHandLimit.setEnabled(bl);
        this.fRightHandLimit.setDefaultEditorAccessibleName("Right-hand text limit spinner, specified as number of columns");
        mJPanel2.add((Component)this.fRightHandLimit, (Object)cellConstraints.xy(4, 3));
        this.fRightHandLimitUnitsLabel = new MJLabel(EditorUtils.lookup("pref.disp.LineUnitsLabel"));
        this.fRightHandLimitUnitsLabel.setEnabled(bl);
        mJPanel2.add((Component)this.fRightHandLimitUnitsLabel, (Object)cellConstraints.xy(6, 3));
        this.fRightHandLimitWidthLabel = new MJLabel(EditorUtils.lookup("pref.disp.LimitLineWidth"));
        this.fRightHandLimitWidthLabel.setEnabled(bl);
        mJPanel2.add((Component)this.fRightHandLimitWidthLabel, (Object)cellConstraints.xy(2, 5));
        this.fRightHandLineWidth = new MJSpinner((SpinnerModel)new SpinnerNumberModel(EditorOptions.getTextLimitLineWidth(), 1, 100, 1));
        this.fRightHandLineWidth.setEnabled(bl);
        this.fRightHandLineWidth.setDefaultEditorAccessibleName("Right-hand text limit line width spinner, specified as number of pixels");
        mJPanel2.add((Component)this.fRightHandLineWidth, (Object)cellConstraints.xy(4, 5));
        this.fRightHandLineWidthUnitsLabel = new MJLabel(EditorUtils.lookup("pref.disp.LimitLineWidthUnits"));
        this.fRightHandLineWidthUnitsLabel.setEnabled(bl);
        mJPanel2.add((Component)this.fRightHandLineWidthUnitsLabel, (Object)cellConstraints.xy(6, 5));
        this.fRightHandLimitColorLabel = new MJLabel(EditorUtils.lookup("pref.disp.LimitLineColor"));
        this.fRightHandLimitColorLabel.setEnabled(bl);
        mJPanel2.add((Component)this.fRightHandLimitColorLabel, (Object)cellConstraints.xy(2, 7));
        this.fRightHandLimitColor = new ColorPicker(ColorPicker.PickerIcon.NONE);
        this.fRightHandLimitColor.setValue((Object)EditorOptions.getTextLimitLineColor());
        this.fRightHandLimitColor.getAccessibleContext().setAccessibleName(EditorUtils.lookup("prefs.language.acc.ColorPicker"));
        this.fRightHandLimitColor.setEnabled(bl);
        mJPanel2.add((Component)this.fRightHandLimitColor, (Object)cellConstraints.xy(4, 7));
        this.setLayout((LayoutManager)new MGridLayout(0, 1, n2, n, 131072));
        this.add((Component)mJPanel);
        this.add((Component)mJPanel2);
    }

    public static MJPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new EditorPrefsDisplayPanel();
        sPrefsPanel.setName("EditorPrefsDisplayPanel");
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    private void saveOptions() {
        EditorOptions.setShowLineNumbers(this.fShowLineNumbers.isSelected());
        EditorOptions.setDataTips(this.fDataTips.isSelected());
        EditorOptions.setTextLimitOn(this.fRightHandLine.isSelected());
        EditorOptions.setTextLimit((Integer)this.fRightHandLimit.getValue());
        EditorOptions.setTextLimitLineWidth((Integer)this.fRightHandLineWidth.getValue());
        EditorOptions.setTextLimitLineColor((Color)this.fRightHandLimitColor.getValue());
        EditorOptions.setCaretRowHighlightingOptions(this.fCaretRowHighlighting.isSelected(), (Color)this.fCaretRowHighlightingColorPicker.getValue());
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_editordisplay_prefs"};
    }
}

