/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import ca.odell.glazedlists.BasicEventList;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.mde.editor.EditorSTPMultiView;
import com.mathworks.mde.editor.EditorViewClient;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionInterface;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionResult;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.CharBuffer;
import com.mathworks.util.Log;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.mcode.MTokenUtils;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.MTreeUtils;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;

public class EditorTabCompletion
implements TabCompletionInterface {
    public int getTabCompletionStartOffset() {
        int n = EditorTabCompletion.getSyntaxTextPane().getCaretPosition();
        try {
            assert (EditorTabCompletion.getSyntaxTextPane().getDocument() instanceof BaseDocument);
            return MTokenUtils.getMLineStart((BaseDocument)((BaseDocument)EditorTabCompletion.getSyntaxTextPane().getDocument()), (int)n);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return n;
        }
    }

    public boolean isComposing() {
        return EditorTabCompletion.getSyntaxTextPane().isComposing();
    }

    public JScrollPane getScrollPane() {
        return (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.getComponent());
    }

    public void processKey(KeyEvent keyEvent) {
        EditorSTPMultiView editorSTPMultiView = (EditorSTPMultiView)EditorTabCompletion.getSyntaxTextPane();
        editorSTPMultiView.processKeyEvent(keyEvent);
    }

    public JTextComponent getComponent() {
        return EditorTabCompletion.getSyntaxTextPane().getActiveTextComponent();
    }

    public boolean isTabCompletionEnabled() {
        return true;
    }

    public ActionListener getDefaultInsertTabAction() {
        return null;
    }

    public void tabCompletionStarted() {
    }

    private static STPInterface getSyntaxTextPane() {
        return EditorViewClient.getActiveEditorView().getSyntaxTextPane();
    }

    public List<TabCompletionResult> getAdditionalTabCompletions(int n, String string) {
        BaseDocument baseDocument = (BaseDocument)EditorTabCompletion.getSyntaxTextPane().getDocument();
        return EditorTabCompletion.getAdditionalTabCompletions(n, string, baseDocument);
    }

    public Context getKeybindingContext() {
        return MatlabKeyBindings.getManager().getContext("MATLABEditor");
    }

    public static List<TabCompletionResult> getAdditionalTabCompletions(int n, String string, BaseDocument baseDocument) {
        Validate.notNull((Object)baseDocument);
        Validate.isTrue((n >= 0 && n <= baseDocument.getLength() ? 1 : 0) != 0, (String)"offset must be between 0 and the length of the document");
        Collection<Object> collection = Collections.emptyList();
        String string2 = EditorTabCompletion.findEndingIdentifier(string);
        try {
            int n2;
            if (string2.length() > 0 && ((n2 = n - string2.length() - 1) == -1 || baseDocument.getChars(n2, 1)[0] != '.')) {
                collection = EditorTabCompletion.getLocalStrings(baseDocument, n, string2);
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        BasicEventList basicEventList = new BasicEventList();
        basicEventList.addAll(collection);
        return basicEventList;
    }

    private static String findEndingIdentifier(String string) {
        char c;
        CharBuffer charBuffer = new CharBuffer();
        for (int i = string.length() - 1; i >= 0 && (CharUtils.isAsciiAlphanumeric((char)(c = string.charAt(i))) || c == '_'); --i) {
            charBuffer.insert(0, c);
        }
        return charBuffer.toString();
    }

    private static Collection<LocalString> getLocalStrings(BaseDocument baseDocument, int n, String string) {
        List list = MTreeUtils.getLocalStringsAtOffset((BaseDocument)baseDocument, (int)n);
        Vector<LocalString> vector = new Vector<LocalString>();
        for (MTree.Node node : list) {
            String string2 = node.getText();
            if (!string2.startsWith(string)) continue;
            vector.add(new LocalString(string2, string.length()));
        }
        return vector;
    }

    public static class LocalString
    extends TabCompletionResult {
        private final int fAmountOfWordAlreadyTyped;

        protected LocalString(String string, int n) {
            super(string);
            this.fAmountOfWordAlreadyTyped = n;
        }

        public void complete(CompletionObserver completionObserver) {
            completionObserver.completed(0, (Object)this.getRestOfWord());
        }

        public String getRestOfWord() {
            return this.getString().substring(this.fAmountOfWordAlreadyTyped);
        }
    }
}

