/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.common.icons.IconContainer;
import com.mathworks.common.icons.ProvisionalIcon;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorEvent;
import com.mathworks.matlab.api.editor.EditorEventListener;
import com.mathworks.matlab.api.editor.EditorToolstripTabContributor;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.desk.MLMenuMergeTag;
import com.mathworks.mde.desk.MLToolstripFactory;
import com.mathworks.mde.difftool.DiffAgainstAutosaveAction;
import com.mathworks.mde.difftool.DiffAgainstBrowseAction;
import com.mathworks.mde.difftool.UnsavedChangesDiffToolAction;
import com.mathworks.mde.editor.ActionID;
import com.mathworks.mde.editor.ActionManager;
import com.mathworks.mde.editor.EditorAction;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mde.editor.EditorToolstripTabFactory;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.GoToMenu;
import com.mathworks.mde.editor.ProfilerButton;
import com.mathworks.mde.editor.codepad.CodepadActionManager;
import com.mathworks.mde.editor.plugins.difftool.DiffToolInfoImpl;
import com.mathworks.mde.editor.plugins.matlab.MatlabDebugActions;
import com.mathworks.mde.editor.plugins.matlab.MatlabMenuContributor;
import com.mathworks.mde.editor.plugins.matlab.MatlabPluginUtils;
import com.mathworks.mde.editor.plugins.matlab.RunMenu;
import com.mathworks.mlservices.MatlabDebugServices;
import com.mathworks.mlwidgets.configeditor.data.RunConfiguration;
import com.mathworks.mlwidgets.debug.DebugActions;
import com.mathworks.mlwidgets.mlservices.scc.MWSccManager;
import com.mathworks.mlwidgets.mlservices.scc.SccFileProvider;
import com.mathworks.mlwidgets.stack.StackComboBox;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.IconSet;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.SimpleDOMUtils;
import com.mathworks.mwswing.plaf.MWindowsComboBoxUI;
import com.mathworks.mwswing.plaf.PlafUtils;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.components.TSSplitButton;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.util.Disposable;
import com.mathworks.util.FileUtils;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.datamodel.FutureFileStorageLocation;
import com.mathworks.widgets.datamodel.StorageLocationUtils;
import com.mathworks.widgets.debug.DebuggerManager;
import com.mathworks.widgets.desk.RecentFiles;
import com.mathworks.widgets.desk.ToolstripInfoRegistrar;
import com.mathworks.widgets.util.EmptyIcon;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import org.apache.commons.lang.Validate;

public class EditorToolSetFactory {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(EditorToolSetFactory.class.getPackage().getName() + ".resources.RES_Editor_Toolstrip");
    private final Editor fEditor;
    private final ActionManager fActionManager;
    private TSToolSet fToolSet;
    private MJAbstractAction fStopIfErrorAction;
    private MJAbstractAction fStopIfWarningAction;
    private RunMenu fRunMenu;
    private Disposable fSaveActionDisposable;
    private EditorEventListener fGoUntilActionEditorEventListener;
    private EditorEventListener fCompareActionEditorEventListener;
    private StackComboBox fStackCombo;

    private static void addDebugClearAllBreakpointsActions(TSToolSet tSToolSet) {
        DebuggerManager debuggerManager = DebuggerManager.getInstance();
        tSToolSet.configureAndAdd("continue", (Action)new ChildAction(debuggerManager.getContinueActionNoEcho()));
        tSToolSet.configureAndAdd("step", (Action)new ChildAction(debuggerManager.getStepActionNoEcho()));
        tSToolSet.configureAndAdd("step_in", (Action)new ChildAction(debuggerManager.getStepInActionNoEcho()));
        tSToolSet.configureAndAdd("step_out", (Action)new ChildAction(debuggerManager.getStepOutActionNoEcho()));
        tSToolSet.configureAndAdd("exit_debug", (Action)new ChildAction(debuggerManager.getExitDebugAction()));
        tSToolSet.configureAndAdd("clear_all_breakpoints", (Action)new ChildAction(DebugActions.getClearAllBkptsAction()));
    }

    public EditorToolSetFactory(Editor editor, ActionManager actionManager) {
        Validate.notNull((Object)editor, (String)"'editor' cannot be null");
        Validate.notNull((Object)actionManager, (String)"'actionManager' cannot be null");
        this.fEditor = editor;
        this.fActionManager = actionManager;
        this.fToolSet = new TSToolSet(TSToolSetContents.readToolSetContents(EditorToolSetFactory.class, (String)"resources/EditorToolset.xml"));
        this.populateFileSection();
        this.populateEditSection();
        this.populateNavigateSection();
        this.populateBreakpointsSection();
        this.populateRunSection();
    }

    public TSToolSet getToolSet() {
        return this.fToolSet;
    }

    public TSTabConfiguration getTabConfig(boolean bl, boolean bl2) {
        MJMenu mJMenu;
        TSTabConfiguration tSTabConfiguration = EditorToolSetFactory.readTabConfiguration("EditorTab.xml");
        if (!bl || bl2) {
            tSTabConfiguration.getSection("run").setVisible(false);
        }
        if (!bl2) {
            tSTabConfiguration.getSection("debug").setVisible(false);
        }
        if ((mJMenu = this.getSourceControlMenu()) == null || !mJMenu.isEnabled()) {
            tSTabConfiguration.removeTool("file", "source_control", "editor_toolset");
        }
        return tSTabConfiguration;
    }

    public void dispose() {
        this.fEditor.removeEventListener(this.fCompareActionEditorEventListener);
        this.fEditor.removeEventListener(this.fGoUntilActionEditorEventListener);
        this.fSaveActionDisposable.dispose();
        if (this.fRunMenu != null) {
            this.fRunMenu.dispose();
        }
        if (this.fStackCombo != null) {
            this.fStackCombo.dispose();
        }
    }

    private void populateFileSection() {
        MLDesktop mLDesktop = MLDesktop.getInstance();
        this.fToolSet.configureAndAdd("new", (Action)new ChildAction(mLDesktop.getNewBlankMFileAction()));
        MLToolstripFactory.populateNewEditorFileActions(this.fToolSet, mLDesktop, "new");
        this.fToolSet.configureAndAdd("find_files", (Action)new ChildAction((Action)this.fActionManager.getAction(EditorAction.FIND_FILES)));
        this.populateOpenAction();
        this.fSaveActionDisposable = EditorToolSetFactory.populateSaveAction(this.fEditor, this.fToolSet, this.fActionManager);
        this.populateSourceControl();
        this.fToolSet.configureAndAdd("print", (Action)new ChildAction((Action)this.fActionManager.getAction(EditorAction.PRINT)));
        this.fToolSet.configureAndAdd("default_print", (Action)new ChildAction((Action)this.fActionManager.getAction(EditorAction.PRINT)));
        this.fToolSet.configureAndAdd("print_selection", (Action)new ChildAction((Action)this.fActionManager.getAction(EditorAction.PRINT_SELECTION)));
        this.fToolSet.configureAndAdd("page_setup", (Action)new ChildAction((Action)this.fActionManager.getAction(EditorAction.PAGE_SETUP)));
        this.populateCompareActions();
    }

    public static Disposable populateSaveAction(final Editor editor, TSToolSet tSToolSet, ActionManager actionManager) {
        ChildAction childAction = new ChildAction((Action)actionManager.getAction(EditorAction.SAVE), false);
        tSToolSet.configureAndAdd("save", (Action)childAction);
        tSToolSet.configureAndAdd("default_save", (Action)childAction);
        childAction.putValue("buttonIcon", EditorToolSetFactory.getSaveIcon(editor));
        ContextTargetingManager.setPropertiesToInject((Action)childAction, (String[])new String[]{"buttonIcon"});
        tSToolSet.configureAndAdd("save_as", (Action)new ChildAction((Action)actionManager.getAction(EditorAction.SAVE_AS)));
        tSToolSet.configureAndAdd("save_all", (Action)new ChildAction((Action)actionManager.getAction(EditorAction.SAVE_ALL)));
        if (StorageLocationUtils.isOrWillBeBackedByFile((StorageLocation)editor.getStorageLocation())) {
            tSToolSet.configureAndAdd("save_backup", (Action)new ChildAction((Action)actionManager.getAction(EditorAction.SAVE_BACKUP)));
        }
        final EditorEventListener editorEventListener = new EditorEventListener((Action)childAction, editor){
            final /* synthetic */ Action val$saveAction;
            final /* synthetic */ Editor val$editor;
            {
                this.val$saveAction = action;
                this.val$editor = editor;
            }

            public void eventOccurred(EditorEvent editorEvent) {
                if (editorEvent == EditorEvent.DIRTY_STATE_CHANGED) {
                    this.val$saveAction.putValue("buttonIcon", EditorToolSetFactory.getSaveIcon(this.val$editor));
                }
            }
        };
        editor.addEventListener(editorEventListener);
        return new Disposable(){

            public void dispose() {
                editor.removeEventListener(editorEventListener);
            }
        };
    }

    private static Icon getSaveIcon(Editor editor) {
        IconSet iconSet = new IconSet(Arrays.asList(ProvisionalIcon.SAVE_DIRTY_16.getIcon(), ProvisionalIcon.SAVE_DIRTY_24.getIcon()));
        IconSet iconSet2 = new IconSet(Arrays.asList(ProvisionalIcon.SAVE_16.getIcon(), ProvisionalIcon.SAVE_24.getIcon()));
        return editor.isDirty() ? iconSet : iconSet2;
    }

    private void populateRunSection() {
        EditorToolSetFactory.addDebugClearAllBreakpointsActions(this.fToolSet);
        if (this.fEditor.isMCode()) {
            this.fRunMenu = new RunMenu(this.fEditor, this.getRunStateChangeListener());
            MJAbstractAction mJAbstractAction = (MJAbstractAction)EditorUtils.createRunOrPublishAction(this.fEditor, MatlabMenuContributor.RUN_OR_CONTINUE, "Run", (IconContainer)ProvisionalIcon.RUN_24, RunConfiguration.TYPE, this.fRunMenu);
            this.fToolSet.configureAndAdd("run", (Action)mJAbstractAction);
            this.fToolSet.getAction("run").putValue("buttonIcon", this.fRunMenu.getRunIcon());
            CodepadActionManager codepadActionManager = CodepadActionManager.getCodepadActionManager(this.fEditor);
            this.fToolSet.configureAndAdd("run_cell_and_advance", (Action)new ChildAction(codepadActionManager.getEvaluateCellAdvanceAction()));
            this.fToolSet.configureAndAdd("run_cell", (Action)new ChildAction(codepadActionManager.getEvaluateCellAction()));
            this.fToolSet.configureAndAdd("next_cell", (Action)new ChildAction(codepadActionManager.getNextAction()));
            new ProfilerButton(this.fToolSet, this.fEditor).populate();
            this.fToolSet.configureAndAdd("run_to_cursor", (Action)((Object)this.createGoUntilAction(this.fEditor)));
            this.fToolSet.addDecorator("compare", this.createDisableForNonFilesDecorator());
            this.fToolSet.addDecorator("run", new TSToolSet.ToolDecorator(){

                public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                    EditorToolSetFactory.disableActionForNonFiles(jComponent, EditorToolSetFactory.this.fEditor);
                    if (DebuggerManager.isDebugging() || EditorStartup.getInDebugMode()) {
                        jComponent.setEnabled(false);
                    }
                    if (toolLocation == TSToolSet.ToolLocation.TOOLSTRIP_TAB) {
                        EditorToolSetFactory.this.fRunMenu.setRunButton((TSSplitButton)jComponent);
                    }
                }
            });
            this.fToolSet.addDecorator("run", EditorToolSetFactory.createToolTipRegistrationDecorator());
            this.fStackCombo = new StackComboBox();
            this.fToolSet.addSupplier("stack", EditorToolSetFactory.createStackToolSupplier(this.fStackCombo));
        }
    }

    private static TSToolSet.ToolSupplier createStackToolSupplier(final StackComboBox stackComboBox) {
        return new TSToolSet.ToolSupplier(){

            public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
                Dimension dimension = stackComboBox.getPreferredSize();
                dimension.width = 150;
                stackComboBox.setPreferredSize(dimension);
                if (PlafUtils.isWindowsLookAndFeel()) {
                    stackComboBox.setUI((ComboBoxUI)new MWindowsComboBoxUI(){

                        protected ComboPopup createPopup() {
                            return new MWindowsComboBoxUI.WindowsMBasicComboPopup(this.comboBox){

                                protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
                                    if (this.comboBox instanceof MJComboBox && !((MJComboBox)this.comboBox).isPopupWidthConstrained() && this.comboBox.getUI() != null) {
                                        n3 = Math.max(this.comboBox.getUI().getPreferredSize((JComponent)this.comboBox).width, n3);
                                    }
                                    return super.computePopupBounds(n, n2, n3, n4);
                                }
                            };
                        }
                    });
                }
                return stackComboBox;
            }
        };
    }

    static TSToolSet.ToolDecorator createToolTipRegistrationDecorator() {
        return new TSToolSet.ToolDecorator(){

            public void decorateTool(final JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                ToolTipManager.sharedInstance().registerComponent(jComponent);
                jComponent.putClientProperty("disposable", new Disposable(){

                    public void dispose() {
                        ToolTipManager.sharedInstance().unregisterComponent(jComponent);
                    }
                });
            }
        };
    }

    private TSToolSet.ToolDecorator createDisableForNonFilesDecorator() {
        return new TSToolSet.ToolDecorator(){

            public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                EditorToolSetFactory.disableActionForNonFiles(jComponent, EditorToolSetFactory.this.fEditor);
            }
        };
    }

    public RunMenu.RunButtonStateChangeListener getRunStateChangeListener() {
        return new RunMenu.RunButtonStateChangeListener(){

            @Override
            public void runButtonStateChanged() {
                EditorToolSetFactory.this.getToolSet().getAction("run").putValue("buttonIcon", EditorToolSetFactory.this.fRunMenu.getRunIcon());
            }
        };
    }

    private static void disableActionForNonFiles(JComponent jComponent, Editor editor) {
        jComponent.setEnabled(StorageLocationUtils.isOrWillBeBackedByFile((StorageLocation)editor.getStorageLocation()));
    }

    private void populateNavigateSection() {
        this.fToolSet.configureAndAdd("find", (Action)new ChildAction((Action)this.fActionManager.getAction(EditorAction.FIND)));
        this.fToolSet.configureAndAdd("default_find", (Action)new ChildAction((Action)this.fActionManager.getAction(EditorAction.FIND)));
        this.fToolSet.configureAndAdd("find_next", (Action)new ChildAction((Action)this.fActionManager.getAction(EditorAction.FIND_AGAIN)));
        this.fToolSet.configureAndAdd("find_previous", (Action)new ChildAction((Action)this.fActionManager.getAction(EditorAction.FIND_AGAIN_BACK)));
        this.fToolSet.configureAndAdd("find_selection", (Action)new ChildAction((Action)this.fActionManager.getAction(EditorAction.FIND_SELECTION)));
        this.fToolSet.configureAndAdd("back", (Action)new ChildAction((Action)this.fActionManager.getAction(ActionID.PREVIOUS_LOCATION)));
        this.fToolSet.configureAndAdd("forward", (Action)new ChildAction((Action)this.fActionManager.getAction(ActionID.NEXT_LOCATION)));
        new GoToMenu(this.fEditor, this.fToolSet, this.fActionManager).populate();
    }

    private void populateEditSection() {
        this.fToolSet.configureAndAdd("comment", (Action)new ChildAction((Action)this.fActionManager.getAction(ActionID.COMMENT)));
        this.fToolSet.configureAndAdd("uncomment", (Action)new ChildAction((Action)this.fActionManager.getAction(ActionID.UNCOMMENT)));
        this.fToolSet.configureAndAdd("wrap_comments", (Action)new ChildAction((Action)this.fActionManager.getAction(ActionID.MERGE_COMMENTS)));
        this.fToolSet.configureAndAdd("increase_indent", (Action)new ChildAction((Action)this.fActionManager.getAction(ActionID.INDENT)));
        this.fToolSet.configureAndAdd("decrease_indent", (Action)new ChildAction((Action)this.fActionManager.getAction(ActionID.UNINDENT)));
        this.fToolSet.configureAndAdd("smart_indent", (Action)new ChildAction((Action)this.fActionManager.getAction(ActionID.SMART_INDENT)));
        this.fToolSet.configureAndAdd("to_uppercase", (Action)new ChildAction((Action)this.fActionManager.getAction(ActionID.TO_UPPERCASE)));
        this.fToolSet.configureAndAdd("to_lowercase", (Action)new ChildAction((Action)this.fActionManager.getAction(ActionID.TO_LOWERCASE)));
        this.fToolSet.configureAndAdd("function", (Action)new ChildAction((Action)this.fActionManager.getAction(EditorAction.FUNCTION_BROWSER)));
        TSToolSet.ToolDecorator toolDecorator = new TSToolSet.ToolDecorator(){

            public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                ((JLabel)jComponent).setIcon((Icon)new IconSet(new Icon[]{new EmptyIcon(21, 1)}));
            }
        };
        this.fToolSet.addDecorator("insert_label", toolDecorator);
        this.fToolSet.addDecorator("comment_label", toolDecorator);
        this.fToolSet.addDecorator("indent_label", toolDecorator);
        if (this.fEditor.isMCode()) {
            CodepadActionManager codepadActionManager = CodepadActionManager.getCodepadActionManager(this.fEditor);
            this.fToolSet.configureAndAdd("new_cell", (Action)new ChildAction(codepadActionManager.getAddDividerAction()));
        } else {
            MJAbstractAction mJAbstractAction = new MJAbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            };
            mJAbstractAction.setEnabled(false);
            this.fToolSet.configureAndAdd("new_cell", (Action)mJAbstractAction);
        }
    }

    private void populateBreakpointsSection() {
        if (this.fEditor.isMCode()) {
            this.fToolSet.configureAndAdd("set_clear_breakpoint", (Action)new ChildAction((Action)MatlabDebugActions.createSetClearBreakpointAction(this.fEditor)));
            this.fToolSet.configureAndAdd("enable_disable_breakpoint", (Action)new ChildAction((Action)MatlabDebugActions.createEnableDisableBreakpointAction(this.fEditor)));
            this.fToolSet.configureAndAdd("set_conditional_breakpoint", (Action)new ChildAction((Action)MatlabDebugActions.createSetConditionalBreakpointAction(this.fEditor)));
        }
        this.fToolSet.configureAndAdd("error_handling_options", (Action)new ChildAction(DebugActions.getSetErrorBkptsAction()));
        this.configureStopIfOptions();
    }

    private void configureStopIfOptions() {
        this.fStopIfErrorAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MatlabDebugServices.MatlabStopIf matlabStopIf = new MatlabDebugServices.MatlabStopIf();
                matlabStopIf.setStopIfError(this.isSelected() ? 1 : 0, null);
                matlabStopIf.sendToMATLAB();
            }
        };
        this.fToolSet.configureAndAdd("stop_if_error", (Action)this.fStopIfErrorAction);
        this.fStopIfWarningAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MatlabDebugServices.MatlabStopIf matlabStopIf = new MatlabDebugServices.MatlabStopIf();
                matlabStopIf.setStopIfWarning(this.isSelected() ? 1 : 0, null);
                matlabStopIf.sendToMATLAB();
            }
        };
        this.fToolSet.configureAndAdd("stop_if_warning", (Action)this.fStopIfWarningAction);
        this.fToolSet.addListDecorator("breakpoints", new TSToolSet.ListDecorator(){

            public void decorateList(PopupList popupList) {
                if (MatlabDebugServices.isInitialized()) {
                    EditorToolSetFactory.this.updateStopActions();
                    for (int i = 0; i < popupList.getModel().getSize(); ++i) {
                        ListItem listItem = (ListItem)popupList.getModel().getElementAt(i);
                        if (listItem.getName().equals("stop_if_warning")) {
                            listItem.setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)EditorToolSetFactory.this.fStopIfWarningAction.isSelected());
                            continue;
                        }
                        if (!listItem.getName().equals("stop_if_error")) continue;
                        listItem.setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)EditorToolSetFactory.this.fStopIfErrorAction.isSelected());
                    }
                }
            }
        });
    }

    private void updateStopActions() {
        this.fStopIfErrorAction.setSelected(MatlabDebugServices.getStopIfErrorState() == 1);
        this.fStopIfWarningAction.setSelected(MatlabDebugServices.getStopIfWarningState() == 1);
    }

    private void populateOpenAction() {
        this.fToolSet.configureAndAdd("open", (Action)new ChildAction((Action)this.fActionManager.getAction(EditorAction.OPEN)));
        this.fToolSet.configureAndAdd("default_open", (Action)new ChildAction((Action)this.fActionManager.getAction(EditorAction.OPEN)));
        this.fToolSet.configureAndAdd("open_as_text", (Action)new ChildAction((Action)this.fActionManager.getAction(EditorAction.OPEN_AS_TEXT)));
        this.fToolSet.addListDecorator("open", new TSToolSet.ListDecorator(){

            public void decorateList(PopupList popupList) {
                RecentFiles recentFiles = MLDesktop.getInstance().getRecentFiles();
                List list = recentFiles.getReopenActions(EditorUtils.getEditorGroupName());
                if (!list.isEmpty()) {
                    DefaultListModel defaultListModel = (DefaultListModel)popupList.getModel();
                    defaultListModel.addElement(ListItem.newHeader((String)BUNDLE.getString("Tool.recent_group.Label")));
                    TSFactory.addToPopupList((PopupList)popupList, (List)list, (ListStyle)ListStyle.SINGLE_LINE_DESCRIPTION);
                }
            }
        });
    }

    private void populateCompareActions() {
        DiffToolInfoImpl diffToolInfoImpl = new DiffToolInfoImpl(this.fEditor);
        final UnsavedChangesDiffToolAction unsavedChangesDiffToolAction = new UnsavedChangesDiffToolAction(diffToolInfoImpl);
        final DiffAgainstAutosaveAction diffAgainstAutosaveAction = new DiffAgainstAutosaveAction(diffToolInfoImpl);
        final DiffAgainstBrowseAction diffAgainstBrowseAction = new DiffAgainstBrowseAction(diffToolInfoImpl);
        final DiffAgainstBrowseAction diffAgainstBrowseAction2 = new DiffAgainstBrowseAction(diffToolInfoImpl);
        this.fToolSet.configureAndAdd("compare", (Action)diffAgainstBrowseAction2.getAction());
        this.fToolSet.configureAndAdd("compare_disk", (Action)unsavedChangesDiffToolAction.getAction());
        this.fToolSet.configureAndAdd("compare_autosave", (Action)diffAgainstAutosaveAction.getAction());
        this.fToolSet.configureAndAdd("compare_browse", (Action)diffAgainstBrowseAction.getAction());
        this.fCompareActionEditorEventListener = new EditorEventListener(){

            public void eventOccurred(EditorEvent editorEvent) {
                if (editorEvent == EditorEvent.DIRTY_STATE_CHANGED || editorEvent == EditorEvent.AUTOSAVED || editorEvent == EditorEvent.AUTOSAVE_OPTIONS_CHANGED) {
                    unsavedChangesDiffToolAction.updateActionStatus();
                    diffAgainstAutosaveAction.updateActionStatus();
                    diffAgainstBrowseAction.updateActionStatus();
                    diffAgainstBrowseAction2.updateActionStatus();
                }
            }
        };
        this.fEditor.addEventListener(this.fCompareActionEditorEventListener);
    }

    private void populateSourceControl() {
        final MJMenu mJMenu = this.getSourceControlMenu();
        if (mJMenu != null && mJMenu.isEnabled()) {
            this.fToolSet.addSupplier("source_control", new TSToolSet.ToolSupplier(){

                public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
                    TSDropDownButton tSDropDownButton = new TSDropDownButton(BUNDLE.getString("Tool.source_control.Label"), (Icon)ProvisionalIcon.SOURCE_CONTROL.getIcon());
                    tSDropDownButton.setToolTipText(BUNDLE.getString("Tool.source_control.Description"));
                    tSDropDownButton.setPopupListener(new PopupListener(){

                        public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                            popupCallback.show((JComponent)mJMenu.getPopupMenu());
                        }
                    });
                    return tSDropDownButton;
                }
            });
        }
    }

    private MJMenu getSourceControlMenu() {
        return this.fEditor.getStorageLocation() instanceof FileStorageLocation ? MWSccManager.getSccMenu((SccFileProvider)EditorUtils.getSccFileProvider(), (String)((FileStorageLocation)this.fEditor.getStorageLocation()).getFile().getPath()) : (this.fEditor.getStorageLocation() instanceof FutureFileStorageLocation ? MWSccManager.getSccMenu((SccFileProvider)EditorUtils.getSccFileProvider(), (String)FileUtils.absolutePathname((String)this.fEditor.getShortName())) : null);
    }

    private static TSTabConfiguration readTabConfiguration(String string) {
        try {
            return new TSTabConfiguration(SimpleDOMUtils.read((URL)EditorToolSetFactory.class.getResource("resources/" + string)));
        }
        catch (DataFormatException dataFormatException) {
            throw new RuntimeException(dataFormatException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private EditorAction.ObservableAction createGoUntilAction(final Editor editor) {
        Validate.notNull((Object)editor, (String)"'editor' cannot be null");
        final EditorAction.ObservableAction observableAction = MatlabMenuContributor.GO_UNTIL_CURSOR.getAction();
        observableAction.setObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                MatlabPluginUtils.runUntilCursor(editor);
            }
        });
        this.fGoUntilActionEditorEventListener = new EditorEventListener(){

            public void eventOccurred(EditorEvent editorEvent) {
                if (editorEvent == EditorEvent.DEBUG_MODE_CHANGED) {
                    observableAction.setEnabled(EditorStartup.getInDebugMode());
                }
            }
        };
        editor.addEventListener(this.fGoUntilActionEditorEventListener);
        observableAction.setEnabled(EditorStartup.getInDebugMode());
        MLMenuMergeTag.GO_UNTIL_CURSOR.setTag((Action)((Object)observableAction));
        return observableAction;
    }

    public static class Registrar
    implements ToolstripInfoRegistrar {
        public void registerToolstripInfo(TSRegistry tSRegistry) {
            TSTabConfiguration tSTabConfiguration = EditorToolSetFactory.readTabConfiguration("EditorTab.xml");
            tSRegistry.addTabConfiguration(tSTabConfiguration);
            TSToolSet tSToolSet = new TSToolSet(TSToolSetContents.readToolSetContents(EditorToolSetFactory.class, (String)"resources/EditorToolset.xml"));
            tSToolSet.addSupplier("stack", EditorToolSetFactory.createStackToolSupplier(new StackComboBox()));
            tSToolSet.configureAndAdd("new", (Action)new ChildAction(MLDesktop.getInstance().getNewBlankMFileAction()));
            MLToolstripFactory.populateNewEditorFileActions(tSToolSet, MLDesktop.getInstance(), "new");
            tSToolSet.configureAndAdd("open", (Action)new ChildAction((Action)((Object)EditorAction.OPEN.getAction())));
            tSToolSet.configureAndAdd("default_open", (Action)new ChildAction((Action)((Object)EditorAction.OPEN.getAction())));
            tSToolSet.configureAndAdd("open_as_text", (Action)new ChildAction((Action)((Object)EditorAction.OPEN_AS_TEXT.getAction())));
            EditorToolSetFactory.addDebugClearAllBreakpointsActions(tSToolSet);
            tSToolSet.configureAndAdd("goto", (Action)new ChildAction((Action)Registrar.createDummyDisabledAction()));
            tSRegistry.addToolSetContents(tSToolSet.getContents());
            tSRegistry.addToolSet(tSToolSet);
            Collection<EditorToolstripTabContributor> collection = EditorToolstripTabFactory.getToolstripTabContributors();
            for (EditorToolstripTabContributor editorToolstripTabContributor : collection) {
                TSTabConfiguration tSTabConfiguration2 = editorToolstripTabContributor.getTSTabConfiguration();
                tSTabConfiguration2.setContributeToName(tSTabConfiguration.getName());
                tSRegistry.addTabConfiguration(tSTabConfiguration2);
                for (TSToolSet tSToolSet2 : editorToolstripTabContributor.getSupportingToolSets()) {
                    tSRegistry.addToolSetContents(tSToolSet2.getContents());
                }
            }
        }

        private static MJAbstractAction createDummyDisabledAction() {
            return new MJAbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }

                public boolean isEnabled() {
                    return false;
                }
            };
        }
    }
}

