/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.editor.EditorGroup;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mde.editor.MatlabEditorApplication;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import org.apache.commons.lang.Validate;

public class EditorUiUtils {
    private EditorUiUtils() {
    }

    static Component getEditorGroupComponent() {
        Container container = null;
        if (EditorStartup.getParentDesktop().isGroupShowing(EditorGroup.getTitle())) {
            container = EditorStartup.getParentDesktop().getGroupContainer(EditorGroup.getTitle());
        } else if (EditorStartup.getParentDesktop().hasMainFrame()) {
            container = EditorStartup.getParentDesktop().getMainFrame();
        }
        return container;
    }

    public static Frame getParentFrame(Component component) {
        MJFrame mJFrame = MJFrame.getFrame((Component)component);
        return mJFrame == null ? MJFrame.getFrame((Component)EditorUiUtils.getEditorGroupComponent()) : mJFrame;
    }

    public static Frame getFrameToCenterDialogOn(File file) {
        Validate.notNull((Object)file, (String)"The given file cannot be null.");
        Editor editor = MatlabEditorApplication.getInstance().findEditor((StorageLocation)new FileStorageLocation(file));
        Frame frame = EditorUiUtils.getParentFrame(editor == null ? null : editor.getComponent());
        assert (frame != null) : "The frame to return should not be null.";
        return frame;
    }
}

