/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.datamodel.BackingStore;
import com.mathworks.matlab.api.datamodel.BackingStoreEventListener;
import com.mathworks.matlab.api.dataview.UiInfoProvider;
import com.mathworks.matlab.api.debug.Breakpoint;
import com.mathworks.matlab.api.debug.BreakpointMargin;
import com.mathworks.matlab.api.debug.ExecutionDisplayAdapter;
import com.mathworks.matlab.api.editor.EditorKitProvider;
import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorLayerProvider;
import com.mathworks.matlab.api.editor.actions.SelectionDelegate;
import com.mathworks.mde.editor.ActionManager;
import com.mathworks.mde.editor.DialogFactory;
import com.mathworks.mde.editor.EditorAction;
import com.mathworks.mde.editor.EditorOptions;
import com.mathworks.mde.editor.EditorPrefsPrintPanel;
import com.mathworks.mde.editor.EditorSTPMultiView;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mde.editor.EditorStateManagerFactory;
import com.mathworks.mde.editor.EditorUiUtils;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.EditorViewCallback;
import com.mathworks.mde.editor.EditorViewListener;
import com.mathworks.mde.editor.EditorViewUtils;
import com.mathworks.mde.editor.ExecutionArrowDisplay;
import com.mathworks.mde.editor.MatlabEditorApplication;
import com.mathworks.mde.editor.PopupAction;
import com.mathworks.mde.editor.SelectionAction;
import com.mathworks.mde.editor.breakpoints.DummyExecutionDisplayAdapter;
import com.mathworks.mde.editor.codepad.Codepad;
import com.mathworks.mde.editor.codepad.CodepadActionManager;
import com.mathworks.mde.editor.codepad.CodepadContainer;
import com.mathworks.mde.find.FindFiles;
import com.mathworks.mde.functionbrowser.FunctionBrowser;
import com.mathworks.mde.functionhints.FunctionHints;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.ScrollablePopupList;
import com.mathworks.mwswing.api.DirtyStateChangeListener;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.AbsoluteFile;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.SyntaxTextPaneBase;
import com.mathworks.widgets.SyntaxTextPaneMultiView;
import com.mathworks.widgets.SyntaxTextPaneUtilities;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.datamodel.TextFileBackingStore;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.editor.breakpoints.MarginProvider;
import com.mathworks.widgets.find.FindClientInterface;
import com.mathworks.widgets.find.FindClientRegistry;
import com.mathworks.widgets.find.FindDialog;
import com.mathworks.widgets.find.FindEvent;
import com.mathworks.widgets.find.FindParentListener;
import com.mathworks.widgets.find.FindPrefs;
import com.mathworks.widgets.text.EditorLanguageUtils;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.STPModelInterface;
import com.mathworks.widgets.text.STPViewInterface;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MEditorUI;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.MTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.SyncFailedException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.JumpList;

public final class EditorView
extends MJPanel {
    private final BackingStore<Document> fBackingStore;
    private final UiInfoProvider fUiInfoProvider;
    private final EditorLayerProviderDistributor fEditorLayerProviderDistributor;
    private final PropertyChangeListener fBackingDataPropertyChangeListener = this.createBackingDataPropertyChangeListener();
    private final BackingStoreEventListener<Document> fBackingStoreEventListener = this.createBackingStoreEventListener();
    private final List<DirtyStateChangeListener> fDirtyStateChangeListeners = new ArrayList<DirtyStateChangeListener>();
    private final List<EditorViewListener> fEditorViewListeners = new ArrayList<EditorViewListener>();
    private PopupMenuListener fContextMenuListener = this.createContextMenuListener();
    private final EditorViewCallback fCallback;
    private final ActionManager fActionManager;
    private MJPanel fCenterPanel;
    private EditorSTPMultiView fSyntaxPane;
    private BreakpointMargin<? extends Breakpoint> fBreakpointMargin;
    private ExecutionArrowDisplay fExecutionArrowDisplay;
    private static String sFindString = "";
    private PrefListener fPrefListener = new EditorPrefListener();
    private FindParentListener fFindListener;
    private FindDialogListener fFindDialogListener;
    private FindClientInterface fFindClient;
    private Codepad fCodepad;
    private CaretListener fCaretListener;
    private KeyListener fKeyListener;
    private boolean fRequestFocusWhenActivated;

    public EditorView(BackingStore<Document> backingStore, UiInfoProvider uiInfoProvider, EditorViewCallback editorViewCallback) throws Exception {
        this(backingStore, uiInfoProvider, editorViewCallback, new OSGiEditorLayerProviderDistributor());
    }

    public EditorView(BackingStore<Document> backingStore, UiInfoProvider uiInfoProvider, EditorViewCallback editorViewCallback, EditorLayerProviderDistributor editorLayerProviderDistributor) throws Exception {
        Validate.notNull(backingStore, (String)"BackingStore cannot be null.");
        Validate.notNull((Object)uiInfoProvider, (String)"UiInfoProvider cannot be null.");
        Validate.notNull((Object)editorViewCallback, (String)"EditorViewCallback cannot be null.");
        Validate.notNull((Object)editorLayerProviderDistributor, (String)"EditorLayerProviderDistributor cannot be null.");
        this.fBackingStore = backingStore;
        this.fUiInfoProvider = uiInfoProvider;
        this.fCallback = editorViewCallback;
        this.fEditorLayerProviderDistributor = editorLayerProviderDistributor;
        this.setName("EditorView");
        this.fActionManager = new ActionManager(this.fCallback.getCorrespondingEditor());
        this.fBackingStore.addPropertyChangeListener("backingData", this.fBackingDataPropertyChangeListener);
        this.fBackingStore.addBackingStoreEventListener(this.fBackingStoreEventListener);
        this.fUiInfoProvider.addPropertyChangeListener("shortName", this.createLongNameListener());
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.fCenterPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fCenterPanel.setOpaque(false);
        this.add((Component)this.fCenterPanel, "Center");
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.setOpaque(false);
        this.add((Component)mJPanel, "West");
        this.fCaretListener = this.createCaretListener();
        this.fKeyListener = this.createFunctionHintsKeyListener();
        this.addDirtyStateChangeListener(this.createDirtyStateChangeListener());
        this.initSyntaxTextPane();
        JumpList.checkAddEntry((JTextComponent)this.fSyntaxPane.getActiveTextComponent(), (int)this.fSyntaxPane.getCaretPosition());
        if (SyntaxTextPaneUtilities.isMCode((STPInterface)this.getSyntaxTextPane())) {
            String string = this.fUiInfoProvider.getUniqueKey();
            EditorStateManagerFactory.getEditorStateManager().loadState(string);
        }
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)this.fPrefListener);
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)this.fPrefListener);
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorEnableDataTips");
        this.createActionObservers();
        this.fFindClient = this.createFindClient();
    }

    private List<MarginProvider> getApplicableMarginProviders() {
        Collection collection = ClasspathOSGiManager.getInstance().getImplementors(MarginProvider.class);
        ArrayList<MarginProvider> arrayList = new ArrayList<MarginProvider>();
        for (MarginProvider marginProvider : collection) {
            if (!marginProvider.isApplicable(this.fCallback.getCorrespondingEditor())) continue;
            arrayList.add(marginProvider);
        }
        Validate.isTrue((arrayList.size() <= 1 ? 1 : 0) != 0, (String)"There should only be at most one applicable Margin");
        return arrayList;
    }

    private void maybeShowBreakpointAlley(List<MarginProvider> list) {
        if (!list.isEmpty()) {
            this.fBreakpointMargin = list.get(0).buildMargin(this.fCallback.getCorrespondingEditor(), (SyntaxTextPaneMultiView)this.fSyntaxPane);
            this.validate();
        }
    }

    boolean negotiateSave() {
        boolean bl = false;
        if (!this.isBuffer() && !this.isDirty()) {
            bl = true;
        } else {
            try {
                EditorViewUtils.addEndOfFileNewLineIfNecessary((STPInterface)this.fSyntaxPane);
                bl = this.fBackingStore.negotiateSave((Object)this.fSyntaxPane.getDocument(), (Component)((Object)this));
            }
            catch (Exception exception) {
                this.showWritingError(exception, "error.writing", "error.writingGeneric");
            }
        }
        return bl;
    }

    private void showWritingError(Exception exception, String string, String string2) {
        String string3;
        String string4 = string3 = exception instanceof SyncFailedException ? EditorUtils.lookup("error.writing.SyncFailedException") : exception.getLocalizedMessage();
        if (string3 != null && string3.length() > 0) {
            this.doShowError(MessageFormat.format(EditorUtils.lookup(string), this.fUiInfoProvider.getShortName(), string3));
        } else {
            this.doShowError(MessageFormat.format(EditorUtils.lookup(string2), this.fUiInfoProvider.getShortName()));
        }
    }

    void save() throws Exception {
        EditorViewUtils.addEndOfFileNewLineIfNecessary((STPInterface)this.fSyntaxPane);
        this.fBackingStore.save((Object)this.fSyntaxPane.getDocument());
    }

    private boolean negotiateSaveAs() {
        boolean bl = false;
        try {
            EditorViewUtils.addEndOfFileNewLineIfNecessary((STPInterface)this.fSyntaxPane);
            bl = this.fBackingStore.negotiateSaveAs((Object)this.fSyntaxPane.getDocument(), (Component)((Object)this));
        }
        catch (Exception exception) {
            this.showWritingError(exception, "error.writing", "error.writingGeneric");
        }
        return bl;
    }

    void saveAs(String string) throws Exception {
        Validate.isTrue((boolean)(this.fBackingStore instanceof TextFileBackingStore), (String)EditorUtils.lookup("error.saveAs.backingStore"));
        Validate.isTrue((boolean)new File(string).isAbsolute(), (String)EditorUtils.lookup("error.saveAs.relativeFilename"));
        EditorViewUtils.addEndOfFileNewLineIfNecessary((STPInterface)this.fSyntaxPane);
        ((TextFileBackingStore)this.fBackingStore).doSaveAs(this.fSyntaxPane.getDocument(), new File(FileUtils.normalizePathname((String)string)));
    }

    private void negotiateBackup() {
        try {
            this.fBackingStore.negotiateBackup((Object)this.fSyntaxPane.getDocument(), (Component)((Object)this));
        }
        catch (Exception exception) {
            this.showWritingError(exception, "error.writingBackup", "error.writingBackupGeneric");
        }
    }

    void reload(boolean bl) {
        String string = this.fSyntaxPane.getText();
        try {
            this.setContents("");
            this.fBackingStore.load((Object)this.getSyntaxTextPane().getDocument());
            this.fSyntaxPane.getUndoManager().discardAllEdits();
            this.fSyntaxPane.setUndoCleanMarker();
        }
        catch (Exception exception) {
            this.setContents(string);
            this.markAsDifferentFromSource();
            if (bl) {
                this.doShowError(MessageFormat.format(EditorUtils.lookup("error.reloading"), this.fUiInfoProvider.getShortName()));
            }
            throw new RuntimeException(exception);
        }
    }

    public void promptToReloadIfNecessary() {
        if (this.getBackingStore().isPersistenceLocationSet() && this.getBackingStore().isOutOfSync()) {
            if (!this.isDirty() && EditorOptions.isAutoReloadFilesFromDisc()) {
                this.reload(true);
            } else if (DialogFactory.getEditorDialogProvider().showReload(EditorUiUtils.getParentFrame((Component)((Object)this)), this.getUiInfoProvider().getShortName()) == 0) {
                this.reload(true);
            } else {
                this.markAsDifferentFromSource();
            }
        }
    }

    void markAsDifferentFromSource() {
        this.getSyntaxTextPane().setUndoDirtyMarker();
        this.getBackingStore().sync();
    }

    public boolean isBuffer() {
        return !this.getBackingStore().isPersistenceLocationSet();
    }

    public boolean isOrWillBeBackedByFile() {
        return !this.getBackingStore().isPersistenceLocationSet() || this.isBackedByFile();
    }

    public boolean isBackedByFile() {
        return this.getBackingStore().getStorageLocation() instanceof FileStorageLocation;
    }

    public AbsoluteFile getBackingFile() {
        if (!this.isBackedByFile()) {
            throw new IllegalStateException("This EditorView is not backed by a File.");
        }
        return new AbsoluteFile(((FileStorageLocation)this.getBackingStore().getStorageLocation()).getFile());
    }

    private void doBackingDataChanged() {
        String string;
        boolean bl;
        String string2;
        boolean bl2 = false;
        if (this.isOrWillBeBackedByFile()) {
            string2 = this.getSyntaxTextPane().getFilename();
            this.updateFilenameProperty();
            boolean bl3 = bl2 = string2 == null || !string2.equals(this.getSyntaxTextPane().getFilename());
            if (bl2 && this.isBackedByFile()) {
                EditorUtils.getMatlab().callRehashToolboxIfToolboxFile(this.getBackingFile().toFile());
            }
        }
        boolean bl4 = bl = !(string2 = this.getSyntaxTextPane().getContentType()).equals(string = this.getBackingStore().getPreferredContentType(string2));
        if (bl) {
            try {
                this.initSyntaxTextPane();
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
        } else {
            this.setInitialCommandStates();
        }
        if (bl || bl2) {
            this.fireLanguageOrFilenameChanged();
        }
        if (!bl) {
            this.disposeBreakpointAlley();
            List<MarginProvider> list = this.getApplicableMarginProviders();
            this.maybeShowBreakpointAlley(list);
            this.fExecutionArrowDisplay.cleanAllExecutionDisplayAdapterDecorations();
            this.fExecutionArrowDisplay.addExecutionDisplayAdapter(this.resolveDebugExecutionAdaptor(list));
        }
        this.updateEditorState();
    }

    private void doBackingStoreSaved() {
        if (SyntaxTextPaneUtilities.isMCode((STPInterface)this.getSyntaxTextPane()) && this.isBackedByFile()) {
            EditorUtils.getMatlab().callFSChange(this.getBackingFile().getPath());
            EditorUtils.getMatlab().callClear(this.getBackingFile().toFile());
        }
        this.getSyntaxTextPane().setUndoCleanMarker();
    }

    private void doBackingStoreLoaded() {
        if (SyntaxTextPaneUtilities.isMCode((STPInterface)this.getSyntaxTextPane()) && this.isBackedByFile() && EditorUtils.isMatlabAvailable()) {
            EditorUtils.getMatlab().callFSChange(this.getBackingFile().getPath());
        }
    }

    private void doDirtyStateChanged(boolean bl) {
        this.getActionManager().updateDirtyDependentActions(bl);
    }

    private PropertyChangeListener createBackingDataPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EditorView.this.doBackingDataChanged();
            }
        };
    }

    private BackingStoreEventListener<Document> createBackingStoreEventListener() {
        return new BackingStoreEventListener<Document>(){

            public void backingStoreSaved(BackingStore<Document> backingStore) {
                EditorView.this.doBackingStoreSaved();
            }

            public void backingStoreLoaded(BackingStore<Document> backingStore) {
                EditorView.this.doBackingStoreLoaded();
            }
        };
    }

    private DirtyStateChangeListener createDirtyStateChangeListener() {
        return new DirtyStateChangeListener(){

            public void dirtyStateChanged(boolean bl) {
                EditorView.this.doDirtyStateChanged(bl);
            }
        };
    }

    private PropertyChangeListener createLongNameListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EditorView.this.doUpdateAccessibleName();
            }
        };
    }

    private void doUpdateAccessibleName() {
        if (this.fSyntaxPane != null) {
            String string = EditorUtils.getEditorGroupTitle() + " - " + this.fUiInfoProvider.getLongName();
            this.fSyntaxPane.setAccessibleName(string);
        }
    }

    private void doCopyFilePathToClipboard() {
        MJClipboard.getMJClipboard().setContents(this.getBackingFile().getPath(), null);
    }

    private CaretListener createCaretListener() {
        return new CaretListener(){
            private boolean iHasSelection;
            private boolean iInitialize = true;

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                Matlab.LMKeepAlive();
                if (!EditorView.this.fSyntaxPane.isSelectionEmpty() != this.iHasSelection || this.iInitialize) {
                    this.iInitialize = false;
                    this.iHasSelection = !EditorView.this.fSyntaxPane.isSelectionEmpty();
                    EditorView.this.enableSelectionDependentCommands(this.iHasSelection);
                }
            }
        };
    }

    private void manageFunctionHintVisibility() {
        if (Prefs.getBooleanPref((String)"EditorFunctionHints", (boolean)true)) {
            try {
                int n = this.fSyntaxPane.getCaretPosition();
                String string = MDocumentUtils.getStatementUpToPosition((BaseDocument)((BaseDocument)this.fSyntaxPane.getDocument()), (int)n);
                FunctionHints.openFunctionHints(this.fSyntaxPane.getActiveTextComponent(), string);
            }
            catch (BadLocationException badLocationException) {
                FunctionHints.hidePopup();
                Log.logException((Exception)badLocationException);
            }
        }
    }

    private void openFunctionHintsSynchronously() {
        try {
            int n = this.fSyntaxPane.getCaretPosition();
            String string = MDocumentUtils.getStatementUpToPosition((BaseDocument)((BaseDocument)this.fSyntaxPane.getDocument()), (int)n);
            FunctionHints.openFunctionHintsSynchronously(this.fSyntaxPane.getActiveTextComponent(), string);
        }
        catch (BadLocationException badLocationException) {
            FunctionHints.hidePopup();
            Log.logException((Exception)badLocationException);
        }
    }

    private KeyListener createFunctionHintsKeyListener() {
        return new SyntaxTextPaneBase.PostKeyListener(){

            public void postKeyTyped(KeyEvent keyEvent) {
                if (EditorView.this.getSyntaxTextPane() != null && SyntaxTextPaneUtilities.isMCode((STPInterface)EditorView.this.getSyntaxTextPane()) && keyEvent.getID() == 400 && (FunctionHints.isTrigger(keyEvent.getKeyChar()) || FunctionHints.isOpenOrOpening())) {
                    EditorView.this.manageFunctionHintVisibility();
                }
            }

            public void postKeyPressed(KeyEvent keyEvent) {
                if (EditorView.this.getSyntaxTextPane() != null && SyntaxTextPaneUtilities.isMCode((STPInterface)EditorView.this.getSyntaxTextPane()) && FunctionHints.isOpenOrOpening()) {
                    if (FunctionHints.isNavigation(keyEvent.getKeyCode())) {
                        EditorView.this.manageFunctionHintVisibility();
                    } else if (FunctionHints.isAction(keyEvent.getKeyCode())) {
                        FunctionHints.hidePopup();
                    }
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        };
    }

    private FindClientInterface createFindClient() {
        return new FindClientInterface(){

            public void addFindParentListener(FindParentListener findParentListener) {
                EditorView.this.fFindListener = findParentListener;
                Window window = findParentListener.getWindow();
                if (EditorView.this.fFindDialogListener == null) {
                    EditorView.this.fFindDialogListener = new FindDialogListener();
                }
                window.addWindowListener(EditorView.this.fFindDialogListener);
                if (window.isActive()) {
                    EditorView.this.fFindDialogListener.windowActivated(null);
                }
            }

            public void removeFindParentListener(FindParentListener findParentListener) {
                Window window = findParentListener.getWindow();
                if (window != null && EditorView.this.fFindDialogListener != null) {
                    window.removeWindowListener(EditorView.this.fFindDialogListener);
                    EditorView.this.fFindDialogListener.windowDeactivated(null);
                    EditorView.this.fCallback.setStatusText("");
                }
                EditorView.this.fFindListener = null;
            }

            public void findForward(FindEvent findEvent) {
                sFindString = findEvent.getFindString();
                EditorView.this.doFindAgain(false);
                EditorView.enableFindAgain();
            }

            public void findBack(FindEvent findEvent) {
                sFindString = findEvent.getFindString();
                EditorView.this.doFindAgain(true);
                EditorView.enableFindAgain();
            }

            public void replace(FindEvent findEvent) {
                EditorView.this.doReplace(findEvent);
            }

            public void replaceAll(FindEvent findEvent) {
                EditorView.replaceAllRequested(findEvent);
            }

            public Component getInvoker() {
                return EditorView.this;
            }

            public void bringForward() {
                EditorView.this.bringForward();
            }
        };
    }

    private void doShowError(String string) {
        DialogFactory.showErrorMessage(EditorUiUtils.getParentFrame((Component)((Object)this)), string);
    }

    private void initSyntaxTextPane() throws Exception {
        EditorSTPMultiView editorSTPMultiView = this.fSyntaxPane;
        this.fSyntaxPane = new EditorSTPMultiView();
        EditorKitProvider editorKitProvider = EditorView.getApplicableEditorKitProvider(this.fBackingStore);
        if (editorKitProvider != null) {
            this.fSyntaxPane.getPrimarySTP().registerEditorKit(editorKitProvider.getType(), editorKitProvider.getEditorKit(this.fBackingStore));
        }
        this.fSyntaxPane.getContextMenu().removeAll();
        this.doUpdateAccessibleName();
        this.fSyntaxPane.setPreferenceKeyProvider(this.createPreferenceKeyProvider());
        this.updateFilenameProperty();
        this.fSyntaxPane.setContentType(this.getBackingStore().getPreferredContentType(MLanguage.INSTANCE.getMimeType()));
        this.updateCorrespondingEditorLanguage();
        if (this.fSyntaxPane.getEditorUI() instanceof MEditorUI) {
            MEditorUI mEditorUI = (MEditorUI)this.fSyntaxPane.getEditorUI();
            for (EditorLayerProvider editorLayerProvider : this.fEditorLayerProviderDistributor.getProviders()) {
                if (!editorLayerProvider.requiresEditor()) continue;
                mEditorUI.addAndBuildLayerForEditor(editorLayerProvider.createEditorLayer(), this.fCallback.getCorrespondingEditor());
            }
        }
        int n = -1;
        Object object = null;
        double d = -1.0;
        int n2 = 0;
        if (editorSTPMultiView != null) {
            if (editorSTPMultiView.getSplitScreenMode() != 0) {
                d = editorSTPMultiView.getSplitLoction();
                n2 = editorSTPMultiView.getSplitScreenMode();
            }
            n = editorSTPMultiView.getSelectionDot();
            object = editorSTPMultiView.isDirty() ? editorSTPMultiView.getText() : null;
            this.disposeSyntaxTextPane(editorSTPMultiView);
        }
        if (this.getBackingStore().isPersistenceLocationSet()) {
            this.reload(true);
            if (object != null && !((String)object).equals(this.fSyntaxPane.getText())) {
                this.fSyntaxPane.replace(0, this.fSyntaxPane.getLength(), (String)object);
            }
            this.fSyntaxPane.setCaretPosition(0);
        }
        Component component = this.fSyntaxPane.getDisplayComponent();
        for (DirtyStateChangeListener dirtyStateChangeListener : this.fDirtyStateChangeListeners) {
            this.fSyntaxPane.getUndoManager().addDirtyStateChangeListener(dirtyStateChangeListener);
        }
        this.fSyntaxPane.setUndoManagerLimit(200);
        this.fActionManager.createSyntaxTextPaneActions(this.fSyntaxPane);
        List<MarginProvider> list = this.getApplicableMarginProviders();
        this.maybeShowBreakpointAlley(list);
        this.initExecutionArrowAndBookmarkAlley(list);
        boolean bl = SyntaxTextPaneUtilities.isMCode((STPInterface)this.fSyntaxPane);
        this.enableBookmarkDependentCommands();
        if (bl) {
            this.createCodepad();
        }
        this.fSyntaxPane.getContextMenu().addPopupMenuListener(this.fContextMenuListener);
        this.setInitialCommandStates();
        this.fSyntaxPane.addCaretListener(this.fCaretListener);
        this.fSyntaxPane.addKeyListener(this.fKeyListener);
        this.fCenterPanel.add(component, (Object)"Center");
        this.fCenterPanel.revalidate();
        if (d >= 0.0 && n2 != 0) {
            this.fSyntaxPane.setSplitLocation(n2, d);
        }
        if (editorSTPMultiView != null && n <= this.fSyntaxPane.getLength()) {
            final int n3 = n;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (EditorView.this.fSyntaxPane != null) {
                        if (EditorStartup.getParentDesktop().isClientSelected(EditorView.this.fCallback.getDesktopClient())) {
                            EditorView.this.requestFocus();
                        } else {
                            EditorView.this.fRequestFocusWhenActivated = true;
                        }
                        EditorView.this.fSyntaxPane.select(n3, n3);
                    }
                }
            });
        }
    }

    public static EditorKitProvider getApplicableEditorKitProvider(BackingStore<?> backingStore) {
        Collection collection = ClasspathOSGiManager.getInstance().getImplementors(EditorKitProvider.class);
        ArrayList<EditorKitProvider> arrayList = new ArrayList<EditorKitProvider>();
        for (EditorKitProvider editorKitProvider : collection) {
            if (!editorKitProvider.isApplicable(backingStore)) continue;
            arrayList.add(editorKitProvider);
        }
        assert (arrayList.size() <= 1) : "There should be exactly one applicable EditorKitProvider";
        return arrayList.isEmpty() ? null : (EditorKitProvider)arrayList.get(0);
    }

    private SyntaxTextPane.UniqueKeyProvider createPreferenceKeyProvider() {
        return new SyntaxTextPane.UniqueKeyProvider(){

            public String provideUniqueKey() {
                return EditorView.this.fUiInfoProvider.getUniqueKey();
            }
        };
    }

    private void updateFilenameProperty() {
        if (this.isOrWillBeBackedByFile()) {
            this.getSyntaxTextPane().setFilename(this.isBackedByFile() ? this.getBackingFile().getPath() : null);
        }
    }

    private PopupMenuListener createContextMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                EditorView.this.fActionManager.contributeToContextMenu(EditorView.this.fSyntaxPane.getContextMenu());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                EditorView.this.fSyntaxPane.getContextMenu().removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        };
    }

    private void createActionObservers() {
        Observer observer = new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                ActionEvent actionEvent = (ActionEvent)object;
                int n = actionEvent.getID();
                if (n == EditorAction.FIND_SELECTION.getId()) {
                    EditorView.this.doFindSel(false);
                } else if (n == EditorAction.FIND_SELECTION_BACK.getId()) {
                    EditorView.this.doFindSel(true);
                } else if (n == EditorAction.GOTO.getId()) {
                    EditorViewUtils.showGotoDialog(EditorView.this.fCallback.getCorrespondingEditor(), EditorView.this.fCodepad);
                } else if (n == EditorAction.EVALUATE_SELECTION.getId()) {
                    new SelectionAction(SelectionDelegate.ActionType.EVALUATE).doAction(EditorView.this.fCallback.getCorrespondingEditor());
                } else if (n == EditorAction.OPEN_SELECTION.getId()) {
                    new SelectionAction(SelectionDelegate.ActionType.OPEN).doAction(EditorView.this.fCallback.getCorrespondingEditor());
                } else if (n == EditorAction.PRINT_SELECTION.getId()) {
                    EditorView.this.doPrint(EditorView.this.fSyntaxPane.getSelectionStart(), EditorView.this.fSyntaxPane.getSelectionEnd());
                } else if (n == EditorAction.HELP_ON_SELECTION.getId()) {
                    new SelectionAction(SelectionDelegate.ActionType.HELP).doAction(EditorView.this.fCallback.getCorrespondingEditor());
                } else if (n == EditorAction.FUNCTION_MENU.getId()) {
                    EditorView.this.doFunctionMenu((Component)actionEvent.getSource());
                } else if (n == EditorAction.TOGGLE_BOOKMARK.getId()) {
                    EditorView.this.doToggleBookmark();
                } else if (n == EditorAction.NEXT_BOOKMARK.getId()) {
                    EditorView.this.doNextBookmark();
                } else if (n == EditorAction.PREVIOUS_BOOKMARK.getId()) {
                    EditorView.this.doPrevBookmark();
                } else if (n == EditorAction.PRINT.getId()) {
                    EditorView.this.doPrint(0, EditorView.this.fSyntaxPane.getLength());
                } else if (n == EditorAction.PAGE_SETUP.getId()) {
                    EditorView.this.doPageSetup();
                } else if (n == EditorAction.SAVE.getId()) {
                    EditorView.this.negotiateSave();
                } else if (n == EditorAction.SAVE_AS.getId()) {
                    EditorView.this.negotiateSaveAs();
                } else if (n == EditorAction.SAVE_BACKUP.getId()) {
                    EditorView.this.negotiateBackup();
                } else if (n == EditorAction.FUNCTION_BROWSER.getId()) {
                    EditorView.this.doFunctionBrowser(actionEvent);
                } else if (n == EditorAction.FUNCTION_HINTS.getId()) {
                    EditorView.this.openFunctionHintsSynchronously();
                } else if (n == EditorAction.COPY_FULL_PATH.getId()) {
                    EditorView.this.doCopyFilePathToClipboard();
                }
            }
        };
        this.fActionManager.setFindSelObserver(observer);
        this.fActionManager.setFindSelBackObserver(observer);
        this.fActionManager.setGotoObserver(observer);
        this.fActionManager.setEvalSelObserver(observer);
        this.fActionManager.setOpenSelObserver(observer);
        this.fActionManager.setPrintSelObserver(observer);
        this.fActionManager.setHelpSelObserver(observer);
        this.fActionManager.setToggleBookmarkObserver(observer);
        this.fActionManager.setNextBookmarkObserver(observer);
        this.fActionManager.setPrevBookmarkObserver(observer);
        this.fActionManager.setFunctionMenuObserver(observer);
        this.fActionManager.setPrintObserver(observer);
        this.fActionManager.setPageSetupObserver(observer);
        this.fActionManager.setSaveObserver(observer);
        this.fActionManager.setSaveAsObserver(observer);
        this.fActionManager.setSaveBackupObserver(observer);
        this.fActionManager.setFunctionBrowserObserver(observer);
        this.fActionManager.setFunctionHintsObserver(observer);
        this.fActionManager.setCopyFullPathObserver(observer);
    }

    boolean isDirty() {
        return this.getSyntaxTextPane().isDirty();
    }

    private CodepadActionManager getCodepadActionManager() {
        return this.fActionManager.getCodepadActionManager();
    }

    public ActionManager getActionManager() {
        return this.fActionManager;
    }

    void setIsDockedInDesktop(boolean bl) {
        if (this.fFindListener != null) {
            if (bl) {
                this.fFindListener.docked(this.fFindClient);
            } else {
                this.fFindListener.undocked(this.fFindClient);
            }
        }
    }

    private void createCodepad() {
        CodepadContainer codepadContainer = new CodepadContainer(){

            @Override
            public JComponent getComponent() {
                return EditorView.this;
            }

            @Override
            public STPInterface getSyntaxTextPane() {
                return EditorView.this.getSyntaxTextPane();
            }

            @Override
            public Codepad getCodepad() {
                return EditorView.this.fCodepad;
            }

            @Override
            public void goToLine(int n) {
                EditorViewUtils.goToLine(this.getSyntaxTextPane(), n);
            }

            @Override
            public void setStatusText(String string) {
                EditorView.this.fCallback.setStatusText(string);
            }
        };
        this.fCodepad = new Codepad((STPInterface)this.fSyntaxPane, this.fActionManager.getCodepadActionManager(), codepadContainer);
        this.fCallback.getCorrespondingEditor().putProperty("Codepad", (Object)this.fCodepad);
    }

    void saveAndCleanupEditorState() {
        if (SyntaxTextPaneUtilities.isMCode((STPInterface)this.getSyntaxTextPane()) && !this.isBuffer()) {
            EditorStateManagerFactory.getEditorStateManager().saveState((STPInterface)this.fSyntaxPane);
            EditorStateManagerFactory.getEditorStateManager().cleanup((STPInterface)this.fSyntaxPane);
        }
    }

    void updateEditorState() {
        if (SyntaxTextPaneUtilities.isMCode((STPInterface)this.getSyntaxTextPane()) && !this.isBuffer()) {
            EditorStateManagerFactory.getEditorStateManager().updateState((STPInterface)this.fSyntaxPane);
        }
    }

    public void dispose() {
        Prefs.removeListener((PrefListener)this.fPrefListener);
        ColorPrefs.removeColorListener((String)"ColorsBackground", (PrefListener)this.fPrefListener);
        ColorPrefs.removeColorListener((String)"ColorsText", (PrefListener)this.fPrefListener);
        this.fBackingStore.removeBackingStoreEventListener(this.fBackingStoreEventListener);
        this.fBackingStore.removePropertyChangeListener(this.fBackingDataPropertyChangeListener);
        this.removeFindListener();
        this.fActionManager.cleanup();
        this.disposeSyntaxTextPane(this.fSyntaxPane);
        this.fPrefListener = null;
        this.fSyntaxPane = null;
        this.fKeyListener = null;
        this.fCaretListener = null;
        this.fFindClient = null;
    }

    private void disposeSyntaxTextPane(SyntaxTextPaneMultiView syntaxTextPaneMultiView) {
        this.fSyntaxPane.getContextMenu().removePopupMenuListener(this.fContextMenuListener);
        this.disposeBreakpointAlley();
        if (this.fCodepad != null) {
            this.fCodepad.cleanup();
            this.fCodepad = null;
        }
        this.fExecutionArrowDisplay.dispose();
        this.fExecutionArrowDisplay = null;
        syntaxTextPaneMultiView.removeCaretListener(this.fCaretListener);
        syntaxTextPaneMultiView.removeKeyListener(this.fKeyListener);
        for (DirtyStateChangeListener dirtyStateChangeListener : this.fDirtyStateChangeListeners) {
            syntaxTextPaneMultiView.getUndoManager().removeDirtyStateChangeListener(dirtyStateChangeListener);
        }
        this.fCenterPanel.remove(syntaxTextPaneMultiView.getDisplayComponent());
        syntaxTextPaneMultiView.cleanup();
    }

    private void removeFindListener() {
        if (this.fFindListener != null) {
            this.fFindListener.closing(this.fFindClient);
        }
        if (MatlabEditorApplication.getInstance().getOpenEditors().isEmpty()) {
            FindClientRegistry.unregister((String)"EditorView");
        }
    }

    public void requestFocus() {
        if (this.fSyntaxPane != null && this.isShowing()) {
            this.fSyntaxPane.requestFocus();
        }
    }

    public STPInterface getSyntaxTextPane() {
        return this.fSyntaxPane;
    }

    public boolean isShowingBreakpointMargin() {
        return this.fBreakpointMargin != null && this.fBreakpointMargin.isActive();
    }

    private void setInitialCommandStates() {
        EditorView.enableFindAgain();
        this.enableSelectionDependentCommands(false);
        this.enableBookmarkDependentCommands();
        this.fActionManager.getCodepadActionManager().enableCodepadMFileActions(Codepad.isCodepadEnabled(), SyntaxTextPaneUtilities.isMCode((STPInterface)this.getSyntaxTextPane()), !this.fSyntaxPane.isSelectionEmpty(), Codepad.atNumericValue((STPInterface)this.fSyntaxPane));
    }

    private boolean hasBookmarks() {
        return this.fExecutionArrowDisplay != null && !this.fExecutionArrowDisplay.getBookmarks().isEmpty();
    }

    private void enableBookmarkDependentCommands() {
        this.fActionManager.enableBookmarkDependentCommands(this.hasBookmarks());
    }

    private void enableSelectionDependentCommands(boolean bl) {
        this.fActionManager.enableSelectionDependentActions(bl);
    }

    void doFindAgain(boolean bl) {
        if (sFindString != null && sFindString.length() > 0 && SyntaxTextPaneUtilities.findString((String)sFindString, (boolean)bl, ((FindPrefs.getOptions() & 4) != 0 ? 1 : 0) != 0, ((FindPrefs.getOptions() & 2) != 0 ? 1 : 0) != 0, ((FindPrefs.getOptions() & 1) != 0 ? 1 : 0) != 0)) {
            this.scrollTextFromBehindFindDialog();
        }
    }

    private void doFindSel(boolean bl) {
        String string = sFindString;
        sFindString = this.fSyntaxPane.getSelectedText();
        if (sFindString != null && sFindString.length() > 0 && SyntaxTextPaneUtilities.findString((String)sFindString, (boolean)bl, ((FindPrefs.getOptions() & 4) != 0 ? 1 : 0) != 0, ((FindPrefs.getOptions() & 2) != 0 ? 1 : 0) != 0, ((FindPrefs.getOptions() & 1) != 0 ? 1 : 0) != 0)) {
            this.scrollTextFromBehindFindDialog();
        }
        EditorView.enableFindAgain();
        if (!(this.fFindListener == null || string != null && string.equals(sFindString))) {
            this.fFindListener.setSearchString(sFindString);
        }
    }

    private void scrollTextFromBehindFindDialog() {
        if (this.fFindListener != null && this.fFindListener.getWindow() != null) {
            EditorViewUtils.scrollTextAvoidingWindow(this.getSyntaxTextPane(), this.fFindListener.getWindow());
        }
    }

    void addFindListener() {
        FindFiles.setEditorFilename(this.isBackedByFile() ? this.getBackingFile().getPath() : this.getUiInfoProvider().getShortName());
        String string = this.isBackedByFile() ? this.getUiInfoProvider().getShortName() : this.getUiInfoProvider().getLongName();
        String string2 = MessageFormat.format(EditorUtils.lookup("find.editorcurrentfile"), string);
        String[] stringArray = new String[]{string2};
        FindClientRegistry.register((String)"EditorView", (FindClientInterface)this.fFindClient, (String[])stringArray, (boolean)true);
    }

    private static void replaceAllRequested(FindEvent findEvent) {
        sFindString = findEvent.getFindString();
        String string = findEvent.getReplaceString();
        SyntaxTextPaneUtilities.replaceAll((String)sFindString, (String)string, ((findEvent.getOptions() & 4) != 0 ? 1 : 0) != 0, ((findEvent.getOptions() & 2) != 0 ? 1 : 0) != 0, ((findEvent.getOptions() & 1) != 0 ? 1 : 0) != 0);
    }

    private void doReplace(FindEvent findEvent) {
        String string;
        sFindString = findEvent.getFindString();
        if (SyntaxTextPaneUtilities.replaceString((String)sFindString, (String)(string = findEvent.getReplaceString()), ((findEvent.getOptions() & 8) != 0 ? 1 : 0) != 0, ((findEvent.getOptions() & 4) != 0 ? 1 : 0) != 0, ((findEvent.getOptions() & 2) != 0 ? 1 : 0) != 0, ((findEvent.getOptions() & 1) != 0 ? 1 : 0) != 0)) {
            this.scrollTextFromBehindFindDialog();
        }
    }

    private static void enableFindAgain() {
        if (sFindString == null || sFindString.length() == 0) {
            ActionManager.enableFindAgainActions(false);
        } else {
            ActionManager.enableFindAgainActions(true);
        }
    }

    void invokeFind() {
        sFindString = this.fSyntaxPane.getSelectedText();
        if (sFindString != null && sFindString.length() == 0) {
            sFindString = null;
        }
        sFindString = FindDialog.invoke((FindClientInterface)this.fFindClient, (String)sFindString, (int)FindPrefs.getOptions()).getText();
    }

    void invokeFindFiles() {
        String string = this.fSyntaxPane.getSelectedText();
        if (string != null && string.length() == 0) {
            string = null;
        }
        FindFiles.invoke(string);
    }

    private Frame getParentFrame() {
        return EditorUiUtils.getParentFrame((Component)((Object)this));
    }

    private void bringForward() {
        Component component;
        Desktop desktop = EditorStartup.getParentDesktop();
        if (!desktop.isClientShowing(component = this.fCallback.getDesktopClient())) {
            desktop.setClientSelected(component, true);
        } else if (!desktop.isClientSelected(component)) {
            Frame frame = this.getParentFrame();
            if (frame != null && frame.getState() == 1) {
                frame.setState(0);
            }
            if (frame != null && !frame.isVisible()) {
                frame.setVisible(true);
            }
            desktop.toFront(component);
        }
        SyntaxTextPaneUtilities.activate((JTextComponent)this.fSyntaxPane.getActiveTextComponent());
    }

    private void doPrint(int n, int n2) {
        this.fSyntaxPane.printDocument(this.getUiInfoProvider().getLongName(), n, n2);
    }

    private void doPageSetup() {
        if (DialogFactory.showPageSetup(this.getParentFrame(), EditorUtils.lookup("pagesetup.title"), (Component)EditorPrefsPrintPanel.createPrefsPanel()) == 0) {
            EditorPrefsPrintPanel.commitPrefsChanges(true);
        }
    }

    public void setContents(String string) {
        try {
            this.fSyntaxPane.delete(0, this.fSyntaxPane.getLength());
            this.fSyntaxPane.insert(0, string);
            this.fSyntaxPane.setCaretPosition(0);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    private void disposeBreakpointAlley() {
        if (this.fBreakpointMargin != null) {
            this.fBreakpointMargin.dispose();
            this.fBreakpointMargin = null;
        }
        this.validate();
    }

    private void initExecutionArrowAndBookmarkAlley(List<MarginProvider> list) {
        this.fExecutionArrowDisplay = new ExecutionArrowDisplay((STPInterface)this.fSyntaxPane, this.resolveDebugExecutionAdaptor(list));
        this.fExecutionArrowDisplay.setColors(ColorPrefs.getBackgroundColor(), ColorPrefs.getTextColor());
        this.fSyntaxPane.addToLeftPanel(this.fExecutionArrowDisplay, "East");
        this.validate();
    }

    private ExecutionDisplayAdapter resolveDebugExecutionAdaptor(List<MarginProvider> list) {
        return list.isEmpty() ? new DummyExecutionDisplayAdapter() : list.get(0).buildExecutionAdapter(this.fCallback.getCorrespondingEditor());
    }

    private void doToggleBookmark() {
        try {
            if (this.fExecutionArrowDisplay != null) {
                int n = this.fSyntaxPane.getSelectionDot();
                int n2 = this.fSyntaxPane.getLineFromPos(n);
                this.fExecutionArrowDisplay.toggleBookmark(n2);
            }
            this.enableBookmarkDependentCommands();
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    private void doPrevBookmark() {
        try {
            if (this.fExecutionArrowDisplay != null) {
                int n = this.fSyntaxPane.getSelectionDot();
                int n2 = this.fSyntaxPane.getLineFromPos(n);
                if ((n2 = this.fExecutionArrowDisplay.prevBookmark(n2)) != -1) {
                    int n3 = this.fSyntaxPane.getLineStart(n2);
                    this.fSyntaxPane.select(n3, n3);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    private void doNextBookmark() {
        try {
            if (this.fExecutionArrowDisplay != null) {
                int n = this.fSyntaxPane.getSelectionDot();
                int n2 = this.fSyntaxPane.getLineFromPos(n);
                if ((n2 = this.fExecutionArrowDisplay.nextBookmark(n2)) != -1) {
                    int n3 = this.fSyntaxPane.getLineStart(n2);
                    this.fSyntaxPane.select(n3, n3);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    private void doFunctionMenu(Component component) {
        PopupAction[] popupActionArray = EditorViewUtils.createFunctionPopupActions(this.fCallback.getCorrespondingEditor());
        new ScrollablePopupList((Action[])popupActionArray).showPopup(component, 0, component.getHeight());
    }

    private void doFunctionBrowser(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            Point point = new Point(0, jButton.getSize().height);
            SwingUtilities.convertPointToScreen(point, jButton);
            FunctionBrowser.open(new Rectangle(point.x, point.y, jButton.getWidth(), jButton.getHeight()), this.fSyntaxPane.getActiveTextComponent());
        } else {
            FunctionBrowser.open(this.fSyntaxPane.getActiveTextComponent());
        }
    }

    private String getFirstFunctionName() {
        return MDocumentUtils.getFirstFunctionName((MTree)MDocumentUtils.getMTree((BaseDocument)((BaseDocument)this.fSyntaxPane.getDocument())));
    }

    boolean isScript() {
        return !this.isFunction() && !this.isClass();
    }

    boolean isFunction() {
        return !this.isClass() && this.getFirstFunctionName() != null;
    }

    boolean isClass() {
        return EditorUtils.getClassName((STPModelInterface)this.fSyntaxPane) != null;
    }

    void setActive() {
        this.addFindListener();
        if (this.fRequestFocusWhenActivated) {
            this.fRequestFocusWhenActivated = false;
            this.requestFocus();
        }
    }

    private void updateCorrespondingEditorLanguage() {
        EditorLanguage editorLanguage = EditorLanguageUtils.findLanguage((String)this.fSyntaxPane.getContentType());
        assert (editorLanguage != null) : "The language cannot be null";
        this.fCallback.getCorrespondingEditor().putProperty("EditorLanguage", (Object)editorLanguage);
    }

    public BackingStore<Document> getBackingStore() {
        return this.fBackingStore;
    }

    public UiInfoProvider getUiInfoProvider() {
        return this.fUiInfoProvider;
    }

    public final void addDirtyStateChangeListener(DirtyStateChangeListener dirtyStateChangeListener) {
        if (this.getSyntaxTextPane() != null) {
            this.getSyntaxTextPane().getUndoManager().addDirtyStateChangeListener(dirtyStateChangeListener);
        }
        this.fDirtyStateChangeListeners.add(dirtyStateChangeListener);
    }

    public final void removeDirtyStateChangeListener(DirtyStateChangeListener dirtyStateChangeListener) {
        if (this.getSyntaxTextPane() != null) {
            this.getSyntaxTextPane().getUndoManager().removeDirtyStateChangeListener(dirtyStateChangeListener);
        }
        this.fDirtyStateChangeListeners.remove(dirtyStateChangeListener);
    }

    public final void addEditorViewListener(EditorViewListener editorViewListener) {
        this.fEditorViewListeners.add(editorViewListener);
    }

    public final void removeEditorViewListener(EditorViewListener editorViewListener) {
        this.fEditorViewListeners.remove(editorViewListener);
    }

    private void fireLanguageOrFilenameChanged() {
        for (EditorViewListener editorViewListener : this.fEditorViewListeners) {
            editorViewListener.languageOrFilenameChanged();
        }
    }

    public Codepad getCodepad() {
        return this.fCodepad;
    }

    public BreakpointMargin<? extends Breakpoint> getBreakpointMargin() {
        return this.fBreakpointMargin;
    }

    public ExecutionArrowDisplay getExecutionArrowDisplay() {
        return this.fExecutionArrowDisplay;
    }

    private static class OSGiEditorLayerProviderDistributor
    implements EditorLayerProviderDistributor {
        private OSGiEditorLayerProviderDistributor() {
        }

        @Override
        public Collection<EditorLayerProvider> getProviders() {
            return ClasspathOSGiManager.getInstance().getImplementors(EditorLayerProvider.class);
        }
    }

    public static interface EditorLayerProviderDistributor {
        public Collection<EditorLayerProvider> getProviders();
    }

    private class FindDialogListener
    extends WindowAdapter {
        private FindDialogListener() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (EditorView.this.fSyntaxPane != null) {
                SyntaxTextPaneUtilities.setSelFocusOverride((STPViewInterface)EditorView.this.fSyntaxPane, (boolean)true);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            if (EditorView.this.fSyntaxPane != null) {
                SyntaxTextPaneUtilities.setSelFocusOverride((STPViewInterface)EditorView.this.fSyntaxPane, (boolean)false);
            }
        }
    }

    private class EditorPrefListener
    implements PrefListener {
        private EditorPrefListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            String string = prefEvent.getPrefKey();
            if ((string.equals("ColorsBackground") || string.equals("ColorsText")) && EditorView.this.fExecutionArrowDisplay != null) {
                EditorView.this.fExecutionArrowDisplay.setColors(ColorPrefs.getBackgroundColor(), ColorPrefs.getTextColor());
            }
        }
    }
}

