/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.breakpoints;

import com.mathworks.mde.editor.breakpoints.MatlabBreakpoint;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUtils;
import java.text.MessageFormat;
import org.apache.commons.lang.Validate;

public class BreakpointDisplayUtils {
    private BreakpointDisplayUtils() {
    }

    public static String createBreakpointDisplayString(MatlabBreakpoint matlabBreakpoint) {
        Validate.notNull((Object)matlabBreakpoint, (String)"The Breakpoint cannot be null.");
        return DisplayStringGenerator.getDisplayString(matlabBreakpoint);
    }

    private static enum DisplayStringGenerator {
        LINE_ENABLED(false, true, false){

            @Override
            String generateDisplayString(MatlabBreakpoint matlabBreakpoint) {
                return MatlabBreakpointUtils.lookup("string.enabled");
            }
        }
        ,
        LINE_ENABLED_CONDITIONAL(false, true, true){

            @Override
            String generateDisplayString(MatlabBreakpoint matlabBreakpoint) {
                return MessageFormat.format(MatlabBreakpointUtils.lookup("string.enabledWithExpression"), DisplayStringGenerator.getQuotedNormalizedExpression(matlabBreakpoint));
            }
        }
        ,
        LINE_DISABLED(false, false, false){

            @Override
            String generateDisplayString(MatlabBreakpoint matlabBreakpoint) {
                return MatlabBreakpointUtils.lookup("string.disabled");
            }
        }
        ,
        LINE_DISABLED_CONDITIONAL(false, false, true){

            @Override
            String generateDisplayString(MatlabBreakpoint matlabBreakpoint) {
                return MessageFormat.format(MatlabBreakpointUtils.lookup("string.disabledWithExpression"), DisplayStringGenerator.getQuotedNormalizedExpression(matlabBreakpoint));
            }
        }
        ,
        ANONYMOUS_ENABLED(true, true, false){

            @Override
            String generateDisplayString(MatlabBreakpoint matlabBreakpoint) {
                return MessageFormat.format(MatlabBreakpointUtils.lookup("string.enabledAnonymous"), Integer.toString(matlabBreakpoint.getAnonymousIndex()));
            }
        }
        ,
        ANONYMOUS_ENABLED_CONDITIONAL(true, true, true){

            @Override
            String generateDisplayString(MatlabBreakpoint matlabBreakpoint) {
                return MessageFormat.format(MatlabBreakpointUtils.lookup("string.enabledAnonymousWithExpression"), Integer.toString(matlabBreakpoint.getAnonymousIndex()), DisplayStringGenerator.getQuotedNormalizedExpression(matlabBreakpoint));
            }
        }
        ,
        ANONYMOUS_DISABLED(true, false, false){

            @Override
            String generateDisplayString(MatlabBreakpoint matlabBreakpoint) {
                return MessageFormat.format(MatlabBreakpointUtils.lookup("string.disabledAnonymous"), Integer.toString(matlabBreakpoint.getAnonymousIndex()));
            }
        }
        ,
        ANONYMOUS_DISABLED_CONDITIONAL(true, false, true){

            @Override
            String generateDisplayString(MatlabBreakpoint matlabBreakpoint) {
                return MessageFormat.format(MatlabBreakpointUtils.lookup("string.disabledAnonymousWithExpression"), Integer.toString(matlabBreakpoint.getAnonymousIndex()), DisplayStringGenerator.getQuotedNormalizedExpression(matlabBreakpoint));
            }
        };

        private final boolean fIsAnonymous;
        private final boolean fIsEnabled;
        private final boolean fHasExpression;

        private DisplayStringGenerator(boolean bl, boolean bl2, boolean bl3) {
            this.fIsAnonymous = bl;
            this.fIsEnabled = bl2;
            this.fHasExpression = bl3;
        }

        private boolean shouldGenerate(MatlabBreakpoint matlabBreakpoint) {
            return matlabBreakpoint.isAnonymous() == this.fIsAnonymous && matlabBreakpoint.isEnabled() == this.fIsEnabled && matlabBreakpoint.hasExpression() == this.fHasExpression;
        }

        abstract String generateDisplayString(MatlabBreakpoint var1);

        private static String getQuotedNormalizedExpression(MatlabBreakpoint matlabBreakpoint) {
            return "'" + matlabBreakpoint.getExpression() + "'";
        }

        private static String getDisplayString(MatlabBreakpoint matlabBreakpoint) {
            for (DisplayStringGenerator displayStringGenerator : DisplayStringGenerator.values()) {
                if (!displayStringGenerator.shouldGenerate(matlabBreakpoint)) continue;
                return displayStringGenerator.generateDisplayString(matlabBreakpoint);
            }
            throw new IllegalStateException("A generator should have been found for the given breakpoint.");
        }
    }
}

