/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.breakpoints;

import com.mathworks.mde.editor.breakpoints.DbStopStatus;
import java.io.File;
import org.apache.commons.lang.Validate;

public class BreakpointInstallationResult {
    private final File fFile;
    private final String fErrorMessage;
    private final DbStopStatus fStatus;
    private boolean fIsValid = true;

    public BreakpointInstallationResult(File file, String string, DbStopStatus dbStopStatus) {
        Validate.notNull((Object)file, (String)"The given File cannot be null.");
        Validate.notNull((Object)string, (String)"The given error message cannot be null.");
        Validate.notNull((Object)((Object)dbStopStatus), (String)"The given Status cannot be null.");
        BreakpointInstallationResult.validateErrorMessageRelativeToStatus(string, dbStopStatus);
        this.fFile = file;
        this.fErrorMessage = string;
        this.fStatus = dbStopStatus;
    }

    public static BreakpointInstallationResult createSuccessfulResult(File file) {
        return new BreakpointInstallationResult(file, "", DbStopStatus.SUCCESS);
    }

    public boolean wasSuccessful() {
        this.validateIsValid();
        return this.fStatus == DbStopStatus.SUCCESS;
    }

    public boolean errorOccurred() {
        this.validateIsValid();
        return !this.wasSuccessful();
    }

    public void showErrorDialog() {
        this.validateIsValid();
        this.fStatus.showErrorDialog(this.fFile, this.fErrorMessage);
    }

    public boolean isValid() {
        return this.fIsValid;
    }

    public void markAsInvalid() {
        this.fIsValid = false;
    }

    private static void validateErrorMessageRelativeToStatus(String string, DbStopStatus dbStopStatus) {
        if (string.length() == 0 && dbStopStatus != DbStopStatus.SUCCESS) {
            throw new IllegalArgumentException("A status other than DbStopStatus.SUCCESS should have an error message.");
        }
        if (dbStopStatus == DbStopStatus.SUCCESS && string.length() > 0) {
            throw new IllegalArgumentException("A DbStopStatus.SUCCESS message should have an empty error message.");
        }
    }

    private void validateIsValid() {
        if (!this.isValid()) {
            throw new IllegalStateException("This BreakpointInstallationResult is invalid.");
        }
    }
}

