/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.breakpoints;

import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mde.editor.EditorUiUtils;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.breakpoints.BreakpointDialogs;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpoint;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.util.FileUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.Validate;

public class EditAllBreakpointsDialog {
    public static final String ADD_BUTTON_NAME = "addButton";
    public static final String SET_EXPRESSION_BUTTON_NAME = "setExpressionButton";
    public static final String ENABLE_BUTTON_NAME = "enableButton";
    public static final String DISABLE_BUTTON_NAME = "disableButton";
    public static final String CLEAR_BUTTON_NAME = "clearButton";
    public static final String LIST_NAME = "list";
    private final Collection<MatlabBreakpoint> fOriginalBreakpoints;
    private final int fLineNumber;
    private final File fFile;
    private final int fNumPossibleInLineBreakpoints;
    private final DefaultListModel fModel = new DefaultListModel();
    private final MJList fList = new MJList((ListModel)this.fModel);
    private final JComponent fComponent;
    private final Action fAddAction = this.createAddAction();
    private final Action fSetExpressionAction = this.createSetExpressionAction();
    private final Action fEnableAction = this.createEnableAction();
    private final Action fDisableAction = this.createDisableAction();
    private final Action fClearAction = this.createClearAction();

    public EditAllBreakpointsDialog(Collection<MatlabBreakpoint> collection, int n, File file, int n2) {
        EditAllBreakpointsDialog.validateBreakpointsAreOnSameLineAndHaveSameFile(collection, n, file);
        EditAllBreakpointsDialog.validateNumberOfBreakpointsGiven(collection, n2);
        this.fOriginalBreakpoints = new ArrayList<MatlabBreakpoint>(collection);
        this.fLineNumber = n;
        this.fFile = file;
        this.fNumPossibleInLineBreakpoints = n2;
        this.init();
        this.fComponent = this.buildContentPanel();
    }

    private void init() {
        this.fList.setName(LIST_NAME);
        this.fList.setPreferredSize(new Dimension(300, 100));
        this.fList.addListSelectionListener(this.createListSelectionListener());
        this.fList.setSelectionMode(2);
        this.buildJListModel();
        this.fList.setSelectedIndex(0);
        this.updateActionEnablement();
    }

    private ListSelectionListener createListSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EditAllBreakpointsDialog.this.updateActionEnablement();
            }
        };
    }

    private void buildJListModel() {
        for (MatlabBreakpoint matlabBreakpoint : this.fOriginalBreakpoints) {
            this.fModel.addElement(matlabBreakpoint);
        }
    }

    private JComponent buildContentPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("p:grow, 3dlu, p", "p, 5dlu, p, 1dlu, p:grow"));
        CellConstraints cellConstraints = new CellConstraints();
        MJLabel mJLabel = new MJLabel(MessageFormat.format(MatlabBreakpointUtils.lookup("editAllBreakpointsDialog.lineContainsMultipleBreakpoints"), this.fLineNumber + 1));
        mJPanel.add((Component)mJLabel, (Object)cellConstraints.xy(1, 1));
        MJLabel mJLabel2 = new MJLabel(MatlabBreakpointUtils.lookup("editAllBreakpointsDialog.currentBreakpoints"));
        mJPanel.add((Component)mJLabel2, (Object)cellConstraints.xy(1, 3));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fList);
        mJPanel.add((Component)mJScrollPane, (Object)cellConstraints.xy(1, 5, "fill,fill"));
        mJPanel.add((Component)this.buildButtonPanel(), (Object)cellConstraints.xy(3, 5));
        return mJPanel;
    }

    private JComponent buildButtonPanel() {
        MJButton mJButton = new MJButton(this.fAddAction);
        MJButton mJButton2 = new MJButton(this.fSetExpressionAction);
        MJButton mJButton3 = new MJButton(this.fEnableAction);
        MJButton mJButton4 = new MJButton(this.fDisableAction);
        MJButton mJButton5 = new MJButton(this.fClearAction);
        mJButton.setName(ADD_BUTTON_NAME);
        mJButton2.setName(SET_EXPRESSION_BUTTON_NAME);
        mJButton3.setName(ENABLE_BUTTON_NAME);
        mJButton4.setName(DISABLE_BUTTON_NAME);
        mJButton5.setName(CLEAR_BUTTON_NAME);
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addButtons(new JButton[]{mJButton, mJButton2, mJButton3, mJButton4, mJButton5});
        return buttonStackBuilder.getPanel();
    }

    public Collection<MatlabBreakpoint> show() {
        Frame frame = EditorUiUtils.getFrameToCenterDialogOn(this.fFile);
        int n = MJOptionPane.showConfirmDialog((Component)frame, (Object)this.fComponent, (String)EditorUtils.EDITOR_TITLE, (int)2);
        return n == 0 ? this.createBreakpointsFromModel() : null;
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private Action createAddAction() {
        return new MJAbstractAction(MatlabBreakpointUtils.lookup("editAllBreakpointsDialog.addButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                MatlabBreakpoint matlabBreakpoint = BreakpointDialogs.showSetBreakpointDialog(EditAllBreakpointsDialog.this.fLineNumber, EditAllBreakpointsDialog.this.createBreakpointsFromModel(), EditAllBreakpointsDialog.this.fNumPossibleInLineBreakpoints, EditAllBreakpointsDialog.this.fFile);
                if (matlabBreakpoint != null) {
                    EditAllBreakpointsDialog.this.fModel.addElement(matlabBreakpoint);
                    EditAllBreakpointsDialog.this.fList.setSelectedValue((Object)matlabBreakpoint, true);
                }
            }
        };
    }

    private Action createSetExpressionAction() {
        return new MJAbstractAction(MatlabBreakpointUtils.lookup("editAllBreakpointsDialog.setExpressionButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                MatlabBreakpoint matlabBreakpoint = (MatlabBreakpoint)EditAllBreakpointsDialog.this.fList.getSelectedValue();
                String string = BreakpointDialogs.promptUserForExpression(matlabBreakpoint, EditAllBreakpointsDialog.this.fNumPossibleInLineBreakpoints);
                if (string != null) {
                    EditAllBreakpointsDialog.this.fModel.setElementAt(matlabBreakpoint.deriveBreakpoint(string), EditAllBreakpointsDialog.this.fList.getSelectedIndex());
                }
            }
        };
    }

    private Action createEnableAction() {
        return new MJAbstractAction(MatlabBreakpointUtils.lookup("editAllBreakpointsDialog.enableButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditAllBreakpointsDialog.this.setSelectedBreakpointsEnablement(true);
            }
        };
    }

    private Action createDisableAction() {
        return new MJAbstractAction(MatlabBreakpointUtils.lookup("editAllBreakpointsDialog.disableButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditAllBreakpointsDialog.this.setSelectedBreakpointsEnablement(false);
            }
        };
    }

    private Action createClearAction() {
        return new MJAbstractAction(MatlabBreakpointUtils.lookup("editAllBreakpointsDialog.clearButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Object object : EditAllBreakpointsDialog.this.fList.getSelectedValues()) {
                    EditAllBreakpointsDialog.this.fModel.removeElement(object);
                }
                EditAllBreakpointsDialog.this.fList.setSelectedIndex(0);
            }
        };
    }

    private boolean shouldAddActionBeEnabled() {
        return this.fModel.size() < this.fNumPossibleInLineBreakpoints + 1;
    }

    private boolean shouldSetExpressionActionEnabled() {
        return this.fList.getSelectedIndices().length == 1;
    }

    private boolean shouldEnableActionBeEnabled() {
        BreakpointsEnablement breakpointsEnablement = this.getBreakpointsEnablement();
        return breakpointsEnablement == BreakpointsEnablement.ALL_DISABLED || breakpointsEnablement == BreakpointsEnablement.MIXED;
    }

    private boolean shouldDisableActionBeEnabled() {
        BreakpointsEnablement breakpointsEnablement = this.getBreakpointsEnablement();
        return breakpointsEnablement == BreakpointsEnablement.ALL_ENABLED || breakpointsEnablement == BreakpointsEnablement.MIXED;
    }

    private boolean shouldClearActionBeEnabled() {
        return this.fList.getSelectedIndices().length > 0;
    }

    private void updateActionEnablement() {
        this.fAddAction.setEnabled(this.shouldAddActionBeEnabled());
        this.fSetExpressionAction.setEnabled(this.shouldSetExpressionActionEnabled());
        this.fEnableAction.setEnabled(this.shouldEnableActionBeEnabled());
        this.fDisableAction.setEnabled(this.shouldDisableActionBeEnabled());
        this.fClearAction.setEnabled(this.shouldClearActionBeEnabled());
    }

    private void setSelectedBreakpointsEnablement(boolean bl) {
        int[] nArray;
        for (int n : nArray = this.fList.getSelectedIndices()) {
            MatlabBreakpoint matlabBreakpoint = (MatlabBreakpoint)this.fModel.get(n);
            this.fModel.setElementAt(matlabBreakpoint.deriveBreakpoint(bl), n);
        }
        this.updateActionEnablement();
    }

    private Collection<MatlabBreakpoint> createBreakpointsFromModel() {
        return Collections.list(this.fModel.elements());
    }

    private BreakpointsEnablement getBreakpointsEnablement() {
        int n = 0;
        for (int n2 : this.fList.getSelectedIndices()) {
            MatlabBreakpoint matlabBreakpoint = (MatlabBreakpoint)this.fModel.getElementAt(n2);
            n += matlabBreakpoint.isEnabled() ? 1 : 0;
        }
        int n3 = this.fList.getSelectedIndices().length;
        BreakpointsEnablement breakpointsEnablement = n3 == 0 ? BreakpointsEnablement.NO_BREAKPOINTS : (n == n3 ? BreakpointsEnablement.ALL_ENABLED : (n == 0 ? BreakpointsEnablement.ALL_DISABLED : BreakpointsEnablement.MIXED));
        return breakpointsEnablement;
    }

    private static void validateBreakpointsAreOnSameLineAndHaveSameFile(Collection<MatlabBreakpoint> collection, int n, File file) {
        for (MatlabBreakpoint matlabBreakpoint : collection) {
            Validate.isTrue((matlabBreakpoint.getZeroBasedLineNumber() == n ? 1 : 0) != 0, (String)"The given breakpoints must all be on the given line.");
            Validate.isTrue((boolean)FileUtils.areFilesTheSame((File)matlabBreakpoint.getFile(), (File)file), (String)"The given breakpoints must all be set in the given file.");
        }
    }

    private static void validateNumberOfBreakpointsGiven(Collection<MatlabBreakpoint> collection, int n) {
        int n2 = n + 1;
        Validate.isTrue((collection.size() <= n2 ? 1 : 0) != 0, (String)("There were too many breakpoints given. Only " + n2 + " breakpoints can exist on the given line."));
    }

    private static enum BreakpointsEnablement {
        NO_BREAKPOINTS,
        ALL_ENABLED,
        ALL_DISABLED,
        MIXED;

    }
}

