/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.breakpoints;

import com.mathworks.matlab.api.debug.BreakpointStyle;
import com.mathworks.matlab.api.debug.BreakpointUiInfoProvider;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpoint;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUtils;
import com.mathworks.widgets.debug.DebuggerManager;
import com.mathworks.widgets.editor.breakpoints.DefaultBreakpointStyle;
import java.text.MessageFormat;
import java.util.Collection;

public class MatlabBreakpointUiInfoProvider
implements BreakpointUiInfoProvider<MatlabBreakpoint> {
    public BreakpointStyle getBreakpointStyle(Collection<MatlabBreakpoint> collection, boolean bl) {
        DefaultBreakpointStyle defaultBreakpointStyle;
        if (!DebuggerManager.getInstance().supportsConditionalBreakpoints() && bl) {
            defaultBreakpointStyle = DefaultBreakpointStyle.SINGLE;
        } else {
            MatlabBreakpoint matlabBreakpoint;
            if (!bl) {
                return DefaultBreakpointStyle.OUT_OF_SYNC;
            }
            defaultBreakpointStyle = collection.size() == 1 ? ((matlabBreakpoint = collection.iterator().next()).hasExpression() ? DefaultBreakpointStyle.CONDITIONAL : DefaultBreakpointStyle.SINGLE) : (collection.size() > 1 ? DefaultBreakpointStyle.MULTIPLE : DefaultBreakpointStyle.SINGLE);
        }
        return defaultBreakpointStyle;
    }

    public String generateToolTipText(Collection<MatlabBreakpoint> collection, boolean bl) {
        String string = bl ? "" : "<b>" + MatlabBreakpointUtils.lookup("tooltip.saveFileSynch") + ". </b>\n";
        int n = 0;
        for (MatlabBreakpoint matlabBreakpoint : collection) {
            string = string + MatlabBreakpointUiInfoProvider.generateToolTipText(matlabBreakpoint);
            boolean bl2 = n < collection.size() - 1;
            string = string + (bl2 ? "\n" : "");
            ++n;
        }
        return string.length() == 0 ? null : string;
    }

    private static String generateToolTipText(MatlabBreakpoint matlabBreakpoint) {
        String string = MatlabBreakpointUiInfoProvider.generateLinePartToolTipText(matlabBreakpoint) + " " + MatlabBreakpointUiInfoProvider.generateEnabledPartToolTipText(matlabBreakpoint) + " " + MatlabBreakpointUiInfoProvider.generateExpressionPartToolTipTextIfNeccessary(matlabBreakpoint);
        return string.trim();
    }

    private static String generateLinePartToolTipText(MatlabBreakpoint matlabBreakpoint) {
        int n = matlabBreakpoint.getZeroBasedLineNumber() + 1;
        return matlabBreakpoint.isAnonymous() ? MessageFormat.format(MatlabBreakpointUtils.lookup("tooltip.lineAnonymousN"), n, matlabBreakpoint.getAnonymousIndex()) : MessageFormat.format(MatlabBreakpointUtils.lookup("tooltip.line"), n);
    }

    private static String generateEnabledPartToolTipText(MatlabBreakpoint matlabBreakpoint) {
        return matlabBreakpoint.isEnabled() ? MatlabBreakpointUtils.lookup("tooltip.statusEnabled") : MatlabBreakpointUtils.lookup("tooltip.statusDisabled");
    }

    private static String generateExpressionPartToolTipTextIfNeccessary(MatlabBreakpoint matlabBreakpoint) {
        return matlabBreakpoint.hasExpression() ? MessageFormat.format(MatlabBreakpointUtils.lookup("tooltip.condition"), "'" + matlabBreakpoint.getExpression() + "'") : "";
    }
}

