/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.matlab;

import com.jidesoft.swing.JideMenu;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorEvent;
import com.mathworks.matlab.api.editor.EditorMenuGroupID;
import com.mathworks.matlab.api.editor.EditorMenuID;
import com.mathworks.matlab.api.menus.MenuBuilder;
import com.mathworks.matlab.api.menus.MenuContext;
import com.mathworks.matlab.api.menus.MenuContributor;
import com.mathworks.matlab.api.menus.MenuGroupID;
import com.mathworks.matlab.api.menus.MenuID;
import com.mathworks.mde.desk.MLMenuMergeTag;
import com.mathworks.mde.editor.EditorAction;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mde.editor.plugins.matlab.DependencyReportUtils;
import com.mathworks.mde.editor.plugins.matlab.MatlabDebugActions;
import com.mathworks.mde.editor.plugins.matlab.MatlabPluginUtils;
import com.mathworks.mde.profiler.Profiler;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.PublishConfiguration;
import com.mathworks.mlwidgets.configeditor.data.RunConfiguration;
import com.mathworks.mlwidgets.debug.RunOrContinueAction;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.datamodel.StorageLocationUtils;
import com.mathworks.widgets.debug.DebuggerManager;
import com.mathworks.widgets.desk.DTMenuBoundary;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.editor.SelfRemovingEditorEventListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.commons.lang.Validate;

public class MatlabMenuContributor
implements MenuContributor<Editor> {
    public static final String RUN_CONFIGURATIONS_MENU_NAME = "RunConfigurationsMenu";
    public static final String PUBLISH_CONFIGURATIONS_MENU_NAME = "PublishConfigurationsMenu";
    public static final EditorAction RUN_OR_CONTINUE = new EditorAction("debug-continue");
    public static final EditorAction PUBLISH = new EditorAction("publish-to-default-format");
    public static final EditorAction GO_UNTIL_CURSOR = new EditorAction("go-until-cursor");
    public static final EditorAction SHOW_DEPENDENCY_REPORT = new EditorAction("show-dependency-report-from-editor");
    public static final EditorAction OPEN_PROFILER = new EditorAction("launch-profiler");
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(MatlabMenuContributor.class.getPackage().getName() + ".resources.RES_matlab");

    public static Action createShowDependencyReportAction(final Editor editor) {
        String string = MatlabMenuContributor.getShowDependencyReportLabel(editor);
        return new MJAbstractAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                DependencyReportUtils.showDependencyReport(editor);
            }
        };
    }

    public static EditorAction.ObservableAction createGoUntilAction(final Editor editor) {
        Validate.notNull((Object)editor, (String)"'editor' cannot be null");
        final EditorAction.ObservableAction observableAction = GO_UNTIL_CURSOR.getAction();
        observableAction.setObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                MatlabPluginUtils.runUntilCursor(editor);
            }
        });
        new SelfRemovingEditorEventListener(editor){

            public void handleEventOccurred(EditorEvent editorEvent) {
                if (editorEvent == EditorEvent.DEBUG_MODE_CHANGED) {
                    observableAction.setEnabled(EditorStartup.getInDebugMode());
                }
            }
        };
        observableAction.setEnabled(EditorStartup.getInDebugMode());
        MLMenuMergeTag.GO_UNTIL_CURSOR.setTag((Action)((Object)observableAction));
        return observableAction;
    }

    static MJAbstractAction createRunOrContinueAction(Editor editor) {
        return new RunOrContinueAction((MJAbstractAction)new RunAction(editor), editor);
    }

    public Class<Editor> getContributionTarget() {
        return Editor.class;
    }

    public void contribute(Editor editor, MenuContext menuContext) {
        new MatlabMenuContribution(editor, menuContext).contribute();
        if (!MatlabPluginUtils.isMatlabFileEndingInDotMOrBuffer(editor)) {
            return;
        }
        MenuBuilder menuBuilder = menuContext.getBuilder((MenuID)EditorMenuID.DEBUG);
        menuBuilder.add((MenuGroupID)EditorMenuGroupID.DEBUG_BREAKPOINTS_GROUP, (Action)MatlabDebugActions.createSetClearBreakpointAction(editor));
        menuBuilder.add((MenuGroupID)EditorMenuGroupID.DEBUG_BREAKPOINTS_GROUP, (Action)MatlabDebugActions.createSetConditionalBreakpointAction(editor));
        menuBuilder.add((MenuGroupID)EditorMenuGroupID.DEBUG_BREAKPOINTS_GROUP, (Action)MatlabDebugActions.createEnableDisableBreakpointAction(editor));
        menuBuilder.add((MenuGroupID)EditorMenuGroupID.DEBUG_BREAKPOINTS_GROUP, (Component)new DTMenuBoundary((DTMenuMergeTag)MLMenuMergeTag.CLEAR_BREAKPOINTS));
    }

    public void contributeToContextMenu(Editor editor, MenuBuilder menuBuilder) {
        if (MatlabPluginUtils.isMatlabFileEndingInDotM(editor) && EditorStartup.getInDebugMode()) {
            menuBuilder.add((MenuGroupID)EditorMenuGroupID.CONTEXT_DEBUG_GROUP, (Action)((Object)MatlabMenuContributor.createGoUntilAction(editor)));
        }
    }

    private static String getShowDependencyReportLabel(Editor editor) {
        return editor.isDirty() ? BUNDLE.getString("menuitem.Tools.SaveAndDependency") : BUNDLE.getString("menuitem.Tools.Dependency");
    }

    private static class JideMenuAction
    extends MJAbstractAction {
        private JideMenuAction() {
            this.setTip(null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private static class MatlabMenuContribution {
        private Editor fEditor;
        private MenuContext fContext;
        private MJAbstractAction fRunOrContinueAction;
        private final EditorAction.ObservableAction fPublishAction;
        private final JideMenuAction fRunConfigMenuAction;
        private EditorAction.ObservableAction fDependencyReportAction;
        private EditorAction.ObservableAction fProfilerAction;
        private JideMenuAction fPublishConfigMenuAction;

        private MatlabMenuContribution(Editor editor, MenuContext menuContext) {
            this.fEditor = editor;
            this.fContext = menuContext;
            if (StorageLocationUtils.isOrWillBeBackedByFile((StorageLocation)editor.getStorageLocation())) {
                this.fRunOrContinueAction = MatlabMenuContributor.createRunOrContinueAction(editor);
            }
            if (MatlabPluginUtils.isMatlabFileEndingInDotMOrBuffer(this.fEditor)) {
                this.fRunConfigMenuAction = new JideMenuAction();
                this.updateRunConfigurationsMenuItemLabel();
                this.fPublishAction = MatlabMenuContribution.createPublishAction(editor);
                this.fPublishConfigMenuAction = new JideMenuAction();
                this.updatePublishMenuItemLabel();
                this.updatePublishConfigurationsMenuItemLabel();
            } else {
                this.fRunConfigMenuAction = null;
                this.fPublishAction = null;
                this.fPublishConfigMenuAction = null;
            }
        }

        private void contribute() {
            this.contributeToFileMenu();
            this.contributeToDebugMenu();
            this.contributeToToolsMenu();
            this.listenToEditorChanges();
            this.updateActionStates();
        }

        private void contributeToFileMenu() {
            if (MatlabPluginUtils.isMatlabFileEndingInDotMOrBuffer(this.fEditor)) {
                MenuBuilder menuBuilder = this.fContext.getBuilder((MenuID)EditorMenuID.FILE);
                this.addFileMenuListener(menuBuilder);
                menuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_SAVE_GROUP, (Action)((Object)this.fPublishAction));
                menuBuilder.add((MenuGroupID)EditorMenuGroupID.FILE_SAVE_GROUP, (Component)this.createPublishMenu());
            }
        }

        private void contributeToDebugMenu() {
            MenuBuilder menuBuilder = this.fContext.getBuilder((MenuID)EditorMenuID.DEBUG);
            this.addDebugMenuListener(menuBuilder);
            if (this.fRunOrContinueAction != null) {
                MLMenuMergeTag.CONTINUE.setTag((Action)this.fRunOrContinueAction);
                menuBuilder.add((MenuGroupID)EditorMenuGroupID.DEBUG_RUN_GROUP, (Action)this.fRunOrContinueAction);
            }
            if (MatlabPluginUtils.isMatlabFileEndingInDotMOrBuffer(this.fEditor)) {
                menuBuilder.add((MenuGroupID)EditorMenuGroupID.DEBUG_RUN_GROUP, (Component)this.createRunMenu());
            }
            if (MatlabPluginUtils.isMatlabFileEndingInDotM(this.fEditor)) {
                menuBuilder.add((MenuGroupID)EditorMenuGroupID.DEBUG_RUN_GROUP, (Action)((Object)MatlabMenuContributor.createGoUntilAction(this.fEditor)));
            }
        }

        private JideMenu createPublishMenu() {
            return this.createMenu((Action)((Object)this.fPublishConfigMenuAction), MatlabMenuContributor.PUBLISH_CONFIGURATIONS_MENU_NAME, PublishConfiguration.TYPE);
        }

        private JideMenu createRunMenu() {
            return this.createMenu((Action)((Object)this.fRunConfigMenuAction), MatlabMenuContributor.RUN_CONFIGURATIONS_MENU_NAME, RunConfiguration.TYPE);
        }

        private void addDebugMenuListener(MenuBuilder menuBuilder) {
            menuBuilder.getMenu().addMenuListener(new MenuListener(){

                @Override
                public void menuCanceled(MenuEvent menuEvent) {
                }

                @Override
                public void menuDeselected(MenuEvent menuEvent) {
                }

                @Override
                public void menuSelected(MenuEvent menuEvent) {
                    MatlabMenuContribution.this.updateRunConfigurationsMenuItemLabel();
                }
            });
        }

        private void addFileMenuListener(MenuBuilder menuBuilder) {
            menuBuilder.getMenu().addMenuListener(new MenuListener(){

                @Override
                public void menuCanceled(MenuEvent menuEvent) {
                }

                @Override
                public void menuDeselected(MenuEvent menuEvent) {
                }

                @Override
                public void menuSelected(MenuEvent menuEvent) {
                    MatlabMenuContribution.this.updatePublishMenuItemLabel();
                    MatlabMenuContribution.this.updatePublishConfigurationsMenuItemLabel();
                }
            });
        }

        private void contributeToToolsMenu() {
            if (MatlabPluginUtils.isMatlabFileEndingInDotMOrBuffer(this.fEditor)) {
                MenuBuilder menuBuilder = this.fContext.getBuilder((MenuID)EditorMenuID.TOOLS);
                this.fDependencyReportAction = this.createShowDependencyReportAction();
                menuBuilder.add((MenuGroupID)EditorMenuGroupID.TOOLS_REPORT_GROUP, (Action)((Object)this.fDependencyReportAction));
                this.fProfilerAction = this.createProfilerAction();
                menuBuilder.add((MenuGroupID)EditorMenuGroupID.TOOLS_REPORT_GROUP, (Action)((Object)this.fProfilerAction));
            }
        }

        private void listenToEditorChanges() {
            new SelfRemovingEditorEventListener(this.fEditor){

                public void handleEventOccurred(EditorEvent editorEvent) {
                    if (editorEvent == EditorEvent.DEBUG_MODE_CHANGED || editorEvent == EditorEvent.DIRTY_STATE_CHANGED) {
                        MatlabMenuContribution.this.updateActionStates();
                    }
                }
            };
        }

        private void updateActionStates() {
            if (MatlabPluginUtils.isMatlabFileEndingInDotMOrBuffer(this.fEditor)) {
                if (this.fDependencyReportAction != null) {
                    this.fDependencyReportAction.setName(MatlabMenuContributor.getShowDependencyReportLabel(this.fEditor));
                }
                if (this.fProfilerAction != null) {
                    this.fProfilerAction.setName(this.fEditor.isDirty() ? BUNDLE.getString("menuitem.Tools.SaveAndProfiler") : BUNDLE.getString("menuitem.Tools.Profiler"));
                }
            }
        }

        private EditorAction.ObservableAction createShowDependencyReportAction() {
            EditorAction.ObservableAction observableAction = SHOW_DEPENDENCY_REPORT.getAction();
            observableAction.setObserver(new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    DependencyReportUtils.showDependencyReport(MatlabMenuContribution.this.fEditor);
                }
            });
            return observableAction;
        }

        private static EditorAction.ObservableAction createPublishAction(final Editor editor) {
            EditorAction.ObservableAction observableAction = PUBLISH.getAction();
            observableAction.setObserver(new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    MatlabPluginUtils.executeDefaultConfiguration(editor, PublishConfiguration.TYPE);
                }
            });
            return observableAction;
        }

        private EditorAction.ObservableAction createProfilerAction() {
            EditorAction.ObservableAction observableAction = OPEN_PROFILER.getAction();
            observableAction.setObserver(new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    MatlabMenuContribution.this.showProfiler();
                }
            });
            return observableAction;
        }

        private void showProfiler() {
            if (this.fEditor.negotiateSave()) {
                File file = ((FileStorageLocation)this.fEditor.getStorageLocation()).getFile();
                String string = file.getName();
                int n = string.indexOf(46);
                if (n != -1) {
                    string = string.substring(0, n);
                }
                Profiler.setCommandText(string);
                Profiler.invoke();
            }
        }

        private JideMenu createMenu(Action action, String string, AbstractFileConfiguration.Type<?> type) {
            final JideMenu jideMenu = new JideMenu(action);
            jideMenu.setName(string);
            jideMenu.setPopupMenuCustomizer((JideMenu.PopupMenuCustomizer)MatlabPluginUtils.createMenuCustomizer(this.fEditor, type));
            final MenuListener menuListener = new MenuListener(){

                @Override
                public void menuCanceled(MenuEvent menuEvent) {
                }

                @Override
                public void menuDeselected(MenuEvent menuEvent) {
                }

                @Override
                public void menuSelected(MenuEvent menuEvent) {
                    if (jideMenu.getPopupMenuCustomizer() != null) {
                        JPopupMenu jPopupMenu = ((JMenu)menuEvent.getSource()).getPopupMenu();
                        jideMenu.getPopupMenuCustomizer().customize(jPopupMenu);
                    }
                }
            };
            jideMenu.addMenuListener(menuListener);
            new SelfRemovingEditorEventListener(this.fEditor){

                public void cleanup() {
                    jideMenu.setPopupMenuCustomizer(null);
                    jideMenu.removeMenuListener(menuListener);
                }
            };
            return jideMenu;
        }

        private void updateRunConfigurationsMenuItemLabel() {
            if (this.fRunConfigMenuAction != null) {
                this.fRunConfigMenuAction.setName(MessageFormat.format(BUNDLE.getString("menuitem.Debug.RunConfigurations"), this.fEditor.getShortName()));
            }
        }

        private void updatePublishConfigurationsMenuItemLabel() {
            this.fPublishConfigMenuAction.setName(MessageFormat.format(BUNDLE.getString("menuitem.File.PublishConfigurations"), this.fEditor.getShortName()));
        }

        private void updatePublishMenuItemLabel() {
            MatlabPluginUtils.assertIsOrWillBeBackedByFile(this.fEditor);
            String string = this.fEditor.isBuffer() ? BUNDLE.getString("menuitem.File.Publish.SaveAndPublish") : (this.fEditor.isDirty() ? MessageFormat.format(BUNDLE.getString("menuitem.File.Publish.SaveAndPublishDynamic"), ConfigurationUtils.getConfigurationNameOrFileName((File)MatlabPluginUtils.getBackingFile(this.fEditor), (AbstractFileConfiguration.Type)PublishConfiguration.TYPE)) : MessageFormat.format(BUNDLE.getString("menuitem.File.Publish"), ConfigurationUtils.getConfigurationNameOrFileName((File)MatlabPluginUtils.getBackingFile(this.fEditor), (AbstractFileConfiguration.Type)PublishConfiguration.TYPE)));
            this.fPublishAction.setName(string);
        }
    }

    private static class RunAction
    extends MJAbstractAction {
        private final Editor fEditor;

        private RunAction(Editor editor) {
            this.fEditor = editor;
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(RUN_OR_CONTINUE.getAction().getContextID(), RUN_OR_CONTINUE.getAction().getActionID(), (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MatlabPluginUtils.executeDefaultConfiguration(this.fEditor, RunConfiguration.TYPE);
        }

        public boolean isEnabled() {
            return MatlabPluginUtils.isMatlabFileEndingInDotMOrBuffer(this.fEditor);
        }

        public String getName() {
            return this.getRunMenuItemLabel(this.fEditor);
        }

        private String getRunMenuItemLabel(Editor editor) {
            String string = !MatlabPluginUtils.isMatlabFileEndingInDotMOrBuffer(editor) ? ((ExtendedAction)DebuggerManager.getInstance().getContinueActionNoEcho()).getName() : (editor.isBuffer() ? BUNDLE.getString("menuitem.Debug.SaveandRun") : (editor.isDirty() ? MessageFormat.format(BUNDLE.getString("menuitem.Debug.SaveandRunDynamic"), ConfigurationUtils.getConfigurationNameOrFileName((File)MatlabPluginUtils.getBackingFile(editor), (AbstractFileConfiguration.Type)RunConfiguration.TYPE)) : MessageFormat.format(BUNDLE.getString("menuitem.Debug.Run"), ConfigurationUtils.getConfigurationNameOrFileName((File)MatlabPluginUtils.getBackingFile(editor), (AbstractFileConfiguration.Type)RunConfiguration.TYPE))));
            return string;
        }
    }
}

