/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.matlab;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.actions.SelectionDelegate;
import com.mathworks.mde.editor.DialogFactory;
import com.mathworks.mde.editor.EditorAction;
import com.mathworks.mde.editor.EditorUiUtils;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.SelectionAction;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.help.HelpPopup;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.TextComponentUtils;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.util.Log;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;

public class MatlabSelectionDelegate
implements SelectionDelegate {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(MatlabSelectionDelegate.class.getPackage().getName() + ".resources.RES_matlab");

    public boolean wouldLikeToHandle(SelectionDelegate.ActionType actionType, Editor editor, String string) {
        return true;
    }

    public void handle(SelectionDelegate.ActionType actionType, Editor editor, String string) {
        switch (actionType) {
            case OPEN: {
                this.openSelection(editor, string);
                break;
            }
            case HELP: {
                this.helpOnSelection(editor);
                break;
            }
            case EVALUATE: {
                this.evaluateSelection(string);
            }
        }
    }

    public int getPriority() {
        return 0;
    }

    private void openSelection(final Editor editor, final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MatlabSelectionDelegate.this.openSelectionOnEdt(editor, string);
            }
        });
    }

    private void openSelectionOnEdt(Editor editor, String string) {
        if (!StringUtils.isEmpty((String)string)) {
            if (SelectionAction.isOpenSelectionStringInvalid(string)) {
                Frame frame = EditorUiUtils.getParentFrame(editor.getComponent());
                DialogFactory.showErrorMessage(frame, BUNDLE.getString("error.selectionNewlineErrorOpen"));
            } else {
                boolean bl = MatlabSelectionDelegate.tryOpeningFunctionWithinFile(editor, string);
                if (!bl) {
                    String string2 = StringUtils.quoteSingleQuotes((String)string);
                    Frame frame = EditorUiUtils.getParentFrame(editor.getComponent());
                    StorageLocation storageLocation = editor.getStorageLocation();
                    if (storageLocation instanceof FileStorageLocation && MatlabSelectionDelegate.doesFileExistInPrivateDirectory(((FileStorageLocation)storageLocation).getFile().getParentFile(), string)) {
                        String string3 = MatlabSelectionDelegate.buildPrivatePath(StringUtils.quoteSingleQuotes((String)((FileStorageLocation)storageLocation).getFile().getParent()), string);
                        EditorUtils.getMatlab().eval("try open('" + string3 + "'); catch " + "try open('" + string2 + "'); catch edit('" + string2 + "'); end" + ";end;", EditorUtils.getShowErrorDialogCompletionObserver(frame));
                    } else {
                        EditorUtils.getMatlab().eval("try, open('" + string2 + "'); catch, edit('" + string2 + "'); end", EditorUtils.getShowErrorDialogCompletionObserver(frame));
                    }
                }
            }
        }
    }

    private static boolean tryOpeningFunctionWithinFile(Editor editor, String string) {
        String string2;
        int n = MatlabSelectionDelegate.getMFunctionLineNumber(editor, string);
        if (n == -1 && editor.getSelection().isEmpty() && (string2 = StringUtils.quoteSingleQuotes((String)TextComponentUtils.getFunctionAt((Document)editor.getDocument(), (int)editor.getCaretPosition(), (boolean)false))) != null) {
            n = MatlabSelectionDelegate.getMFunctionLineNumber(editor, string2);
        }
        if (n >= 0) {
            editor.goToLine(n + 1, false);
            return true;
        }
        return false;
    }

    private static int getMFunctionLineNumber(Editor editor, String string) {
        Validate.notNull((Object)string, (String)"The function name cannot be null.");
        Validate.notEmpty((String)string, (String)"The function name cannot be empty.");
        return editor.getLanguage() instanceof MLanguage ? MDocumentUtils.getFunctionLineNumber((BaseDocument)((BaseDocument)editor.getDocument()), (String)string) : -1;
    }

    private static boolean doesFileExistInPrivateDirectory(File file, String string) {
        assert (file != null) : "File cannot be null";
        File file2 = new File(MatlabSelectionDelegate.buildPrivatePath(file.getAbsolutePath(), string));
        return file2.exists() && file2.isFile();
    }

    private static String buildPrivatePath(String string, String string2) {
        String string3 = string.endsWith("private") ? string + File.separator + string2 : string + File.separator + "private" + File.separator + string2;
        return MLFileUtils.isMFile((String)string3) ? string3 : string3 + ".m";
    }

    private void evaluateSelection(String string) {
        try {
            MLExecuteServices.executeCommand((String)string);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.logThrowable((Throwable)outOfMemoryError);
        }
    }

    private void helpOnSelection(final Editor editor) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<KeyStrokeList> list = EditorAction.HELP_ON_SELECTION.getKeyBindings();
                KeyStrokeList keyStrokeList = !list.isEmpty() ? list.get(0) : null;
                HelpPopup.showHelp((JTextComponent)editor.getTextComponent(), (KeyStrokeList)keyStrokeList);
            }
        });
    }
}

