/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.matlab;

import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.editor.plugins.matlab.EditorSaveRunAndPublishUtils;
import com.mathworks.mde.editor.plugins.matlab.MatlabPluginUtils;
import com.mathworks.mde.editor.plugins.matlab.RunMenuItemSelectionManager;
import com.mathworks.mlservices.MatlabExecutionErrorHandler;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.data.RunConfiguration;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.datamodel.FutureFileStorageLocation;
import com.mathworks.widgets.datamodel.StorageLocationUtils;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MTree;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.netbeans.editor.BaseDocument;

public class RunMenuUtils {
    private RunMenuUtils() {
    }

    static List<RunConfiguration> getConfigurations(Editor editor, boolean bl) {
        if (editor.getStorageLocation() instanceof FutureFileStorageLocation) {
            return Collections.emptyList();
        }
        File file = MatlabPluginUtils.getBackingFile(editor);
        List<RunConfiguration> list = RunMenuUtils.getConfigurationsForFile(file);
        List<RunConfiguration> list2 = bl ? (list.isEmpty() ? Arrays.asList((RunConfiguration)ConfigurationManager.getInstance().getDefaultConfigurationForFile(file, RunConfiguration.TYPE, true)) : list) : RunMenuUtils.getConfigurationsStartingWithMostRecentlyUsed(list, file);
        return list2;
    }

    public static List<RunConfiguration> getConfigurationsForFile(File file) {
        return new ArrayList<RunConfiguration>((Collection<RunConfiguration>)ConfigurationManager.getInstance().getConfigurationsForFile(file, RunConfiguration.TYPE));
    }

    public static List<RunConfiguration> getConfigurationsStartingWithMostRecentlyUsed(List<RunConfiguration> list, File file) {
        ArrayList<RunConfiguration> arrayList = new ArrayList<RunConfiguration>();
        RunConfiguration runConfiguration = (RunConfiguration)ConfigurationManager.getInstance().getMostRecentlyActionedConfigurationForFileOrDefault(file, RunConfiguration.TYPE);
        arrayList.add(runConfiguration);
        for (RunConfiguration runConfiguration2 : list) {
            if (runConfiguration2.equals((Object)runConfiguration)) continue;
            arrayList.add(runConfiguration2);
        }
        return arrayList;
    }

    static void closeRunMenu(Component component) {
        OverlayManager overlayManager = OverlayManagers.get((Component)component);
        if (overlayManager != null) {
            overlayManager.removePopups();
        }
    }

    static String getFunctionName(Editor editor) {
        String string = StorageLocationUtils.isBackedByFile((StorageLocation)editor.getStorageLocation()) ? MatlabPath.getQualifiedFunctionOrMethodName((File)((FileStorageLocation)editor.getStorageLocation()).getFile()) : MDocumentUtils.getDefaultFilename((MTree)MDocumentUtils.getMTree((BaseDocument)((BaseDocument)editor.getDocument())));
        return string;
    }

    static String getFunctionHeader(Editor editor) {
        String string = RunMenuUtils.getFunctionName(editor);
        MTree mTree = MDocumentUtils.getMTree((BaseDocument)((BaseDocument)editor.getDocument()));
        boolean bl = false;
        for (Object object : mTree.getRoot().getListOfNextNodes()) {
            if (!object.getType().isFunction()) continue;
            bl = true;
            break;
        }
        boolean bl2 = false;
        for (MTree.Node node : mTree.getRoot().getListOfNextNodes()) {
            if (!node.getType().isClass()) continue;
            bl2 = true;
            break;
        }
        if (bl || bl2) {
            Object object;
            string = string + "(";
            object = null;
            if (bl) {
                object = MDocumentUtils.getFirstFunctionArgumentList((MTree)mTree);
            } else if (bl2) {
                object = MDocumentUtils.getClassConstructorArgumentList((MTree)mTree);
            }
            if (object != null) {
                for (int i = 0; i < object.size(); ++i) {
                    string = string + (String)object.get(i);
                    if (i == object.size() - 1) continue;
                    string = string + ", ";
                }
            }
            string = string + ")";
        }
        return string;
    }

    static Dimension getTSLabelDimension(String string) {
        FontMetrics fontMetrics = FontUtils.getFontMetrics((Font)ToolstripTheme.getInstance().getPopupDescriptionFont());
        int n = 6 + fontMetrics.stringWidth(string) + 6;
        int n2 = fontMetrics.getHeight() + 16;
        return new Dimension(n, n2);
    }

    static void applyTSStyle(JComponent jComponent) {
        jComponent.setFont(ToolstripTheme.getInstance().getPopupDescriptionFont());
        jComponent.setForeground(ToolstripTheme.getInstance().getPopupDescriptionColor());
        jComponent.setBackground(ToolstripTheme.getInstance().getPopupNonSelectedBackgroundColor());
    }

    static boolean areConfigurationsEqual(RunConfiguration runConfiguration, AbstractFileConfiguration abstractFileConfiguration) {
        return abstractFileConfiguration.equals((Object)runConfiguration);
    }

    static boolean isAutoGeneratedConfiguration(RunConfiguration runConfiguration, List<RunConfiguration> list, Editor editor) {
        boolean bl = list.size() == 1;
        RunConfiguration runConfiguration2 = RunMenuUtils.getMostRecentlyActionedConfiguration(editor);
        boolean bl2 = runConfiguration2 != null && !runConfiguration2.equals((Object)runConfiguration);
        return runConfiguration != null && bl && bl2;
    }

    static RunConfiguration getMostRecentlyActionedConfiguration(Editor editor) {
        return (RunConfiguration)ConfigurationManager.getInstance().getMostRecentlyActionedConfigurationForFileOrDefault(MatlabPluginUtils.getBackingFile(editor), RunConfiguration.TYPE);
    }

    static RunConfiguration getConfigurationWithSameExpression(String string, Editor editor) {
        RunConfiguration runConfiguration = null;
        File file = MatlabPluginUtils.getBackingFile(editor);
        List<RunConfiguration> list = RunMenuUtils.getConfigurationsForFile(file);
        for (RunConfiguration runConfiguration2 : list) {
            if (!runConfiguration2.getMatlabExpressionToRun().equals(string)) continue;
            runConfiguration = runConfiguration2;
            break;
        }
        return runConfiguration;
    }

    static RunConfiguration createConfiguration(String string, Editor editor) {
        RunConfiguration runConfiguration = (RunConfiguration)RunConfiguration.TYPE.create(((FileStorageLocation)editor.getStorageLocation()).getFile());
        runConfiguration.setMatlabExpression(string);
        return runConfiguration;
    }

    public static void setSelectionInExpression(JTextField jTextField) {
        String string = jTextField.getText();
        int n = string.indexOf(40) + 1;
        int n2 = string.lastIndexOf(41);
        if (n == -1 || n2 == -1) {
            n = 0;
            n2 = string.length();
        }
        jTextField.setSelectionStart(n);
        jTextField.setSelectionEnd(n2);
    }

    static MJLabel createNonEditableMenuItemLabel(String string) {
        MJLabel mJLabel = new MJLabel(string);
        RunMenuUtils.applyTSStyle((JComponent)mJLabel);
        mJLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        return mJLabel;
    }

    static FormLayout getMenuLayout(int n) {
        String string = "pref";
        while (n > 0) {
            string = string + ",pref";
            --n;
        }
        return new FormLayout("pref", string);
    }

    static void dismissMenuAndRunConfiguration(RunConfiguration runConfiguration, MJPanel mJPanel, Editor editor, MatlabExecutionErrorHandler matlabExecutionErrorHandler) {
        RunMenuUtils.closeRunMenu((Component)mJPanel);
        EditorSaveRunAndPublishUtils.saveFileAndDoConfigurationAction(editor, (AbstractFileConfiguration)runConfiguration, RunConfiguration.TYPE, matlabExecutionErrorHandler);
    }

    static void adjustPaintedSelection(MJPanel mJPanel, int n) {
        for (Component component : mJPanel.getComponents()) {
            ((RunMenuItemSelectionManager.SelectableMenuItem)((Object)component)).getFocusableComponent().setBackground(ToolstripTheme.getInstance().getPopupNonSelectedBackgroundColor());
        }
        if (n >= 0 && n < mJPanel.getComponentCount() && mJPanel.getComponentCount() > 0) {
            ((RunMenuItemSelectionManager.SelectableMenuItem)((Object)mJPanel.getComponent(n))).getFocusableComponent().setBackground(ToolstripTheme.getInstance().getPopupItemHoverFocusColor());
        }
    }
}

