/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.explorer;

import com.mathworks.matlab.api.explorer.ActionComponentProvider;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.MenuSection;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mde.explorer.RunConfigurationUtils;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.DynamicMenuContributor;
import com.mathworks.mlwidgets.explorer.model.actions.DynamicMenuUtils;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.util.Converter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;

public class RunConfigurationsActionProvider
implements ActionProvider {
    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return fileSystemEntry != null && !fileSystemEntry.isFolder() && fileSystemEntry.getLocation().checkExtension(new String[]{"m"});
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.getAction(CoreActionID.RUN).setLabel((Converter)new Converter<ActionInput, String>(){

            public String convert(ActionInput actionInput) {
                if (RunConfigurationUtils.isAnyFileDirty(actionInput)) {
                    return ExplorerResources.getString((String)"context.saveAndRun");
                }
                return null;
            }
        });
        actionRegistry.getAction(CoreActionID.RUN).setCode(SelectionMode.EXPLICIT_MULTIPLE_FILE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
                    try {
                        FileSystemEntry fileSystemEntry2 = MLFileSystemUtils.getMatlabAccessibleEntry((FileSystemEntry)fileSystemEntry);
                        RunConfigurationUtils.runDefaultConfiguration(new File(fileSystemEntry2.getLocation().toString()));
                    }
                    catch (IOException iOException) {}
                }
                return Status.COMPLETED;
            }
        });
        actionRegistry.getAction(CoreActionID.RUN_CONFIGURATIONS_MENU).setMenuComponentProvider(SelectionMode.EXPLICIT_SINGLE_SELECTION, new ActionComponentProvider(){

            public JComponent getComponent(ActionInput actionInput) {
                MJMenu mJMenu = new MJMenu(ExplorerResources.getString((String)"context.run.configurations"));
                ArrayList<DynamicMenuContributor<FileSystemEntry>> arrayList = new ArrayList<DynamicMenuContributor<FileSystemEntry>>();
                arrayList.add(RunConfigurationUtils.getMenuContributor());
                DynamicMenuUtils.updateMenu((MJMenu)mJMenu, arrayList, (Object[])actionInput.getSelectionArray(), RunConfigurationUtils.getSectionComparator(), (MenuSection[])RunConfigurationUtils.getSections());
                return mJMenu;
            }
        });
    }
}

