/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.find;

import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class Grep {
    private Pattern fPattern;
    private static final Charset CHARSET = Charset.defaultCharset();
    private static final CharsetDecoder DECODER = CHARSET.newDecoder();
    private static final int MAX_READ_CHUNK = 1000000;
    private ArrayList fResults = new ArrayList();
    private static final Pattern linePattern = Pattern.compile("\\r\\n|\\n|\\r");
    private static boolean sStop = false;
    private static int fPrevLineNumber = 0;

    public void compile(String string, boolean bl) throws PatternSyntaxException {
        this.fPattern = Pattern.compile(string, bl ? 2 : 0);
        sStop = false;
    }

    public void setStop(boolean bl) {
        sStop = bl;
    }

    public ArrayList grepFile(File file) {
        this.fResults.clear();
        this.fResults.ensureCapacity(1000);
        fPrevLineNumber = 0;
        if (!file.canRead()) {
            return this.fResults;
        }
        if (!file.isFile()) {
            return this.fResults;
        }
        if (!file.exists()) {
            return this.fResults;
        }
        if (file.length() > 1000000L) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                FileChannel fileChannel = fileInputStream.getChannel();
                long l = file.length();
                while (fileChannel.position() < file.length() && !sStop) {
                    l = file.length() - fileChannel.position();
                    MappedByteBuffer mappedByteBuffer = l < 1000000L ? fileChannel.map(FileChannel.MapMode.READ_ONLY, fileChannel.position(), l) : fileChannel.map(FileChannel.MapMode.READ_ONLY, fileChannel.position(), 1000000L);
                    String string = Grep.getFileEncoding();
                    CharsetDecoder charsetDecoder = DECODER;
                    if (string != null) {
                        Charset charset = Charset.forName(string);
                        charsetDecoder = charset.newDecoder();
                    }
                    this.grepInBuffer(mappedByteBuffer, charsetDecoder, this.fResults);
                    fileChannel = fileChannel.position(fileChannel.position() + 1000000L);
                }
                fileChannel.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.fResults.clear();
                fPrevLineNumber = 0;
                this.grepInFile(file, this.fResults);
            }
            catch (CharacterCodingException characterCodingException) {
                this.fResults.clear();
                fPrevLineNumber = 0;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.fResults.clear();
                fPrevLineNumber = 0;
                this.grepInFile(file, this.fResults);
            }
        } else {
            this.grepInFile(file, this.fResults);
        }
        return this.fResults;
    }

    private void grepInFile(File file, ArrayList arrayList) {
        try {
            String string;
            LineNumberReader lineNumberReader;
            Object object;
            String string2 = Grep.getFileEncoding();
            if (string2 != null) {
                object = new InputStreamReader((InputStream)new FileInputStream(file), string2);
                lineNumberReader = new LineNumberReader((Reader)object);
            } else {
                object = new FileReader(file);
                lineNumberReader = new LineNumberReader((Reader)object);
            }
            object = this.fPattern.matcher("");
            while ((string = lineNumberReader.readLine()) != null) {
                ((Matcher)object).reset(string);
                if (!((Matcher)object).find()) continue;
                String[] stringArray = new String[]{Integer.toString(lineNumberReader.getLineNumber()), string};
                arrayList.add(stringArray);
            }
            lineNumberReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String getFileEncoding() {
        String string = null;
        if (PlatformInfo.isMacintosh()) {
            string = NativeJava.getSystemCharEncoding();
        }
        return string;
    }

    private void grepInBuffer(MappedByteBuffer mappedByteBuffer, CharsetDecoder charsetDecoder, ArrayList arrayList) throws CharacterCodingException {
        CharBuffer charBuffer = charsetDecoder.decode(mappedByteBuffer);
        while (mappedByteBuffer.hasRemaining()) {
            charBuffer.put(mappedByteBuffer.getChar());
        }
        Matcher matcher = this.fPattern.matcher(charBuffer);
        String string = null;
        if (matcher.find()) {
            Matcher matcher2 = linePattern.matcher(charBuffer);
            Matcher matcher3 = null;
            int n = 0;
            String[] stringArray = new String[2];
            while (matcher2.find(n)) {
                ++fPrevLineNumber;
                string = new String(charBuffer.array(), n, matcher2.start() - n);
                if (matcher3 == null) {
                    matcher3 = this.fPattern.matcher(string);
                } else {
                    matcher3.reset(string);
                }
                if (matcher3.find()) {
                    stringArray = new String[]{Integer.toString(fPrevLineNumber), string.toString()};
                    arrayList.add(stringArray);
                }
                n = matcher2.end();
                if (matcher2.end() != charBuffer.limit()) continue;
                break;
            }
        } else {
            Matcher matcher4 = linePattern.matcher(charBuffer);
            int n = 0;
            while (matcher4.find(n)) {
                ++fPrevLineNumber;
                n = matcher4.end();
                if (matcher4.end() != charBuffer.limit()) continue;
                break;
            }
        }
    }
}

