/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.DocLocation;
import com.mathworks.help.helpui.DocSearchPageChangedListener;
import com.mathworks.help.helpui.SearchHelper;
import com.mathworks.help.helpui.suggestions.DocSuggestionProtocolHandler;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.FigurePeerWindowEvent;
import com.mathworks.hg.peer.FigurePeerWindowListener;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.RequestHandler;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.ProductFilterRequestHandler;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.CSHelpTopicMap;
import com.mathworks.mlwidgets.help.DocCenterSearchHelper;
import com.mathworks.mlwidgets.help.DocCenterUtils;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.html.DocSearchRequestHandler;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.HtmlConversionUtils;
import com.mathworks.mlwidgets.html.LinkClickedHandler;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import com.mathworks.mlwidgets.html.MatlabHtmlActions;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJDialogParent;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.SwingUtilities;

public class CSHelpViewer {
    private static CSHelpViewer sSingleton = null;
    private static CSHelpDisplay sTestDisplay = null;
    private static ExternalDisplayHandler sTestDisplayHandler = null;
    private CSHelpDisplay fCSHelpDisplay;
    private ExternalDisplayHandler fDisplayHandler;
    private MJDialog fDialog;
    private MJDialogParent fDialogParent = null;
    private Component fParentComponent = null;
    private boolean fIsParentModal = false;
    private Dimension fSize = null;
    private Point fLocation = null;
    private String fDefaultTitle = null;
    private CSHPageChangedListener fPageChangedListener;
    private CSHLinkClickedHandler fLinkClickedHandler;
    private Window fParentWindow;
    private WindowListener fParentWindowListener;

    private CSHelpViewer() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CSHelpViewer.this.fCSHelpDisplay = CSHelpViewer.getCSHelpDisplay();
                CSHelpViewer.this.fDisplayHandler = CSHelpViewer.this.getDisplayHandler();
                CSHelpViewer.this.fDefaultTitle = HelpUtils.getLocalizedString((String)"cshelpviewer.title");
                CSHelpViewer.this.parentViewerToNull();
            }
        });
    }

    static synchronized CSHelpViewer getInstance() {
        if (sSingleton == null) {
            sSingleton = new CSHelpViewer();
        }
        return sSingleton;
    }

    private static CSHelpDisplay getCSHelpDisplay() {
        if (sTestDisplay == null) {
            return new CSHelpPanelDisplay();
        }
        return sTestDisplay;
    }

    private ExternalDisplayHandler getDisplayHandler() {
        if (sTestDisplayHandler == null) {
            return new HelpBrowserDisplayHandler();
        }
        return sTestDisplayHandler;
    }

    static String getHtmlText() {
        return CSHelpViewer.getCSHelpDisplay().getHtmlText();
    }

    void displayTopic(final Object object, final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CSHelpViewer.this.showViewer(object);
                CSHelpViewer.this.fCSHelpDisplay.displayTopic(string, string2);
            }
        });
    }

    void displayFile(final Object object, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CSHelpViewer.this.showViewer(object);
                CSHelpViewer.this.fCSHelpDisplay.setCurrentLocation(string);
            }
        });
    }

    void displayTopic(String string, String string2) {
        this.displayTopic(null, string, string2);
    }

    void displayFile(String string) {
        this.displayFile(null, string);
    }

    void setLocation(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CSHelpViewer.this.fLocation = new Point(n, n2);
                if (CSHelpViewer.this.fDialog != null) {
                    CSHelpViewer.this.fDialog.setLocation(CSHelpViewer.this.fLocation);
                }
            }
        });
    }

    void setSize(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CSHelpViewer.this.fSize = new Dimension(n, n2);
                if (CSHelpViewer.this.fDialog != null) {
                    CSHelpViewer.this.fDialog.setSize(CSHelpViewer.this.fSize);
                }
            }
        });
    }

    void close() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CSHelpViewer.this.fDialog != null) {
                    CSHelpViewer.this.handleWindowClosing();
                    CSHelpViewer.this.fDialog.setVisible(false);
                }
            }
        });
    }

    private static Component getOwnerComponent(Object object) {
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        } else if (object instanceof FigurePeer) {
            FigurePeer figurePeer = (FigurePeer)object;
            component = figurePeer.getAxisComponent();
        }
        return component;
    }

    private void showViewer(Object object) {
        assert (SwingUtilities.isEventDispatchThread()) : "showViewer must be called on the EDT";
        Component component = CSHelpViewer.getOwnerComponent(object);
        if (this.isOwnerUnchanged(component)) {
            this.fDialog.setVisible(true);
            this.fDialog.toFront();
        } else if (component == null) {
            this.parentViewerToNull();
        } else {
            this.parentViewerToOwner(component);
            if (object instanceof FigurePeer) {
                FigurePeer figurePeer = (FigurePeer)object;
                figurePeer.addFigurePeerWindowListener((FigurePeerWindowListener)new CshFigurePeerWindowListener());
            }
        }
        this.handleListeners();
        this.fParentComponent = component;
    }

    private boolean isOwnerUnchanged(Component component) {
        if (this.fParentComponent != null && component != null) {
            return this.fParentComponent.equals(component);
        }
        return this.fParentComponent == null && component == null;
    }

    private void removeParent() {
        if (this.fDialog != null) {
            this.saveDialogInfo();
            this.fDialog.remove(this.fCSHelpDisplay.getComponent());
            this.fDialog.dispose();
            this.fDialog = null;
            if (this.fDialogParent != null) {
                this.fDialogParent.dispose();
                this.fDialogParent = null;
            }
        }
        if (this.fParentWindow != null && this.fParentWindowListener != null) {
            this.fParentWindow.removeWindowListener(this.fParentWindowListener);
            this.fParentWindow = null;
            this.fParentWindowListener = null;
        }
    }

    private void parentViewerToNull() {
        assert (SwingUtilities.isEventDispatchThread()) : "The context-sensitive help viewer must be reparented on the event dispatch thread.";
        this.removeParent();
        this.fDialog = new MJDialog();
        this.fIsParentModal = false;
        this.finishDialogSetup();
    }

    private void parentViewerToOwner(Component component) {
        assert (SwingUtilities.isEventDispatchThread()) : "The context-sensitive help viewer must be parented on the event dispatch thread.";
        assert (component != null) : "The context-sensitive help viewer must be parented with non-null Component.";
        this.removeParent();
        Window window = !(component instanceof Dialog) && !(component instanceof Frame) ? SwingUtilities.windowForComponent(component) : (Window)component;
        if (window == null) {
            this.parentViewerToNull();
            return;
        }
        if (window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            this.fIsParentModal = dialog.isModal();
            this.fDialog = new MJDialog(dialog);
        } else {
            this.fIsParentModal = false;
            this.fDialog = new MJDialog((Frame)window);
        }
        this.fParentWindow = window;
        this.fParentWindowListener = new ParentWindowAdapter();
        this.fParentWindow.addWindowListener(this.fParentWindowListener);
        this.finishDialogSetup();
    }

    private void finishDialogSetup() {
        assert (SwingUtilities.isEventDispatchThread()) : "The context-sensitive help viewer must be set up on the event dispatch thread.";
        if (this.fSize == null) {
            this.fSize = new Dimension(400, 400);
        }
        if (this.fLocation == null) {
            this.fLocation = new Point(20, 40);
        }
        this.fDialog.setName("CSH Dialog");
        this.fDialog.getContentPane().setLayout(new BorderLayout());
        this.fDialog.getContentPane().add(this.fCSHelpDisplay.getComponent(), "Center");
        this.fDialog.setSize(this.fSize);
        this.fDialog.setLocation(this.fLocation);
        this.fDialog.setVisible(true);
        this.fDialog.setTitle(this.fDefaultTitle);
        this.fDialog.addWindowListener((WindowListener)new CSHWindowAdapter());
        if (PlatformInfo.isWindows()) {
            this.fDialogParent = new MJDialogParent(this.fDefaultTitle);
            this.fDialogParent.setVisible(true);
            this.fDialogParent.attachDialog((Dialog)this.fDialog);
        }
    }

    private void handleListeners() {
        if (this.fPageChangedListener == null) {
            this.fPageChangedListener = new CSHPageChangedListener();
            this.fCSHelpDisplay.addPageChangedListener(this.fPageChangedListener);
        }
        if (this.fIsParentModal) {
            if (this.fLinkClickedHandler != null) {
                this.fCSHelpDisplay.removeLinkClickedHandler(this.fLinkClickedHandler);
                this.fLinkClickedHandler = null;
            }
        } else if (this.fLinkClickedHandler == null) {
            this.fLinkClickedHandler = new CSHLinkClickedHandler();
            this.fCSHelpDisplay.setLinkClickedHandler(this.fLinkClickedHandler);
        }
    }

    private void removeListeners() {
        if (this.fPageChangedListener != null) {
            this.fCSHelpDisplay.removePageChangedListener(this.fPageChangedListener);
            this.fPageChangedListener = null;
        }
        if (this.fLinkClickedHandler != null) {
            this.fCSHelpDisplay.removeLinkClickedHandler(this.fLinkClickedHandler);
            this.fLinkClickedHandler = null;
        }
    }

    private void saveDialogInfo() {
        this.fSize = this.fDialog.getSize();
        this.fLocation = this.fDialog.getLocation();
    }

    private void handleWindowClosing() {
        this.removeListeners();
        this.fCSHelpDisplay.setCurrentLocation("about:blank");
        this.fParentComponent = null;
    }

    private String getCurrentLocation() {
        if (this.fCSHelpDisplay != null) {
            return this.fCSHelpDisplay.getCurrentLocation();
        }
        return null;
    }

    private Component getParentComponent() {
        return this.fParentComponent;
    }

    private static void setTestHelpViewer(CSHelpDisplay cSHelpDisplay) {
        sTestDisplay = cSHelpDisplay;
    }

    private static void setTestDisplayHandler(ExternalDisplayHandler externalDisplayHandler) {
        sTestDisplayHandler = externalDisplayHandler;
    }

    private class HelpBrowserDisplayHandler
    implements ExternalDisplayHandler {
        private HelpBrowserDisplayHandler() {
        }

        @Override
        public void displayPage(String string) {
            if (string.startsWith("docsuggestion:")) {
                return;
            }
            if (string.contains("?qdoc=")) {
                MLHelpServices.docSearch((String)string.substring(string.indexOf("qdoc=") + 5));
                return;
            }
            if (!HTMLUtils.isTargetOnPage((String)CSHelpViewer.this.fCSHelpDisplay.getCurrentLocation(), (String)string)) {
                MLHelpServices.setCurrentLocation((String)string);
            }
        }
    }

    public static interface ExternalDisplayHandler {
        public void displayPage(String var1);
    }

    private static class CSHelpPanelDisplay
    implements CSHelpDisplay {
        private HtmlComponent<MatlabHtmlActions> fHtmlComponent = HtmlComponentFactory.buildHtmlComponent((HtmlComponentFactory.HtmlComponentType[])new HtmlComponentFactory.HtmlComponentType[]{HtmlComponentFactory.HtmlComponentType.FOLLOW_PREFERENCE, HtmlComponentFactory.HtmlComponentType.HTMLPANEL, HtmlComponentFactory.HtmlComponentType.HTMLRENDERER});

        private CSHelpPanelDisplay() {
            CSHelpViewerVisitor cSHelpViewerVisitor = new CSHelpViewerVisitor();
            HtmlConversionUtils.visitBrowser(this.fHtmlComponent, (HtmlConversionUtils.BrowserVisitor)cSHelpViewerVisitor);
            this.fHtmlComponent.getComponent().setName("CSH HTML Renderer");
            this.fHtmlComponent.disableNavigation();
        }

        private static void addHandlersForInstalledDoc(MJHtmlPanel mJHtmlPanel) {
            DocCenterSearchHelper docCenterSearchHelper = DocCenterSearchHelper.getInstance();
            mJHtmlPanel.addPageChangedListener((PageChangedListener)new DocSearchPageChangedListener((HtmlComponent)mJHtmlPanel, (SearchHelper)docCenterSearchHelper, HelpPrefs.DEFAULT_DOC_RELEASE));
            mJHtmlPanel.addRequestHandler((RequestHandler)new DocSuggestionProtocolHandler((HtmlComponent)mJHtmlPanel, (SearchHelper)docCenterSearchHelper, HelpPrefs.getDocCenterRoot()));
            mJHtmlPanel.addRequestHandler((RequestHandler)new ProductFilterRequestHandler((HtmlComponent)mJHtmlPanel, docCenterSearchHelper.getDocumentationSet()));
        }

        @Override
        public void setCurrentLocation(String string) {
            String string2 = string;
            if (HelpPrefs.isUsingDocCenterBrowser()) {
                if (HelpPrefs.getDocCenterLocation().equals((Object)DocLocation.INSTALLED)) {
                    string2 = HelpUtils.getLocalizedFilename((String)string);
                } else if (!string2.equals("about:blank")) {
                    string2 = DocCenterUtils.buildDocCenterUrl((String)string2.replace(File.separatorChar, '/'));
                }
            } else {
                string2 = HelpUtils.getLocalizedFilename((String)string);
            }
            this.fHtmlComponent.setCurrentLocation(string2);
        }

        @Override
        public void displayTopic(String string, String string2) {
            CSHelpTopicMap cSHelpTopicMap = new CSHelpTopicMap(string);
            if (cSHelpTopicMap.exists()) {
                String string3 = cSHelpTopicMap.mapID(string2);
                if (string3 != null) {
                    this.setCurrentLocation(string3);
                } else {
                    this.fHtmlComponent.setHtmlText("<html><body>Topic " + string2 + " in " + cSHelpTopicMap.getFilePath() + " not found.</body></html>");
                }
            } else {
                this.fHtmlComponent.setHtmlText("<html><body>Mapfile not found: " + cSHelpTopicMap.getFilePath() + "</body></html>");
            }
        }

        @Override
        public String getCurrentLocation() {
            return this.fHtmlComponent.getCurrentLocation();
        }

        @Override
        public Component getComponent() {
            return this.fHtmlComponent.getComponent();
        }

        @Override
        public void addPageChangedListener(PageChangedListener pageChangedListener) {
            this.fHtmlComponent.addPageChangedListener(pageChangedListener);
        }

        @Override
        public void removePageChangedListener(PageChangedListener pageChangedListener) {
            this.fHtmlComponent.removePageChangedListener(pageChangedListener);
        }

        @Override
        public void setLinkClickedHandler(LinkClickedHandler linkClickedHandler) {
            HtmlConversionUtils.addLinkClickedHandler(this.fHtmlComponent, (LinkClickedHandler)linkClickedHandler);
        }

        @Override
        public void removeLinkClickedHandler(LinkClickedHandler linkClickedHandler) {
            HtmlConversionUtils.removeLinkClickedHandler(this.fHtmlComponent, (LinkClickedHandler)linkClickedHandler);
        }

        @Override
        public String getHtmlText() {
            return this.fHtmlComponent.getHtmlText();
        }

        private static class CSHelpViewerVisitor
        implements HtmlConversionUtils.BrowserVisitor {
            private CSHelpViewerVisitor() {
            }

            public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
                if (HelpPrefs.getDocCenterLocation() == DocLocation.INSTALLED) {
                    CSHelpPanelDisplay.addHandlersForInstalledDoc(mJHtmlPanel);
                }
            }

            public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
                hTMLRenderer.addRequestHandler((RequestHandler)new DocSearchRequestHandler(hTMLRenderer, (SearchHelper)DocCenterSearchHelper.getInstance(), HelpPrefs.DEFAULT_DOC_RELEASE));
            }
        }
    }

    public static interface CSHelpDisplay {
        public void setCurrentLocation(String var1);

        public void displayTopic(String var1, String var2);

        public String getCurrentLocation();

        public Component getComponent();

        public void addPageChangedListener(PageChangedListener var1);

        public void removePageChangedListener(PageChangedListener var1);

        public void setLinkClickedHandler(LinkClickedHandler var1);

        public void removeLinkClickedHandler(LinkClickedHandler var1);

        public String getHtmlText();
    }

    private class ParentWindowAdapter
    extends WindowAdapter {
        private ParentWindowAdapter() {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            super.windowClosed(windowEvent);
            CSHelpViewer.this.saveDialogInfo();
            CSHelpViewer.this.handleWindowClosing();
        }
    }

    private class CSHWindowAdapter
    extends WindowAdapter {
        private CSHWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            super.windowClosing(windowEvent);
            CSHelpViewer.this.saveDialogInfo();
            CSHelpViewer.this.handleWindowClosing();
        }
    }

    private class CSHLinkClickedHandler
    implements LinkClickedHandler {
        private CSHLinkClickedHandler() {
        }

        public void linkClicked(final String string) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CSHelpViewer.this.fDisplayHandler.displayPage(string);
                }
            });
        }
    }

    private class CSHPageChangedListener
    implements PageChangedListener {
        private CSHPageChangedListener() {
        }

        public void pageChanged(PageChangedEvent pageChangedEvent) {
            String string = pageChangedEvent.getTitle();
            String string2 = pageChangedEvent.getFullUrl();
            if (CSHelpViewer.this.fDialog != null) {
                if (string == null || string.trim().length() == 0 || string2 != null && string2.equals(HTMLUtils.getFilenameFromURL((String)string))) {
                    CSHelpViewer.this.fDialog.setTitle(CSHelpViewer.this.fDefaultTitle);
                } else {
                    CSHelpViewer.this.fDialog.setTitle(string);
                }
                if (PlatformInfo.isWindows() && CSHelpViewer.this.fDialogParent != null) {
                    CSHelpViewer.this.fDialogParent.setTitle(string);
                }
            }
        }
    }

    private class CshFigurePeerWindowListener
    implements FigurePeerWindowListener {
        private CshFigurePeerWindowListener() {
        }

        public void figurePeerWindowEvent(FigurePeerWindowEvent figurePeerWindowEvent) {
            if (figurePeerWindowEvent.getID() == 201) {
                CSHelpViewer.this.close();
            }
        }
    }
}

