/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.html.HtmlUtils;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.help.ClassicHelpBrowserHandler;
import com.mathworks.mde.help.DocCenterBrowserHandler;
import com.mathworks.mde.help.HelpBrowser;
import com.mathworks.mde.help.HelpBrowserHandler;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.MLHelpBrowser;
import com.mathworks.mde.help.MLHelpBrowserActiveTab;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.PageChangedListener;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HelpLocator
extends MJDialog {
    public static String ONLINE_HELP_PREFIX = HelpPrefs.getDocCenterDomain() + "help";
    private static final HelpLocatorHelper sClassicDocHelpLocatorHelper = new ClassicDocHelpLocatorHelper();
    private static final HelpLocatorHelper sDocCenterHelpLocatorHelper = new DocCenterHelpLocatorHelper();
    private static HelpLocatorInfoProvider sClassicDocInfoProvider = new ClassicDocHelpServicesProvider();
    private static HelpLocatorInfoProvider sDocCenterInfoProvider = new DocCenterHelpServicesProvider();
    private static HelpLocator sHelpLocator = null;
    private static String sWebAddress = null;
    private static String sInstalledAddress = null;
    private static HelpLocatorHelper sHelpLocatorHelper;
    private static HelpLocatorInfoProvider sHelpInfoProvider;
    private static HelpLocatorPrefsProvider sHelpPrefsProvider;
    private MyDTClientAdapterListener fMyDTClientAdapterListener;
    private MJTextField fWebTextField;
    private MJTextField fInstalledTextField;
    private MJButton fWebGoButton;
    private boolean fInvokedFromDocCenter;

    public static synchronized void invokeFromClassicHelp(MJFrame mJFrame) {
        HelpLocator.invoke(mJFrame, false);
    }

    public static synchronized void invokeFromDocCenter(MJFrame mJFrame) {
        HelpLocator.invoke(mJFrame, true);
    }

    private static synchronized void invoke(MJFrame mJFrame, boolean bl) {
        boolean bl2 = false;
        if (sHelpLocator == null || sHelpLocator.isInvokedFromDocCenter() != bl) {
            bl2 = true;
        }
        if (bl2) {
            if (sHelpLocator != null) {
                sHelpLocator.closeHelpLocator();
            }
            sHelpLocator = new HelpLocator(mJFrame, bl);
        } else {
            sHelpLocator.toFront();
        }
    }

    public static synchronized HelpLocator getInstance() {
        return sHelpLocator;
    }

    private HelpLocator(MJFrame mJFrame, boolean bl) {
        super((Frame)mJFrame);
        this.setInvokedFromDocCenter(bl);
        HelpLocator.setDependencyProviders(this.isInvokedFromDocCenter());
        this.setTitle(com.mathworks.mlwidgets.help.HelpUtils.getLocalizedString((String)"helplocator.title"));
        this.setName("HelpLocator");
        this.setResizable(false);
        HelpLocator.setAddresses();
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new FormLayout("p, 3dlu, p:grow, 3dlu, p", "p, 3dlu, p, 8dlu, p, 3dlu, p, 8dlu, pref:grow, 8dlu, p"));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)mJPanel, "Center");
        CellConstraints cellConstraints = new CellConstraints();
        String string = com.mathworks.mlwidgets.help.HelpUtils.getLocalizedString((String)"helplocator.install.description");
        ImageIcon imageIcon = CommonIcon.HELP.getIcon();
        mJPanel.add((Component)new MJLabel((Icon)imageIcon), (Object)cellConstraints.xy(1, 1));
        MJLabel mJLabel = new MJLabel(string);
        mJLabel.getAccessibleContext().setAccessibleName(string);
        mJPanel.add((Component)mJLabel, (Object)cellConstraints.xy(3, 1));
        this.fInstalledTextField = new MJTextField();
        this.fInstalledTextField.setName("InstalledTextField");
        this.fInstalledTextField.setEditable(false);
        this.fInstalledTextField.setCursor(Cursor.getPredefinedCursor(2));
        mJPanel.add((Component)this.fInstalledTextField, (Object)cellConstraints.xyw(1, 3, 3));
        String string2 = com.mathworks.mlwidgets.help.HelpUtils.getLocalizedString((String)"helplocator.web.description");
        ImageIcon imageIcon2 = CommonIcon.WEB.getIcon();
        mJPanel.add((Component)new MJLabel((Icon)imageIcon2), (Object)cellConstraints.xy(1, 5));
        MJLabel mJLabel2 = new MJLabel(string2);
        mJLabel2.getAccessibleContext().setAccessibleName(string2);
        mJPanel.add((Component)mJLabel2, (Object)cellConstraints.xy(3, 5));
        this.fWebTextField = new MJTextField();
        this.fWebTextField.setName("WebTextField");
        this.fWebTextField.setEditable(false);
        this.fWebTextField.setCursor(Cursor.getPredefinedCursor(2));
        mJPanel.add((Component)this.fWebTextField, (Object)cellConstraints.xyw(1, 7, 3));
        this.fWebGoButton = new MJButton(com.mathworks.mlwidgets.help.HelpUtils.getLocalizedString((String)"helplocator.go"));
        this.fWebGoButton.setName("WebGoButton");
        this.fWebGoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpLocator.this.executeCommand("web('" + HelpLocator.getWebAddress() + "','-browser')");
            }
        });
        mJPanel.add((Component)this.fWebGoButton, (Object)cellConstraints.xy(5, 7));
        this.updateComponents();
        mJPanel.add((Component)new MJLabel((Icon)DialogIcon.INFO.getIcon(), 2), (Object)cellConstraints.xy(1, 9, CellConstraints.LEFT, CellConstraints.TOP));
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(com.mathworks.mlwidgets.help.HelpUtils.getLocalizedString((String)"helplocator.release.warning"), true);
        mJMultilineLabel.setSize(new Dimension(this.fWebTextField.getPreferredSize().width, 1));
        mJPanel.add((Component)mJMultilineLabel, (Object)cellConstraints.xy(3, 9));
        ButtonActionListener buttonActionListener = new ButtonActionListener();
        MJButton mJButton = new MJButton(HelpUtils.getLocalizedString((String)"helplocator.close"));
        mJButton.setName("Close");
        mJButton.setActionCommand("Close");
        mJButton.addActionListener((ActionListener)buttonActionListener);
        MJButton mJButton2 = new MJButton(HelpUtils.getLocalizedString((String)"helplocator.help"));
        mJButton2.setName("Help");
        mJButton2.setActionCommand("Help");
        mJButton2.addActionListener((ActionListener)buttonActionListener);
        mJPanel.add((Component)ButtonBarFactory.buildCloseHelpBar((JButton)mJButton, (JButton)mJButton2), (Object)cellConstraints.xyw(1, 11, 5));
        sHelpInfoProvider.registerPageChangedListener(sHelpLocatorHelper.getPageChangedListener());
        sHelpLocatorHelper.registerActiveTabListener(sHelpLocatorHelper.getActiveTabListener());
        this.fMyDTClientAdapterListener = new MyDTClientAdapterListener();
        MLDesktop.getInstance().addClientListener(sHelpLocatorHelper.getClientTitle(), (DTClientListener)this.fMyDTClientAdapterListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HelpLocator.this.closeHelpLocator();
            }
        });
        this.pack();
        this.setLocationRelativeTo((Component)mJFrame);
        this.setVisible(true);
    }

    private boolean isInvokedFromDocCenter() {
        return this.fInvokedFromDocCenter;
    }

    private void setInvokedFromDocCenter(boolean bl) {
        this.fInvokedFromDocCenter = bl;
    }

    static boolean isValidClassicHelpLocation(String string, String string2) {
        return string.contains(string2) && !string.endsWith("/begin_here.html") && !string.endsWith("/nofunc.html");
    }

    public static void setAddresses() {
        String string;
        String string2;
        String string3 = sHelpInfoProvider.getDocRoot();
        if (HTMLUtils.needsEncoding((String)string3)) {
            string3 = HTMLUtils.encodeUrl((String)string3);
        }
        if (HTMLUtils.needsEncoding((String)(string2 = sHelpInfoProvider.getCurrentLocation()))) {
            string2 = HTMLUtils.encodeUrl((String)string2);
        }
        if (sHelpLocatorHelper.isValidLocation(string = sHelpLocatorHelper.removeLocalizedPath(string2), string3)) {
            sInstalledAddress = "web([docroot '" + sHelpLocatorHelper.getDocTail(string, string3) + "'])";
            sWebAddress = ONLINE_HELP_PREFIX + sHelpLocatorHelper.getDocTail(string2, string3);
        } else {
            sInstalledAddress = "";
            sWebAddress = "";
        }
    }

    private static void resetAddresses() {
        HelpLocator.setAddresses();
        HelpLocator helpLocator = HelpLocator.getInstance();
        if (helpLocator != null) {
            helpLocator.updateComponents();
        }
    }

    private void updateComponents() {
        String string;
        String string2 = HelpLocator.getWebAddress();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = HelpLocator.getInstalledAddress()) == null) {
            string = "";
        }
        this.fWebTextField.setText(string2);
        this.fInstalledTextField.setText(string);
        this.fWebGoButton.setEnabled(string2.length() > 0);
    }

    private void executeCommand(final String string) {
        Matlab.whenMatlabReady((Runnable)new Runnable(){

            @Override
            public void run() {
                HelpLocator.this.doMatlabEval(string);
            }
        });
    }

    private synchronized void doMatlabEval(String string) {
        new Matlab().evalConsoleOutput(string);
    }

    private synchronized void closeHelpLocator() {
        MLDesktop.getInstance().removeClientListener(sHelpLocatorHelper.getClientTitle(), (DTClientListener)this.fMyDTClientAdapterListener);
        sHelpInfoProvider.removePageChangedListener(sHelpLocatorHelper.getPageChangedListener());
        sHelpLocatorHelper.removeActiveTabListener(sHelpLocatorHelper.getActiveTabListener());
        this.dispose();
        this.fMyDTClientAdapterListener = null;
        sHelpLocator = null;
    }

    public static synchronized void setPrefsProviderAndUpdatePrefix(HelpLocatorPrefsProvider helpLocatorPrefsProvider) {
        HelpLocator.setHelpPrefsProvider(helpLocatorPrefsProvider);
        HelpLocator.updatePrefix();
    }

    private static void setHelpPrefsProvider(HelpLocatorPrefsProvider helpLocatorPrefsProvider) {
        sHelpPrefsProvider = helpLocatorPrefsProvider;
    }

    public static synchronized HelpLocatorPrefsProvider getHelpPrefsProvider() {
        return sHelpPrefsProvider;
    }

    private static void updatePrefix() {
        String string = HelpLocator.removeReleaseFromPrefix(ONLINE_HELP_PREFIX);
        String string2 = HelpLocator.getHelpPrefsProvider().getDocRelease();
        if (string2 != null && !string2.isEmpty()) {
            string = string + "/releases/" + string2;
        }
        if (!string.equalsIgnoreCase(ONLINE_HELP_PREFIX)) {
            ONLINE_HELP_PREFIX = string;
        }
    }

    private static String removeReleaseFromPrefix(String string) {
        Pattern pattern = Pattern.compile("(.*)[\\\\/]releases[\\\\/]R20\\d\\d[ab]");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return string;
    }

    public static synchronized void setDependencyProviders(boolean bl) {
        sHelpInfoProvider = bl ? HelpLocator.getDocCenterInfoProvider() : HelpLocator.getClassicDocInfoProvider();
        sHelpLocatorHelper = bl ? sDocCenterHelpLocatorHelper : sClassicDocHelpLocatorHelper;
    }

    public static synchronized void setClassicDocInfoProvider(HelpLocatorInfoProvider helpLocatorInfoProvider) {
        sClassicDocInfoProvider = helpLocatorInfoProvider;
    }

    public static synchronized HelpLocatorInfoProvider getClassicDocInfoProvider() {
        return sClassicDocInfoProvider;
    }

    public static synchronized void setDocCenterInfoProvider(HelpLocatorInfoProvider helpLocatorInfoProvider) {
        sDocCenterInfoProvider = helpLocatorInfoProvider;
    }

    public static synchronized HelpLocatorInfoProvider getDocCenterInfoProvider() {
        return sDocCenterInfoProvider;
    }

    public static String getWebAddress() {
        return sWebAddress;
    }

    public static String getInstalledAddress() {
        return sInstalledAddress;
    }

    static {
        HelpLocator.setPrefsProviderAndUpdatePrefix(new HelpPrefsProvider());
    }

    private static class DocCenterHelpServicesProvider
    implements HelpLocatorInfoProvider {
        private MLHelpBrowser iHelpBrowser;
        private final HelpBrowserHandler fDocCenterHandler = new DocCenterBrowserHandler();

        private DocCenterHelpServicesProvider() {
        }

        @Override
        public void registerPageChangedListener(Object object) {
            assert (object instanceof PageChangedListener);
            this.iHelpBrowser = MLHelpBrowserActiveTab.getActiveHelpBrowserTab();
            this.iHelpBrowser.addPageChangedListener((PageChangedListener)object);
        }

        @Override
        public void removePageChangedListener(Object object) {
            assert (object instanceof PageChangedListener);
            if (this.iHelpBrowser != null) {
                this.iHelpBrowser.removePageChangedListener((PageChangedListener)object);
            }
            this.iHelpBrowser = null;
        }

        @Override
        public String getCurrentLocation() {
            return this.fDocCenterHandler.getCurrentLocation();
        }

        @Override
        public String getDocRoot() {
            String string = this.getCurrentLocation();
            return HelpBrowserUtils.isWebAddress((String)string) ? HelpPrefs.getDocCenterWebRoot() : HelpPrefs.getDocRoot();
        }
    }

    private static class ClassicDocHelpServicesProvider
    implements HelpLocatorInfoProvider {
        private final HelpBrowserHandler iClassicHelpBrowserHandler = new ClassicHelpBrowserHandler();

        private ClassicDocHelpServicesProvider() {
        }

        @Override
        public void registerPageChangedListener(Object object) {
            assert (object instanceof com.mathworks.mlwidgets.html.PageChangedListener);
            HelpBrowser.getInstance().getHelpPanel().getHTMLRenderer().addPageChangedListener((com.mathworks.mlwidgets.html.PageChangedListener)object);
        }

        @Override
        public void removePageChangedListener(Object object) {
            assert (object instanceof com.mathworks.mlwidgets.html.PageChangedListener);
            HelpBrowser.getInstance().getHelpPanel().getHTMLRenderer().removePageChangedListener((com.mathworks.mlwidgets.html.PageChangedListener)object);
        }

        @Override
        public String getCurrentLocation() {
            return this.iClassicHelpBrowserHandler.getCurrentLocation();
        }

        @Override
        public String getDocRoot() {
            return MLHelpServices.getDocRoot();
        }
    }

    private static class DocCenterHelpLocatorHelper
    implements HelpLocatorHelper {
        private PageChangedListener iPageChangedListener = new DocCenterPageChangedListener();
        private ChangeListener iActiveTabListener = new DoccenterActiveTabListener();

        private DocCenterHelpLocatorHelper() {
        }

        @Override
        public String getClientTitle() {
            return "Doc Center";
        }

        @Override
        public String removeLocalizedPath(String string) {
            return com.mathworks.mlwidgets.help.HelpUtils.removeLocalizedPath((String)string);
        }

        @Override
        public String getDocTail(String string, String string2) {
            string = HtmlUtils.getBaseUrl((String)string);
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            String string3 = string2;
            if (HelpBrowserUtils.isWebAddress((String)string) && !string.contains(string2)) {
                string3 = this.getRedirectDocRoot(string2);
                assert (string.contains(string3));
            }
            String string4 = string.substring(string.indexOf(string3) + string3.length());
            return string4;
        }

        @Override
        public Object getPageChangedListener() {
            return this.iPageChangedListener;
        }

        @Override
        public Object getActiveTabListener() {
            return this.iActiveTabListener;
        }

        @Override
        public void registerActiveTabListener(Object object) {
            if (object instanceof ChangeListener) {
                MLHelpBrowserActiveTab.addListener((ChangeListener)object);
            }
        }

        @Override
        public void removeActiveTabListener(Object object) {
            if (object instanceof ChangeListener) {
                MLHelpBrowserActiveTab.removeListener((ChangeListener)object);
            }
        }

        @Override
        public boolean isValidLocation(String string, String string2) {
            if (string.endsWith("/begin_here.html") || string.endsWith("/nofunc.html")) {
                return false;
            }
            return string.contains(string2) || HelpBrowserUtils.isWebAddress((String)string) && string.contains(this.getRedirectDocRoot(string2));
        }

        private String getRedirectDocRoot(String string) {
            if (string == null) {
                return null;
            }
            return HelpLocator.removeReleaseFromPrefix(string);
        }

        private static class DoccenterActiveTabListener
        implements ChangeListener {
            private DoccenterActiveTabListener() {
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                HelpLocator.getInstance().closeHelpLocator();
            }
        }

        private static class DocCenterPageChangedListener
        implements PageChangedListener {
            private DocCenterPageChangedListener() {
            }

            public void pageChanged(PageChangedEvent pageChangedEvent) {
                HelpLocator.resetAddresses();
            }
        }
    }

    private static class ClassicDocHelpLocatorHelper
    implements HelpLocatorHelper {
        private com.mathworks.mlwidgets.html.PageChangedListener iPageChangedListener = new ClassicDocPageChangedListener();

        private ClassicDocHelpLocatorHelper() {
        }

        @Override
        public String getClientTitle() {
            return "Help";
        }

        @Override
        public String removeLocalizedPath(String string) {
            return com.mathworks.mlwidgets.help.HelpUtils.removeLocalizedPath((String)string);
        }

        @Override
        public String getDocTail(String string, String string2) {
            String string3 = string.substring(string.indexOf(string2) + string2.length());
            if (string3.contains("help.jar!/")) {
                string3 = string3.replaceFirst("help.jar!/", "");
            }
            return string3;
        }

        @Override
        public Object getPageChangedListener() {
            return this.iPageChangedListener;
        }

        @Override
        public Object getActiveTabListener() {
            return null;
        }

        @Override
        public void registerActiveTabListener(Object object) {
        }

        @Override
        public void removeActiveTabListener(Object object) {
        }

        @Override
        public boolean isValidLocation(String string, String string2) {
            return HelpLocator.isValidClassicHelpLocation(string, string2);
        }

        private static class ClassicDocPageChangedListener
        implements com.mathworks.mlwidgets.html.PageChangedListener {
            private ClassicDocPageChangedListener() {
            }

            public void pageChanged(PageChangedListener.PageChangedEvent pageChangedEvent) {
                HelpLocator.resetAddresses();
            }
        }
    }

    private static class HelpPrefsProvider
    implements HelpLocatorPrefsProvider {
        private HelpPrefsProvider() {
        }

        @Override
        public String getDocRelease() {
            return HelpPrefs.DEFAULT_DOC_RELEASE;
        }
    }

    public static interface HelpLocatorInfoProvider {
        public String getCurrentLocation();

        public String getDocRoot();

        public void registerPageChangedListener(Object var1);

        public void removePageChangedListener(Object var1);
    }

    public static interface HelpLocatorPrefsProvider {
        public String getDocRelease();
    }

    private static interface HelpLocatorHelper {
        public String getClientTitle();

        public String removeLocalizedPath(String var1);

        public String getDocTail(String var1, String var2);

        public Object getPageChangedListener();

        public Object getActiveTabListener();

        public void registerActiveTabListener(Object var1);

        public void removeActiveTabListener(Object var1);

        public boolean isValidLocation(String var1, String var2);
    }

    private class MyDTClientAdapterListener
    extends DTClientAdapter {
        private MyDTClientAdapterListener() {
        }

        public void clientClosing(DTClientEvent dTClientEvent) {
            HelpLocator.this.closeHelpLocator();
        }

        public void clientDocking(DTClientEvent dTClientEvent) {
            HelpLocator.this.closeHelpLocator();
        }

        public void clientUndocking(DTClientEvent dTClientEvent) {
            HelpLocator.this.closeHelpLocator();
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Close")) {
                HelpLocator.this.closeHelpLocator();
            } else if (string.equals("Help")) {
                String string2 = com.mathworks.mlwidgets.help.HelpUtils.getMapfileName((String)"matlab", (String)"matlab_env");
                MLHelpServices.cshDisplayTopic((Object)((Object)HelpLocator.this), (String)string2, (String)"matlab_env_help_page_location");
            }
        }
    }
}

