/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.json.JsonArray;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductBaseCodeMap;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.ProtocolRequestHandler;
import com.mathworks.mlwidgets.help.DocCenterUtils;
import com.mathworks.product.util.ProductIdentifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class ProductFilterRequestHandler
extends ProtocolRequestHandler {
    private final HtmlComponent fHtmlComponent;
    private final DocumentationSet fDocSet;
    private static final String URL_PREFIX = "productfilter";

    ProductFilterRequestHandler(HtmlComponent htmlComponent, DocumentationSet documentationSet) {
        super(new String[]{URL_PREFIX});
        this.fHtmlComponent = htmlComponent;
        this.fDocSet = documentationSet;
    }

    protected void handleMatchedUrl(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string3 = string.substring(ProductFilterRequestHandler.URL_PREFIX.length() + 1);
                String string2 = ProductFilterRequestHandler.this.getShortNameJsonArray();
                ProductFilterRequestHandler.this.fHtmlComponent.executeScript(String.format("%s(%s);", string3, string2));
            }
        };
        new Thread(runnable).start();
    }

    private String getShortNameJsonArray() {
        JsonArray jsonArray = new JsonArray();
        Collection<DocProduct> collection = this.getSelectedInstalledProducts();
        for (DocProduct docProduct : collection) {
            jsonArray.addString(docProduct.getShortName());
        }
        if (DocCenterUtils.hasClassicDoc()) {
            jsonArray.addString("3p");
        }
        return jsonArray.getJsonString();
    }

    private Collection<DocProduct> getSelectedInstalledProducts() {
        ProductBaseCodeMap productBaseCodeMap = this.fDocSet.getBaseCodeMap();
        if (productBaseCodeMap != null) {
            Set<String> set = ProductFilterRequestHandler.getSelectedBaseCodes();
            return productBaseCodeMap.getDocProductsForBaseCodes(set);
        }
        return this.fDocSet.getAllProducts();
    }

    private static Set<String> getSelectedBaseCodes() {
        HashSet<String> hashSet = new HashSet<String>();
        Collection collection = DocCenterUtils.getSelectedInstalledProductIdentifiers();
        for (ProductIdentifier productIdentifier : collection) {
            hashSet.add(productIdentifier.getBaseCode());
        }
        return hashSet;
    }
}

