/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.licensing.borrowing.view;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.mathworks.mde.licensing.borrowing.controller.BorrowController;
import com.mathworks.mde.licensing.borrowing.view.AutoBorrowView;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJSpinner;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class AutoBorrowViewImpl
implements AutoBorrowView,
ActionListener {
    public static final String NUMDAYS_SPINNER_NAME = "NumDaysSpinner";
    public static final String DATESTRING_LABEL_NAME = "DateString";
    public static final String TURNON_BUTTON_NAME = "OnButton";
    public static final String TURNOFF_BUTTON_NAME = "OffButton";
    public static final String AUTOBORROW_PANEL_NAME = "AutoBorrowPanel";
    public static final String INFO_MULTILINELABEL_NAME = "InfoMultilineLabel";
    private BorrowController fController;
    private MJMultilineLabel fInfoText;
    private MJButton fBorrowOnButton;
    private MJButton fBorrowOffButton;
    private MJLabel fDateString = new MJLabel();
    private MJSpinner fNumDaysSpinner;
    private SpinnerNumberModel fSpinnerModel;
    private JPanel autoBorrowPanel;
    private int fBorrowForDays = 1;
    private final int fInitDays = 1;
    private final int fMinDays = 1;
    private final int fMaxDays = 30;
    private final int fStepValue = 1;
    private ResourceBundle fResBundle;

    public AutoBorrowViewImpl(BorrowController borrowController, ResourceBundle resourceBundle) {
        this.fController = borrowController;
        this.fResBundle = resourceBundle;
        this.fNumDaysSpinner = new MJSpinner();
        this.fNumDaysSpinner.setName(NUMDAYS_SPINNER_NAME);
        this.fSpinnerModel = new SpinnerNumberModel(1, 1, 30, 1);
        this.fDateString.setName(DATESTRING_LABEL_NAME);
    }

    private JPanel buildSubPanel() {
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.PREFERRED, 0.0), new ColumnSpec((Size)Sizes.DLUX3), new ColumnSpec(ColumnSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new ColumnSpec((Size)Sizes.DLUX3), new ColumnSpec(ColumnSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new ColumnSpec((Size)Sizes.DLUX7), new ColumnSpec(ColumnSpec.DEFAULT, (Size)Sizes.PREFERRED, 1.0), new ColumnSpec((Size)Sizes.DLUX3), new ColumnSpec(ColumnSpec.DEFAULT, (Size)Sizes.PREFERRED, 1.0)};
        RowSpec[] rowSpecArray = new RowSpec[]{new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.dluY((int)10)), new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.DLUY9), new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.DLUY4), new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.DLUY9), new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 1.0)};
        FormLayout formLayout = new FormLayout(columnSpecArray, rowSpecArray);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator(this.fResBundle.getString("autoborrow.title"), cellConstraints.xyw(1, 1, 9));
        panelBuilder.addLabel(this.fResBundle.getString("borrow.period.text"), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.createNumberSpinner(), cellConstraints.xy(3, 3));
        this.updateBorrowDateString();
        panelBuilder.add((Component)this.fDateString, cellConstraints.xy(5, 3));
        this.createButtons();
        JPanel jPanel = ButtonBarFactory.buildRightAlignedBar((JButton)this.fBorrowOnButton, (JButton)this.fBorrowOffButton);
        panelBuilder.add((Component)jPanel, cellConstraints.xyw(1, 5, 9));
        panelBuilder.addSeparator("", cellConstraints.xyw(1, 7, 9));
        panelBuilder.add((Component)this.createInfoPanel(), cellConstraints.xyw(1, 9, 9));
        return panelBuilder.getPanel();
    }

    private JSpinner createNumberSpinner() {
        this.fNumDaysSpinner.setModel((SpinnerModel)this.fSpinnerModel);
        JComponent jComponent = this.fNumDaysSpinner.getEditor();
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
        jFormattedTextField.setEditable(false);
        jFormattedTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ((JFormattedTextField)focusEvent.getSource()).getCaret().setVisible(true);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ((JFormattedTextField)focusEvent.getSource()).getCaret().setVisible(false);
            }
        });
        this.fNumDaysSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                Integer n = (Integer)jSpinner.getValue();
                AutoBorrowViewImpl.this.fBorrowForDays = n;
                AutoBorrowViewImpl.this.updateBorrowDateString();
            }
        });
        return this.fNumDaysSpinner;
    }

    private void updateBorrowDateString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.fResBundle.getString("borrow.date.string.until");
        MessageFormat messageFormat = new MessageFormat(string);
        Object[] objectArray = new Object[]{this.getDisplayDateString()};
        stringBuffer.append(messageFormat.format(objectArray));
        this.fDateString.setText(stringBuffer.toString());
        this.fDateString.revalidate();
        this.fDateString.repaint();
    }

    private void createButtons() {
        this.fBorrowOnButton = new MJButton(this.fResBundle.getString("button.turnborrowon"));
        this.fBorrowOnButton.setName(TURNON_BUTTON_NAME);
        this.fBorrowOnButton.setMnemonic(78);
        this.fBorrowOnButton.setActionCommand("ON");
        this.fBorrowOnButton.addActionListener((ActionListener)this);
        this.fBorrowOffButton = new MJButton(this.fResBundle.getString("button.turnborrowoff"));
        this.fBorrowOffButton.setName(TURNOFF_BUTTON_NAME);
        this.fBorrowOffButton.setMnemonic(79);
        this.fBorrowOffButton.setActionCommand("OFF");
        this.fBorrowOffButton.addActionListener((ActionListener)this);
    }

    private JComponent createInfoPanel() {
        this.fInfoText = new MJMultilineLabel(this.fResBundle.getString("autoborrow.on.messageline1"), true);
        this.fInfoText.setName(INFO_MULTILINELABEL_NAME);
        this.fInfoText.append(this.fResBundle.getString("autoborrow.on.messageline2"));
        this.fInfoText.append(this.fResBundle.getString("autoborrow.on.messageline3"));
        this.fInfoText.setVisible(false);
        return this.fInfoText;
    }

    @Override
    public JPanel createSubPanelView() {
        this.autoBorrowPanel = this.buildSubPanel();
        this.autoBorrowPanel.setName(AUTOBORROW_PANEL_NAME);
        this.disableOffButton();
        return this.autoBorrowPanel;
    }

    @Override
    public void enableOnButton() {
        this.fBorrowOnButton.setEnabled(true);
    }

    @Override
    public void disableOnButton() {
        this.fBorrowOnButton.setEnabled(false);
    }

    @Override
    public void enableOffButton() {
        this.fBorrowOffButton.setEnabled(true);
    }

    @Override
    public void disableOffButton() {
        this.fBorrowOffButton.setEnabled(false);
    }

    @Override
    public void enableDaysSpinner() {
        this.fNumDaysSpinner.setEnabled(true);
    }

    @Override
    public void disableDaysSpinner() {
        this.fNumDaysSpinner.setEnabled(false);
    }

    @Override
    public void showInfoPanel() {
        this.fInfoText.setVisible(true);
    }

    @Override
    public void hideInfoPanel() {
        this.fInfoText.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ON")) {
            this.fController.turnBorrowModeOn();
        }
        if (actionEvent.getActionCommand().equals("OFF")) {
            try {
                this.autoBorrowPanel.setCursor(Cursor.getPredefinedCursor(3));
                this.fController.turnBorrowModeOff();
            }
            finally {
                this.autoBorrowPanel.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    @Override
    public int getNumDaysSelected() {
        return this.fBorrowForDays;
    }

    private String getDisplayDateString() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, this.fBorrowForDays - 1);
        Date date = calendar.getTime();
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        String string = dateFormat.format(date);
        return string;
    }
}

