/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.licensing.borrowing.view;

import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import com.mathworks.mde.licensing.borrowing.view.SelectableFeature;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.ResourceBundle;

public final class BorrowTableFormat
implements AdvancedTableFormat<SelectableFeature>,
WritableTableFormat<SelectableFeature> {
    private ResourceBundle fResBundle;

    public BorrowTableFormat(ResourceBundle resourceBundle) {
        this.fResBundle = resourceBundle;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return this.fResBundle.getString("table.col.productname");
            }
            case 2: {
                return this.fResBundle.getString("table.col.inuse");
            }
            case 3: {
                return this.fResBundle.getString("table.col.borrowstatus");
            }
            case 4: {
                return this.fResBundle.getString("table.col.returndate");
            }
        }
        throw new IllegalStateException();
    }

    public Object getColumnValue(SelectableFeature selectableFeature, int n) {
        switch (n) {
            case 0: {
                return selectableFeature.getSelected();
            }
            case 1: {
                return selectableFeature.getProductName();
            }
            case 2: {
                if (selectableFeature.isLicenseInUse()) {
                    return this.fResBundle.getString("table.col.inuse.value");
                }
                return "";
            }
            case 3: {
                return selectableFeature.getCurrentFeatureStatus();
            }
            case 4: {
                return this.formatDateString(selectableFeature.getReturnDate());
            }
        }
        throw new IllegalStateException();
    }

    private String formatDateString(String string) {
        String string2 = "";
        if (string.equals("")) {
            return string;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
            Date date = simpleDateFormat.parse(string);
            DateFormat dateFormat = DateFormat.getDateInstance(2);
            string2 = dateFormat.format(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return string2;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    public Comparator getColumnComparator(int n) {
        return null;
    }

    public boolean isEditable(SelectableFeature selectableFeature, int n) {
        if (n == 0) {
            return selectableFeature.canBorrow();
        }
        return false;
    }

    public SelectableFeature setColumnValue(SelectableFeature selectableFeature, Object object, int n) {
        switch (n) {
            case 0: {
                selectableFeature.setSelected((Boolean)object);
                break;
            }
            default: {
                throw new IllegalStateException("column " + n + " is not editable");
            }
        }
        return selectableFeature;
    }
}

