/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

class Introspector {
    Introspector() {
    }

    public static boolean isHidden(Field field) {
        int n = field.getModifiers();
        return Modifier.isPrivate(n) || Modifier.isStatic(n);
    }

    public static boolean isString(Class clazz) {
        return "java.lang.String".equals(clazz.getName());
    }

    public static boolean isWrapper(Class clazz) {
        String string = clazz.getName();
        return "java.lang.Integer".equals(string) || "java.lang.Boolean".equals(string) || "java.lang.Byte".equals(string) || "java.lang.Char".equals(string) || "java.lang.Double".equals(string) || "java.lang.Float".equals(string) || "java.lang.Long".equals(string);
    }

    public static String getTypename(Class clazz, boolean bl) {
        String string = "";
        while (clazz.isArray()) {
            string = string + "[]";
            clazz = clazz.getComponentType();
        }
        if (bl) {
            return clazz.getName() + string;
        }
        return Introspector.extractClassName(clazz.getName()) + string;
    }

    public static String getModifierString(int n) {
        if (n == 0) {
            return "";
        }
        return Modifier.toString(n) + " ";
    }

    public static String getFieldString(Field field, boolean bl, boolean bl2) {
        String string = "";
        if (bl) {
            string = string + Introspector.getModifierString(field.getModifiers());
        }
        string = string + Introspector.getTypename(field.getType(), bl2);
        string = string + " ";
        string = string + field.getName();
        return string;
    }

    public static String extractClassName(String string) {
        int n = string.lastIndexOf(".");
        return string.substring(n + 1);
    }
}

