/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import com.sun.jini.example.browser.Introspector;
import com.sun.jini.example.browser.MetalIcons;
import java.io.Serializable;
import java.lang.reflect.Field;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;

class ObjectNode
extends DefaultMutableTreeNode
implements Serializable {
    private String name;
    private Object obj;
    private Class clazz;
    private String fieldName;
    private int arrayIndex = -1;
    private boolean editable = false;
    private boolean isLeaf;
    private boolean isAdministrable;
    private boolean isControllable;
    private boolean isRoot = false;
    private boolean isEntryTop = false;
    private static Icon[] icons = new Icon[6];

    public ObjectNode(boolean bl) {
        this("Root node", "".getClass(), null, -1, false);
        this.isAdministrable = bl;
        this.isRoot = true;
        this.isEntryTop = true;
    }

    public ObjectNode(Object object, boolean bl) {
        this(object, object.getClass(), null, -1, false);
        this.isControllable = bl;
        this.isEntryTop = true;
    }

    public ObjectNode(Object object, Class clazz, String string, boolean bl) {
        this(object, clazz, string, -1, bl);
    }

    public ObjectNode(Object object, Class clazz, String string, int n, boolean bl) {
        this.obj = object;
        this.clazz = clazz;
        this.fieldName = string;
        this.arrayIndex = n;
        this.isLeaf = bl;
        super.setAllowsChildren(!bl);
        this.setNodeName();
    }

    private void setNodeName() {
        this.name = Introspector.getTypename(this.clazz, false);
        if (this.fieldName != null) {
            this.name = this.name + " " + this.fieldName;
        }
        if (this.isLeaf) {
            String string = "";
            if (this.arrayIndex >= 0) {
                string = string + "[" + this.arrayIndex + "]";
            }
            string = string + "=";
            if (this.clazz.isPrimitive()) {
                string = string + "" + this.obj;
                this.editable = false;
            } else if (Introspector.isWrapper(this.clazz)) {
                string = string + "" + this.obj;
                this.editable = true;
            } else if (Introspector.isString(this.clazz)) {
                string = string + "\"" + this.obj + "\"";
                this.editable = true;
            } else {
                string = string + (this.obj == null ? "null" : this.obj.toString());
            }
            this.name = this.name + string;
        } else if (this.obj == null) {
            this.name = this.name + "=null";
        }
        super.setUserObject(this.name);
    }

    public void add(ObjectNode objectNode) {
        objectNode.setAdministrable(this.isAdministrable);
        if (!this.isRoot) {
            objectNode.setControllable(this.isControllable);
        }
        super.add(objectNode);
    }

    public Object getEntryTop() {
        ObjectNode objectNode = this;
        while (!(objectNode = (ObjectNode)objectNode.getParent()).isEntryTop()) {
        }
        return objectNode.getObject();
    }

    protected boolean isEntryTop() {
        return this.isEntryTop;
    }

    public void setObjectRecursive() throws NoSuchFieldException, IllegalAccessException {
        ObjectNode objectNode = this;
        do {
            objectNode = (ObjectNode)objectNode.getParent();
            Object object = objectNode.getObject();
            Field field = object.getClass().getField(this.fieldName);
            field.set(object, this.obj);
        } while (!objectNode.isEntryTop());
    }

    public String getTitle() {
        return this.name;
    }

    public Icon getIcon() {
        if (this.isAdministrable && this.isControllable) {
            if (this.isLeaf) {
                return icons[3];
            }
            return icons[0];
        }
        if (this.isLeaf) {
            return icons[4];
        }
        return icons[1];
    }

    public void setUserObject(Object object) {
        if (object instanceof String) {
            this.name = (String)object;
        }
        super.setUserObject(object);
    }

    public Object getUserObject() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getObject() {
        return this.obj;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isAdministrable() {
        return this.isAdministrable;
    }

    public void setAdministrable(boolean bl) {
        this.isAdministrable = bl;
    }

    public boolean isControllable() {
        return this.isControllable;
    }

    public void setControllable(boolean bl) {
        this.isControllable = bl;
    }

    public Object setValue(Object object) throws NumberFormatException {
        Object object2;
        String string = this.clazz.getName();
        Object object3 = null;
        if (object instanceof String || object == null) {
            object2 = (String)object;
            if (string.equals("java.lang.Integer")) {
                object3 = new Integer((String)object2);
            } else if (string.equals("java.lang.Boolean")) {
                object3 = new Boolean((String)object2);
            } else if (string.equals("java.lang.Byte")) {
                object3 = new Byte((String)object2);
            } else if (string.equals("java.lang.Character")) {
                object3 = new Character(((String)object2).charAt(0));
            } else if (string.equals("java.lang.Double")) {
                object3 = new Double((String)object2);
            } else if (string.equals("java.lang.Float")) {
                object3 = new Float((String)object2);
            } else if (string.equals("java.lang.Long")) {
                object3 = new Long((String)object2);
            } else if (string.equals("java.lang.String")) {
                object3 = new String((String)object2);
            }
        } else if (object.getClass().equals(this.obj.getClass())) {
            object3 = object;
        }
        object2 = this.obj;
        this.obj = object3;
        this.setNodeName();
        return object2;
    }

    static {
        ObjectNode.icons[0] = MetalIcons.getBlueFolderIcon();
        ObjectNode.icons[1] = MetalIcons.getGrayFolderIcon();
        ObjectNode.icons[2] = MetalIcons.getOrangeFolderIcon();
        ObjectNode.icons[3] = MetalIcons.getBlueFileIcon();
        ObjectNode.icons[4] = MetalIcons.getGrayFileIcon();
        ObjectNode.icons[5] = MetalIcons.getOrangeFileIcon();
    }
}

