/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.config.Config;
import com.sun.jini.example.browser.Browser;
import com.sun.jini.example.browser.EntryTreePanel;
import com.sun.jini.example.browser.ObjectNode;
import com.sun.jini.logging.Levels;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.rmi.server.ExportException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import net.jini.admin.Administrable;
import net.jini.admin.JoinAdmin;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.export.Exporter;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lookup.DiscoveryAdmin;
import net.jini.lookup.entry.ServiceControlled;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

class ServiceEditor
extends JFrame {
    private static final Logger logger = Browser.logger;
    private Browser browser;
    private ServiceItem item;
    private ServiceRegistrar registrar;
    protected Object adminRoot = null;
    protected JoinAdmin jadmin = null;
    private ServiceTemplate stmpl;
    private NotifyReceiver receiver;
    private Lease elease = null;
    private long eventID = 0L;
    private long seqNo = Long.MAX_VALUE;
    private AttributeTreePanel attrPanel;
    private static final int MINIMUM_WINDOW_WIDTH = 320;
    static /* synthetic */ Class class$net$jini$export$Exporter;

    public ServiceEditor(ServiceItem serviceItem, ServiceRegistrar serviceRegistrar, Browser browser) {
        super("ServiceItem Editor");
        this.item = serviceItem;
        this.registrar = serviceRegistrar;
        this.browser = browser;
        try {
            this.adminRoot = browser.adminPreparer.prepareProxy(((Administrable)serviceItem.service).getAdmin());
            this.jadmin = (JoinAdmin)this.adminRoot;
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "obtaining service admin failed", throwable);
        }
        this.attrPanel = new AttributeTreePanel();
        try {
            this.stmpl = new ServiceTemplate(serviceItem.serviceID, new Class[]{serviceItem.service.getClass()}, new Entry[0]);
            this.receiver = new NotifyReceiver();
            this.setupNotify();
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "event registration failed", throwable);
            this.cancelNotify();
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JoinMenuBar(), "North");
        this.getContentPane().add((Component)this.attrPanel, "Center");
        this.validate();
        this.pack();
        this.setSize(this.getSize().width < 320 ? 320 : this.getSize().width, this.getSize().height);
        Rectangle rectangle = browser.getBounds();
        Dimension dimension = this.getPreferredSize();
        int n = rectangle.x + (rectangle.width - dimension.width) / 2;
        int n2 = rectangle.y + (rectangle.height - dimension.height) / 2;
        this.setLocation(n < 0 ? 0 : n, n2 < 0 ? 0 : n2);
    }

    protected void cancelNotify() {
        if (this.elease != null) {
            try {
                this.browser.leaseMgr.cancel(this.elease);
            }
            catch (Throwable throwable) {
                logger.log(Levels.HANDLED, "event cancellation failed", throwable);
            }
            this.elease = null;
            this.seqNo = Long.MAX_VALUE;
        }
    }

    protected void setupNotify() {
        if (this.registrar != null) {
            try {
                EventRegistration eventRegistration = this.registrar.notify(this.stmpl, 7, this.receiver.proxy, null, -1L);
                this.elease = (Lease)this.browser.leasePreparer.prepareProxy(eventRegistration.getLease());
                this.browser.leaseMgr.renewUntil(this.elease, -1L, new Browser.LeaseNotify());
                this.eventID = eventRegistration.getID();
                this.seqNo = eventRegistration.getSequenceNumber();
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "event registration failed", throwable);
            }
        }
    }

    class LocatorLister
    extends ListerFrame {
        public LocatorLister(String string) {
            super(string);
        }

        protected void initListModel() {
            try {
                LookupLocator[] lookupLocatorArray = ServiceEditor.this.jadmin.getLookupLocators();
                for (int i = 0; i < lookupLocatorArray.length; ++i) {
                    this.model.addElement(lookupLocatorArray[i]);
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "obtaining locators failed", throwable);
            }
        }

        protected String getAddMessage() {
            return "Enter a new locator's URL";
        }

        protected String getRemoveMessage(Object[] objectArray) {
            StringBuffer stringBuffer = new StringBuffer();
            if (objectArray.length > 1) {
                stringBuffer.append("Remove these locators : ");
            } else {
                stringBuffer.append("Remove a locator : ");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(objectArray[i].toString());
            }
            return stringBuffer.toString();
        }

        protected void addItems(String[] stringArray) {
            LookupLocator[] lookupLocatorArray = new LookupLocator[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    lookupLocatorArray[i] = new LookupLocator(stringArray[i]);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    JOptionPane.showMessageDialog(this, "\"" + stringArray[i] + "\": " + malformedURLException.getMessage(), "Bad Locator", 2);
                    return;
                }
            }
            try {
                ServiceEditor.this.jadmin.addLookupLocators(lookupLocatorArray);
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "adding locators failed", throwable);
            }
        }

        protected void removeItems(Object[] objectArray) {
            LookupLocator[] lookupLocatorArray = new LookupLocator[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                lookupLocatorArray[i] = (LookupLocator)objectArray[i];
            }
            try {
                ServiceEditor.this.jadmin.removeLookupLocators(lookupLocatorArray);
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "removing locators failed", throwable);
            }
        }
    }

    class GroupItem {
        public String group;

        public GroupItem(String string) {
            this.group = string.equals("public") ? "" : string;
        }

        public String toString() {
            if ("".equals(this.group)) {
                return "public";
            }
            return this.group;
        }
    }

    class MemberGroupLister
    extends ListerFrame {
        public MemberGroupLister(String string) {
            super(string);
        }

        protected void initListModel() {
            try {
                String[] stringArray = ((DiscoveryAdmin)ServiceEditor.this.adminRoot).getMemberGroups();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.model.addElement(new GroupItem(stringArray[i]));
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "obtaining groups failed", throwable);
            }
        }

        protected String getAddMessage() {
            return "Enter adding group(s)";
        }

        protected String getRemoveMessage(Object[] objectArray) {
            StringBuffer stringBuffer = new StringBuffer();
            if (objectArray.length > 1) {
                stringBuffer.append("Remove these groups : ");
            } else {
                stringBuffer.append("Remove a group : ");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((GroupItem)objectArray[i]).toString());
            }
            return stringBuffer.toString();
        }

        protected void addItems(String[] stringArray) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = (ServiceEditor)ServiceEditor.this.new GroupItem((String)stringArray[i]).group;
            }
            try {
                ((DiscoveryAdmin)ServiceEditor.this.adminRoot).addMemberGroups(stringArray2);
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "adding groups failed", throwable);
            }
        }

        protected void removeItems(Object[] objectArray) {
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = ((GroupItem)objectArray[i]).group;
            }
            try {
                ((DiscoveryAdmin)ServiceEditor.this.adminRoot).removeMemberGroups(stringArray);
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "removing groups failed", throwable);
            }
        }
    }

    class GroupLister
    extends ListerFrame {
        public GroupLister(String string) {
            super(string);
        }

        protected void initListModel() {
            try {
                String[] stringArray = ServiceEditor.this.jadmin.getLookupGroups();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.model.addElement(new GroupItem(stringArray[i]));
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "obtaining groups failed", throwable);
            }
        }

        protected String getAddMessage() {
            return "Enter adding group(s)";
        }

        protected String getRemoveMessage(Object[] objectArray) {
            StringBuffer stringBuffer = new StringBuffer();
            if (objectArray.length > 1) {
                stringBuffer.append("Remove these groups : ");
            } else {
                stringBuffer.append("Remove a group : ");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((GroupItem)objectArray[i]).toString());
            }
            return stringBuffer.toString();
        }

        protected void addItems(String[] stringArray) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = (ServiceEditor)ServiceEditor.this.new GroupItem((String)stringArray[i]).group;
            }
            try {
                ServiceEditor.this.jadmin.addLookupGroups(stringArray2);
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "adding groups failed", throwable);
            }
        }

        protected void removeItems(Object[] objectArray) {
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = ((GroupItem)objectArray[i]).group;
            }
            try {
                ServiceEditor.this.jadmin.removeLookupGroups(stringArray);
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "removing groups failed", throwable);
            }
        }
    }

    abstract class ListerFrame
    extends JFrame {
        private JList listBox;
        private JScrollPane scrollPane;
        protected DefaultListModel model;
        private DefaultListModel dummyModel;
        private JButton addButton;
        private JButton removeButton;
        private JButton closeButton;

        public ListerFrame(String string) {
            super(string);
            this.model = new DefaultListModel();
            this.dummyModel = new DefaultListModel();
            this.getContentPane().setLayout(new BorderLayout());
            this.listBox = new JList(this.model);
            this.listBox.setFixedCellHeight(20);
            this.scrollPane = new JScrollPane(this.listBox);
            this.getContentPane().add((Component)this.scrollPane, "Center");
            JPanel jPanel = new JPanel();
            this.addButton = new JButton("Add");
            this.addButton.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = JOptionPane.showInputDialog(ListerFrame.this, (Object)ListerFrame.this.getAddMessage());
                    if (string != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        String[] stringArray = new String[stringTokenizer.countTokens()];
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray[i] = stringTokenizer.nextToken().trim();
                        }
                        ListerFrame.this.addItems(stringArray);
                        ListerFrame.this.resetListModel();
                        ListerFrame.this.scrollPane.validate();
                    }
                }
            }));
            jPanel.add(this.addButton);
            this.removeButton = new JButton("Remove");
            this.removeButton.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = ListerFrame.this.listBox.getSelectedValues();
                    if (objectArray == null || objectArray.length == 0) {
                        JOptionPane.showMessageDialog(ListerFrame.this, "No items are selected", "Warning", 2);
                        return;
                    }
                    int n = JOptionPane.showConfirmDialog(ListerFrame.this, ListerFrame.this.getRemoveMessage(objectArray), "Query", 0);
                    if (n == 0) {
                        ListerFrame.this.removeItems(objectArray);
                        ListerFrame.this.resetListModel();
                        ListerFrame.this.scrollPane.validate();
                    }
                }
            }));
            jPanel.add(this.removeButton);
            this.closeButton = new JButton("Close");
            this.closeButton.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ListerFrame.this.setVisible(false);
                }
            }));
            jPanel.add(this.closeButton);
            this.getContentPane().add((Component)jPanel, "South");
            this.pack();
        }

        public void showFrame() {
            this.resetListModel();
            Rectangle rectangle = ServiceEditor.this.getBounds();
            Dimension dimension = this.getPreferredSize();
            this.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            this.setVisible(true);
        }

        private void resetListModel() {
            this.listBox.setModel(this.dummyModel);
            this.model.removeAllElements();
            this.initListModel();
            this.listBox.setModel(this.model);
            this.listBox.clearSelection();
            this.listBox.ensureIndexIsVisible(0);
            this.listBox.repaint();
            this.listBox.revalidate();
        }

        protected abstract void initListModel();

        protected abstract String getAddMessage();

        protected abstract String getRemoveMessage(Object[] var1);

        protected abstract void addItems(String[] var1);

        protected abstract void removeItems(Object[] var1);
    }

    class AttributeTreePanel
    extends EntryTreePanel {
        public AttributeTreePanel() {
            super(true);
            this.tree.addMouseListener(ServiceEditor.this.browser.wrap(new DoubleClicker(this)));
            this.refreshPanel();
        }

        protected Entry[] getEntryArray() {
            try {
                return ServiceEditor.this.jadmin.getLookupAttributes();
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "obtaining attributes failed", throwable);
                return null;
            }
        }

        protected void receiveNotify() {
            String[] stringArray = new String[]{"Attributes have been modified by another client or service provider itself.", "Do you want refresh attributes ?"};
            int n = JOptionPane.showConfirmDialog(this, stringArray, "Query", 0);
            if (n == 0) {
                this.refreshPanel();
            }
        }

        public void editField(ObjectNode objectNode) {
            String string = JOptionPane.showInputDialog(this, "Input a new value", "Modify a field", 3);
            if (string != null) {
                Entry entry = this.cloneEntry((Entry)objectNode.getEntryTop());
                Object object = null;
                object = string.length() == 0 ? objectNode.setValue(null) : objectNode.setValue(string);
                try {
                    objectNode.setObjectRecursive();
                    Entry entry2 = (Entry)objectNode.getEntryTop();
                    ServiceEditor.this.cancelNotify();
                    ServiceEditor.this.jadmin.modifyLookupAttributes(new Entry[]{entry}, new Entry[]{entry2});
                    ServiceEditor.this.setupNotify();
                    this.model.nodeChanged(objectNode);
                }
                catch (Throwable throwable) {
                    logger.log(Level.INFO, "attribute modification failed", throwable);
                    try {
                        objectNode.setValue(object);
                        objectNode.setObjectRecursive();
                    }
                    catch (Throwable throwable2) {
                        logger.log(Levels.HANDLED, "node reset failed", throwable2);
                    }
                    this.model.nodeChanged(objectNode);
                    JOptionPane.showMessageDialog(this, throwable.getMessage(), throwable.getClass().getName(), 0);
                }
            }
        }

        public void addAttr() {
            String string = JOptionPane.showInputDialog(this, "Input an entry class name", "Add an attribute", 3);
            if (string != null && string.length() != 0) {
                try {
                    Class<?> clazz = Class.forName(string);
                    Object obj = clazz.newInstance();
                    if (!(obj instanceof Entry)) {
                        JOptionPane.showMessageDialog(this, "Does not implement Entry interface", "Unacceptable Class", 2);
                    } else if (obj instanceof ServiceControlled) {
                        JOptionPane.showMessageDialog(this, "Implements ServiceControlled interface", "Unacceptable Class", 2);
                    } else {
                        ServiceEditor.this.cancelNotify();
                        ServiceEditor.this.jadmin.addLookupAttributes(new Entry[]{(Entry)obj});
                        ObjectNode objectNode = new ObjectNode(obj, true);
                        this.root.add(objectNode);
                        this.recursiveObjectTree(objectNode);
                        ServiceEditor.this.setupNotify();
                        this.model.nodesWereInserted(this.root, new int[]{this.model.getIndexOfChild(this.root, objectNode)});
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    JOptionPane.showMessageDialog(this, classNotFoundException.getMessage(), "Class Not Found", 2);
                }
                catch (Throwable throwable) {
                    logger.log(Level.INFO, "adding attribute failed", throwable);
                    JOptionPane.showMessageDialog(this, throwable.getMessage(), throwable.getClass().getName(), 2);
                }
            }
        }

        public void removeAttr() {
            ObjectNode objectNode = (ObjectNode)this.tree.getLastSelectedPathComponent();
            if (objectNode == null) {
                JOptionPane.showMessageDialog(this, "Select an attribute folder to remove.", "Warning", 2);
                return;
            }
            if (!objectNode.isControllable()) {
                JOptionPane.showMessageDialog(this, "This attribute is under service provider's control.", "Warning", 2);
                return;
            }
            if (!objectNode.isEntryTop()) {
                JOptionPane.showMessageDialog(this, "Select a top of attribute folder.", "Warning", 2);
                return;
            }
            Entry entry = (Entry)objectNode.getObject();
            int n = JOptionPane.showConfirmDialog(this, new String[]{"Remove attribute:", entry.toString()}, "Query", 0);
            if (n == 0) {
                try {
                    ServiceEditor.this.cancelNotify();
                    ServiceEditor.this.jadmin.modifyLookupAttributes(new Entry[]{entry}, new Entry[]{null});
                    ServiceEditor.this.setupNotify();
                    int n2 = this.root.getIndex(objectNode);
                    this.root.remove(objectNode);
                    this.model.nodesWereRemoved(this.root, new int[]{n2}, new Object[]{objectNode});
                    objectNode = null;
                }
                catch (Throwable throwable) {
                    logger.log(Level.INFO, "attribute removal failed", throwable);
                    JOptionPane.showMessageDialog(this, throwable.getMessage(), throwable.getClass().getName(), 0);
                }
            }
        }

        private Entry cloneEntry(Entry entry) {
            try {
                Class<?> clazz = entry.getClass();
                Entry entry2 = (Entry)clazz.newInstance();
                Field[] fieldArray = clazz.getFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    if (!this.usableField(fieldArray[i])) continue;
                    fieldArray[i].set(entry2, fieldArray[i].get(entry));
                }
                return entry2;
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "duplicating entry failed", throwable);
                return null;
            }
        }

        private boolean usableField(Field field) {
            Class<?> clazz = field.getDeclaringClass();
            if (clazz.isPrimitive()) {
                throw new IllegalArgumentException("primitive types not allowed in an Entry");
            }
            int n = field.getModifiers();
            return 0 == (n & 0x98);
        }

        private Entry generateTemplate(Entry entry) {
            try {
                Class<?> clazz = entry.getClass();
                Entry entry2 = (Entry)clazz.newInstance();
                Field[] fieldArray = clazz.getFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    fieldArray[i].set(entry2, null);
                }
                return entry2;
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "instantiating template failed", throwable);
                return null;
            }
        }

        class DoubleClicker
        extends MouseAdapter {
            AttributeTreePanel parent;

            public DoubleClicker(AttributeTreePanel attributeTreePanel2) {
                this.parent = attributeTreePanel2;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    JTree jTree = (JTree)mouseEvent.getSource();
                    TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        return;
                    }
                    ObjectNode objectNode = (ObjectNode)treePath.getLastPathComponent();
                    if (objectNode.isLeaf()) {
                        if (!objectNode.isControllable()) {
                            JOptionPane.showMessageDialog(AttributeTreePanel.this, "This attribute is under service provider's control.", "Warning", 2);
                        } else if (objectNode.isEditable() && ((ObjectNode)objectNode.getParent()).isEntryTop()) {
                            this.parent.editField(objectNode);
                        } else {
                            JOptionPane.showMessageDialog(AttributeTreePanel.this, "This field is not editable.", "Warning", 2);
                        }
                    }
                    jTree.scrollPathToVisible(treePath);
                }
            }
        }
    }

    class JoinMenuBar
    extends JMenuBar {
        public JoinMenuBar() {
            JMenu jMenu = this.add(new JMenu("File"));
            JMenuItem jMenuItem = jMenu.add(new JMenuItem("Show Info"));
            jMenuItem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Class[] classArray = Browser.getInterfaces(((ServiceEditor)((JoinMenuBar)JoinMenuBar.this).ServiceEditor.this).item.service.getClass());
                    String[] stringArray = new String[3 + classArray.length];
                    stringArray[0] = "ServiceID: " + ((ServiceEditor)((JoinMenuBar)JoinMenuBar.this).ServiceEditor.this).item.serviceID;
                    stringArray[1] = "Service Instance: " + ((ServiceEditor)((JoinMenuBar)JoinMenuBar.this).ServiceEditor.this).item.service.getClass().getName();
                    stringArray[2] = classArray.length == 1 ? "Implemented Interface:" : "Implemented Interfaces:";
                    for (int i = 0; i < classArray.length; ++i) {
                        stringArray[3 + i] = "    " + classArray[i].getName();
                    }
                    JOptionPane.showMessageDialog(ServiceEditor.this, stringArray, "ServiceItem Information", 1);
                }
            }));
            jMenuItem = jMenu.add(new JMenuItem("Refresh"));
            jMenuItem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServiceEditor.this.attrPanel.refreshPanel();
                }
            }));
            jMenuItem = jMenu.add(new JMenuItem("Close"));
            jMenuItem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServiceEditor.this.cancelNotify();
                    ServiceEditor.this.dispose();
                }
            }));
            JMenu jMenu2 = this.add(new JMenu("Edit"));
            jMenuItem = jMenu2.add(new JMenuItem("Add Attribute..."));
            jMenuItem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServiceEditor.this.attrPanel.addAttr();
                }
            }));
            jMenuItem = jMenu2.add(new JMenuItem("Remove Attribute"));
            jMenuItem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServiceEditor.this.attrPanel.removeAttr();
                }
            }));
            JMenu jMenu3 = this.add(new JMenu("Admin"));
            jMenuItem = jMenu3.add(new JMenuItem("Joining groups..."));
            jMenuItem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new GroupLister("Joining Groups").showFrame();
                }
            }));
            jMenuItem = jMenu3.add(new JMenuItem("Joining locators..."));
            jMenuItem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new LocatorLister("Joining Locators").showFrame();
                }
            }));
            jMenu3.addSeparator();
            jMenuItem = jMenu3.add(new JMenuItem("Member groups..."));
            jMenuItem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new MemberGroupLister("Member Groups").showFrame();
                }
            }));
            if (!(ServiceEditor.this.adminRoot instanceof DiscoveryAdmin)) {
                jMenuItem.setEnabled(false);
            }
            jMenuItem = jMenu3.add(new JMenuItem("Unicast port..."));
            jMenuItem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        String[] stringArray = new String[]{"Current port is " + ((DiscoveryAdmin)((JoinMenuBar)JoinMenuBar.this).ServiceEditor.this.adminRoot).getUnicastPort(), "Input a new value"};
                        String string = JOptionPane.showInputDialog(ServiceEditor.this, stringArray, "Unicast Port", 3);
                        if (string == null) {
                            return;
                        }
                        try {
                            int n = Integer.parseInt(string);
                            ((DiscoveryAdmin)((JoinMenuBar)JoinMenuBar.this).ServiceEditor.this.adminRoot).setUnicastPort(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            JOptionPane.showMessageDialog(ServiceEditor.this, string + " is not acceptable.", "Error", 0);
                        }
                        catch (Throwable throwable) {
                            logger.log(Level.INFO, "setting unicast port failed", throwable);
                            JOptionPane.showMessageDialog(ServiceEditor.this, throwable.getMessage(), throwable.getClass().getName(), 0);
                        }
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.INFO, "getting unicast port failed", throwable);
                        JOptionPane.showMessageDialog(ServiceEditor.this, throwable.getMessage(), throwable.getClass().getName(), 0);
                    }
                }
            }));
            if (!(ServiceEditor.this.adminRoot instanceof DiscoveryAdmin)) {
                jMenuItem.setEnabled(false);
            }
            jMenu3.addSeparator();
            jMenuItem = jMenu3.add(new JMenuItem("Destroy"));
            jMenuItem.addActionListener(ServiceEditor.this.browser.wrap(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (JOptionPane.showConfirmDialog(ServiceEditor.this, "Are you sure to destroy this service?", "Query", 0) == 0) {
                        try {
                            ((DestroyAdmin)((JoinMenuBar)JoinMenuBar.this).ServiceEditor.this.adminRoot).destroy();
                            ServiceEditor.this.cancelNotify();
                            ServiceEditor.this.dispose();
                        }
                        catch (Throwable throwable) {
                            logger.log(Level.INFO, "service destroy failed", throwable);
                            JOptionPane.showMessageDialog(ServiceEditor.this, throwable.getMessage(), throwable.getClass().getName(), 0);
                        }
                    }
                }
            }));
            if (!(ServiceEditor.this.adminRoot instanceof DestroyAdmin)) {
                jMenuItem.setEnabled(false);
            }
        }
    }

    private class NotifyReceiver
    implements RemoteEventListener,
    ServerProxyTrust {
        private final Exporter exporter;
        final RemoteEventListener proxy;

        public NotifyReceiver() throws ConfigurationException, ExportException {
            this.exporter = (Exporter)Config.getNonNullEntry(((ServiceEditor)ServiceEditor.this).browser.config, "com.sun.jini.example.browser", "listenerExporter", class$net$jini$export$Exporter == null ? (class$net$jini$export$Exporter = ServiceEditor.class$("net.jini.export.Exporter")) : class$net$jini$export$Exporter, new BasicJeriExporter(TcpServerEndpoint.getInstance(0), new BasicILFactory()));
            this.proxy = (RemoteEventListener)this.exporter.export(this);
        }

        public void notify(final RemoteEvent remoteEvent) {
            SwingUtilities.invokeLater(ServiceEditor.this.browser.wrap(new Runnable(){

                public void run() {
                    if (ServiceEditor.this.eventID == remoteEvent.getID() && ServiceEditor.this.seqNo < remoteEvent.getSequenceNumber()) {
                        ServiceEditor.this.seqNo = remoteEvent.getSequenceNumber();
                        ServiceEditor.this.attrPanel.receiveNotify();
                    }
                }
            }));
        }

        public TrustVerifier getProxyVerifier() {
            return new BasicProxyTrustVerifier(this.proxy);
        }
    }
}

