/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryChangeListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupLocatorDiscovery;

public class LookupDiscoveryManager
implements DiscoveryManagement,
DiscoveryGroupManagement,
DiscoveryLocatorManagement {
    public static final int FROM_GROUP = 1;
    public static final int FROM_LOCATOR = 2;
    private static final int DISCOVERED = 0;
    private static final int DISCARDED = 1;
    private static final int CHANGED = 2;
    private final ArrayList discoveredSet = new ArrayList(1);
    private final ArrayList listeners = new ArrayList(1);
    private LookupDiscovery lookupDisc;
    private DiscoveryListener groupListener = new GroupDiscoveryListener();
    private LookupLocatorDiscovery locatorDisc;
    private DiscoveryListener locatorListener = new LocatorDiscoveryListener();

    public LookupDiscoveryManager(String[] stringArray, LookupLocator[] lookupLocatorArray, DiscoveryListener discoveryListener) throws IOException {
        try {
            this.beginDiscovery(stringArray, lookupLocatorArray, discoveryListener, EmptyConfiguration.INSTANCE);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public LookupDiscoveryManager(String[] stringArray, LookupLocator[] lookupLocatorArray, DiscoveryListener discoveryListener, Configuration configuration) throws IOException, ConfigurationException {
        this.beginDiscovery(stringArray, lookupLocatorArray, discoveryListener, configuration);
    }

    public LookupLocator[] getLocators() {
        return this.locatorDisc.getLocators();
    }

    public void addLocators(LookupLocator[] lookupLocatorArray) {
        this.locatorDisc.addLocators(lookupLocatorArray);
    }

    public void removeLocators(LookupLocator[] lookupLocatorArray) {
        this.locatorDisc.removeLocators(lookupLocatorArray);
    }

    public void setLocators(LookupLocator[] lookupLocatorArray) {
        this.locatorDisc.setLocators(lookupLocatorArray);
    }

    public String[] getGroups() {
        return this.lookupDisc.getGroups();
    }

    public void addGroups(String[] stringArray) throws IOException {
        this.lookupDisc.addGroups(stringArray);
    }

    public void removeGroups(String[] stringArray) {
        int n;
        if (stringArray == null) {
            throw new NullPointerException("can't remove null from groups to discover");
        }
        String[] stringArray2 = this.lookupDisc.getGroups();
        if (stringArray2 == null) {
            throw new UnsupportedOperationException("can't remove from \"any groups\"");
        }
        if (stringArray2.length == 0) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray2.length);
        for (n = 0; n < stringArray2.length; ++n) {
            hashSet.add(stringArray2[n]);
        }
        n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            n |= hashSet.remove(stringArray[i]);
        }
        if (n == 0) {
            return;
        }
        String[] stringArray3 = hashSet.toArray(new String[hashSet.size()]);
        this.lookupDisc.removeGroups(stringArray);
    }

    public void setGroups(String[] stringArray) throws IOException {
        this.lookupDisc.setGroups(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveryListener(DiscoveryListener discoveryListener) {
        if (discoveryListener == null) {
            throw new NullPointerException("can't add null listener");
        }
        HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(this.discoveredSet.size());
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(discoveryListener)) {
                this.listeners.add(discoveryListener);
            }
            if (this.discoveredSet.isEmpty()) {
                return;
            }
            for (int i = 0; i < this.discoveredSet.size(); ++i) {
                ProxyReg proxyReg = (ProxyReg)this.discoveredSet.get(i);
                hashMap.put(proxyReg.proxy, proxyReg.getMemberGroups());
            }
        }
        this.notifyListener(discoveryListener, hashMap, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiscoveryListener(DiscoveryListener discoveryListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(discoveryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistrar[] getRegistrars() {
        ArrayList<ServiceRegistrar> arrayList = new ArrayList<ServiceRegistrar>(1);
        ServiceRegistrar[] serviceRegistrarArray = this.discoveredSet;
        synchronized (this.discoveredSet) {
            boolean bl = false;
            Iterator iterator = this.discoveredSet.iterator();
            while (iterator.hasNext()) {
                ProxyReg proxyReg = (ProxyReg)iterator.next();
                if (proxyReg.isDiscarded()) continue;
                arrayList.add(proxyReg.proxy);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            serviceRegistrarArray = new ServiceRegistrar[arrayList.size()];
            arrayList.toArray(serviceRegistrarArray);
            return serviceRegistrarArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard(ServiceRegistrar serviceRegistrar) {
        if (serviceRegistrar == null) {
            return;
        }
        ProxyReg proxyReg = this.findReg(serviceRegistrar);
        if (proxyReg != null) {
            ArrayList arrayList = this.discoveredSet;
            synchronized (arrayList) {
                proxyReg.discard();
                proxyReg.commDiscard = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.clear();
        }
        this.lookupDisc.terminate();
        this.locatorDisc.terminate();
    }

    public int getFrom(ServiceRegistrar serviceRegistrar) {
        ProxyReg proxyReg = this.findReg(serviceRegistrar);
        if (proxyReg != null) {
            return proxyReg.getFrom();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProxyReg findReg(ServiceRegistrar serviceRegistrar) {
        ArrayList arrayList = this.discoveredSet;
        synchronized (arrayList) {
            Iterator iterator = this.discoveredSet.iterator();
            while (iterator.hasNext()) {
                ProxyReg proxyReg = (ProxyReg)iterator.next();
                if (!proxyReg.proxy.equals(serviceRegistrar)) continue;
                return proxyReg;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener(Map map, int n) {
        ArrayList arrayList;
        if (map.isEmpty()) {
            return;
        }
        Object object = this.listeners;
        synchronized (object) {
            arrayList = (ArrayList)this.listeners.clone();
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            DiscoveryListener discoveryListener = (DiscoveryListener)object.next();
            this.notifyListener(discoveryListener, map, n);
        }
    }

    private void notifyListener(DiscoveryListener discoveryListener, Map map, int n) {
        if (n == 2 && !(discoveryListener instanceof DiscoveryChangeListener)) {
            return;
        }
        DiscoveryEvent discoveryEvent = new DiscoveryEvent((Object)this, this.deepCopy((HashMap)map));
        switch (n) {
            case 0: {
                discoveryListener.discovered(discoveryEvent);
                break;
            }
            case 1: {
                discoveryListener.discarded(discoveryEvent);
                break;
            }
            case 2: {
                ((DiscoveryChangeListener)discoveryListener).changed(discoveryEvent);
            }
        }
    }

    private static boolean groupSetsEqual(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        block0: for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray[i].equals(stringArray2[j])) continue block0;
            }
            return false;
        }
        return true;
    }

    private boolean stillInterested(String[] stringArray, String[] stringArray2) {
        if (stringArray2 == DiscoveryGroupManagement.ALL_GROUPS) {
            return true;
        }
        if (stringArray2.length == 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray[i].equals(stringArray2[j])) continue;
                return true;
            }
        }
        return false;
    }

    private Map deepCopy(HashMap hashMap) {
        HashMap hashMap2 = (HashMap)hashMap.clone();
        Set set = hashMap2.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            entry.setValue(((String[])entry.getValue()).clone());
        }
        return hashMap2;
    }

    private void beginDiscovery(String[] stringArray, LookupLocator[] lookupLocatorArray, DiscoveryListener discoveryListener, Configuration configuration) throws IOException, ConfigurationException {
        if (discoveryListener != null) {
            this.listeners.add(discoveryListener);
        }
        this.lookupDisc = new LookupDiscovery(stringArray, configuration);
        this.lookupDisc.addDiscoveryListener(this.groupListener);
        this.locatorDisc = new LookupLocatorDiscovery(lookupLocatorArray, configuration);
        this.locatorDisc.addDiscoveryListener(this.locatorListener);
    }

    private final class GroupDiscoveryListener
    extends LocatorDiscoveryListener
    implements DiscoveryChangeListener {
        private GroupDiscoveryListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discovered(DiscoveryEvent discoveryEvent) {
            ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
            Map map = discoveryEvent.getGroups();
            HashMap hashMap = new HashMap(serviceRegistrarArray.length);
            HashMap<ServiceRegistrar, String[]> hashMap2 = new HashMap<ServiceRegistrar, String[]>(serviceRegistrarArray.length);
            for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                ArrayList arrayList = LookupDiscoveryManager.this.discoveredSet;
                synchronized (arrayList) {
                    ProxyReg proxyReg = LookupDiscoveryManager.this.findReg(serviceRegistrarArray[i]);
                    if (proxyReg == null) {
                        proxyReg = new ProxyReg(serviceRegistrarArray[i], (String[])map.get(serviceRegistrarArray[i]), 1);
                        this.addDiscoveredSet(proxyReg);
                        hashMap.put(serviceRegistrarArray[i], map.get(serviceRegistrarArray[i]));
                    } else {
                        String[] stringArray;
                        String[] stringArray2 = proxyReg.getMemberGroups();
                        if (LookupDiscoveryManager.groupSetsEqual(stringArray2, stringArray = (String[])map.get(proxyReg.proxy))) {
                            proxyReg.addFrom(1);
                        } else {
                            proxyReg.setMemberGroups(stringArray);
                            hashMap2.put(proxyReg.proxy, stringArray);
                        }
                    }
                    continue;
                }
            }
            LookupDiscoveryManager.this.notifyListener(hashMap, 0);
            LookupDiscoveryManager.this.notifyListener(hashMap2, 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discarded(DiscoveryEvent discoveryEvent) {
            ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
            Map map = discoveryEvent.getGroups();
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(serviceRegistrarArray.length);
            HashMap<ServiceRegistrar, String[]> hashMap2 = new HashMap<ServiceRegistrar, String[]>(serviceRegistrarArray.length);
            for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                ArrayList arrayList = LookupDiscoveryManager.this.discoveredSet;
                synchronized (arrayList) {
                    ProxyReg proxyReg = LookupDiscoveryManager.this.findReg(serviceRegistrarArray[i]);
                    if (proxyReg != null) {
                        String[] stringArray = (String[])map.get(proxyReg.proxy);
                        if (this.removeDiscoveredSet(proxyReg, 1)) {
                            hashMap.put(proxyReg.proxy, stringArray);
                        } else {
                            String[] stringArray2 = LookupDiscoveryManager.this.lookupDisc.getGroups();
                            if (!LookupDiscoveryManager.this.stillInterested(stringArray, stringArray2)) {
                                String[] stringArray3 = proxyReg.getMemberGroups();
                                if (!LookupDiscoveryManager.groupSetsEqual(stringArray3, stringArray)) {
                                    proxyReg.setMemberGroups(stringArray);
                                    hashMap2.put(proxyReg.proxy, stringArray);
                                }
                            } else {
                                proxyReg.discard();
                            }
                        }
                    }
                    continue;
                }
            }
            LookupDiscoveryManager.this.notifyListener(hashMap, 1);
            LookupDiscoveryManager.this.notifyListener(hashMap2, 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed(DiscoveryEvent discoveryEvent) {
            ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
            Map map = discoveryEvent.getGroups();
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(serviceRegistrarArray.length);
            for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                ArrayList arrayList = LookupDiscoveryManager.this.discoveredSet;
                synchronized (arrayList) {
                    ProxyReg proxyReg = LookupDiscoveryManager.this.findReg(serviceRegistrarArray[i]);
                    if (proxyReg != null) {
                        String[] stringArray = (String[])map.get(proxyReg.proxy);
                        proxyReg.setMemberGroups(stringArray);
                        hashMap.put(proxyReg.proxy, stringArray);
                    }
                    continue;
                }
            }
            LookupDiscoveryManager.this.notifyListener(hashMap, 2);
        }
    }

    class LocatorDiscoveryListener
    implements DiscoveryListener {
        LocatorDiscoveryListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discovered(DiscoveryEvent discoveryEvent) {
            ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
            Map map = discoveryEvent.getGroups();
            HashMap hashMap = new HashMap(serviceRegistrarArray.length);
            HashMap hashMap2 = new HashMap(serviceRegistrarArray.length);
            for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                ArrayList arrayList = LookupDiscoveryManager.this.discoveredSet;
                synchronized (arrayList) {
                    ProxyReg proxyReg = LookupDiscoveryManager.this.findReg(serviceRegistrarArray[i]);
                    if (proxyReg == null) {
                        proxyReg = new ProxyReg(serviceRegistrarArray[i], (String[])map.get(serviceRegistrarArray[i]), 2);
                        this.addDiscoveredSet(proxyReg);
                        hashMap.put(serviceRegistrarArray[i], map.get(serviceRegistrarArray[i]));
                    } else {
                        proxyReg.addFrom(2);
                    }
                    continue;
                }
            }
            LookupDiscoveryManager.this.notifyListener(hashMap, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discarded(DiscoveryEvent discoveryEvent) {
            ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
            Map map = discoveryEvent.getGroups();
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(serviceRegistrarArray.length);
            for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                ArrayList arrayList = LookupDiscoveryManager.this.discoveredSet;
                synchronized (arrayList) {
                    ProxyReg proxyReg = LookupDiscoveryManager.this.findReg(serviceRegistrarArray[i]);
                    if (proxyReg != null) {
                        String[] stringArray = (String[])map.get(proxyReg.proxy);
                        if (this.removeDiscoveredSet(proxyReg, 2)) {
                            hashMap.put(proxyReg.proxy, stringArray);
                        } else if (proxyReg.commDiscard) {
                            proxyReg.discard();
                        }
                    }
                    continue;
                }
            }
            LookupDiscoveryManager.this.notifyListener(hashMap, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addDiscoveredSet(ProxyReg proxyReg) {
            ArrayList arrayList = LookupDiscoveryManager.this.discoveredSet;
            synchronized (arrayList) {
                LookupDiscoveryManager.this.discoveredSet.add(proxyReg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeDiscoveredSet(ProxyReg proxyReg, int n) {
            boolean bl = proxyReg.removeFrom(n);
            if (bl) {
                ArrayList arrayList = LookupDiscoveryManager.this.discoveredSet;
                synchronized (arrayList) {
                    LookupDiscoveryManager.this.discoveredSet.remove(proxyReg);
                }
            }
            return bl;
        }
    }

    private final class ProxyReg {
        public ServiceRegistrar proxy;
        public String[] memberGroups;
        public boolean commDiscard = false;
        private int from;
        private boolean bDiscarded = false;

        public ProxyReg(ServiceRegistrar serviceRegistrar, String[] stringArray, int n) {
            if (serviceRegistrar == null) {
                throw new IllegalArgumentException("proxy cannot be null");
            }
            if (n != 1 && n != 2) {
                throw new IllegalArgumentException("invalid discovery mechanism: must be either FROM_GROUP or FROM_LOCATOR");
            }
            this.proxy = serviceRegistrar;
            this.memberGroups = stringArray;
            this.from = n;
        }

        public boolean equals(Object object) {
            if (object instanceof ProxyReg) {
                return this.proxy.equals(((ProxyReg)object).proxy);
            }
            return false;
        }

        public int hashCode() {
            return this.proxy.hashCode();
        }

        public synchronized void addFrom(int n) {
            this.from |= n;
        }

        public synchronized boolean removeFrom(int n) {
            if (n == 0) {
                throw new RuntimeException("call to removeFrom with bad argument");
            }
            this.from &= ~n;
            return this.from == 0;
        }

        public synchronized int getFrom() {
            return this.from;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discard() {
            ProxyReg proxyReg = this;
            synchronized (proxyReg) {
                this.bDiscarded = true;
            }
            if ((this.from & 1) != 0) {
                LookupDiscoveryManager.this.lookupDisc.discard(this.proxy);
            } else if ((this.from & 2) != 0) {
                LookupDiscoveryManager.this.locatorDisc.discard(this.proxy);
            }
        }

        public synchronized boolean isDiscarded() {
            return this.bDiscarded;
        }

        public synchronized String[] getMemberGroups() {
            return this.memberGroups;
        }

        public synchronized void setMemberGroups(String[] stringArray) {
            this.memberGroups = stringArray;
        }
    }
}

