/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.EmulatorConnection;
import com.intel.bluetooth.EmulatorLocalDevice;
import com.intel.bluetooth.ServiceRecordImpl;
import com.intel.bluetooth.UtilsJavaSE;
import com.intel.bluetooth.emu.ServicesDescriptor;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.DataElement;
import javax.bluetooth.ServiceRegistrationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class EmulatorServiceConnection
extends EmulatorConnection {
    protected BluetoothConnectionNotifierParams params;

    EmulatorServiceConnection(EmulatorLocalDevice localDevice, long handle) {
        super(localDevice, handle);
    }

    private void addServiceClassUUID(Vector<String> uuids, ServiceRecordImpl serviceRecord) {
        DataElement attrDataElement = serviceRecord.getAttributeValue(1);
        if (attrDataElement == null || attrDataElement.getDataType() != 48 || attrDataElement.getSize() == 0) {
            return;
        }
        Object value = attrDataElement.getValue();
        if (value == null || !(value instanceof Enumeration)) {
            return;
        }
        Enumeration e = (Enumeration)value;
        while (e.hasMoreElements()) {
            DataElement dataElement;
            Object element = e.nextElement();
            if (!(element instanceof DataElement) || (dataElement = (DataElement)element).getDataType() != 24 || uuids.contains(dataElement.getValue().toString())) continue;
            uuids.add(dataElement.getValue().toString());
        }
    }

    private void addProtocolDescriptorUUID(Vector<String> uuids, ServiceRecordImpl serviceRecord) {
        DataElement protocolDescriptor = serviceRecord.getAttributeValue(4);
        if (protocolDescriptor == null || protocolDescriptor.getDataType() != 48) {
            return;
        }
        Enumeration protocolsSeqEnum = (Enumeration)protocolDescriptor.getValue();
        while (protocolsSeqEnum.hasMoreElements()) {
            DataElement protocolElement;
            Enumeration elementSeqEnum;
            Object element = protocolsSeqEnum.nextElement();
            if (!(element instanceof DataElement)) {
                throw new IllegalArgumentException("SDP protocol descriptor list");
            }
            DataElement elementSeq = (DataElement)element;
            if (elementSeq.getDataType() != 48 || !(elementSeqEnum = (Enumeration)elementSeq.getValue()).hasMoreElements() || (protocolElement = (DataElement)elementSeqEnum.nextElement()).getDataType() != 24 || uuids.contains(protocolElement.getValue().toString())) continue;
            uuids.add(protocolElement.getValue().toString());
        }
    }

    void updateServiceRecord(ServiceRecordImpl serviceRecord) throws ServiceRegistrationException {
        byte[] sdpBinary;
        Vector<String> uuids = new Vector<String>();
        this.addServiceClassUUID(uuids, serviceRecord);
        this.addProtocolDescriptorUUID(uuids, serviceRecord);
        try {
            sdpBinary = serviceRecord.toByteArray();
        }
        catch (IOException e) {
            throw (ServiceRegistrationException)UtilsJavaSE.initCause((Throwable)new ServiceRegistrationException(e.getMessage()), (Throwable)e);
        }
        this.localDevice.getDeviceManagerService().updateServiceRecord(this.localDevice.getAddress(), serviceRecord.getHandle(), new ServicesDescriptor(uuids.toArray(new String[uuids.size()]), sdpBinary, serviceRecord.deviceServiceClasses));
    }
}

