/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.emu;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.emu.ConnectionBuffer;
import com.intel.bluetooth.emu.DeviceCommand;
import com.intel.bluetooth.emu.DeviceDescriptor;
import com.intel.bluetooth.emu.DeviceManagerServiceImpl;
import com.intel.bluetooth.emu.DeviceSDP;
import com.intel.bluetooth.emu.ServiceListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Vector;
import javax.bluetooth.BluetoothConnectionException;

class Device {
    private boolean isReleased = false;
    private DeviceDescriptor descriptor;
    private DeviceSDP sdp;
    private Hashtable<String, String> servicesOpen = new Hashtable();
    private Vector<ServiceListener> serviceListeners;
    private Object serviceNotification = new Object();
    private Hashtable<Long, ConnectionBuffer> connections = new Hashtable();
    private Queue<DeviceCommand> commandQueue = new LinkedList<DeviceCommand>();
    private long lastEvent = System.currentTimeMillis();

    Device(DeviceDescriptor descriptor) {
        this.descriptor = descriptor;
        this.serviceListeners = new Vector();
    }

    DeviceDescriptor getDescriptor() {
        return this.descriptor;
    }

    boolean isHasServices() {
        return !this.servicesOpen.isEmpty();
    }

    boolean isListening() {
        return !this.serviceListeners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long[] getConnectedTo() {
        Vector<Long> connectedTo = new Vector<Long>();
        Hashtable<Long, ConnectionBuffer> hashtable = this.connections;
        synchronized (hashtable) {
            Enumeration<ConnectionBuffer> iterator = this.connections.elements();
            while (iterator.hasMoreElements()) {
                ConnectionBuffer c = iterator.nextElement();
                if (c.isServerSide()) continue;
                connectedTo.add(new Long(c.getRemoteAddress()));
            }
        }
        return connectedTo.toArray(new Long[connectedTo.size()]);
    }

    synchronized DeviceSDP getDeviceSDP(boolean create) {
        if (create && this.sdp == null) {
            this.sdp = new DeviceSDP(this.descriptor.getAddress());
        }
        return this.sdp;
    }

    void openService(String portID) {
        this.servicesOpen.put(portID, portID);
    }

    void closeService(String portID) {
        ServiceListener sl;
        this.servicesOpen.remove(portID);
        while ((sl = this.removeServiceListener(portID)) != null) {
            sl.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceListener createServiceListener(String portID) {
        ServiceListener sl = new ServiceListener(portID);
        Vector<ServiceListener> vector = this.serviceListeners;
        synchronized (vector) {
            this.serviceListeners.addElement(sl);
        }
        return sl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceListener removeServiceListener(String portID) {
        ServiceListener sl = null;
        Vector<ServiceListener> vector = this.serviceListeners;
        synchronized (vector) {
            Enumeration<ServiceListener> iterator = this.serviceListeners.elements();
            while (iterator.hasMoreElements()) {
                ServiceListener s = iterator.nextElement();
                if (!s.getPortID().equals(portID)) continue;
                this.serviceListeners.removeElement(s);
                sl = s;
                break;
            }
        }
        return sl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serviceListenerAccepting(String portID) {
        Object object = this.serviceNotification;
        synchronized (object) {
            this.serviceNotification.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceListener connectService(String portID, long timeout) throws IOException {
        if (this.servicesOpen.get(portID) == null) {
            return null;
        }
        ServiceListener sl = this.removeServiceListener(portID);
        long endOfDellay = System.currentTimeMillis() + timeout;
        while (sl == null && timeout > 0L) {
            long timeleft = endOfDellay - System.currentTimeMillis();
            if (timeleft <= 0L) {
                throw new BluetoothConnectionException(5, "Service " + portID + " not accepting");
            }
            try {
                Object object = this.serviceNotification;
                synchronized (object) {
                    this.serviceNotification.wait(timeleft);
                }
            }
            catch (InterruptedException e) {
                break;
            }
            if (this.servicesOpen.get(portID) == null) break;
            sl = this.removeServiceListener(portID);
        }
        return sl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnectionBuffer(long connectionId, ConnectionBuffer c) {
        Hashtable<Long, ConnectionBuffer> hashtable = this.connections;
        synchronized (hashtable) {
            this.connections.put(new Long(connectionId), c);
        }
    }

    ConnectionBuffer getConnectionBuffer(long connectionId) {
        return this.connections.get(new Long(connectionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionBuffer getConnectionBuffer(long remoteAddress, String portID) {
        Hashtable<Long, ConnectionBuffer> hashtable = this.connections;
        synchronized (hashtable) {
            Enumeration<ConnectionBuffer> iterator = this.connections.elements();
            while (iterator.hasMoreElements()) {
                ConnectionBuffer c = iterator.nextElement();
                if (c.remoteAddress != remoteAddress || !c.getPortID().equals(portID)) continue;
                return c;
            }
            this.connections.clear();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeConnection(long connectionId) throws IOException {
        ConnectionBuffer c;
        Hashtable<Long, ConnectionBuffer> hashtable = this.connections;
        synchronized (hashtable) {
            c = this.connections.remove(new Long(connectionId));
        }
        if (c == null) {
            throw new IOException("No such connection " + connectionId);
        }
        c.close();
    }

    void setDevicePower(boolean on) {
        this.descriptor.setPoweredOn(on);
        if (!on) {
            this.close();
        }
        this.putCommand(new DeviceCommand(DeviceCommand.DeviceCommandType.chagePowerState, new Boolean(on)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putCommand(DeviceCommand command) {
        Queue<DeviceCommand> queue = this.commandQueue;
        synchronized (queue) {
            this.commandQueue.add(command);
            this.commandQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    DeviceCommand pollCommand() {
        this.lastEvent = System.currentTimeMillis();
        DeviceCommand command = null;
        Queue<DeviceCommand> queue = this.commandQueue;
        // MONITORENTER : queue
        while (command == null && !this.isReleased) {
            command = this.commandQueue.poll();
            if (command != null) continue;
            try {
                this.commandQueue.wait(DeviceManagerServiceImpl.configuration.getKeepAliveSeconds() * 1000);
                if (this.isReleased || !this.commandQueue.isEmpty()) continue;
                return DeviceCommand.keepAliveCommand;
            }
            catch (InterruptedException e) {
                // empty catch block
                return command;
            }
        }
        // MONITOREXIT : queue
        return command;
    }

    boolean isAlive() {
        return System.currentTimeMillis() < this.lastEvent + (long)((DeviceManagerServiceImpl.configuration.getKeepAliveSeconds() + 7) * 1000);
    }

    void died() {
        DebugLog.debug((String)"device died", (String)RemoteDeviceHelper.getBluetoothAddress((long)this.descriptor.getAddress()));
        this.release();
    }

    void release() {
        this.isReleased = true;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.commandQueue;
        synchronized (object) {
            this.commandQueue.notifyAll();
        }
        this.servicesOpen.clear();
        Enumeration<ServiceListener> iterator = this.serviceListeners.elements();
        while (iterator.hasMoreElements()) {
            ServiceListener s = iterator.nextElement();
            s.close();
        }
        this.serviceListeners.clear();
        object = this.connections;
        synchronized (object) {
            Enumeration<ConnectionBuffer> iterator2 = this.connections.elements();
            while (iterator2.hasMoreElements()) {
                ConnectionBuffer c = iterator2.nextElement();
                try {
                    c.close();
                }
                catch (IOException e) {}
            }
            this.connections.clear();
        }
    }
}

