/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.rmi;

import com.intel.bluetooth.rmi.RemoteService;
import com.intel.bluetooth.rmi.ServiceRequest;
import com.intel.bluetooth.rmi.ServiceResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteServiceImpl
implements RemoteService {
    private static final long serialVersionUID = 1L;
    private Map<String, Class<?>> cash = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getClassByInterfaceName(String interfaceName) throws ClassNotFoundException {
        Class<?> c;
        Map<String, Class<?>> map = this.cash;
        synchronized (map) {
            c = this.cash.get(interfaceName);
            if (c == null) {
                c = Class.forName(interfaceName + "Impl");
                this.cash.put(interfaceName, c);
            }
        }
        return c;
    }

    @Override
    public boolean verify(String interfaceName) throws RemoteException {
        try {
            this.getClassByInterfaceName(interfaceName);
        }
        catch (Throwable e) {
            throw new RemoteException("Service for " + interfaceName + " not ready", e);
        }
        return true;
    }

    @Override
    public ServiceResponse execute(ServiceRequest request) {
        try {
            Class<?> c = this.getClassByInterfaceName(request.getClassName());
            Method m = c.getDeclaredMethod(request.getMethodName(), request.getParameterTypes());
            ServiceResponse response = new ServiceResponse();
            try {
                response.setReturnValue(m.invoke(c.newInstance(), request.getParameters()));
            }
            catch (InvocationTargetException e) {
                response.setException(e.getTargetException());
            }
            return response;
        }
        catch (Throwable e) {
            return new ServiceResponse(e);
        }
    }
}

